/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector.parser;

import org.exolab.jms.selector.SelectorException;
import org.exolab.jms.selector.parser.SelectorAST;

final class PatternValidator {
    private PatternValidator() {
    }

    public static void validate(SelectorAST patternNode, SelectorAST escapeNode) throws SelectorException {
        String pattern = patternNode.getText();
        if (escapeNode != null) {
            String escape = escapeNode.getText();
            if (escape.length() != 1) {
                String msg = "escape must be a single character";
                throw new SelectorException(escapeNode.getContext(), msg);
            }
            char esc = escape.charAt(0);
            int i = 0;
            while (i < pattern.length()) {
                char ch = pattern.charAt(i);
                if (pattern.charAt(i) == esc && ++i >= pattern.length()) {
                    String msg = "invalid pattern: no character following last escape character";
                    throw new SelectorException(patternNode.getContext(), msg);
                }
                ++i;
            }
        }
    }
}

