/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import javax.jms.Message;
import org.exolab.jms.selector.Identifier;
import org.exolab.jms.selector.IdentifierExpression;
import org.exolab.jms.selector.SBool;
import org.exolab.jms.selector.SObject;
import org.exolab.jms.selector.SString;
import org.exolab.jms.selector.TypeCaster;
import org.exolab.jms.selector.TypeMismatchException;

class InExpression
extends IdentifierExpression {
    private final HashSet _values;

    public InExpression(Identifier ident, HashSet values) {
        super(ident);
        this._values = values;
    }

    public final SObject evaluate(Message msg) throws TypeMismatchException {
        SBool result = null;
        SString value = TypeCaster.castToString(this.identifier().evaluate(msg), "in expression");
        if (value != null) {
            result = this._values.contains(value.getObject()) ? SBool.TRUE : SBool.FALSE;
        }
        return result;
    }

    public final String toString() {
        StringBuffer result = new StringBuffer();
        result.append('(');
        result.append(this.identifier().toString());
        result.append(" in (");
        int i = 0;
        TreeSet sorted = new TreeSet(this._values);
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            if (i > 0) {
                result.append(", ");
            }
            result.append("'");
            result.append((String)iter.next());
            result.append("'");
            ++i;
        }
        result.append("))");
        return result.toString();
    }
}

