/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector;

import javax.jms.JMSException;
import javax.jms.Message;
import org.exolab.jms.selector.Expression;
import org.exolab.jms.selector.Identifiers;
import org.exolab.jms.selector.SLong;
import org.exolab.jms.selector.SObject;
import org.exolab.jms.selector.SObjectFactory;
import org.exolab.jms.selector.SString;
import org.exolab.jms.selector.SelectorException;

class Identifier
implements Expression {
    private final String _name;
    private final boolean _headerField;
    private static final SString PERSISTENT = new SString("PERSISTENT");
    private static final SString NON_PERSISTENT = new SString("NON_PERSISTENT");

    public Identifier(String name) throws SelectorException {
        this._name = name;
        if (Identifiers.isJMSIdentifier(this._name)) {
            if (!Identifiers.isQueryableJMSIdentifier(this._name)) {
                throw new SelectorException("Invalid header field: " + this._name);
            }
            this._headerField = true;
        } else {
            this._headerField = false;
        }
    }

    public final SObject evaluate(Message msg) {
        SObject value = null;
        try {
            if (this._headerField) {
                String type;
                if (this._name.equals("JMSDeliveryMode")) {
                    value = this.deliveryMode(msg.getJMSDeliveryMode());
                } else if (this._name.equals("JMSPriority")) {
                    value = new SLong(msg.getJMSPriority());
                } else if (this._name.equals("JMSTimestamp")) {
                    value = new SLong(msg.getJMSTimestamp());
                } else if (this._name.equals("JMSMessageID")) {
                    String id = msg.getJMSMessageID();
                    if (id != null) {
                        value = new SString(id);
                    }
                } else if (this._name.equals("JMSCorrelationID")) {
                    String id = msg.getJMSCorrelationID();
                    if (id != null) {
                        value = new SString(id);
                    }
                } else if (this._name.equals("JMSType") && (type = msg.getJMSType()) != null) {
                    value = new SString(type);
                }
            } else {
                value = SObjectFactory.create(msg.getObjectProperty(this._name));
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return value;
    }

    public final String toString() {
        return this._name;
    }

    private SString deliveryMode(int mode) {
        SString result = PERSISTENT;
        if (mode == 1) {
            result = NON_PERSISTENT;
        }
        return result;
    }
}

