/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector;

import javax.jms.Message;
import org.exolab.jms.selector.Expression;
import org.exolab.jms.selector.LogicalOperator;
import org.exolab.jms.selector.SBool;
import org.exolab.jms.selector.SObject;
import org.exolab.jms.selector.TypeCaster;
import org.exolab.jms.selector.TypeMismatchException;

class And
extends LogicalOperator {
    private static final String CONTEXT = "and operator";

    public And(Expression lhs, Expression rhs) {
        super("and", lhs, rhs);
    }

    public final SObject evaluate(Message msg) throws TypeMismatchException {
        SBool result = null;
        SBool lhs = TypeCaster.castToBool(this.left().evaluate(msg), CONTEXT);
        if (lhs != null) {
            if (!lhs.value()) {
                result = SBool.FALSE;
            } else {
                SBool rhs = TypeCaster.castToBool(this.right().evaluate(msg), CONTEXT);
                result = lhs.and(rhs);
            }
        } else {
            SBool rhs = TypeCaster.castToBool(this.right().evaluate(msg), CONTEXT);
            if (rhs != null) {
                result = rhs.and(lhs);
            }
        }
        return result;
    }
}

