/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.scheduler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.scheduler.Scheduler;

public class SerialTask
implements Runnable {
    private Runnable _task;
    private final Scheduler _scheduler;
    private boolean _active = false;
    private boolean _stop = false;
    private boolean _scheduled = false;
    private boolean _reschedule = false;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$scheduler$SerialTask == null ? (class$org$exolab$jms$scheduler$SerialTask = SerialTask.class$("org.exolab.jms.scheduler.SerialTask")) : class$org$exolab$jms$scheduler$SerialTask));
    static /* synthetic */ Class class$org$exolab$jms$scheduler$SerialTask;

    public SerialTask(Runnable task, Scheduler scheduler) {
        this._task = task;
        this._scheduler = scheduler;
    }

    public synchronized boolean schedule() throws InterruptedException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("schedule() " + this));
        }
        boolean result = false;
        if (!this._stop && !this._scheduled) {
            if (this._active) {
                this._reschedule = true;
            } else {
                this._scheduled = true;
                try {
                    this._scheduler.execute(this);
                }
                catch (InterruptedException exception) {
                    this._scheduled = false;
                    throw exception;
                }
            }
            result = true;
        }
        return result;
    }

    public void run() {
        SerialTask serialTask;
        SerialTask serialTask2 = this;
        synchronized (serialTask2) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("run() " + this));
            }
            if (this._stop) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Scheduled task cancelled");
                }
                return;
            }
            if (this._active) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Serial task already running, aborting");
                }
                throw new IllegalStateException("SerialTask already running");
            }
            this._active = true;
            this._scheduled = false;
        }
        try {
            this._task.run();
            Object var4_3 = null;
            serialTask = this;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            SerialTask serialTask3 = this;
            synchronized (serialTask3) {
                this._active = false;
                if (this._reschedule) {
                    try {
                        this._reschedule = false;
                        this._scheduled = true;
                        this._scheduler.execute(this);
                    }
                    catch (InterruptedException exception) {
                        this._scheduled = false;
                    }
                } else {
                    this._scheduled = false;
                }
                this.notify();
            }
            throw throwable;
        }
        synchronized (serialTask) {
            this._active = false;
            if (this._reschedule) {
                try {
                    this._reschedule = false;
                    this._scheduled = true;
                    this._scheduler.execute(this);
                }
                catch (InterruptedException exception) {
                    this._scheduled = false;
                }
            } else {
                this._scheduled = false;
            }
            this.notify();
        }
    }

    public synchronized void stop() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("stop() " + this));
        }
        this._stop = true;
        this._reschedule = false;
        this._scheduled = false;
        while (this._active) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._reschedule = false;
        this._stop = false;
    }

    public synchronized String toString() {
        return "[stop=" + this._stop + ", active=" + this._active + ", reschedule=" + this._reschedule + ", scheduled=" + this._scheduled + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

