/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.persistence;

import EDU.oswego.cs.dl.util.concurrent.FIFOReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.authentication.User;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.config.DatabaseConfiguration;
import org.exolab.jms.config.RdbmsDatabaseConfiguration;
import org.exolab.jms.events.EventHandler;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.persistence.Consumers;
import org.exolab.jms.persistence.DBConnectionManager;
import org.exolab.jms.persistence.Destinations;
import org.exolab.jms.persistence.MessageHandles;
import org.exolab.jms.persistence.Messages;
import org.exolab.jms.persistence.PersistenceAdapter;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.persistence.SeedGenerator;
import org.exolab.jms.persistence.Users;

public class RDBMSAdapter
extends PersistenceAdapter
implements EventHandler {
    private final SeedGenerator _seeds;
    private final Destinations _destinations;
    private final Consumers _consumers;
    private final Messages _messages;
    private final MessageHandles _handles;
    private final Users _users;
    public static final String SCHEMA_VERSION = "V0.7.6";
    private DBConnectionManager _connectionManager = null;
    private ReadWriteLock _destinationLock = new FIFOReadWriteLock();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$persistence$RDBMSAdapter == null ? (class$org$exolab$jms$persistence$RDBMSAdapter = RDBMSAdapter.class$("org.exolab.jms.persistence.RDBMSAdapter")) : class$org$exolab$jms$persistence$RDBMSAdapter));
    static /* synthetic */ Class class$org$exolab$jms$persistence$RDBMSAdapter;

    public RDBMSAdapter(DatabaseConfiguration dbConfig, String driver, String url, String userName, String password) throws PersistenceException {
        RdbmsDatabaseConfiguration config = dbConfig.getRdbmsDatabaseConfiguration();
        this._connectionManager = this.getConnectionManager(config.getClazz());
        this._connectionManager.setUser(userName);
        this._connectionManager.setPassword(password);
        this._connectionManager.setDriver(driver);
        this._connectionManager.setURL(url);
        this._connectionManager.setMaxActive(config.getMaxActive());
        this._connectionManager.setMaxIdle(config.getMaxIdle());
        this._connectionManager.setMinIdleTime(config.getMinIdleTime());
        this._connectionManager.setEvictionInterval(config.getEvictionInterval());
        this._connectionManager.setTestQuery(config.getTestQuery());
        this._connectionManager.setTestBeforeUse(config.getTestBeforeUse());
        this._connectionManager.init();
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
                String version = this.getSchemaVersion(connection);
                if (version == null) {
                    this.initSchemaVersion(connection);
                } else if (!version.equals(SCHEMA_VERSION)) {
                    throw new PersistenceException("Schema needs to be converted from version=" + version + " to version=" + SCHEMA_VERSION + "\nBack up your database, and run 'dbtool -migrate'" + "to convert the schema");
                }
                this._seeds = new SeedGenerator();
                this._consumers = new Consumers(this._seeds, connection);
                this._destinations = new Destinations(this._seeds, this._consumers, connection);
                this._consumers.setDestinations(this._destinations);
                this._messages = new Messages(this._destinations);
                this._handles = new MessageHandles(this._destinations, this._consumers);
                this._users = new Users();
                connection.commit();
            }
            catch (PersistenceException exception) {
                SQLHelper.rollback(connection);
                throw exception;
            }
            catch (Exception exception) {
                throw new PersistenceException("Failed to initialise database adapter", exception);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
    }

    public void close() {
        this._consumers.close();
        this._destinations.close();
    }

    public long getLastId(Connection connection) throws PersistenceException {
        long lastId = -1L;
        PreparedStatement query = null;
        ResultSet result = null;
        PreparedStatement insert = null;
        try {
            block5: {
                try {
                    query = connection.prepareStatement("select maxid from message_id where id = 1");
                    result = query.executeQuery();
                    if (result.next()) {
                        lastId = result.getInt(1);
                        break block5;
                    }
                    insert = connection.prepareStatement("insert into message_id values (?,?)");
                    insert.setInt(1, 1);
                    insert.setLong(2, 0L);
                    insert.executeUpdate();
                    lastId = 0L;
                }
                catch (Exception exception) {
                    throw new PersistenceException("Failed to get last message id", exception);
                }
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            SQLHelper.close(result);
            SQLHelper.close(insert);
            SQLHelper.close(query);
            throw throwable;
        }
        SQLHelper.close(result);
        SQLHelper.close(insert);
        SQLHelper.close(query);
        return lastId;
    }

    public void updateIds(Connection connection, long id) throws PersistenceException {
        PreparedStatement insert = null;
        try {
            try {
                insert = connection.prepareStatement("update message_id set maxId = ? where id = 1");
                insert.setLong(1, id);
                insert.executeUpdate();
            }
            catch (Exception exception) {
                throw new PersistenceException("Failed to update message id", exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            SQLHelper.close(insert);
            throw throwable;
        }
        SQLHelper.close(insert);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addMessage(Connection connection, MessageImpl message) throws PersistenceException {
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            try {
                this._destinationLock.readLock().acquire();
                this._messages.add(connection, message);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this._destinationLock.readLock().release();
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("addMessage," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        this._destinationLock.readLock().release();
        if (!_log.isDebugEnabled()) return;
        _log.debug((Object)("addMessage," + (System.currentTimeMillis() - start)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateMessage(Connection connection, MessageImpl message) throws PersistenceException {
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            try {
                this._destinationLock.readLock().acquire();
                this._messages.update(connection, message);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this._destinationLock.readLock().release();
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("updateMessage," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        this._destinationLock.readLock().release();
        if (!_log.isDebugEnabled()) return;
        _log.debug((Object)("updateMessage," + (System.currentTimeMillis() - start)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getUnprocessedMessages(Connection connection) throws PersistenceException {
        Vector vector;
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            vector = this._messages.getUnprocessedMessages(connection);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("getUnprocessedMessages," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        if (!_log.isDebugEnabled()) return vector;
        _log.debug((Object)("getUnprocessedMessages," + (System.currentTimeMillis() - start)));
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeMessage(Connection connection, String id) throws PersistenceException {
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            try {
                this._destinationLock.readLock().acquire();
                this._messages.remove(connection, id);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this._destinationLock.readLock().release();
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("removeMessage," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        this._destinationLock.readLock().release();
        if (!_log.isDebugEnabled()) return;
        _log.debug((Object)("removeMessage," + (System.currentTimeMillis() - start)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MessageImpl getMessage(Connection connection, String id) throws PersistenceException {
        MessageImpl messageImpl;
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            messageImpl = this._messages.get(connection, id);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("getMessage," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        if (!_log.isDebugEnabled()) return messageImpl;
        _log.debug((Object)("getMessage," + (System.currentTimeMillis() - start)));
        return messageImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getMessages(Connection connection, MessageHandle handle) throws PersistenceException {
        Vector vector;
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            vector = this._messages.getMessages(connection, handle.getDestination().getName(), handle.getPriority(), handle.getAcceptedTime());
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("getMessages," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        if (!_log.isDebugEnabled()) return vector;
        _log.debug((Object)("getMessages," + (System.currentTimeMillis() - start)));
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addMessageHandle(Connection connection, MessageHandle handle) throws PersistenceException {
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            try {
                this._destinationLock.readLock().acquire();
                this._handles.addMessageHandle(connection, handle);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this._destinationLock.readLock().release();
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("addMessageHandle," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        this._destinationLock.readLock().release();
        if (!_log.isDebugEnabled()) return;
        _log.debug((Object)("addMessageHandle," + (System.currentTimeMillis() - start)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateMessageHandle(Connection connection, MessageHandle handle) throws PersistenceException {
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            try {
                this._destinationLock.readLock().acquire();
                this._handles.updateMessageHandle(connection, handle);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this._destinationLock.readLock().release();
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("updateMessageHandle," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        this._destinationLock.readLock().release();
        if (!_log.isDebugEnabled()) return;
        _log.debug((Object)("updateMessageHandle," + (System.currentTimeMillis() - start)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeMessageHandle(Connection connection, MessageHandle handle) throws PersistenceException {
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            try {
                this._destinationLock.readLock().acquire();
                this._handles.removeMessageHandle(connection, handle);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this._destinationLock.readLock().release();
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("removeMessageHandle," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        this._destinationLock.readLock().release();
        if (!_log.isDebugEnabled()) return;
        _log.debug((Object)("removeMessageHandle," + (System.currentTimeMillis() - start)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getMessageHandles(Connection connection, JmsDestination destination, String name) throws PersistenceException {
        Vector vector;
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        try {
            vector = this._handles.getMessageHandles(connection, destination.getName(), name);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (!_log.isDebugEnabled()) throw throwable;
            _log.debug((Object)("getMessageHandles," + (System.currentTimeMillis() - start)));
            throw throwable;
        }
        if (!_log.isDebugEnabled()) return vector;
        _log.debug((Object)("getMessageHandles," + (System.currentTimeMillis() - start)));
        return vector;
    }

    public void addDurableConsumer(Connection connection, String topic, String consumer) throws PersistenceException {
        try {
            try {
                this._destinationLock.readLock().acquire();
                this._consumers.add(connection, topic, consumer);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this._destinationLock.readLock().release();
            throw throwable;
        }
        this._destinationLock.readLock().release();
    }

    public void removeDurableConsumer(Connection connection, String consumer) throws PersistenceException {
        try {
            try {
                this._destinationLock.readLock().acquire();
                this._consumers.remove(connection, consumer);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this._destinationLock.readLock().release();
            throw throwable;
        }
        this._destinationLock.readLock().release();
    }

    public Enumeration getDurableConsumers(Connection connection, String topic) throws PersistenceException {
        return this._consumers.getDurableConsumers(topic).elements();
    }

    public HashMap getAllDurableConsumers(Connection connection) throws PersistenceException {
        return this._consumers.getAllDurableConsumers();
    }

    public boolean durableConsumerExists(Connection connection, String name) throws PersistenceException {
        return this._consumers.exists(name);
    }

    public void addDestination(Connection connection, String name, boolean queue) throws PersistenceException {
        JmsDestination destination = queue ? new JmsQueue(name) : new JmsTopic(name);
        try {
            block4: {
                try {
                    this._destinationLock.readLock().acquire();
                    this._destinations.add(connection, destination);
                    if (!queue) break block4;
                    this._consumers.add(connection, name, name);
                }
                catch (InterruptedException exception) {
                    throw new PersistenceException("Failed to acquire lock", exception);
                }
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this._destinationLock.readLock().release();
            throw throwable;
        }
        this._destinationLock.readLock().release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeDestination(Connection connection, String name) throws PersistenceException {
        JmsDestination destination = this._destinations.get(name);
        if (destination == null) return;
        try {
            try {
                this._destinationLock.writeLock().acquire();
                this._destinations.remove(connection, destination);
            }
            catch (InterruptedException exception) {
                throw new PersistenceException("Failed to acquire lock", exception);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this._destinationLock.writeLock().release();
            throw throwable;
        }
        this._destinationLock.writeLock().release();
    }

    public Enumeration getAllDestinations(Connection connection) throws PersistenceException {
        return this._destinations.getDestinations().elements();
    }

    public boolean checkDestination(Connection connection, String name) throws PersistenceException {
        return this._destinations.get(name) != null;
    }

    public int getQueueMessageCount(Connection connection, String name) throws PersistenceException {
        return this._handles.getMessageCount(connection, name, name);
    }

    public int getDurableConsumerMessageCount(Connection connection, String destination, String name) throws PersistenceException {
        return this._handles.getMessageCount(connection, destination, name);
    }

    public void removeExpiredMessages(Connection connection) throws PersistenceException {
        this._messages.removeExpiredMessages(connection);
    }

    public void removeExpiredMessageHandles(Connection connection, String consumer) throws PersistenceException {
        this._handles.removeExpiredMessageHandles(connection, consumer);
    }

    public Vector getNonExpiredMessages(Connection connection, JmsDestination destination) throws PersistenceException {
        return this._messages.getNonExpiredMessages(connection, destination);
    }

    public void handleEvent(int event, Object callback, long time) {
    }

    public Connection getConnection() throws PersistenceException {
        return this._connectionManager.getConnection();
    }

    public DBConnectionManager getDBConnectionManager() {
        return this._connectionManager;
    }

    public void addUser(Connection connection, User user) throws PersistenceException {
        this._users.add(connection, user);
    }

    public Enumeration getAllUsers(Connection connection) throws PersistenceException {
        return this._users.getAllUsers(connection).elements();
    }

    public User getUser(Connection connection, User user) throws PersistenceException {
        return this._users.get(connection, user);
    }

    public void removeUser(Connection connection, User user) throws PersistenceException {
        this._users.remove(connection, user);
    }

    public void updateUser(Connection connection, User user) throws PersistenceException {
        this._users.update(connection, user);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int purgeMessages() {
        Connection connection = null;
        try {
            try {
                connection = this.getConnection();
                this.removeExpiredMessages(connection);
                connection.commit();
            }
            catch (Exception exception) {
                _log.error((Object)"Exception in purgeMessages", (Throwable)exception);
                Object var4_3 = null;
                SQLHelper.close(connection);
                return 0;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
        return 0;
    }

    private String getSchemaVersion(Connection connection) throws PersistenceException {
        String version = null;
        PreparedStatement query = null;
        ResultSet result = null;
        try {
            block4: {
                try {
                    query = connection.prepareStatement("select version from system_data where id = 1");
                    result = query.executeQuery();
                    if (!result.next()) break block4;
                    version = result.getString(1);
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to get the schema version", exception);
                }
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            SQLHelper.close(result);
            SQLHelper.close(query);
            throw throwable;
        }
        SQLHelper.close(result);
        SQLHelper.close(query);
        return version;
    }

    private void initSchemaVersion(Connection connection) throws PersistenceException {
        _log.info((Object)"Initialising schema version V0.7.6");
        PreparedStatement insert = null;
        try {
            try {
                insert = connection.prepareStatement("insert into system_data (id, version, creationdate) values (?,?,?)");
                insert.setInt(1, 1);
                insert.setString(2, SCHEMA_VERSION);
                insert.setDate(3, new Date(System.currentTimeMillis()));
                insert.executeUpdate();
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to initialise schema version", exception);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            SQLHelper.close(insert);
            throw throwable;
        }
        SQLHelper.close(insert);
    }

    private DBConnectionManager getConnectionManager(String className) throws PersistenceException {
        DBConnectionManager result = null;
        Class<?> clazz = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            if (loader != null) {
                clazz = loader.loadClass(className);
            }
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        try {
            if (clazz == null) {
                clazz = Class.forName(className);
            }
        }
        catch (ClassNotFoundException exception) {
            throw new PersistenceException("Failed to locate connection manager implementation: " + className, exception);
        }
        try {
            result = (DBConnectionManager)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new PersistenceException("Failed to create connection manager", exception);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

