/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.persistence.Destinations;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;

class Messages {
    private final Destinations _destinations;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$persistence$Messages == null ? (class$org$exolab$jms$persistence$Messages = Messages.class$("org.exolab.jms.persistence.Messages")) : class$org$exolab$jms$persistence$Messages));
    static /* synthetic */ Class class$org$exolab$jms$persistence$Messages;

    public Messages(Destinations destinations) {
        this._destinations = destinations;
    }

    public void add(Connection connection, MessageImpl message) throws PersistenceException {
        String name;
        PreparedStatement insert = null;
        String messageId = message.getMessageId().getId();
        try {
            name = ((JmsDestination)message.getJMSDestination()).getName();
        }
        catch (JMSException exception) {
            throw new PersistenceException("Failed to get destination for message=" + message.getMessageId(), exception);
        }
        long destinationId = this._destinations.getId(name);
        if (destinationId == 0L) {
            throw new PersistenceException("Cannot add message=" + message.getMessageId() + ", destination=" + name + " (" + destinationId + "): destination does not exist");
        }
        try {
            try {
                insert = connection.prepareStatement("insert into messages (messageid, destinationid, priority, createtime, expirytime, processed, messageblob) values (?,?,?,?,?,?,?)");
                insert.setString(1, messageId);
                insert.setLong(2, destinationId);
                insert.setInt(3, message.getJMSPriority());
                insert.setLong(4, message.getAcceptedTime());
                insert.setLong(5, message.getJMSExpiration());
                insert.setInt(6, message.getProcessed() ? 1 : 0);
                byte[] bytes = this.serialize(message);
                insert.setBinaryStream(7, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                if (insert.executeUpdate() != 1) {
                    throw new PersistenceException("Failed to add message=" + message.getMessageId() + ", destination=" + name + " (" + destinationId + ")");
                }
                Object var11_10 = null;
            }
            catch (PersistenceException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new PersistenceException("Failed to add message=" + message.getMessageId() + ", destination=" + name + " (" + destinationId + ")", exception);
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            SQLHelper.close(insert);
            throw throwable;
        }
        SQLHelper.close(insert);
    }

    public void update(Connection connection, MessageImpl message) throws PersistenceException {
        PreparedStatement update = null;
        String messageId = message.getMessageId().getId();
        try {
            block4: {
                try {
                    update = connection.prepareStatement("update messages set processed=? where messageId=?");
                    update.setInt(1, message.getProcessed() ? 1 : 0);
                    update.setString(2, messageId);
                    if (update.executeUpdate() == 1) break block4;
                    _log.error((Object)("Cannot update message=" + messageId));
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to update message, id=" + messageId, exception);
                }
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            SQLHelper.close(update);
            throw throwable;
        }
        SQLHelper.close(update);
    }

    public void remove(Connection connection, String messageId) throws PersistenceException {
        PreparedStatement delete = null;
        try {
            block4: {
                try {
                    delete = connection.prepareStatement("delete from messages where messageId=?");
                    delete.setString(1, messageId);
                    if (delete.executeUpdate() == 1) break block4;
                    _log.error((Object)("Cannot remove message=" + messageId));
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to remove message, id=" + messageId, exception);
                }
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            SQLHelper.close(delete);
            throw throwable;
        }
        SQLHelper.close(delete);
    }

    public MessageImpl get(Connection connection, String messageId) throws PersistenceException {
        MessageImpl result = null;
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            block4: {
                try {
                    select = connection.prepareStatement("select messageBlob, processed from messages where messageId=?");
                    select.setString(1, messageId);
                    set = select.executeQuery();
                    if (!set.next()) break block4;
                    result = this.deserialize(set.getBytes(1));
                    result.setProcessed(set.getInt(2) == 1);
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to retrieve message, id=" + messageId, exception);
                }
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            SQLHelper.close(set);
            SQLHelper.close(select);
            throw throwable;
        }
        SQLHelper.close(set);
        SQLHelper.close(select);
        return result;
    }

    public int removeMessages(Connection connection, String destination) throws PersistenceException {
        int result = 0;
        PreparedStatement delete = null;
        long destinationId = this._destinations.getId(destination);
        if (destinationId == 0L) {
            throw new PersistenceException("Cannot delete messages for destination=" + destination + ": destination does not exist");
        }
        try {
            try {
                delete = connection.prepareStatement("delete from messages where destinationId = ?");
                delete.setLong(1, destinationId);
                result = delete.executeUpdate();
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to remove messages for destination=" + destination, exception);
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            SQLHelper.close(delete);
            throw throwable;
        }
        SQLHelper.close(delete);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getMessages(Connection connection, String destination, int priority, long time) throws PersistenceException {
        PreparedStatement select = null;
        ResultSet set = null;
        Vector<MessageImpl> messages = new Vector<MessageImpl>();
        try {
            try {
                JmsDestination dest = this._destinations.get(destination);
                if (dest == null) {
                    throw new PersistenceException("Cannot getMessages for destination=" + destination + ": destination does not exist");
                }
                long destinationId = this._destinations.getId(destination);
                if (destinationId == 0L) {
                    throw new PersistenceException("Cannot getMessages for destination=" + destination + ": destination does not exist");
                }
                if (dest instanceof JmsTopic && ((JmsTopic)dest).isWildCard()) {
                    select = connection.prepareStatement("select createtime,processed,messageblob from messages where priority=? and createTime>=? order by createTime asc");
                    select.setInt(1, priority);
                    select.setLong(2, time);
                } else {
                    select = connection.prepareStatement("select createtime,processed,messageblob from messages where destinationId=? and priority=? and createTime>=? order by createTime asc");
                    select.setLong(1, destinationId);
                    select.setInt(2, priority);
                    select.setLong(3, time);
                }
                set = select.executeQuery();
                int count = 0;
                long lastTimeStamp = time;
                while (set.next()) {
                    MessageImpl m = this.deserialize(set.getBytes(3));
                    m.setProcessed(set.getInt(2) == 1);
                    messages.add(m);
                    if (++count > 200) {
                        if (set.getLong(1) <= lastTimeStamp) continue;
                    }
                    lastTimeStamp = set.getLong(1);
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to retrieve messages", exception);
            }
            Object var17_14 = null;
        }
        catch (Throwable throwable) {
            Object var17_15 = null;
            SQLHelper.close(set);
            SQLHelper.close(select);
            throw throwable;
        }
        SQLHelper.close(set);
        SQLHelper.close(select);
        return messages;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getMessageIds(Connection connection, long time, int hint) throws PersistenceException {
        PreparedStatement select = null;
        ResultSet set = null;
        HashMap<String, Long> messages = new HashMap<String, Long>();
        try {
            try {
                select = connection.prepareStatement("select messageId,createTime from messages where createTime>? order by createTime asc");
                select.setLong(1, time);
                set = select.executeQuery();
                int count = 0;
                long lastTimeStamp = time;
                while (set.next()) {
                    messages.put(set.getString(1), new Long(set.getLong(2)));
                    if (++count > hint) {
                        if (set.getLong(2) <= lastTimeStamp) continue;
                    }
                    lastTimeStamp = set.getLong("createTime");
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to retrieve message identifiers", exception);
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            SQLHelper.close(set);
            SQLHelper.close(select);
            throw throwable;
        }
        SQLHelper.close(set);
        SQLHelper.close(select);
        return messages;
    }

    public Vector getUnprocessedMessages(Connection connection) throws PersistenceException {
        PreparedStatement select = null;
        ResultSet set = null;
        Vector<MessageImpl> messages = new Vector<MessageImpl>();
        try {
            try {
                select = connection.prepareStatement("select messageblob from messages where processed=0");
                set = select.executeQuery();
                while (set.next()) {
                    MessageImpl m = this.deserialize(set.getBytes(1));
                    m.setProcessed(false);
                    messages.add(m);
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to retrieve unprocessed messages", exception);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            SQLHelper.close(set);
            SQLHelper.close(select);
            throw throwable;
        }
        SQLHelper.close(set);
        SQLHelper.close(select);
        return messages;
    }

    public Vector getNonExpiredMessages(Connection connection, JmsDestination destination) throws PersistenceException {
        Vector<PersistentMessageHandle> result = new Vector<PersistentMessageHandle>();
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                long destinationId = this._destinations.getId(destination.getName());
                if (destinationId == 0L) {
                    throw new PersistenceException("Cannot getMessages for destination=" + destination + ": destination does not exist");
                }
                select = connection.prepareStatement("select messageId,destinationId,priority,createTime,sequenceNumber,expiryTime from messages where expiryTime>0 and destinationId=? order by expiryTime asc");
                select.setLong(1, destinationId);
                set = select.executeQuery();
                while (set.next()) {
                    String messageId = set.getString(1);
                    int priority = set.getInt(3);
                    long acceptedTime = set.getLong(4);
                    long sequenceNumber = set.getLong(5);
                    long expiryTime = set.getLong(6);
                    PersistentMessageHandle handle = new PersistentMessageHandle(messageId, priority, acceptedTime, sequenceNumber, expiryTime, destination);
                    result.add(handle);
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to retrieve non-expired messages", exception);
            }
            Object var18_14 = null;
        }
        catch (Throwable throwable) {
            Object var18_15 = null;
            SQLHelper.close(set);
            SQLHelper.close(select);
            throw throwable;
        }
        SQLHelper.close(set);
        SQLHelper.close(select);
        return result;
    }

    public void removeExpiredMessages(Connection connection) throws PersistenceException {
        PreparedStatement delete = null;
        try {
            try {
                long time = System.currentTimeMillis();
                delete = connection.prepareStatement("delete from messages where expiryTime > 0 and expiryTime < ?");
                delete.setLong(1, time);
                delete.executeUpdate();
                delete.close();
                delete = connection.prepareStatement("delete from message_handles where expiryTime > 0 and expiryTime < ?");
                delete.setLong(1, time);
                delete.executeUpdate();
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to remove expired messages", exception);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            SQLHelper.close(delete);
            throw throwable;
        }
        SQLHelper.close(delete);
    }

    public byte[] serialize(MessageImpl message) throws PersistenceException {
        byte[] result = null;
        ObjectOutputStream ostream = null;
        try {
            try {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream();
                ostream = new ObjectOutputStream(bstream);
                ostream.writeObject(message);
                result = bstream.toByteArray();
            }
            catch (Exception exception) {
                throw new PersistenceException("Failed to serialize message", exception);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            SQLHelper.close(ostream);
            throw throwable;
        }
        SQLHelper.close(ostream);
        return result;
    }

    public MessageImpl deserialize(byte[] blob) throws PersistenceException {
        ObjectInputStream istream;
        MessageImpl message;
        block5: {
            message = null;
            if (blob != null) {
                istream = null;
                try {
                    try {
                        ByteArrayInputStream bstream = new ByteArrayInputStream(blob);
                        istream = new ObjectInputStream(bstream);
                        message = (MessageImpl)istream.readObject();
                    }
                    catch (Exception exception) {
                        throw new PersistenceException("Failed to de-serialize message", exception);
                    }
                    Object var6_6 = null;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    SQLHelper.close(istream);
                    throw throwable;
                }
            }
            throw new PersistenceException("Cannot de-serialize null message blob");
        }
        SQLHelper.close(istream);
        return message;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

