/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.persistence.Consumers;
import org.exolab.jms.persistence.Destinations;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;

class MessageHandles {
    private final Destinations _destinations;
    private final Consumers _consumers;
    private static final String INSERT_MSG_HANDLE_STMT = "insert into message_handles (messageid, destinationid, consumerid, priority, acceptedtime, sequencenumber, expirytime, delivered) values (?,?,?,?,?,?,?,?)";
    private static final String DELETE_MSG_HANDLE_STMT1 = "delete from message_handles where messageId=? and consumerId=?";
    private static final String DELETE_MSG_HANDLE_STMT2 = "delete from message_handles where messageId=? and destinationId=? and consumerId=?";
    private static final String DELETE_MSG_HANDLES_STMT = "delete from message_handles where messageId=?";
    private static final String UPDATE_MSG_HANDLE_STMT = "update message_handles set delivered=? where messageId=? and destinationId=? and consumerId=?";
    private static final String DELETE_MSG_HANDLES_FOR_DEST = "delete from message_handles where destinationId=?";
    private static final String GET_MSG_HANDLES_FOR_DEST = "select messageid, destinationid, consumerid, priority, acceptedtime, sequencenumber, expirytime, delivered from message_handles where consumerId=? order by acceptedTime asc";
    private static final String GET_MESSAGE_HANDLES_IN_RANGE = "select distinct messageId from message_handles where  acceptedTime >= ? and acceptedTime <=?";
    private static final String GET_MESSAGE_HANDLE_WITH_ID = "select distinct messageId from message_handles where messageId=?";
    private static final String GET_MSG_HANDLE_COUNT_FOR_DEST_AND_CONSUMER = "select count(messageId) from message_handles where destinationId=? and consumerId=?";
    private static final String GET_MSG_HANDLE_COUNT_FOR_CONSUMER = "select count(messageId) from message_handles where consumerId=?";
    private static final String DELETE_EXPIRED_MESSAGES = "delete from message_handles where consumerId=? and expiryTime != 0 and expiryTime<?";
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$persistence$MessageHandles == null ? (class$org$exolab$jms$persistence$MessageHandles = MessageHandles.class$("org.exolab.jms.persistence.MessageHandles")) : class$org$exolab$jms$persistence$MessageHandles));
    static /* synthetic */ Class class$org$exolab$jms$persistence$MessageHandles;

    public MessageHandles(Destinations destinations, Consumers consumers) {
        this._destinations = destinations;
        this._consumers = consumers;
    }

    public void addMessageHandle(Connection connection, MessageHandle handle) throws PersistenceException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("addMessageHandle(handle=[consumer=" + handle.getConsumerPersistentId() + ", destination=" + handle.getDestination() + ", id=" + handle.getMessageId() + "])"));
        }
        PreparedStatement insert = null;
        try {
            block7: {
                try {
                    long destinationId = this._destinations.getId(handle.getDestination().getName());
                    if (destinationId == 0L) {
                        throw new PersistenceException("Cannot add message handle id=" + handle.getMessageId() + " for destination=" + handle.getDestination().getName() + " and consumer=" + handle.getConsumerPersistentId() + " since the destination cannot be mapped to an id");
                    }
                    long consumerId = this._consumers.getConsumerId(handle.getConsumerPersistentId());
                    if (consumerId == 0L) {
                        throw new PersistenceException("Cannot add message handle id=" + handle.getMessageId() + " for destination=" + handle.getDestination().getName() + " and consumer=" + handle.getConsumerPersistentId() + " since the consumer cannot be mapped to an id");
                    }
                    insert = connection.prepareStatement(INSERT_MSG_HANDLE_STMT);
                    insert.setString(1, handle.getMessageId());
                    insert.setLong(2, destinationId);
                    insert.setLong(3, consumerId);
                    insert.setInt(4, handle.getPriority());
                    insert.setLong(5, handle.getAcceptedTime());
                    insert.setLong(6, handle.getSequenceNumber());
                    insert.setLong(7, handle.getExpiryTime());
                    insert.setInt(8, handle.getDelivered() ? 1 : 0);
                    if (insert.executeUpdate() == 1) break block7;
                    _log.error((Object)("Failed to execute addMessageHandle for handle=" + handle.getMessageId() + ", destination Id=" + destinationId));
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to add message handle=" + handle, exception);
                }
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            SQLHelper.close(insert);
            throw throwable;
        }
        SQLHelper.close(insert);
    }

    public void removeMessageHandle(Connection connection, MessageHandle handle) throws PersistenceException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("removeMessageHandle(handle=[consumer=" + handle.getConsumerPersistentId() + ", destination=" + handle.getDestination() + ", id=" + handle.getMessageId() + "])"));
        }
        PreparedStatement delete = null;
        Statement select = null;
        ResultSet rs = null;
        try {
            block7: {
                try {
                    long consumerId = this._consumers.getConsumerId(handle.getConsumerPersistentId());
                    if (consumerId == 0L) break block7;
                    String id = handle.getMessageId();
                    long destinationId = this._destinations.getId(handle.getDestination().getName());
                    if (destinationId == 0L) {
                        delete = connection.prepareStatement(DELETE_MSG_HANDLE_STMT1);
                        delete.setString(1, id);
                        delete.setLong(2, consumerId);
                    } else {
                        delete = connection.prepareStatement(DELETE_MSG_HANDLE_STMT2);
                        delete.setString(1, id);
                        delete.setLong(2, destinationId);
                        delete.setLong(3, consumerId);
                    }
                    if (delete.executeUpdate() == 1 || handle.hasExpired()) break block7;
                    _log.error((Object)("Failed to execute removeMessageHandle for handle=" + id + " destination id=" + destinationId + " consumer id=" + consumerId));
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to remove message handle=" + handle, exception);
                }
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            SQLHelper.close(rs);
            SQLHelper.close(delete);
            SQLHelper.close(select);
            throw throwable;
        }
        SQLHelper.close(rs);
        SQLHelper.close(delete);
        SQLHelper.close(select);
    }

    public void updateMessageHandle(Connection connection, MessageHandle handle) throws PersistenceException {
        PreparedStatement update = null;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("updateMessageHandle(handle=[consumer=" + handle.getConsumerPersistentId() + ", destination=" + handle.getDestination() + ", id=" + handle.getMessageId() + "])"));
        }
        try {
            block7: {
                try {
                    String id = handle.getMessageId();
                    long destinationId = this._destinations.getId(handle.getDestination().getName());
                    if (destinationId == 0L) {
                        throw new PersistenceException("Cannot update message handle id=" + handle.getMessageId() + " for destination=" + handle.getDestination().getName() + " and consumer=" + handle.getConsumerPersistentId() + " since the destination cannot be mapped to an id");
                    }
                    long consumerId = this._consumers.getConsumerId(handle.getConsumerPersistentId());
                    if (consumerId == 0L) {
                        throw new PersistenceException("Cannot update message handle id=" + handle.getMessageId() + " for destination=" + handle.getDestination().getName() + " and consumer=" + handle.getConsumerPersistentId() + " since the consumer cannot be mapped to an id");
                    }
                    update = connection.prepareStatement(UPDATE_MSG_HANDLE_STMT);
                    update.setInt(1, handle.getDelivered() ? 1 : 0);
                    update.setString(2, id);
                    update.setLong(3, destinationId);
                    update.setLong(4, consumerId);
                    if (update.executeUpdate() == 1 || handle.hasExpired()) break block7;
                    _log.error((Object)("Failed to execute updateMessageHandle for handle=" + id + ", destination id=" + destinationId + ", consumer id=" + consumerId));
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to update message handle=" + handle, exception);
                }
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            SQLHelper.close(update);
            throw throwable;
        }
        SQLHelper.close(update);
    }

    public void removeMessageHandles(Connection connection, String destination) throws PersistenceException {
        PreparedStatement delete = null;
        try {
            try {
                long destinationId = this._destinations.getId(destination);
                if (destinationId == 0L) {
                    throw new PersistenceException("Cannot remove message handles for destination=" + destination + " since the destination cannot be " + "mapped to an id");
                }
                delete = connection.prepareStatement(DELETE_MSG_HANDLES_FOR_DEST);
                delete.setLong(1, destinationId);
                delete.executeUpdate();
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to remove message handles for destination=" + destination, exception);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SQLHelper.close(delete);
            throw throwable;
        }
        SQLHelper.close(delete);
    }

    public void removeMessageHandles(Connection connection, long messageId) throws PersistenceException {
        PreparedStatement delete = null;
        try {
            try {
                delete = connection.prepareStatement(DELETE_MSG_HANDLES_STMT);
                delete.setLong(1, messageId);
                delete.executeUpdate();
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to remove message handles for message id=" + messageId, exception);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            SQLHelper.close(delete);
            throw throwable;
        }
        SQLHelper.close(delete);
    }

    public Vector getMessageHandles(Connection connection, String destination, String name) throws PersistenceException {
        Vector<PersistentMessageHandle> result = new Vector<PersistentMessageHandle>();
        PreparedStatement select = null;
        ResultSet set = null;
        long destinationId = this._destinations.getId(destination);
        long consumerId = this._consumers.getConsumerId(name);
        if (consumerId == 0L || destinationId == 0L) {
            return result;
        }
        try {
            try {
                select = connection.prepareStatement(GET_MSG_HANDLES_FOR_DEST);
                select.setLong(1, consumerId);
                set = select.executeQuery();
                while (set.next()) {
                    JmsDestination dest = this._destinations.get(set.getLong(2));
                    if (dest == null) {
                        throw new PersistenceException("Cannot create persistent handle, because destination mapping failed for " + set.getLong(2));
                    }
                    String consumer = this._consumers.getConsumerName(set.getLong(3));
                    if (name == null) {
                        throw new PersistenceException("Cannot create persistent handle because consumer mapping failed for " + set.getLong(3));
                    }
                    String messageId = set.getString(1);
                    int priority = set.getInt(4);
                    long acceptedTime = set.getLong(5);
                    long sequenceNumber = set.getLong(6);
                    long expiryTime = set.getLong(7);
                    boolean delivered = set.getInt(8) != 0;
                    PersistentMessageHandle handle = new PersistentMessageHandle(messageId, priority, acceptedTime, sequenceNumber, expiryTime, dest, consumer);
                    handle.setDelivered(delivered);
                    result.add(handle);
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to get message handles for destination=" + destination + ", consumer=" + name, exception);
            }
            Object var24_19 = null;
        }
        catch (Throwable throwable) {
            Object var24_20 = null;
            SQLHelper.close(set);
            SQLHelper.close(select);
            throw throwable;
        }
        SQLHelper.close(set);
        SQLHelper.close(select);
        return result;
    }

    public Vector getMessageIds(Connection connection, long min, long max) throws PersistenceException {
        Vector<String> result = new Vector<String>();
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                select = connection.prepareStatement(GET_MESSAGE_HANDLES_IN_RANGE);
                select.setLong(1, min);
                select.setLong(2, max);
                set = select.executeQuery();
                while (set.next()) {
                    result.add(set.getString(1));
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to retrieve message ids", exception);
            }
            Object var11_7 = null;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            SQLHelper.close(set);
            SQLHelper.close(select);
            throw throwable;
        }
        SQLHelper.close(set);
        SQLHelper.close(select);
        return result;
    }

    public boolean messageExists(Connection connection, long messageId) throws PersistenceException {
        boolean result = false;
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            block4: {
                try {
                    select = connection.prepareStatement(GET_MESSAGE_HANDLE_WITH_ID);
                    select.setLong(1, messageId);
                    set = select.executeQuery();
                    if (!set.next()) break block4;
                    result = true;
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to determine if message exists, id=" + messageId, exception);
                }
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            SQLHelper.close(set);
            SQLHelper.close(select);
            throw throwable;
        }
        SQLHelper.close(set);
        SQLHelper.close(select);
        return result;
    }

    public int getMessageCount(Connection connection, String destination, String name) throws PersistenceException {
        long consumerId;
        int result = -1;
        boolean destinationIsWildCard = false;
        long destinationId = this._destinations.getId(destination);
        if (destinationId == 0L) {
            if (JmsTopic.isWildCard(destination)) {
                destinationIsWildCard = true;
            } else {
                throw new PersistenceException("Cannot get message handle count for destination=" + destination + " and consumer=" + name + " since the destination cannot be mapped to an id");
            }
        }
        if ((consumerId = this._consumers.getConsumerId(name)) == 0L) {
            throw new PersistenceException("Cannot get message handle count for destination=" + destination + " and consumer=" + name + " since the consumer cannot be mapped to an id");
        }
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            block10: {
                try {
                    if (destinationIsWildCard) {
                        select = connection.prepareStatement(GET_MSG_HANDLE_COUNT_FOR_DEST_AND_CONSUMER);
                        select.setLong(1, destinationId);
                        select.setLong(2, consumerId);
                    } else {
                        select = connection.prepareStatement(GET_MSG_HANDLE_COUNT_FOR_CONSUMER);
                        select.setLong(1, consumerId);
                    }
                    set = select.executeQuery();
                    if (!set.next()) break block10;
                    result = set.getInt(1);
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to count messages for destination=" + destination + ", consumer=" + name, exception);
                }
            }
            Object var14_10 = null;
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            SQLHelper.close(set);
            SQLHelper.close(select);
            throw throwable;
        }
        SQLHelper.close(set);
        SQLHelper.close(select);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeExpiredMessageHandles(Connection connection, String consumer) throws PersistenceException {
        PreparedStatement delete = null;
        long consumerId = this._consumers.getConsumerId(consumer);
        if (consumerId == 0L) return;
        try {
            try {
                delete = connection.prepareStatement(DELETE_EXPIRED_MESSAGES);
                delete.setLong(1, consumerId);
                delete.setLong(2, System.currentTimeMillis());
                delete.executeUpdate();
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to remove expired message handles", exception);
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            SQLHelper.close(delete);
            throw throwable;
        }
        SQLHelper.close(delete);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

