/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.common.threads.ThreadListener;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.DatabaseConfiguration;
import org.exolab.jms.config.RdbmsDatabaseConfiguration;
import org.exolab.jms.persistence.PersistenceAdapter;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.RDBMSAdapter;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.service.Service;
import org.exolab.jms.service.ServiceException;
import org.exolab.jms.service.ServiceThreadListener;

public class DatabaseService
extends Service {
    private final DatabaseConfiguration _config;
    private PersistenceAdapter _adapter;
    private ServiceThreadListener _listener;
    private ThreadListener _monitor;
    private static final ThreadLocal _state = new ThreadLocal();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$persistence$DatabaseService == null ? (class$org$exolab$jms$persistence$DatabaseService = DatabaseService.class$("org.exolab.jms.persistence.DatabaseService")) : class$org$exolab$jms$persistence$DatabaseService));
    static /* synthetic */ Class class$org$exolab$jms$persistence$DatabaseService;

    public DatabaseService(Configuration config) {
        super("DatabaseService");
        this._config = config.getDatabaseConfiguration();
        this._monitor = new Monitor();
    }

    public void setServiceThreadListener(ServiceThreadListener listener) {
        this._listener = listener;
    }

    public static DatabaseService getInstance() throws PersistenceException {
        State state = (State)_state.get();
        if (state == null) {
            throw new PersistenceException("No DatabaseService registered");
        }
        return state.getInstance();
    }

    public PersistenceAdapter getAdapter() {
        return this._adapter;
    }

    public void begin() throws PersistenceException {
        State state = (State)_state.get();
        if (state != null) {
            if (state.getInstance() != this) {
                throw new PersistenceException("State not associated with current service");
            }
            _log.error((Object)"Transaction in progress, allocated at ", (Throwable)state.STACK);
            throw new PersistenceException("Transaction already in progress");
        }
        _state.set(new State());
    }

    public Connection getConnection() throws PersistenceException {
        State state = this.getState();
        if (state.getConnection() == null) {
            state.setConnection(this._adapter.getConnection());
        }
        return state.getConnection();
    }

    public void commit() throws PersistenceException {
        State state = this.getState();
        Connection connection = state.getConnection();
        try {
            block4: {
                try {
                    if (connection == null) break block4;
                    connection.commit();
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to commit", exception);
                }
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            SQLHelper.close(connection);
            _state.set(null);
            throw throwable;
        }
        SQLHelper.close(connection);
        _state.set(null);
    }

    public void rollback() throws PersistenceException {
        State state = this.getState();
        Connection connection = state.getConnection();
        try {
            block4: {
                try {
                    if (connection == null) break block4;
                    connection.rollback();
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to rollback", exception);
                }
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            SQLHelper.close(connection);
            _state.set(null);
            throw throwable;
        }
        SQLHelper.close(connection);
        _state.set(null);
    }

    public boolean isTransacted() {
        return _state.get() != null;
    }

    protected void doStart() throws ServiceException {
        if (this._listener != null) {
            this._listener.addThreadListener(this._monitor);
        } else {
            _log.info((Object)"Not monitoring service threads");
        }
        this._adapter = this.createAdapter(this._config);
        try {
            this.begin();
            Connection connection = this.getConnection();
            this.getAdapter().removeExpiredMessages(connection);
            _log.info((Object)"Removed expired messages.");
            this.commit();
        }
        catch (PersistenceException exception) {
            try {
                this.rollback();
            }
            catch (PersistenceException ignore) {
                // empty catch block
            }
            throw exception;
        }
        catch (Exception exception) {
            throw new ServiceException("Failed to start the DatabaseService", exception);
        }
    }

    protected void doStop() throws ServiceException {
        if (this._listener != null) {
            this._listener.removeThreadListener(this._monitor);
        }
        this._adapter.close();
        _state.set(null);
    }

    private State getState() throws PersistenceException {
        State state = (State)_state.get();
        if (state == null) {
            throw new PersistenceException("No transaction in progress");
        }
        if (state.getInstance() != this) {
            throw new PersistenceException("State not associated with current service");
        }
        return state;
    }

    private PersistenceAdapter createAdapter(DatabaseConfiguration dbConfig) throws PersistenceException {
        RDBMSAdapter adapter = null;
        RdbmsDatabaseConfiguration config = dbConfig.getRdbmsDatabaseConfiguration();
        _log.info((Object)("Creating RdbmsAdapter for " + config.getDriver()));
        adapter = new RDBMSAdapter(dbConfig, config.getDriver(), config.getUrl(), config.getUser(), config.getPassword());
        return adapter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Monitor
    implements ThreadListener {
        Monitor() {
        }

        public void begin(Runnable command) {
        }

        public void end(Runnable command) {
            State state = (State)_state.get();
            if (state != null) {
                _state.set(null);
                _log.error((Object)("Transaction not finished by " + command + ". Allocated at "), (Throwable)state.STACK);
                SQLHelper.close(state.getConnection());
            }
        }
    }

    class State {
        public final Exception STACK = new Exception();
        private Connection _connection;

        State() {
        }

        public DatabaseService getInstance() {
            return DatabaseService.this;
        }

        public Connection getConnection() {
            return this._connection;
        }

        public void setConnection(Connection connection) {
            this._connection = connection;
        }
    }
}

