/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.persistence.Destinations;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.persistence.SeedGenerator;

class Consumers {
    private final SeedGenerator _seeds;
    private Destinations _destinations;
    private final HashMap _consumers = new HashMap();
    private static final String CONSUMER_ID_SEED = "consumerId";
    private static final String CONSUMER_MESSAGE = "message_handles";
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$persistence$Consumers == null ? (class$org$exolab$jms$persistence$Consumers = Consumers.class$("org.exolab.jms.persistence.Consumers")) : class$org$exolab$jms$persistence$Consumers));
    static /* synthetic */ Class class$org$exolab$jms$persistence$Consumers;

    public Consumers(SeedGenerator seeds, Connection connection) throws PersistenceException {
        this._seeds = seeds;
        this.init(connection);
    }

    public void setDestinations(Destinations destinations) {
        this._destinations = destinations;
    }

    public synchronized void add(Connection connection, String dest, String consumer) throws PersistenceException {
        JmsDestination destination = null;
        long destinationId = 0L;
        Destinations destinations = this._destinations;
        synchronized (destinations) {
            destination = this._destinations.get(dest);
            if (destination == null) {
                this.raise("add", consumer, dest, "destination is invalid");
            }
            destinationId = this._destinations.getId(dest);
        }
        if (destination instanceof JmsTopic && consumer.equals(dest)) {
            this.raise("add", consumer, dest, "The consumer name and destination name cannot be the same");
        }
        long consumerId = this._seeds.next(connection, CONSUMER_ID_SEED);
        PreparedStatement insert = null;
        try {
            block10: {
                try {
                    insert = connection.prepareStatement("insert into consumers values (?,?,?,?)");
                    long created = new Date().getTime();
                    insert.setString(1, consumer);
                    insert.setLong(2, destinationId);
                    insert.setLong(3, consumerId);
                    insert.setLong(4, created);
                    insert.executeUpdate();
                    Consumer map = new Consumer(consumer, consumerId, destinationId, created);
                    if (!this._consumers.containsKey(consumer)) {
                        this._consumers.put(consumer, map);
                        break block10;
                    }
                    _log.error((Object)("Durable consumer with name " + consumer + " already exists."));
                }
                catch (Exception exception) {
                    throw new PersistenceException("Failed to add consumer, destination=" + dest + ", name=" + consumer, exception);
                }
            }
            Object var15_13 = null;
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            SQLHelper.close(insert);
            throw throwable;
        }
        SQLHelper.close(insert);
    }

    public synchronized void remove(Connection connection, String name) throws PersistenceException {
        PreparedStatement delete = null;
        Consumer map = (Consumer)this._consumers.get(name);
        if (map == null) {
            this.raise("remove", name, "consumer does not exist");
        }
        try {
            try {
                delete = connection.prepareStatement("delete from consumers where name=?");
                delete.setString(1, name);
                delete.executeUpdate();
                this.remove(CONSUMER_MESSAGE, map.consumerId, connection);
                this._consumers.remove(name);
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to remove consumer=" + name, exception);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            SQLHelper.close(delete);
            throw throwable;
        }
        SQLHelper.close(delete);
    }

    public synchronized long getConsumerId(String name) {
        Consumer map = (Consumer)this._consumers.get(name);
        return map != null ? map.consumerId : 0L;
    }

    public synchronized boolean exists(String name) {
        return this._consumers.get(name) != null;
    }

    public synchronized Vector getDurableConsumers(String destination) {
        Vector<String> result = new Vector<String>();
        long destinationId = this._destinations.getId(destination);
        if (destinationId != 0L) {
            Iterator iter = this._consumers.values().iterator();
            while (iter.hasNext()) {
                Consumer map = (Consumer)iter.next();
                if (map.destinationId != destinationId) continue;
                result.add(map.name);
            }
        }
        return result;
    }

    public synchronized HashMap getAllDurableConsumers() {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator iter = this._consumers.values().iterator();
        while (iter.hasNext()) {
            Consumer map = (Consumer)iter.next();
            JmsDestination dest = this._destinations.get(map.destinationId);
            if (!(dest instanceof JmsTopic)) continue;
            result.put(map.name, dest.getName());
        }
        return result;
    }

    public synchronized String getConsumerName(long id) {
        String name = null;
        Iterator iter = this._consumers.values().iterator();
        while (iter.hasNext()) {
            Consumer map = (Consumer)iter.next();
            if (map.consumerId != id) continue;
            name = map.name;
            break;
        }
        return name;
    }

    public synchronized void close() {
        this._consumers.clear();
    }

    protected synchronized void removeCached(long destinationId) {
        Object[] list = this._consumers.values().toArray();
        int i = 0;
        while (i < list.length) {
            Consumer map = (Consumer)list[i];
            if (map.destinationId == destinationId) {
                this._consumers.remove(map.name);
            }
            ++i;
        }
    }

    private void init(Connection connection) throws PersistenceException {
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                select = connection.prepareStatement("select name, consumerid, destinationid, created from consumers");
                set = select.executeQuery();
                String name = null;
                long consumerId = 0L;
                long destinationId = 0L;
                long created = 0L;
                Consumer map = null;
                while (set.next()) {
                    name = set.getString(1);
                    consumerId = set.getLong(2);
                    destinationId = set.getLong(3);
                    created = set.getLong(4);
                    map = new Consumer(name, consumerId, destinationId, created);
                    this._consumers.put(name, map);
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to retrieve consumers", exception);
            }
            Object var13_10 = null;
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            SQLHelper.close(set);
            SQLHelper.close(select);
            throw throwable;
        }
        SQLHelper.close(set);
        SQLHelper.close(select);
    }

    private void remove(String table, long consumerId, Connection connection) throws SQLException {
        PreparedStatement delete = null;
        try {
            delete = connection.prepareStatement("delete from " + table + " where consumerId=?");
            delete.setLong(1, consumerId);
            delete.executeUpdate();
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            SQLHelper.close(delete);
            throw throwable;
        }
        SQLHelper.close(delete);
    }

    private void raise(String operation, String name, String destination, String reason) throws PersistenceException {
        throw new PersistenceException("Cannot " + operation + " consumer=" + name + ", destination=" + destination + ": " + reason);
    }

    private void raise(String operation, String name, String reason) throws PersistenceException {
        throw new PersistenceException("Cannot " + operation + " consumer=" + name + ": " + reason);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Consumer {
        public String name;
        public long consumerId;
        public long destinationId;
        public long created;

        public Consumer(String name, long consumerId, long destinationId, long created) {
            this.name = name;
            this.consumerId = consumerId;
            this.destinationId = destinationId;
            this.created = created;
        }

        public String getKey() {
            return this.name;
        }
    }
}

