/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.jms.JMSException;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.lease.LeaseManager;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.AbstractDestinationCache;
import org.exolab.jms.messagemgr.AbstractTopicConsumerEndpoint;
import org.exolab.jms.messagemgr.CachedMessageRef;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.DefaultMessageCache;
import org.exolab.jms.messagemgr.MessageCache;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.messagemgr.MessageRef;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.messagemgr.SharedMessageHandle;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;

class TopicDestinationCache
extends AbstractDestinationCache {
    public TopicDestinationCache(JmsTopic topic, DatabaseService database, LeaseManager leases) {
        super(topic, database, leases);
    }

    public boolean addConsumer(ConsumerEndpoint consumer) {
        JmsTopic ddest;
        boolean result = false;
        JmsTopic cdest = (JmsTopic)consumer.getDestination();
        if (cdest.match(ddest = (JmsTopic)this.getDestination())) {
            result = super.addConsumer(consumer);
        }
        return result;
    }

    public void messageAdded(JmsDestination destination, MessageImpl message) throws JMSException {
        boolean processed = false;
        CachedMessageRef reference = new CachedMessageRef(message, false, (MessageCache)this.getMessageCache());
        reference.reference();
        this.addMessage(reference, message);
        SharedMessageHandle handle = new SharedMessageHandle(this, reference, message);
        ConsumerEndpoint[] consumers = this.getConsumerArray();
        int index = 0;
        while (index < consumers.length) {
            ConsumerEndpoint consumer = consumers[index];
            processed |= consumer.messageAdded(handle, message);
            ++index;
        }
        if (processed) {
            this.checkMessageExpiry((MessageRef)reference, message);
            reference.dereference();
        } else {
            reference.destroy();
        }
    }

    public void persistentMessageAdded(JmsDestination destination, MessageImpl message) throws JMSException, PersistenceException {
        boolean processed = false;
        CachedMessageRef reference = new CachedMessageRef(message, true, (MessageCache)this.getMessageCache());
        reference.reference();
        this.addMessage(reference, message);
        SharedMessageHandle handle = new SharedMessageHandle(this, reference, message);
        ConsumerEndpoint[] consumers = this.getConsumerArray();
        int index = 0;
        while (index < consumers.length) {
            ConsumerEndpoint consumer = consumers[index];
            processed |= consumer.persistentMessageAdded(handle, message);
            ++index;
        }
        if (processed) {
            this.checkMessageExpiry((MessageRef)reference, message);
            reference.dereference();
        } else {
            handle.destroy();
        }
    }

    public void returnMessageHandle(MessageHandle handle) {
        long consumerId = handle.getConsumerId();
        AbstractTopicConsumerEndpoint endpoint = (AbstractTopicConsumerEndpoint)this.getConsumerEndpoint(consumerId);
        if (endpoint != null) {
            endpoint.returnMessage(handle);
        }
    }

    public List getDurableMessageHandles(String name) throws JMSException, PersistenceException {
        DatabaseService service = DatabaseService.getInstance();
        Connection connection = service.getConnection();
        Vector handles = service.getAdapter().getMessageHandles(connection, this.getDestination(), name);
        ArrayList<PersistentMessageHandle> result = new ArrayList<PersistentMessageHandle>(handles.size());
        DefaultMessageCache cache = this.getMessageCache();
        Iterator iterator = handles.iterator();
        while (iterator.hasNext()) {
            PersistentMessageHandle handle = (PersistentMessageHandle)iterator.next();
            String messageId = handle.getMessageId();
            MessageRef reference = cache.getMessageRef(messageId);
            if (reference == null) {
                reference = new CachedMessageRef(messageId, true, (MessageCache)cache);
            }
            cache.addMessageRef(reference);
            handle.reference(reference);
            handle.setDestinationCache(this);
            result.add(handle);
            this.checkMessageExpiry(reference, handle.getExpiryTime());
        }
        return result;
    }

    protected void persistentMessageExpired(MessageRef reference) throws JMSException, PersistenceException {
        String messageId = reference.getMessageId();
        ConsumerEndpoint[] consumers = this.getConsumerArray();
        int i = 0;
        while (i < consumers.length) {
            consumers[i].persistentMessageRemoved(messageId);
            ++i;
        }
    }
}

