/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.sql.Connection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTemporaryDestination;
import org.exolab.jms.lease.LeaseManager;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.AbstractDestinationCache;
import org.exolab.jms.messagemgr.CachedMessageRef;
import org.exolab.jms.messagemgr.Condition;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.DefaultMessageCache;
import org.exolab.jms.messagemgr.MessageCache;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.messagemgr.MessageQueue;
import org.exolab.jms.messagemgr.MessageRef;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.messagemgr.QueueBrowserEndpoint;
import org.exolab.jms.messagemgr.QueueConsumerMessageHandle;
import org.exolab.jms.messagemgr.SharedMessageHandle;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.selector.Selector;
import org.exolab.jms.server.ServerConnectionManager;

public class QueueDestinationCache
extends AbstractDestinationCache {
    private final MessageQueue _handles = new MessageQueue();
    private final List _browsers = Collections.synchronizedList(new LinkedList());
    private final ServerConnectionManager _connections;
    private final Object _lock = new Object();
    private int _lastConsumerIndex = 0;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$QueueDestinationCache == null ? (class$org$exolab$jms$messagemgr$QueueDestinationCache = QueueDestinationCache.class$("org.exolab.jms.messagemgr.QueueDestinationCache")) : class$org$exolab$jms$messagemgr$QueueDestinationCache));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$QueueDestinationCache;

    public QueueDestinationCache(JmsQueue queue, DatabaseService database, LeaseManager leases, ServerConnectionManager connections) throws JMSException {
        super(queue, database, leases);
        if (connections == null) {
            throw new IllegalArgumentException("Argument 'connections' is null");
        }
        this._connections = connections;
        if (queue.getPersistent()) {
            this.init();
        }
    }

    public void addQueueListener(QueueBrowserEndpoint listener) {
        if (!this._browsers.contains(listener)) {
            this._browsers.add(listener);
        }
    }

    public void removeQueueListener(QueueBrowserEndpoint listener) {
        if (this._browsers.contains(listener)) {
            this._browsers.remove(listener);
        }
    }

    public void messageAdded(JmsDestination destination, MessageImpl message) throws JMSException {
        CachedMessageRef reference = new CachedMessageRef(message, false, (MessageCache)this.getMessageCache());
        SharedMessageHandle shared = new SharedMessageHandle(this, reference, message);
        QueueConsumerMessageHandle handle = new QueueConsumerMessageHandle(shared);
        this.addMessage(reference, message, handle);
        ConsumerEndpoint consumer = this.getConsumerForMessage(message);
        if (consumer != null) {
            consumer.messageAdded(handle, message);
        }
    }

    public void persistentMessageAdded(JmsDestination destination, MessageImpl message) throws JMSException, PersistenceException {
        CachedMessageRef reference = new CachedMessageRef(message, true, (MessageCache)this.getMessageCache());
        SharedMessageHandle shared = new SharedMessageHandle(this, reference, message);
        QueueConsumerMessageHandle handle = new QueueConsumerMessageHandle(shared);
        handle.add();
        this.addMessage(reference, message, handle);
        ConsumerEndpoint consumer = this.getConsumerForMessage(message);
        if (consumer != null) {
            consumer.persistentMessageAdded(handle, message);
        }
    }

    public synchronized MessageHandle getMessage(Selector selector, Condition cancel) throws JMSException {
        QueueConsumerMessageHandle handle = null;
        if (selector == null) {
            handle = (QueueConsumerMessageHandle)this._handles.removeFirst();
        } else {
            MessageHandle[] handles = this._handles.toArray();
            int i = 0;
            while (i < handles.length && !cancel.get()) {
                MessageHandle hdl = handles[i];
                MessageImpl message = hdl.getMessage();
                if (message != null && selector.selects(message)) {
                    handle = (QueueConsumerMessageHandle)hdl;
                    this._handles.remove(handle);
                    break;
                }
                ++i;
            }
        }
        return handle;
    }

    public void playbackMessages(QueueBrowserEndpoint browser) throws JMSException {
        MessageHandle[] handles = this._handles.toArray();
        int i = 0;
        while (i < handles.length) {
            MessageHandle handle = handles[i];
            MessageImpl message = handle.getMessage();
            if (message != null) {
                browser.messageAdded(handle, message);
            }
            ++i;
        }
    }

    public void returnMessageHandle(MessageHandle handle) {
        this._handles.add(handle);
        try {
            ConsumerEndpoint consumer;
            MessageImpl message = handle.getMessage();
            if (message != null && (consumer = this.getConsumerForMessage(message)) != null) {
                consumer.messageAdded(handle, message);
            }
        }
        catch (JMSException exception) {
            _log.debug((Object)exception, (Throwable)exception);
        }
    }

    public boolean hasConsumers() {
        boolean active = super.hasConsumers();
        if (!active && !this._browsers.isEmpty()) {
            active = true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("hasActiveConsumers()[queue=" + this.getDestination() + "]=" + active));
        }
        return active;
    }

    public int getMessageCount() {
        return this._handles.size();
    }

    public boolean canDestroy() {
        boolean destroy = false;
        if (!this.hasConsumers()) {
            long connectionId;
            JmsDestination queue = this.getDestination();
            if (queue.getPersistent() && this.getMessageCount() == 0) {
                destroy = true;
            } else if (queue.isTemporaryDestination() && this._connections.getConnection(connectionId = ((JmsTemporaryDestination)((Object)queue)).getConnectionId()) == null) {
                destroy = true;
            }
        }
        return destroy;
    }

    public void destroy() {
        super.destroy();
        this._browsers.clear();
    }

    protected void init() throws JMSException {
        Vector handles;
        JmsDestination queue = this.getDestination();
        DatabaseService service = null;
        try {
            service = DatabaseService.getInstance();
            Connection connection = service.getConnection();
            service.getAdapter().removeExpiredMessageHandles(connection, queue.getName());
            handles = service.getAdapter().getMessageHandles(connection, queue, queue.getName());
        }
        catch (PersistenceException exception) {
            _log.error((Object)exception, (Throwable)exception);
            try {
                if (service != null) {
                    service.rollback();
                }
            }
            catch (PersistenceException error) {
                _log.error((Object)error, (Throwable)error);
            }
            throw new JMSException(exception.getMessage());
        }
        Iterator iterator = handles.iterator();
        DefaultMessageCache cache = this.getMessageCache();
        while (iterator.hasNext()) {
            PersistentMessageHandle handle = (PersistentMessageHandle)iterator.next();
            String messageId = handle.getMessageId();
            MessageRef reference = cache.getMessageRef(messageId);
            if (reference == null) {
                reference = new CachedMessageRef(messageId, true, (MessageCache)cache);
            }
            cache.addMessageRef(reference);
            handle.reference(reference);
            handle.setDestinationCache(this);
            this._handles.add(new QueueConsumerMessageHandle(handle));
            this.checkMessageExpiry(reference, handle.getExpiryTime());
        }
    }

    protected void addMessage(MessageRef reference, MessageImpl message, MessageHandle handle) throws JMSException {
        this.addMessage(reference, message);
        this._handles.add(handle);
        this.notifyQueueListeners(handle, message);
        this.checkMessageExpiry(reference, message);
    }

    protected void notifyQueueListeners(MessageHandle handle, MessageImpl message) throws JMSException {
        QueueBrowserEndpoint[] browsers = this._browsers.toArray(new QueueBrowserEndpoint[0]);
        int index = 0;
        while (index < browsers.length) {
            QueueBrowserEndpoint browser = browsers[index];
            browser.messageAdded(handle, message);
            ++index;
        }
    }

    protected void messageExpired(MessageRef reference) throws JMSException {
        this._handles.remove(reference.getMessageId());
        super.messageExpired(reference);
    }

    protected void persistentMessageExpired(MessageRef reference) throws JMSException, PersistenceException {
        this._handles.remove(reference.getMessageId());
        super.messageExpired(reference);
    }

    private ConsumerEndpoint getConsumerForMessage(MessageImpl message) {
        ConsumerEndpoint result = null;
        ConsumerEndpoint[] consumers = this.getConsumerArray();
        int size = consumers.length;
        if (size > 0) {
            Object object = this._lock;
            synchronized (object) {
                if (this._lastConsumerIndex + 1 > size) {
                    this._lastConsumerIndex = 0;
                }
                int index = this._lastConsumerIndex;
                do {
                    ConsumerEndpoint consumer;
                    if (((consumer = consumers[index]).isAsynchronous() || consumer.isWaitingForMessage()) && consumer.selects(message)) {
                        this._lastConsumerIndex = ++index;
                        result = consumer;
                        break;
                    }
                    if (++index < size) continue;
                    index = 0;
                } while (index != this._lastConsumerIndex);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

