/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.AbstractConsumerEndpoint;
import org.exolab.jms.messagemgr.Condition;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.messagemgr.MessageQueue;
import org.exolab.jms.messagemgr.QueueDestinationCache;

public class QueueBrowserEndpoint
extends AbstractConsumerEndpoint {
    private MessageQueue _handles = new MessageQueue();
    private QueueDestinationCache _cache;

    public QueueBrowserEndpoint(long consumerId, QueueDestinationCache cache, String selector) throws InvalidSelectorException, JMSException {
        super(consumerId, cache.getDestination(), selector, false);
        this._cache = cache;
        this._cache.addQueueListener(this);
        this._cache.playbackMessages(this);
    }

    public boolean messageAdded(MessageHandle handle, MessageImpl message) {
        this._handles.add(handle);
        this.notifyMessageAvailable();
        return true;
    }

    public boolean persistentMessageAdded(MessageHandle handle, MessageImpl message) {
        return this.messageAdded(handle, message);
    }

    public void messageRemoved(String messageId) {
        this._handles.remove(messageId);
    }

    public void persistentMessageRemoved(String messageId) {
        this.messageRemoved(messageId);
    }

    public int getMessageCount() {
        return this._handles.size();
    }

    /*
     * WARNING - void declaration
     */
    protected MessageHandle doReceive(Condition cancel) throws JMSException {
        MessageHandle handle;
        MessageHandle result = null;
        while (!cancel.get() && (handle = this._handles.removeFirst()) != null) {
            void var3_3;
            MessageImpl message = var3_3.getMessage();
            if (message == null || !this.selects(message)) continue;
            result = var3_3;
            break;
        }
        return result;
    }

    protected void doClose() {
        this._cache.removeQueueListener(this);
    }
}

