/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.config.AdministeredDestinations;
import org.exolab.jms.config.AdministeredQueue;
import org.exolab.jms.config.AdministeredTopic;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.Subscriber;
import org.exolab.jms.messagemgr.ConsumerManager;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.service.Service;
import org.exolab.jms.service.ServiceException;

public class DestinationConfigurator
extends Service {
    private final Configuration _config;
    private final DestinationManager _destinations;
    private final ConsumerManager _consumers;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$DestinationConfigurator == null ? (class$org$exolab$jms$messagemgr$DestinationConfigurator = DestinationConfigurator.class$("org.exolab.jms.messagemgr.DestinationConfigurator")) : class$org$exolab$jms$messagemgr$DestinationConfigurator));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$DestinationConfigurator;

    public DestinationConfigurator(Configuration config, DestinationManager destinations, ConsumerManager consumers) {
        if (config == null) {
            throw new IllegalArgumentException("Argument 'config' is null");
        }
        if (destinations == null) {
            throw new IllegalArgumentException("Argument 'destinations' is null");
        }
        if (consumers == null) {
            throw new IllegalArgumentException("Argument 'consumers' is null");
        }
        this._config = config;
        this._destinations = destinations;
        this._consumers = consumers;
    }

    protected void doStart() throws ServiceException {
        AdministeredDestinations destinations = this._config.getAdministeredDestinations();
        if (destinations != null) {
            this.configureTopics(destinations.getAdministeredTopic());
            this.configureQueues(destinations.getAdministeredQueue());
        }
    }

    protected void configureTopics(AdministeredTopic[] topics) {
        int i = 0;
        while (i < topics.length) {
            AdministeredTopic topic = topics[i];
            String name = topics[i].getName();
            if (this._destinations.getDestination(name) == null) {
                JmsTopic destination = new JmsTopic(name);
                destination.setPersistent(true);
                try {
                    this._destinations.createDestination(destination);
                    int scount = topic.getSubscriberCount();
                    int sindex = 0;
                    while (sindex < scount) {
                        Subscriber subscriber = topic.getSubscriber(sindex);
                        this._consumers.subscribe(destination, subscriber.getName(), null);
                        ++sindex;
                    }
                }
                catch (JMSException exception) {
                    _log.error((Object)("Failed to register persistent topic " + name), (Throwable)exception);
                }
            }
            ++i;
        }
    }

    protected void configureQueues(AdministeredQueue[] queues) {
        int i = 0;
        while (i < queues.length) {
            AdministeredQueue queue = queues[i];
            String name = queue.getName();
            if (this._destinations.getDestination(name) == null) {
                JmsQueue destination = new JmsQueue(name);
                destination.setPersistent(true);
                try {
                    this._destinations.createDestination(destination);
                }
                catch (JMSException exception) {
                    _log.error((Object)("Failed to register persistent queue " + name), (Throwable)exception);
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

