/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.messagemgr.ContextHelper;
import org.exolab.jms.messagemgr.DestinationCache;
import org.exolab.jms.messagemgr.DestinationEventListener;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.server.NameService;
import org.exolab.jms.service.Service;
import org.exolab.jms.service.ServiceException;

public class DestinationBinder
extends Service
implements DestinationEventListener {
    private final DestinationManager _destinations;
    private final NameService _names;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$DestinationBinder == null ? (class$org$exolab$jms$messagemgr$DestinationBinder = DestinationBinder.class$("org.exolab.jms.messagemgr.DestinationBinder")) : class$org$exolab$jms$messagemgr$DestinationBinder));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$DestinationBinder;

    public DestinationBinder(DestinationManager destinations, NameService names) {
        if (destinations == null) {
            throw new IllegalArgumentException("Argument 'destinations' is null");
        }
        if (names == null) {
            throw new IllegalArgumentException("Argument 'names' is null");
        }
        this._destinations = destinations;
        this._names = names;
    }

    public void destinationAdded(JmsDestination destination) throws JMSException {
        if (destination.getPersistent()) {
            try {
                Context context = this._names.getInitialContext();
                ContextHelper.rebind(context, destination.getName(), destination);
            }
            catch (NamingException exception) {
                String msg = "Failed to add destination " + destination.getName() + " to JNDI context";
                _log.error((Object)msg, (Throwable)exception);
                throw new JMSException(msg + ": " + exception.getMessage());
            }
        }
    }

    public void destinationRemoved(JmsDestination destination) {
        if (destination.getPersistent()) {
            try {
                Context context = this._names.getInitialContext();
                context.unbind(destination.getName());
            }
            catch (NamingException error) {
                _log.error((Object)("Failed to remove destination " + destination.getName() + " from JNDI"), (Throwable)error);
            }
        }
    }

    public void cacheAdded(JmsDestination destination, DestinationCache cache) {
    }

    public void cacheRemoved(JmsDestination destination, DestinationCache cache) {
    }

    protected void doStart() throws ServiceException {
        List destinations;
        Context context;
        try {
            context = this._names.getInitialContext();
        }
        catch (NamingException exception) {
            throw new ServiceException("Failed to get initial JNDI context", exception);
        }
        try {
            destinations = this._destinations.getDestinations();
        }
        catch (JMSException exception) {
            throw new ServiceException("Failed to get destinations", exception);
        }
        Iterator i = destinations.iterator();
        while (i.hasNext()) {
            JmsDestination destination = (JmsDestination)i.next();
            if (!destination.getPersistent()) continue;
            try {
                ContextHelper.rebind(context, destination.getName(), destination);
            }
            catch (NamingException exception) {
                throw new ServiceException("Failed to add destination " + destination.getName() + " to JNDI", exception);
            }
        }
        this._destinations.addDestinationEventListener(this);
    }

    protected void doStop() throws ServiceException {
        this._destinations.removeDestinationEventListener(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

