/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import javax.jms.JMSException;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.AbstractMessageRef;
import org.exolab.jms.messagemgr.MessageCache;

class CachedMessageRef
extends AbstractMessageRef {
    private final MessageCache _cache;

    public CachedMessageRef(MessageImpl message, boolean persistent, MessageCache cache) {
        super(message.getMessageId().getId(), persistent);
        if (cache == null) {
            throw new IllegalArgumentException("Argument 'cache' is null");
        }
        this._cache = cache;
    }

    public CachedMessageRef(String messageId, boolean persistent, MessageCache cache) {
        super(messageId, persistent);
        if (cache == null) {
            throw new IllegalArgumentException("Argument 'cache' is null");
        }
        this._cache = cache;
    }

    public MessageImpl getMessage() throws JMSException {
        return this._cache.getMessage(this);
    }

    public synchronized void destroy() throws JMSException {
        if (!this.isDestroyed()) {
            this._cache.destroy(this);
            this.setDestroyed();
        }
    }
}

