/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.AbstractConsumerEndpoint;
import org.exolab.jms.messagemgr.Condition;
import org.exolab.jms.messagemgr.DestinationCache;
import org.exolab.jms.messagemgr.DestinationEventListener;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.messagemgr.MessageQueue;
import org.exolab.jms.messagemgr.TopicConsumerMessageHandle;
import org.exolab.jms.persistence.PersistenceException;

abstract class AbstractTopicConsumerEndpoint
extends AbstractConsumerEndpoint
implements DestinationEventListener {
    private long _connectionId;
    private final DestinationManager _destinations;
    private MessageQueue _handles = new MessageQueue();
    protected Map _caches = Collections.synchronizedMap(new HashMap());
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$messagemgr$AbstractTopicConsumerEndpoint == null ? (class$org$exolab$jms$messagemgr$AbstractTopicConsumerEndpoint = AbstractTopicConsumerEndpoint.class$("org.exolab.jms.messagemgr.AbstractTopicConsumerEndpoint")) : class$org$exolab$jms$messagemgr$AbstractTopicConsumerEndpoint));
    static /* synthetic */ Class class$org$exolab$jms$messagemgr$AbstractTopicConsumerEndpoint;

    public AbstractTopicConsumerEndpoint(long consumerId, long connectionId, JmsTopic topic, String selector, boolean noLocal, DestinationManager destinations) throws JMSException {
        super(consumerId, topic, selector, noLocal);
        this._connectionId = connectionId;
        this._destinations = destinations;
    }

    public long getConnectionId() {
        return this._connectionId;
    }

    public boolean canConsume(JmsDestination destination) {
        boolean result = false;
        if (destination instanceof JmsTopic) {
            JmsTopic topic = (JmsTopic)this.getDestination();
            result = !topic.isWildCard() ? super.canConsume(destination) : topic.match((JmsTopic)destination);
        }
        return result;
    }

    public void returnMessage(MessageHandle handle) {
        this.addMessage(handle);
    }

    public int getMessageCount() {
        return this._handles.size();
    }

    public boolean messageAdded(MessageHandle handle, MessageImpl message) throws JMSException {
        boolean accepted = true;
        if (this.getNoLocal() && message.getConnectionId() == this.getConnectionId()) {
            accepted = false;
        } else if (!this._handles.contains(handle = new TopicConsumerMessageHandle(handle, this))) {
            this.addMessage(handle);
        } else {
            accepted = false;
            _log.warn((Object)("Endpoint=" + this + " already has message cached: " + handle));
        }
        return accepted;
    }

    public void messageRemoved(String messageId) throws JMSException {
        MessageHandle handle = this._handles.remove(messageId);
        if (handle != null) {
            handle.destroy();
        }
    }

    public boolean persistentMessageAdded(MessageHandle handle, MessageImpl message) throws JMSException, PersistenceException {
        boolean accepted = true;
        if (this.getNoLocal() && message.getConnectionId() == this.getConnectionId()) {
            accepted = false;
        } else {
            handle = new TopicConsumerMessageHandle(handle, this);
            if (this.isPersistent()) {
                handle.add();
            }
            if (!this._handles.contains(handle)) {
                this.addMessage(handle);
            } else {
                accepted = false;
                _log.warn((Object)("Endpoint=" + this + " already has message cached: " + handle));
            }
        }
        return accepted;
    }

    public void persistentMessageRemoved(String messageId) throws JMSException, PersistenceException {
        MessageHandle handle = this._handles.remove(messageId);
        if (handle != null) {
            handle.destroy();
        }
    }

    public void destinationAdded(JmsDestination destination) {
    }

    public void destinationRemoved(JmsDestination destination) {
    }

    public void cacheAdded(JmsDestination destination, DestinationCache cache) {
        JmsTopic topic;
        JmsTopic myTopic;
        if (destination instanceof JmsTopic && (myTopic = (JmsTopic)this.getDestination()).match(topic = (JmsTopic)destination) && !this._caches.containsKey(topic)) {
            this._caches.put(topic, cache);
            cache.addConsumer(this);
        }
    }

    public void cacheRemoved(JmsDestination destination, DestinationCache cache) {
        if (destination instanceof JmsTopic) {
            this._caches.remove(destination);
        }
    }

    protected void init() throws JMSException {
        JmsTopic topic = (JmsTopic)this.getDestination();
        if (topic.isWildCard()) {
            this._caches = this._destinations.getTopicDestinationCaches(topic);
            this._destinations.addDestinationEventListener(this);
            DestinationCache[] caches = this.getDestinationCaches();
            int i = 0;
            while (i < caches.length) {
                caches[i].addConsumer(this);
                ++i;
            }
        } else {
            DestinationCache cache = this._destinations.getDestinationCache(topic);
            this._caches.put(topic, cache);
            cache.addConsumer(this);
        }
    }

    protected void setConnectionId(long connectionId) {
        this._connectionId = connectionId;
    }

    protected void addMessage(MessageHandle handle) {
        this._handles.add(handle);
        this.notifyMessageAvailable();
    }

    /*
     * WARNING - void declaration
     */
    protected MessageHandle doReceive(Condition cancel) throws JMSException {
        MessageHandle handle;
        MessageHandle result = null;
        while (!cancel.get() && (handle = this._handles.removeFirst()) != null) {
            MessageImpl message;
            void var3_3;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("doReceive() - next available=" + var3_3.getMessageId()));
            }
            if ((message = var3_3.getMessage()) == null) continue;
            if (this.selects(message)) {
                result = var3_3;
                break;
            }
            var3_3.destroy();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("doReceive() - result=" + (result != null ? result.getMessageId() : null)));
        }
        return result;
    }

    protected void doClose() {
        this._destinations.removeDestinationEventListener(this);
        DestinationCache[] caches = this.getDestinationCaches();
        int i = 0;
        while (i < caches.length) {
            caches[i].removeConsumer(this);
            ++i;
        }
        this._caches.clear();
        if (!this.isPersistent()) {
            MessageHandle[] handles = this._handles.toArray();
            int i2 = 0;
            while (i2 < handles.length) {
                MessageHandle handle = handles[i2];
                try {
                    handle.destroy();
                }
                catch (JMSException exception) {
                    _log.error((Object)exception, (Throwable)exception);
                }
                ++i2;
            }
        }
    }

    protected DestinationManager getDestinationManager() {
        return this._destinations;
    }

    protected DestinationCache[] getDestinationCaches() {
        return this._caches.values().toArray(new DestinationCache[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

