/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.messagemgr;

import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.Condition;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.ConsumerEndpointListener;
import org.exolab.jms.messagemgr.Flag;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.selector.Selector;

public abstract class AbstractConsumerEndpoint
implements ConsumerEndpoint {
    private final long _id;
    private final JmsDestination _destination;
    private Selector _selector;
    private boolean _noLocal;
    private boolean _asynchronous = false;
    private Condition _waitingForMessage;
    private ConsumerEndpointListener _listener = null;
    private final Flag _closed = new Flag(false);

    public AbstractConsumerEndpoint(long consumerId, JmsDestination destination, String selector, boolean noLocal) throws InvalidSelectorException {
        if (destination == null) {
            throw new IllegalArgumentException("Argument 'destination' is null");
        }
        this._id = consumerId;
        this._destination = destination;
        this.setSelector(selector);
        this._noLocal = noLocal;
    }

    public long getId() {
        return this._id;
    }

    public boolean isPersistent() {
        return false;
    }

    public String getPersistentId() {
        return null;
    }

    public JmsDestination getDestination() {
        return this._destination;
    }

    public boolean canConsume(JmsDestination destination) {
        return this._destination.equals(destination);
    }

    public Selector getSelector() {
        return this._selector;
    }

    public boolean selects(MessageImpl message) {
        return this._selector == null || this._selector.selects(message);
    }

    public boolean getNoLocal() {
        return this._noLocal;
    }

    public final synchronized MessageHandle receive(final Condition cancel) throws JMSException {
        MessageHandle result = null;
        if (!this._closed.get()) {
            Condition condition = new Condition(){

                public boolean get() {
                    return AbstractConsumerEndpoint.this._closed.get() || cancel.get();
                }
            };
            result = this.doReceive(condition);
        }
        return result;
    }

    public synchronized void setAsynchronous(boolean asynchronous) {
        this._asynchronous = asynchronous;
    }

    public synchronized boolean isAsynchronous() {
        return this._asynchronous;
    }

    public synchronized void setWaitingForMessage(Condition condition) {
        this._waitingForMessage = condition;
    }

    public synchronized boolean isWaitingForMessage() {
        return this._waitingForMessage != null && this._waitingForMessage.get();
    }

    public synchronized void setListener(ConsumerEndpointListener listener) {
        this._listener = listener;
    }

    public final boolean isClosed() {
        return this._closed.get();
    }

    public final void close() {
        this._closed.set(true);
        AbstractConsumerEndpoint abstractConsumerEndpoint = this;
        synchronized (abstractConsumerEndpoint) {
            this._listener = null;
            this.doClose();
        }
    }

    public String toString() {
        return this._id + ":" + this.getDestination();
    }

    protected abstract MessageHandle doReceive(Condition var1) throws JMSException;

    protected abstract void doClose();

    protected synchronized void notifyMessageAvailable() {
        if (this._listener != null && !this._closed.get()) {
            this._listener.messageAvailable(this);
        }
    }

    protected void setSelector(String selector) throws InvalidSelectorException {
        this._selector = selector != null ? new Selector(selector) : null;
    }

    protected void setNoLocal(boolean noLocal) {
        this._noLocal = noLocal;
    }

    public abstract int getMessageCount();

    public abstract void persistentMessageRemoved(String var1) throws JMSException, PersistenceException;

    public abstract boolean persistentMessageAdded(MessageHandle var1, MessageImpl var2) throws JMSException, PersistenceException;

    public abstract void messageRemoved(String var1) throws JMSException;

    public abstract boolean messageAdded(MessageHandle var1, MessageImpl var2) throws JMSException;
}

