/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.message;

import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.message.MessageConverter;

abstract class AbstractMessageConverter
implements MessageConverter {
    AbstractMessageConverter() {
    }

    public Message convert(Message message) throws JMSException {
        Message result = this.create();
        this.populate(message, result);
        return result;
    }

    protected abstract Message create() throws JMSException;

    protected void populate(Message source, Message target) throws JMSException {
        target.setJMSMessageID(source.getJMSMessageID());
        target.setJMSDestination(source.getJMSDestination());
        target.setJMSTimestamp(source.getJMSTimestamp());
        target.setJMSPriority(source.getJMSPriority());
        target.setJMSExpiration(source.getJMSExpiration());
        target.setJMSDeliveryMode(source.getJMSDeliveryMode());
        target.setJMSCorrelationID(source.getJMSCorrelationID());
        target.setJMSType(source.getJMSType());
        Destination replyTo = source.getJMSReplyTo();
        if (replyTo instanceof JmsDestination) {
            target.setJMSReplyTo(replyTo);
        }
        Enumeration iterator = source.getPropertyNames();
        while (iterator.hasMoreElements()) {
            String name = (String)iterator.nextElement();
            if (name.startsWith("JMSX") && !name.equals("JMSXGroupID") && !name.equals("JMSXGroupSeq")) continue;
            Object value = source.getObjectProperty(name);
            target.setObjectProperty(name, value);
        }
    }
}

