/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.lease;

import org.exolab.jms.common.util.OrderedQueue;
import org.exolab.jms.lease.BaseLease;
import org.exolab.jms.lease.LeaseComparator;
import org.exolab.jms.service.BasicService;
import org.exolab.jms.service.ServiceException;

public class LeaseManager
extends BasicService {
    private OrderedQueue _queue = null;
    private final Object _waiter = new Object();

    public LeaseManager() {
        super("LeaseManager");
        this._queue = new OrderedQueue(new LeaseComparator());
    }

    public void addLease(BaseLease lease) {
        OrderedQueue orderedQueue = this._queue;
        synchronized (orderedQueue) {
            this._queue.add(lease);
            if (this._queue.firstElement() == lease) {
                Object object = this._waiter;
                synchronized (object) {
                    this._waiter.notify();
                }
            }
        }
    }

    public boolean removeLease(BaseLease lease) {
        boolean result = false;
        OrderedQueue orderedQueue = this._queue;
        synchronized (orderedQueue) {
            result = this._queue.remove(lease);
        }
        if (result) {
            Object object = this._waiter;
            synchronized (object) {
                this._waiter.notify();
            }
        }
        return result;
    }

    public BaseLease renewLease(BaseLease lease, long duration) {
        BaseLease newlease = null;
        if (lease != null && duration > 0L) {
            OrderedQueue orderedQueue = this._queue;
            synchronized (orderedQueue) {
                if (this._queue.remove(lease)) {
                    lease.setDuration(duration);
                    this._queue.add(lease);
                    newlease = lease;
                    Object object = this._waiter;
                    synchronized (object) {
                        this._waiter.notify();
                    }
                }
            }
        }
        return newlease;
    }

    public void removeAll() {
        OrderedQueue orderedQueue = this._queue;
        synchronized (orderedQueue) {
            this._queue.clear();
        }
    }

    public void run() {
        while (!Thread.interrupted()) {
            this.expire();
            Object object = this._waiter;
            synchronized (object) {
                try {
                    this._waiter.wait();
                }
                catch (InterruptedException terminate) {
                    break;
                }
            }
        }
    }

    public void doStop() throws ServiceException {
        Object object = this._waiter;
        synchronized (object) {
            this._waiter.notifyAll();
        }
    }

    protected void expire() {
        while (this._queue.size() > 0) {
            BaseLease lease = null;
            boolean expired = false;
            OrderedQueue orderedQueue = this._queue;
            synchronized (orderedQueue) {
                lease = (BaseLease)this._queue.firstElement();
                if (lease == null) {
                    continue;
                }
                if (lease.getExpiryTime() <= System.currentTimeMillis()) {
                    this._queue.removeFirstElement();
                    expired = true;
                }
            }
            if (expired) {
                lease.notifyLeaseExpired();
                continue;
            }
            long time = lease.getExpiryTime() - System.currentTimeMillis();
            if (time <= 0L) continue;
            try {
                Object object = this._waiter;
                synchronized (object) {
                    this._waiter.wait(time);
                }
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
    }
}

