/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.jndi;

import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import org.codehaus.spice.jndikit.NamingProvider;
import org.codehaus.spice.jndikit.RemoteContext;
import org.codehaus.spice.jndikit.StandardNamespace;
import org.exolab.jms.client.net.SharedORB;
import org.exolab.jms.jndi.ORBRemoteContext;
import org.exolab.jms.net.orb.ORB;
import org.exolab.jms.net.proxy.Proxy;
import org.exolab.jms.net.registry.Registry;
import org.exolab.jms.net.uri.URI;

public class InitialContextFactory
implements javax.naming.spi.InitialContextFactory {
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final String SERVLET = "/openjms-tunnel/tunnel";
    private static final String EMBEDDED_SCHEME = "embedded";
    private static final String VM_SCHEME = "vm";
    private static final String VM_PATH = "openjms";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Context getInitialContext(Hashtable environment) throws NamingException {
        NameParser parser;
        NamingProvider provider;
        Registry registry;
        if (environment == null) {
            throw new ConfigurationException("Cannot connect to JNDI provider - environment not set");
        }
        String url = (String)environment.get("java.naming.provider.url");
        if (url == null) {
            throw new ConfigurationException("Cannot connect to JNDI provider - java.naming.provider.url not set ");
        }
        Hashtable<String, String> properties = new Hashtable<String, String>(environment);
        properties.put("java.naming.provider.url", this.getProviderURI(url));
        this.map(properties, "java.naming.provider.url", "org.exolab.jms.net.orb.provider.uri");
        this.map(properties, "java.naming.security.principal", "org.exolab.jms.net.orb.security.principal");
        this.map(properties, "java.naming.security.credentials", "org.exolab.jms.net.orb.security.credentials");
        try {
            ORB orb = SharedORB.getInstance();
            registry = orb.getRegistry(properties);
        }
        catch (RemoteException exception) {
            CommunicationException error = new CommunicationException("Failed to get registry service for URL: " + url);
            error.setRootCause(exception);
            throw error;
        }
        try {
            try {
                provider = (NamingProvider)registry.lookup("jndi");
            }
            catch (NotBoundException exception) {
                throw new ServiceUnavailableException("JNDI service is not bound in the registry for URL: " + url);
            }
            catch (RemoteException exception) {
                CommunicationException error = new CommunicationException("Failed to lookup JNDI provider for URL: " + url);
                error.setRootCause(exception);
                throw error;
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (registry instanceof Proxy) {
                ((Proxy)registry).disposeProxy();
            }
            throw throwable;
        }
        if (registry instanceof Proxy) {
            ((Proxy)registry).disposeProxy();
        }
        try {
            parser = provider.getNameParser();
        }
        catch (NamingException exception) {
            throw exception;
        }
        catch (Exception exception) {
            ServiceUnavailableException error = new ServiceUnavailableException(exception.getMessage());
            error.setRootCause(exception);
            throw error;
        }
        StandardNamespace namespace = new StandardNamespace(parser);
        properties.put("org.codehaus.spice.jndikit.NamingProvider", (String)provider);
        properties.put("org.codehaus.spice.jndikit.Namespace", (String)namespace);
        RemoteContext root = new RemoteContext(properties, parser.parse(""));
        return new ORBRemoteContext(root);
    }

    private String getProviderURI(String uri) throws ConfigurationException {
        URI parsed;
        try {
            parsed = new URI(uri);
            String scheme = parsed.getScheme();
            if (scheme.equals(HTTP_SCHEME) || scheme.equals(HTTPS_SCHEME)) {
                String path = parsed.getPath();
                if (path == null || path.length() == 0 || path.equals("/")) {
                    parsed.setPath(SERVLET);
                }
            } else if (scheme.equals(EMBEDDED_SCHEME)) {
                parsed.setScheme(VM_SCHEME);
                parsed.setPath(VM_PATH);
            }
        }
        catch (IOException exception) {
            throw new ConfigurationException(exception.getMessage());
        }
        return parsed.toString();
    }

    private void map(Hashtable properties, String from, String to) {
        String value = (String)properties.get(from);
        if (value != null) {
            properties.put(to, value);
        }
    }
}

