/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.config;

import org.exolab.jms.config.ConfigHelper;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.Connector;
import org.exolab.jms.config.ConnectorHelper;
import org.exolab.jms.config.ConnectorResource;
import org.exolab.jms.config.Connectors;
import org.exolab.jms.config.JndiConfiguration;
import org.exolab.jms.config.Property;
import org.exolab.jms.config.ServerConfiguration;
import org.exolab.jms.config.types.SchemeType;

public class JndiConfigurationFactory {
    public static JndiConfiguration create(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("Argument config is null");
        }
        JndiConfiguration result = new JndiConfiguration();
        Connectors connectors = config.getConnectors();
        Connector connector = connectors.getConnector(0);
        return JndiConfigurationFactory.create(connector, config);
    }

    public static JndiConfiguration create(Connector connector, Configuration config) {
        if (connector == null) {
            throw new IllegalArgumentException("Argument connector is null");
        }
        if (config == null) {
            throw new IllegalArgumentException("Argument config is null");
        }
        JndiConfiguration result = new JndiConfiguration();
        ServerConfiguration server = config.getServerConfiguration();
        SchemeType scheme = connector.getScheme();
        ConnectorResource resource = ConnectorHelper.getConnectorResource(scheme, config);
        Property context = new Property();
        context.setName("java.naming.factory.initial");
        context.setValue(resource.getJndi().getInitialContextClass());
        result.addProperty(context);
        Property url = new Property();
        url.setName("java.naming.provider.url");
        url.setValue(ConfigHelper.getJndiURL(scheme, config));
        result.addProperty(url);
        return result;
    }
}

