/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.config;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.xml.EventProducer;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class AttributeExpander
implements EventProducer {
    private DocumentHandler _handler = null;
    private Reader _reader = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$config$AttributeExpander == null ? (class$org$exolab$jms$config$AttributeExpander = AttributeExpander.class$("org.exolab.jms.config.AttributeExpander")) : class$org$exolab$jms$config$AttributeExpander));
    static /* synthetic */ Class class$org$exolab$jms$config$AttributeExpander;

    public AttributeExpander(Reader reader) {
        this._reader = reader;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this._handler = handler;
    }

    public void start() throws SAXException {
        Parser parser = Configuration.getDefaultParser();
        if (parser == null) {
            throw new SAXException("Unable to create parser");
        }
        AttributeInterceptor handler = new AttributeInterceptor();
        parser.setDocumentHandler(handler);
        try {
            parser.parse(new InputSource(this._reader));
        }
        catch (IOException exception) {
            throw new SAXException(exception.getMessage(), exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AttributeInterceptor
    implements DocumentHandler {
        private AttributeInterceptor() {
        }

        public void setDocumentLocator(Locator locator) {
            AttributeExpander.this._handler.setDocumentLocator(locator);
        }

        public void startDocument() throws SAXException {
            AttributeExpander.this._handler.startDocument();
        }

        public void endDocument() throws SAXException {
            AttributeExpander.this._handler.endDocument();
        }

        public void startElement(String name, AttributeList list) throws SAXException {
            AttributeListImpl replaced = new AttributeListImpl();
            int i = 0;
            while (i < list.getLength()) {
                String value = this.expand(list.getName(i), list.getValue(i));
                replaced.addAttribute(list.getName(i), list.getType(i), value);
                ++i;
            }
            AttributeExpander.this._handler.startElement(name, replaced);
        }

        public void endElement(String name) throws SAXException {
            AttributeExpander.this._handler.endElement(name);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            AttributeExpander.this._handler.characters(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            AttributeExpander.this._handler.ignorableWhitespace(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            AttributeExpander.this._handler.processingInstruction(target, data);
        }

        /*
         * WARNING - void declaration
         */
        private String expand(String attribute, String value) {
            int pos;
            StringBuffer buffer = new StringBuffer();
            int prev = 0;
            while ((pos = value.indexOf("${", prev)) >= 0) {
                int index;
                void var5_5;
                if (var5_5 > 0) {
                    buffer.append(value.substring(prev, (int)var5_5));
                }
                if ((index = value.indexOf(125, (int)var5_5)) < 0) {
                    _log.warn((Object)("Cannot expand " + attribute + " - invalid format: " + value));
                    buffer.append("${");
                    prev = var5_5 + 2;
                    continue;
                }
                String name = value.substring((int)(var5_5 + 2), index);
                String property = System.getProperty(name);
                if (property != null) {
                    buffer.append(property);
                } else {
                    _log.warn((Object)("Cannot expand " + attribute + " as property " + name + " is not defined"));
                    buffer.append("${");
                    buffer.append(name);
                    buffer.append("}");
                }
                prev = index + 1;
            }
            if (prev < value.length()) {
                buffer.append(value.substring(prev));
            }
            String result = buffer.toString();
            return result;
        }
    }
}

