/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.net;

import java.rmi.RemoteException;
import java.util.List;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.net.orb.ORB;
import org.exolab.jms.net.proxy.Proxy;
import org.exolab.jms.server.ServerSession;

public class JmsSessionStubImpl
implements ServerSession,
JmsMessageListener {
    private JmsMessageListener _listener;
    private ORB _orb;
    private ServerSession _session;

    protected JmsSessionStubImpl(ServerSession session, ORB orb, String uri, String principal, String credentials) throws RemoteException {
        if (session == null) {
            throw new IllegalArgumentException("Argument 'session' is null");
        }
        if (orb == null) {
            throw new IllegalArgumentException("Argument 'orb' is null");
        }
        this._session = session;
        this._orb = orb;
        Proxy proxy = orb.exportObjectTo((Object)this, uri, principal, credentials);
        this._session.setMessageListener((JmsMessageListener)proxy);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws JMSException {
        try {
            try {
                this._session.close();
                this._orb.unexportObject((Object)this);
            }
            catch (RemoteException exception) {
                this.rethrow(exception);
                Object var3_2 = null;
                if (this._session instanceof Proxy) {
                    ((Proxy)this._session).disposeProxy();
                }
                this._session = null;
                this._listener = null;
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this._session instanceof Proxy) {
                ((Proxy)this._session).disposeProxy();
            }
            this._session = null;
            this._listener = null;
            throw throwable;
        }
        if (this._session instanceof Proxy) {
            ((Proxy)this._session).disposeProxy();
        }
        this._session = null;
        this._listener = null;
    }

    public void acknowledgeMessage(long consumerId, String messageId) throws JMSException {
        this._session.acknowledgeMessage(consumerId, messageId);
    }

    public void send(MessageImpl message) throws JMSException {
        this._session.send(message);
    }

    public void send(List messages) throws JMSException {
        this._session.send(messages);
    }

    public MessageImpl receiveNoWait(long consumerId) throws JMSException {
        return this._session.receiveNoWait(consumerId);
    }

    public MessageImpl receive(long consumerId, long wait) throws JMSException {
        return this._session.receive(consumerId, wait);
    }

    public List browse(long consumerId, int count) throws JMSException {
        return this._session.browse(consumerId, count);
    }

    public long createConsumer(JmsDestination destination, String selector, boolean noLocal) throws JMSException {
        return this._session.createConsumer(destination, selector, noLocal);
    }

    public long createDurableConsumer(JmsTopic topic, String name, String selector, boolean noLocal) throws JMSException {
        return this._session.createDurableConsumer(topic, name, selector, noLocal);
    }

    public long createBrowser(JmsQueue queue, String selector) throws JMSException {
        return this._session.createBrowser(queue, selector);
    }

    public void closeConsumer(long consumerId) throws JMSException {
        this._session.closeConsumer(consumerId);
    }

    public void unsubscribe(String name) throws JMSException {
        this._session.unsubscribe(name);
    }

    public void start() throws JMSException {
        this._session.start();
    }

    public void stop() throws JMSException {
        this._session.stop();
    }

    public void setMessageListener(JmsMessageListener listener) {
        this._listener = listener;
    }

    public void setAsynchronous(long consumerId, boolean enable) throws JMSException {
        this._session.setAsynchronous(consumerId, enable);
    }

    public void recover() throws JMSException {
        this._session.recover();
    }

    public void commit() throws JMSException {
        this._session.commit();
    }

    public void rollback() throws JMSException {
        this._session.rollback();
    }

    public void start(Xid xid, int flags) throws XAException {
        this._session.start(xid, flags);
    }

    public int prepare(Xid xid) throws XAException {
        return this._session.prepare(xid);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this._session.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        this._session.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        this._session.forget(xid);
    }

    public void rollback(Xid xid) throws XAException {
        this._session.rollback(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this._session.recover(flag);
    }

    public int getTransactionTimeout() throws XAException {
        return this._session.getTransactionTimeout();
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this._session.setTransactionTimeout(seconds);
    }

    public String getResourceManagerId() throws XAException {
        return this._session.getResourceManagerId();
    }

    public boolean onMessage(MessageImpl message) throws RemoteException {
        return this._listener.onMessage(message);
    }

    public void onMessageAvailable() throws RemoteException {
        this._listener.onMessageAvailable();
    }

    private void rethrow(RemoteException exception) throws JMSException {
        JMSException error = new JMSException(exception.getMessage());
        error.setLinkedException((Exception)exception);
        throw error;
    }
}

