/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.net;

import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.exolab.jms.client.JmsServerStubIfc;
import org.exolab.jms.client.net.JmsConnectionStubImpl;
import org.exolab.jms.client.net.SharedORB;
import org.exolab.jms.net.connector.Caller;
import org.exolab.jms.net.connector.CallerListener;
import org.exolab.jms.net.orb.ORB;
import org.exolab.jms.net.proxy.Proxy;
import org.exolab.jms.net.registry.Registry;
import org.exolab.jms.server.ServerConnection;
import org.exolab.jms.server.ServerConnectionFactory;

public class JmsServerStubImpl
implements JmsServerStubIfc,
CallerListener {
    private ORB _orb;
    private final Map _properties;
    private final String _serverURI;
    private final String _defaultUser;
    private final String _defaultPassword;
    private ExceptionListener _listener = null;

    public JmsServerStubImpl(Map properties, Map environment) {
        if (properties == null) {
            throw new IllegalArgumentException("Argument 'properties' is null");
        }
        this._properties = properties;
        this._serverURI = (String)properties.get("org.exolab.jms.net.orb.provider.uri");
        if (this._serverURI == null) {
            throw new IllegalArgumentException("Argument 'properties' does not contain property org.exolab.jms.net.orb.provider.uri");
        }
        if (environment != null) {
            this._defaultUser = (String)environment.get("org.exolab.jms.net.orb.security.principal");
            this._defaultPassword = (String)environment.get("org.exolab.jms.net.orb.security.credentials");
        } else {
            this._defaultUser = null;
            this._defaultPassword = null;
        }
    }

    public ServerConnection createConnection(String clientID, String user, String password) throws JMSException {
        JmsConnectionStubImpl stub;
        if (user == null) {
            user = this._defaultUser;
            password = this._defaultPassword;
        }
        ServerConnectionFactory factory = this.getServerConnectionFactory(user, password);
        try {
            ServerConnection connection = factory.createConnection(clientID, user, password);
            stub = new JmsConnectionStubImpl(connection, this._orb, this._serverURI, user, password);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (factory instanceof Proxy) {
                ((Proxy)factory).disposeProxy();
            }
            throw throwable;
        }
        if (factory instanceof Proxy) {
            ((Proxy)factory).disposeProxy();
        }
        return stub;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this._listener = listener;
    }

    public void disconnected(Caller caller) {
        if (this._listener != null) {
            this._listener.onException(new JMSException("Lost connection"));
        }
    }

    private synchronized ServerConnectionFactory getServerConnectionFactory(String user, String password) throws JMSException {
        ServerConnectionFactory factory = null;
        HashMap<String, String> properties = this._properties;
        if (user != null) {
            properties = new HashMap<String, String>(this._properties);
            properties.put("org.exolab.jms.net.orb.security.principal", user);
            properties.put("org.exolab.jms.net.orb.security.credentials", password);
        }
        Registry registry = null;
        try {
            if (this._orb == null) {
                this._orb = SharedORB.getInstance();
            }
            registry = this._orb.getRegistry(properties);
        }
        catch (AccessException exception) {
            JMSSecurityException error = new JMSSecurityException(exception.getMessage());
            error.setLinkedException((Exception)exception);
            throw error;
        }
        catch (RemoteException exception) {
            JMSException error = new JMSException("Failed to get registry service for URL: " + this._serverURI);
            error.setLinkedException((Exception)exception);
            throw error;
        }
        try {
            factory = (ServerConnectionFactory)registry.lookup("server");
        }
        catch (NotBoundException exception) {
            throw new JMSException("Server is not bound in the registry for URL: " + this._serverURI);
        }
        catch (RemoteException exception) {
            JMSException error = new JMSException("Failed to lookup OpenJMS server for URL: " + this._serverURI);
            error.setLinkedException((Exception)exception);
            throw error;
        }
        try {
            this._orb.addCallerListener(this._serverURI, (CallerListener)this);
        }
        catch (RemoteException exception) {
            JMSException error = new JMSException("Failed to register for disconnection notification for URL: " + this._serverURI);
            error.setLinkedException((Exception)exception);
            throw error;
        }
        if (registry instanceof Proxy) {
            ((Proxy)registry).disposeProxy();
        }
        return factory;
    }
}

