/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.net;

import java.rmi.RemoteException;
import javax.jms.JMSException;
import org.exolab.jms.client.net.JmsSessionStubImpl;
import org.exolab.jms.net.orb.ORB;
import org.exolab.jms.net.proxy.Proxy;
import org.exolab.jms.server.ServerConnection;
import org.exolab.jms.server.ServerSession;

public class JmsConnectionStubImpl
implements ServerConnection {
    private ServerConnection _connection;
    private final ORB _orb;
    private final String _uri;
    private final String _principal;
    private final String _credentials;

    public JmsConnectionStubImpl(ServerConnection connection, ORB orb, String uri, String principal, String credentials) {
        if (connection == null) {
            throw new IllegalArgumentException("Argument 'connection' is null");
        }
        this._connection = connection;
        this._orb = orb;
        this._uri = uri;
        this._principal = principal;
        this._credentials = credentials;
    }

    public long getConnectionId() throws JMSException {
        return this._connection.getConnectionId();
    }

    public String getClientID() throws JMSException {
        return this._connection.getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        this._connection.setClientID(clientID);
    }

    public ServerSession createSession(int acknowledgeMode, boolean transacted) throws JMSException {
        JmsSessionStubImpl result = null;
        try {
            ServerSession session = this._connection.createSession(acknowledgeMode, transacted);
            result = new JmsSessionStubImpl(session, this._orb, this._uri, this._principal, this._credentials);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to create session: " + exception);
        }
        return result;
    }

    public void close() throws JMSException {
        try {
            this._connection.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this._connection instanceof Proxy) {
                ((Proxy)this._connection).disposeProxy();
            }
            this._connection = null;
            throw throwable;
        }
        if (this._connection instanceof Proxy) {
            ((Proxy)this._connection).disposeProxy();
        }
        this._connection = null;
    }
}

