/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.exolab.jms.server.ServerSession;

class JmsXAResource
implements XAResource {
    private ServerSession _session;
    private String _rmId = null;

    public JmsXAResource(ServerSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 'session' is null");
        }
        this._session = session;
    }

    public void start(Xid xid, int flags) throws XAException {
        this._session.start(xid, flags);
    }

    public int prepare(Xid xid) throws XAException {
        return this._session.prepare(xid);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this._session.commit(xid, onePhase);
    }

    public void end(Xid xid, int flags) throws XAException {
        this._session.end(xid, flags);
    }

    public void forget(Xid xid) throws XAException {
        this._session.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this._session.getTransactionTimeout();
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this._session.setTransactionTimeout(seconds);
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        boolean result = xares instanceof JmsXAResource;
        if (result) {
            JmsXAResource other = (JmsXAResource)xares;
            result = other.getResourceManagerId() == this.getResourceManagerId();
        }
        return result;
    }

    public Xid[] recover(int flag) throws XAException {
        return this._session.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this._session.rollback(xid);
    }

    public synchronized String getResourceManagerId() throws XAException {
        if (this._rmId == null) {
            this._rmId = this._session.getResourceManagerId();
        }
        return this._rmId;
    }
}

