/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsConnectionConsumer;
import org.exolab.jms.client.JmsConnectionFactory;
import org.exolab.jms.client.JmsConnectionMetaData;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsSession;
import org.exolab.jms.client.JmsTemporaryDestination;
import org.exolab.jms.server.ServerConnection;

class JmsConnection
implements Connection {
    private JmsConnectionFactory _factory;
    private ServerConnection _connection;
    private final long _connectionId;
    private boolean _closed = false;
    private boolean _stopped = true;
    private boolean _modified = false;
    private String _clientId;
    private boolean _clientIdSet = false;
    private ExceptionListener _exceptionListener;
    private List _sessions = new ArrayList();
    private static final JmsConnectionMetaData _metaData = new JmsConnectionMetaData();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$client$JmsConnection == null ? (class$org$exolab$jms$client$JmsConnection = JmsConnection.class$("org.exolab.jms.client.JmsConnection")) : class$org$exolab$jms$client$JmsConnection));
    static /* synthetic */ Class class$org$exolab$jms$client$JmsConnection;

    protected JmsConnection(JmsConnectionFactory factory, String clientID, String username, String password) throws JMSException {
        if (factory == null) {
            throw new IllegalArgumentException("Argument 'factory' is null");
        }
        this._factory = factory;
        this._clientId = clientID;
        this._stopped = true;
        this._connection = factory.getProxy().createConnection(this._clientId, username, password);
        this._connectionId = this._connection.getConnectionId();
    }

    public long getConnectionId() {
        return this._connectionId;
    }

    public String getClientID() throws JMSException {
        this.ensureOpen();
        this.setModified();
        return this._clientId;
    }

    public void setClientID(String clientID) throws JMSException {
        this.ensureOpen();
        if (this._clientIdSet) {
            throw new IllegalStateException("The client id has already been set");
        }
        if (this._modified) {
            throw new IllegalStateException("The client identifier must be set before any other operation is performed");
        }
        this._connection.setClientID(clientID);
        this._clientId = clientID;
        this._clientIdSet = true;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.ensureOpen();
        this.setModified();
        return _metaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.ensureOpen();
        this.setModified();
        return this._exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.ensureOpen();
        this.setModified();
        this._exceptionListener = listener;
    }

    public void notifyExceptionListener(JMSException message) {
        if (message.getErrorCode() != null && message.getErrorCode().equals("connection_to_server_dropped")) {
            try {
                this.close();
            }
            catch (JMSException exception) {
                _log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        if (this._exceptionListener != null) {
            this._exceptionListener.onException(message);
        }
    }

    public synchronized void start() throws JMSException {
        this.ensureOpen();
        this.setModified();
        if (this._stopped) {
            Iterator iterator = this._sessions.iterator();
            while (iterator.hasNext()) {
                JmsSession session = (JmsSession)iterator.next();
                session.start();
            }
            this._stopped = false;
        }
    }

    public synchronized void stop() throws JMSException {
        this.ensureOpen();
        this.setModified();
        if (!this._stopped) {
            List list = this._sessions;
            synchronized (list) {
                Iterator iterator = this._sessions.iterator();
                while (iterator.hasNext()) {
                    JmsSession session = (JmsSession)iterator.next();
                    session.stop();
                }
            }
            this._stopped = true;
        }
    }

    public synchronized void close() throws JMSException {
        if (!this._closed) {
            this.stop();
            JmsSession[] sessions = null;
            List list = this._sessions;
            synchronized (list) {
                sessions = this._sessions.toArray(new JmsSession[0]);
            }
            int i = 0;
            while (i < sessions.length) {
                sessions[i].close();
                ++i;
            }
            this.getServerConnection().close();
            this._connection = null;
            this._factory.removeConnection(this);
            this._factory = null;
            this._closed = true;
        }
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.ensureOpen();
        this.setModified();
        JmsSession session = new JmsSession(this, transacted, acknowledgeMode);
        if (!this.isStopped()) {
            session.start();
        }
        this.addSession(session);
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.ensureOpen();
        this.setModified();
        return new JmsConnectionConsumer(this, destination, sessionPool, messageSelector, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.ensureOpen();
        this.setModified();
        return new JmsConnectionConsumer(this, (Destination)topic, subscriptionName, sessionPool, messageSelector, maxMessages);
    }

    protected ServerConnection getServerConnection() throws JMSException {
        if (this._connection == null) {
            throw new JMSException("Connection closed");
        }
        return this._connection;
    }

    protected void addSession(JmsSession session) {
        List list = this._sessions;
        synchronized (list) {
            this._sessions.add(session);
        }
    }

    protected void removeSession(JmsSession session) {
        List list = this._sessions;
        synchronized (list) {
            this._sessions.remove(session);
        }
    }

    protected boolean isStopped() {
        return this._stopped;
    }

    protected void setModified() {
        this._modified = true;
    }

    protected synchronized void deleteTemporaryDestination(JmsDestination destination) throws JMSException {
        if (destination != null && destination instanceof JmsTemporaryDestination) {
            JmsTemporaryDestination temp_dest = (JmsTemporaryDestination)((Object)destination);
            if (temp_dest.getOwningConnection() != this) {
                throw new JMSException("The temp destination cannot be used outside the scope of the connection creating it");
            }
        } else {
            throw new JMSException("The destination is not temporary");
        }
    }

    protected void ensureOpen() throws IllegalStateException {
        if (this._closed) {
            throw new IllegalStateException("Cannot perform operation - session has been closed");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

