/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.authentication;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.authentication.User;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.SecurityConfiguration;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceAdapter;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.service.Service;
import org.exolab.jms.service.ServiceException;

public class UserManager
extends Service {
    private HashMap _userCache = new HashMap();
    private final Configuration _config;
    private final DatabaseService _database;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$authentication$UserManager == null ? (class$org$exolab$jms$authentication$UserManager = UserManager.class$("org.exolab.jms.authentication.UserManager")) : class$org$exolab$jms$authentication$UserManager));
    static /* synthetic */ Class class$org$exolab$jms$authentication$UserManager;

    public UserManager(Configuration config, DatabaseService database) {
        if (config == null) {
            throw new IllegalArgumentException("Argument 'config' is null");
        }
        if (database == null) {
            throw new IllegalArgumentException("Argument 'database' is null");
        }
        this._config = config;
        this._database = database;
    }

    public synchronized boolean createUser(User user) {
        boolean success = false;
        PersistenceAdapter adapter = this._database.getAdapter();
        if (this._userCache.get(user.getUsername()) == null) {
            try {
                this._database.begin();
                Connection connection = this._database.getConnection();
                adapter.addUser(connection, user);
                this.addToUserCache(user);
                this._database.commit();
                success = true;
            }
            catch (Exception exception) {
                _log.error((Object)"Failed to create user", (Throwable)exception);
                try {
                    this._database.rollback();
                }
                catch (PersistenceException error) {
                    _log.error((Object)error, (Throwable)error);
                }
            }
        }
        return success;
    }

    public synchronized boolean updateUser(User user) {
        boolean success = false;
        PersistenceAdapter adapter = this._database.getAdapter();
        if (this._userCache.get(user.getUsername()) != null) {
            try {
                this._database.begin();
                Connection connection = this._database.getConnection();
                adapter.updateUser(connection, user);
                this._database.commit();
                this.addToUserCache(user);
                success = true;
            }
            catch (Exception exception) {
                _log.error((Object)"Failed to update user", (Throwable)exception);
                this.rollback();
            }
        }
        return success;
    }

    public synchronized boolean deleteUser(User user) {
        boolean success = false;
        PersistenceAdapter adapter = this._database.getAdapter();
        if (this._userCache.get(user.getUsername()) != null) {
            try {
                this._database.begin();
                Connection connection = this._database.getConnection();
                adapter.removeUser(connection, user);
                this.removeFromUserCache(user);
                success = true;
                this._database.commit();
            }
            catch (Exception exception) {
                _log.error((Object)"Failed to remove user", (Throwable)exception);
                this.rollback();
            }
        }
        return success;
    }

    public synchronized User getUser(User user) {
        return (User)this._userCache.get(user.getUsername());
    }

    public Iterator userNames() {
        return this._userCache.keySet().iterator();
    }

    public synchronized boolean validateUser(String username, String password) {
        boolean result = false;
        SecurityConfiguration config = this._config.getSecurityConfiguration();
        if (!config.getSecurityEnabled()) {
            result = true;
        } else {
            User user = (User)this._userCache.get(username);
            if (user != null && user.getPassword().equals(password)) {
                result = true;
            }
        }
        return result;
    }

    protected void doStart() throws ServiceException {
        this.init();
    }

    protected synchronized void doStop() {
        this._userCache.clear();
    }

    protected void init() throws ServiceException {
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            Enumeration iter = this._database.getAdapter().getAllUsers(connection);
            this._database.commit();
            while (iter.hasMoreElements()) {
                User user = (User)iter.nextElement();
                this.addToUserCache(user);
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Failed to initialise UserManager", (Throwable)exception);
            this.rollback();
            throw new ServiceException(exception);
        }
        this.registerConfiguredUsers();
    }

    protected void addToUserCache(User user) {
        this._userCache.put(user.getUsername(), user);
    }

    protected void removeFromUserCache(User user) {
        this._userCache.remove(user.getUsername());
    }

    protected void registerConfiguredUsers() {
        if (this._config.getUsers() != null) {
            org.exolab.jms.config.User[] users = this._config.getUsers().getUser();
            int i = 0;
            while (i < users.length) {
                User user = new User(users[i].getName(), users[i].getPassword());
                this.createUser(user);
                ++i;
            }
        }
    }

    private void rollback() {
        try {
            this._database.rollback();
        }
        catch (PersistenceException exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

