/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.authentication;

import java.security.Principal;
import org.exolab.jms.authentication.User;
import org.exolab.jms.authentication.UserManager;
import org.exolab.jms.common.security.BasicPrincipal;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.service.Service;

public class AuthenticationMgr
extends Service
implements Authenticator {
    private final UserManager _users;

    public AuthenticationMgr(UserManager users) {
        super("AuthenticationMgr");
        if (users == null) {
            throw new IllegalArgumentException("Argument 'users' is null");
        }
        this._users = users;
    }

    public boolean addUser(User user) {
        return this._users.createUser(user);
    }

    public boolean removeUser(User user) {
        return this._users.deleteUser(user);
    }

    public boolean updateUser(User user) {
        return this._users.updateUser(user);
    }

    public boolean validateUser(String username, String password) {
        return this._users.validateUser(username, password);
    }

    public boolean authenticate(Principal principal) {
        String user = null;
        String password = null;
        if (principal instanceof BasicPrincipal) {
            BasicPrincipal basic = (BasicPrincipal)principal;
            user = basic.getName();
            password = basic.getPassword();
        }
        return this.validateUser(user, password);
    }
}

