/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.common.uuid;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Clock
extends Thread {
    public static final int UNSYNCH_TICKS = 100;
    public static final int SYNCH_EVERY = 10;
    private static long _clock;
    private static int _unsynchTicks;
    private static int _synchEvery;
    private static long _advance;
    private static int _adjust;
    private static final Log _log;
    static /* synthetic */ Class class$org$exolab$jms$common$uuid$Clock;

    public static synchronized long clock() {
        return _clock;
    }

    public static void setUnsynchTicks(int ticks) {
        if (ticks <= 0) {
            ticks = 100;
        } else if (ticks < 100) {
            ticks = 100;
        }
        _unsynchTicks = ticks;
    }

    public static int getUnsynchTicks() {
        return _unsynchTicks;
    }

    public static void setSynchEvery(int every) {
        if (every <= 0) {
            every = 10;
        }
        _synchEvery = every;
    }

    public static synchronized void advance(long byMillis) {
        _advance += byMillis;
        _clock += byMillis;
    }

    public static long getAdvance() {
        return _advance;
    }

    public void run() {
        while (true) {
            try {
                int i = 0;
                while (i < _synchEvery) {
                    Thread.sleep(_unsynchTicks);
                    Class clazz = class$org$exolab$jms$common$uuid$Clock == null ? Clock.class$("org.exolab.jms.common.uuid.Clock") : class$org$exolab$jms$common$uuid$Clock;
                    synchronized (clazz) {
                        _clock += (long)(_unsynchTicks + _adjust);
                    }
                    ++i;
                }
                Clock.synchronize();
                continue;
            }
            catch (InterruptedException exception) {
                Clock.synchronize();
                continue;
            }
            catch (ThreadDeath exception) {
                _log.debug((Object)"clock daemon terminating", (Throwable)exception);
                throw exception;
            }
            catch (Throwable exception) {
                _log.error((Object)"Internal error in clock daemon", exception);
                continue;
            }
            break;
        }
    }

    public static synchronized long synchronize() {
        int adjust;
        long clock;
        long retarded;
        long current = System.currentTimeMillis();
        if (current != (retarded = (clock = _clock) - _advance) && (adjust = (int)(current - retarded) / _synchEvery) != 0) {
            _adjust += adjust;
        }
        if (current > retarded) {
            _clock = clock = current + _advance;
        }
        return clock;
    }

    private Clock() {
        super("Clock Daemon");
        _clock = System.currentTimeMillis();
        this.setPriority(10);
        this.setDaemon(true);
        this.start();
    }

    public static void main(String[] args) {
        try {
            int count = 1000000;
            System.out.println("Using Clock.clock()");
            long clock = System.currentTimeMillis();
            int i = 0;
            while (i < count) {
                if (i % 100 == 0) {
                    Clock.synchronize();
                } else {
                    Clock.clock();
                }
                ++i;
            }
            clock = System.currentTimeMillis() - clock;
            System.out.println("Performed " + count + " in " + clock + "ms");
            System.out.println("Using System.currentTimeMillis()");
            clock = System.currentTimeMillis();
            int i2 = 0;
            while (i2 < count) {
                System.currentTimeMillis();
                ++i2;
            }
            clock = System.currentTimeMillis() - clock;
            System.out.println("Performed " + count + " in " + clock + "ms");
        }
        catch (Exception except) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _unsynchTicks = 100;
        _synchEvery = 10;
        _log = LogFactory.getLog((Class)(class$org$exolab$jms$common$uuid$Clock == null ? (class$org$exolab$jms$common$uuid$Clock = Clock.class$("org.exolab.jms.common.uuid.Clock")) : class$org$exolab$jms$common$uuid$Clock));
        new Clock();
    }
}

