/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.common.util;

import java.util.Comparator;
import java.util.Vector;

public class OrderedQueue {
    private Vector _queue = null;
    private Comparator _comparator = null;

    public OrderedQueue(Comparator comparator) {
        this._comparator = comparator;
        this._queue = new Vector();
    }

    public synchronized void add(Object object) {
        if (this._queue.size() == 0) {
            this._queue.addElement(object);
        } else {
            int start = 0;
            int end = this._queue.size() - 1;
            if (this._comparator.compare(object, this._queue.firstElement()) < 0) {
                this._queue.insertElementAt(object, 0);
            } else if (this._comparator.compare(object, this._queue.lastElement()) > 0) {
                this._queue.addElement(object);
            } else {
                while (true) {
                    int result;
                    int midpoint = start + (end - start) / 2;
                    if ((end - start) % 2 != 0) {
                        ++midpoint;
                    }
                    if ((result = this._comparator.compare(object, this._queue.elementAt(midpoint))) == 0) {
                        this._queue.insertElementAt(object, midpoint);
                        break;
                    }
                    if (start + 1 == end) {
                        this._queue.insertElementAt(object, end);
                        break;
                    }
                    if (result > 0) {
                        start = midpoint;
                        continue;
                    }
                    end = midpoint;
                }
            }
        }
    }

    public synchronized boolean remove(Object object) {
        return this._queue.remove(object);
    }

    public synchronized void clear() {
        this._queue.clear();
    }

    public int size() {
        return this._queue.size();
    }

    public Object firstElement() {
        return this._queue.firstElement();
    }

    public synchronized Object removeFirstElement() {
        return this._queue.remove(0);
    }
}

