/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.jndikit;

import java.util.NoSuchElementException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.codehaus.spice.jndikit.Namespace;

public abstract class AbstractNamingEnumeration
implements NamingEnumeration {
    private Context m_owner;
    private Namespace m_namespace;

    public AbstractNamingEnumeration(Context owner, Namespace namespace) {
        this.m_owner = owner;
        this.m_namespace = namespace;
    }

    public boolean hasMore() throws NamingException {
        return this.hasMoreElements();
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException ne) {
            throw new NoSuchElementException(ne.toString());
        }
    }

    protected Object resolve(String name, Object object) throws NamingException {
        try {
            Name atom = this.m_owner.getNameParser(name).parse(name);
            return this.m_namespace.getObjectInstance(object, atom, this.m_owner, this.m_owner.getEnvironment());
        }
        catch (Exception e) {
            NamingException ne = new NamingException("getObjectInstance failed");
            ne.setRootCause(e);
            throw ne;
        }
    }

    public void close() {
        this.m_namespace = null;
        this.m_owner = null;
    }

    public abstract Object next() throws NamingException;

    public abstract boolean hasMoreElements();
}

