/*
 * Decompiled with CFR 0.152.
 */
package idl_reflection;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.omg.CORBA.ORB;
import org.openorb.compiler.idl.parser.idlParser;
import org.openorb.compiler.idl.reflect.idlAttribute;
import org.openorb.compiler.idl.reflect.idlObject;
import org.openorb.compiler.idl.reflect.idlOperation;

public class reflection {
    public static void displayHelp() {
        System.out.println("");
        System.out.println("");
        System.out.println("##################################################");
        System.out.println("#                                                #");
        System.out.println("#          OpenORB IDL Reflection Example        #");
        System.out.println("#                                                #");
        System.out.println("##################################################");
        System.out.println("");
        System.out.println("");
        System.out.println("Usage");
        System.out.println("-----");
        System.out.println("");
        System.out.println("\tReflectionEx idl_file_name");
        System.out.println("");
        System.out.println("Example");
        System.out.println("-------");
        System.out.println("\tReflectionEx ReflectionEx.idl");
        System.exit(0);
    }

    public static void generateHTML(Enumeration enumeration) {
        try {
            File file = new File("ReflectionEx.html");
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.println("<html>\n<head>\n<title>OpenORB IDL Reflection - Generated HTML Page</title>\n</head>\n<body>");
            printWriter.println("<b>The following document was generated from an IDL file using the IDL Reflection.</b><br>");
            reflection.addContents(enumeration, printWriter);
            printWriter.println("</body>\n</html>");
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("[IDL Reflection Example] File error.");
            System.exit(0);
        }
    }

    public static void addContents(Enumeration enumeration, PrintWriter printWriter) {
        block6: while (enumeration.hasMoreElements()) {
            idlObject idlObject2 = (idlObject)enumeration.nextElement();
            switch (idlObject2.idlType()) {
                case 17: {
                    if (((idlAttribute)idlObject2).isReadOnly()) {
                        printWriter.println("readonly attribute ");
                    } else {
                        printWriter.println("attribute ");
                    }
                    printWriter.println(idlObject2.idlName() + ";<br><br>");
                    break;
                }
                case 1: {
                    if (idlObject2.idlName().equals("CORBA")) continue block6;
                    printWriter.println("module ");
                    printWriter.println("<font color=blue>" + idlObject2.idlName() + "</font>{<br><br>");
                    reflection.addContents(idlObject2.content(), printWriter);
                    printWriter.println("<br>};<br><br>");
                    break;
                }
                case 15: {
                    printWriter.println("interface ");
                    printWriter.println("<font color=red>" + idlObject2.idlName() + "</font>{<br><br>");
                    reflection.addContents(idlObject2.content(), printWriter);
                    printWriter.println("<br>};<br><br>");
                    break;
                }
                case 16: {
                    if (((idlOperation)idlObject2).isOneway()) {
                        printWriter.println("oneway ");
                    }
                    printWriter.println("void <font color=green>" + idlObject2.idlName() + "</font>();<br><br>");
                    break;
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            reflection.displayHelp();
        }
        System.out.println("[IDL Reflection Example] Generating HTML from IDL...");
        ORB oRB = ORB.init(stringArray, null);
        idlParser idlParser2 = new idlParser(stringArray);
        int n = idlParser2.compile(System.out);
        if (n != 0) {
            System.out.println("[IDL Reflection Example] There are errors in the IDL file.");
            System.exit(0);
        }
        reflection.generateHTML(idlParser2.content());
        System.out.println("[IDL Reflection Example] HTML generated from IDL in file ReflectionEx.html.");
    }
}

