/*
 * Decompiled with CFR 0.152.
 */
package dynany;

import dynany.IPolymorphPOA;
import dynany.UnknownType;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynArray;
import org.omg.DynamicAny.DynArrayHelper;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynStructHelper;
import org.omg.DynamicAny.NameValuePair;

public class DynPolymorph
extends IPolymorphPOA {
    public void pass(Any any) throws UnknownType {
        TypeCode typeCode = any.type();
        switch (typeCode.kind().value()) {
            case 3: {
                int n = any.extract_long();
                System.out.println(" A long value : " + n);
                break;
            }
            case 2: {
                short s = any.extract_short();
                System.out.println(" A short value : " + s);
                break;
            }
            case 18: {
                String string = any.extract_string();
                System.out.println(" A string value : " + string);
                break;
            }
            case 8: {
                boolean bl = any.extract_boolean();
                System.out.println(" A boolean value : " + bl);
                break;
            }
            case 10: {
                byte by = any.extract_octet();
                System.out.println(" An octet value : " + by);
                break;
            }
            default: {
                this.scan_any(any);
            }
        }
    }

    private void scan_any(Any any) throws UnknownType {
        TypeCode typeCode = any.type();
        switch (this.getEquivalentKind(typeCode)) {
            case 15: {
                this.scan_struct(any);
                break;
            }
            case 19: {
                this.scan_sequence(any);
                break;
            }
            case 20: {
                this.scan_array(any);
                break;
            }
            default: {
                throw new UnknownType();
            }
        }
    }

    private int getEquivalentKind(TypeCode typeCode) {
        switch (typeCode.kind().value()) {
            case 21: {
                try {
                    return typeCode.content_type().kind().value();
                }
                catch (BadKind badKind) {
                    badKind.printStackTrace();
                    return 0;
                }
            }
        }
        return typeCode.kind().value();
    }

    private void scan_struct(Any any) throws UnknownType {
        DynAnyFactory dynAnyFactory = this.getDynAnyFactory();
        DynAny dynAny = null;
        try {
            dynAny = dynAnyFactory.create_dyn_any(any);
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            System.out.println("Inconsistent typecode: " + inconsistentTypeCode);
            System.exit(1);
        }
        DynStruct dynStruct = DynStructHelper.narrow(dynAny);
        NameValuePair[] nameValuePairArray = dynStruct.get_members();
        System.out.println("-------------------------------------------");
        System.out.println("Got a struct, scan each member :");
        int n = 0;
        while (n < nameValuePairArray.length) {
            System.out.println("Member name : " + nameValuePairArray[n].id);
            this.pass(nameValuePairArray[n].value);
            ++n;
        }
        System.out.println("-------------------------------------------");
        System.out.println("");
    }

    private void scan_array(Any any) throws UnknownType {
        DynAnyFactory dynAnyFactory = this.getDynAnyFactory();
        DynAny dynAny = null;
        try {
            dynAny = dynAnyFactory.create_dyn_any(any);
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            System.out.println("Inconsistent typecode: " + inconsistentTypeCode);
            System.exit(1);
        }
        DynArray dynArray = DynArrayHelper.narrow(dynAny);
        Any[] anyArray = dynArray.get_elements();
        System.out.println("-------------------------------------------");
        System.out.println("Got an array, scan each element : ");
        int n = 0;
        while (n < anyArray.length) {
            this.pass(anyArray[n]);
            ++n;
        }
        System.out.println("-------------------------------------------");
        System.out.println("");
    }

    private void scan_sequence(Any any) throws UnknownType {
        DynAnyFactory dynAnyFactory = this.getDynAnyFactory();
        DynAny dynAny = null;
        try {
            dynAny = dynAnyFactory.create_dyn_any(any);
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            System.out.println("Inconsistent typecode: " + inconsistentTypeCode);
            System.exit(1);
        }
        DynSequence dynSequence = DynSequenceHelper.narrow(dynAny);
        Any[] anyArray = dynSequence.get_elements();
        System.out.println("-------------------------------------------");
        System.out.println("Got a sequence, scan each member : ");
        int n = 0;
        while (n < anyArray.length) {
            this.pass(anyArray[n]);
            ++n;
        }
        System.out.println("-------------------------------------------");
        System.out.println("");
    }

    private DynAnyFactory getDynAnyFactory() {
        DynAnyFactory dynAnyFactory = null;
        try {
            ORB oRB = ORB.init();
            Object object = oRB.resolve_initial_references("DynAnyFactory");
            dynAnyFactory = DynAnyFactoryHelper.narrow(object);
        }
        catch (InvalidName invalidName) {
            System.out.println("Couldn't get DynAnyFactory!");
            System.exit(1);
        }
        return dynAnyFactory;
    }
}

