/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakValueHashMap
extends AbstractMap
implements Map {
    private Map m_hash;
    private ReferenceQueue m_queue = new ReferenceQueue();
    private Set m_entrySet = null;

    public WeakValueHashMap(int n, float f) {
        this.m_hash = new HashMap(n, f);
    }

    public WeakValueHashMap(int n) {
        this.m_hash = new HashMap(n);
    }

    public WeakValueHashMap() {
        this.m_hash = new HashMap();
    }

    public WeakValueHashMap(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    private void processQueue() {
        WeakValue weakValue;
        while ((weakValue = (WeakValue)this.m_queue.poll()) != null) {
            this.m_hash.remove(weakValue.getKey());
        }
    }

    public Set entrySet() {
        if (this.m_entrySet == null) {
            this.m_entrySet = new EntrySet();
        }
        return this.m_entrySet;
    }

    public boolean containsKey(Object object) {
        return this.m_hash.containsKey(object);
    }

    public Object get(Object object) {
        WeakValue weakValue = (WeakValue)this.m_hash.get(object);
        if (weakValue == null) {
            return null;
        }
        return weakValue.get();
    }

    public Object put(Object object, Object object2) {
        this.processQueue();
        return this.m_hash.put(object, new WeakValue(object, object2, this.m_queue));
    }

    public Object remove(Object object) {
        this.processQueue();
        return this.m_hash.remove(object);
    }

    public void clear() {
        this.processQueue();
        this.m_hash.clear();
    }

    private static boolean valEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private class EntrySet
    extends AbstractSet {
        private Set m_hashEntrySet;

        private EntrySet() {
            this.m_hashEntrySet = WeakValueHashMap.this.m_hash.entrySet();
        }

        public Set getEntrySet() {
            return this.m_hashEntrySet;
        }

        public Iterator iterator() {
            return new Iterator(){
                Iterator hashIterator;
                Entry next;
                {
                    this.hashIterator = this.getEntrySet().iterator();
                    this.next = null;
                }

                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)this.hashIterator.next();
                        WeakValue weakValue = (WeakValue)entry.getValue();
                        Object var3_3 = null;
                        if (weakValue != null) {
                            Object t = weakValue.get();
                            var3_3 = t;
                            if (t == null) continue;
                        }
                        this.next = new Entry(entry, var3_3);
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry entry = this.next;
                    this.next = null;
                    return entry;
                }

                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        public int size() {
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
            return n;
        }

        public boolean remove(Object object) {
            WeakValueHashMap.this.processQueue();
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            WeakValue weakValue = (WeakValue)WeakValueHashMap.this.m_hash.get(k);
            if (weakValue == null ? WeakValueHashMap.this.m_hash.containsKey(k) : weakValue.get() != null) {
                WeakValueHashMap.this.m_hash.remove(k);
                return true;
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            Iterator iterator = this.getEntrySet().iterator();
            while (iterator.hasNext()) {
                Object t;
                Map.Entry entry = (Map.Entry)iterator.next();
                Object k = entry.getKey();
                if (k == null) continue;
                WeakValue weakValue = (WeakValue)entry.getValue();
                n += k.hashCode() ^ (weakValue == null || (t = weakValue.get()) == null ? 0 : t.hashCode());
            }
            return n;
        }
    }

    private class Entry
    implements Map.Entry {
        private Map.Entry m_ent;
        private Object m_value;

        Entry(Map.Entry entry, Object object) {
            this.m_ent = entry;
            this.m_value = object;
        }

        public Object getKey() {
            return this.m_ent.getKey();
        }

        public Object getValue() {
            return this.m_value;
        }

        public Object setValue(Object object) {
            this.m_value = object;
            return this.m_ent.setValue(new WeakValue(this.m_ent.getKey(), object, WeakValueHashMap.this.m_queue));
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return WeakValueHashMap.valEquals(this.getKey(), entry.getKey()) && WeakValueHashMap.valEquals(this.m_value, entry.getValue());
        }

        public int hashCode() {
            Object object = this.getKey();
            return (object == null ? 0 : object.hashCode()) ^ (this.m_value == null ? 0 : this.m_value.hashCode());
        }
    }

    private static class WeakValue
    extends WeakReference {
        private Object m_key;

        public WeakValue(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.m_key = object;
        }

        public Object getKey() {
            return this.m_key;
        }
    }
}

