/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

public abstract class Profiler {
    private static long s_begin;
    private static long[] s_sums;
    private static long[] s_sumsq;
    private static int s_upto;
    private static int s_count;
    private static boolean s_active;

    public static void reset(int n) {
        s_sums = new long[n];
        s_sumsq = new long[n];
        s_upto = 0;
        s_count = 0;
        s_active = true;
        s_begin = System.currentTimeMillis();
    }

    public static void point() {
        if (!s_active) {
            return;
        }
        long l = System.currentTimeMillis() - s_begin;
        int n = s_upto;
        s_sums[n] = s_sums[n] + l;
        int n2 = s_upto++;
        s_sumsq[n2] = s_sumsq[n2] + l * l;
        s_begin = System.currentTimeMillis();
    }

    public static int next() {
        Profiler.point();
        int n = s_upto;
        ++s_count;
        s_upto = 0;
        s_begin = System.currentTimeMillis();
        return n;
    }

    public static double[] means() {
        double[] dArray = new double[s_sums.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = (double)s_sums[n] / (double)s_count;
            ++n;
        }
        s_active = false;
        return dArray;
    }

    public static double[] stddev() {
        double[] dArray = new double[s_sums.length];
        double d = s_count;
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = Math.sqrt((d * (double)s_sumsq[n] - (double)s_sums[n] * (double)s_sums[n]) / (d * d));
            ++n;
        }
        s_active = false;
        return dArray;
    }

    static {
        s_active = false;
    }
}

