/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

public final class NumberCache {
    private static final Byte[] BYTE_CACHE;
    private static final Short MIN_SHORT;
    private static final Short MAX_SHORT;
    private static final Short[] SHORT_BLOCK;
    private static final short MIN_SHORT_BLOCK = -2;
    private static final short MAX_SHORT_BLOCK = 100;
    private static final Integer MIN_INTEGER;
    private static final Integer MAX_INTEGER;
    private static final Integer[] INTEGER_BLOCK;
    private static final int MIN_INTEGER_BLOCK = -2;
    private static final int MAX_INTEGER_BLOCK = 100;
    private static final Long MIN_LONG;
    private static final Long MAX_LONG;
    private static final Long[] LONG_BLOCK;
    private static final long MIN_LONG_BLOCK = -2L;
    private static final long MAX_LONG_BLOCK = 100L;
    private static final Float ZERO_FLOAT;
    private static final Float ONE_FLOAT;
    private static final Float NEG_ONE_FLOAT;
    private static final Double ZERO_DOUBLE;
    private static final Double ONE_DOUBLE;
    private static final Double NEG_ONE_DOUBLE;

    private NumberCache() {
    }

    public static Byte getByte(byte by) {
        return BYTE_CACHE[by - -128];
    }

    public static Short getShort(short s) {
        if (-2 <= s && s <= 100) {
            return SHORT_BLOCK[s - -2];
        }
        return Short.MIN_VALUE == s ? MIN_SHORT : (Short.MAX_VALUE == s ? MAX_SHORT : new Short(s));
    }

    public static Integer getInteger(int n) {
        if (-2 <= n && n <= 100) {
            return INTEGER_BLOCK[n - -2];
        }
        return Integer.MIN_VALUE == n ? MIN_INTEGER : (Integer.MAX_VALUE == n ? MAX_INTEGER : new Integer(n));
    }

    public static Long getLong(long l) {
        if (-2L <= l && l <= 100L) {
            return LONG_BLOCK[(int)(l - -2L)];
        }
        return Long.MIN_VALUE == l ? MIN_LONG : (Long.MAX_VALUE == l ? MAX_LONG : new Long(l));
    }

    public static Float getFloat(float f) {
        if (0.0f == f) {
            return ZERO_FLOAT;
        }
        if (1.0f == f) {
            return ONE_FLOAT;
        }
        if (-1.0f == f) {
            return NEG_ONE_FLOAT;
        }
        return new Float(f);
    }

    public static Double getDouble(double d) {
        if (0.0 == d) {
            return ZERO_DOUBLE;
        }
        if (1.0 == d) {
            return ONE_DOUBLE;
        }
        if (-1.0 == d) {
            return NEG_ONE_DOUBLE;
        }
        return new Double(d);
    }

    static {
        MIN_SHORT = new Short(Short.MIN_VALUE);
        MAX_SHORT = new Short(Short.MAX_VALUE);
        MIN_INTEGER = new Integer(Integer.MIN_VALUE);
        MAX_INTEGER = new Integer(Integer.MAX_VALUE);
        MIN_LONG = new Long(Long.MIN_VALUE);
        MAX_LONG = new Long(Long.MAX_VALUE);
        ZERO_FLOAT = new Float(0.0f);
        ONE_FLOAT = new Float(1.0f);
        NEG_ONE_FLOAT = new Float(-1.0f);
        ZERO_DOUBLE = new Double(0.0);
        ONE_DOUBLE = new Double(1.0);
        NEG_ONE_DOUBLE = new Double(-1.0);
        BYTE_CACHE = new Byte[256];
        byte by = -128;
        while (by < 127) {
            NumberCache.BYTE_CACHE[by - -128] = new Byte(by);
            by = (byte)(by + 1);
        }
        NumberCache.BYTE_CACHE[255] = new Byte(127);
        SHORT_BLOCK = new Short[103];
        short s = -2;
        while (s <= 100) {
            NumberCache.SHORT_BLOCK[s - -2] = new Short(s);
            s = (short)(s + 1);
        }
        INTEGER_BLOCK = new Integer[103];
        int n = -2;
        while (n <= 100) {
            NumberCache.INTEGER_BLOCK[n - -2] = new Integer(n);
            ++n;
        }
        LONG_BLOCK = new Long[103];
        long l = -2L;
        while (l <= 100L) {
            NumberCache.LONG_BLOCK[(int)(l - -2L)] = new Long(l);
            ++l;
        }
    }
}

