/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.util.Comparator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.PortableInterceptor.ForwardRequest;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.adapter.ObjectAdapter;
import org.openorb.net.Address;
import org.openorb.net.ClientChannel;
import org.openorb.net.ClientRequest;
import org.openorb.net.LocalClientRequest;
import org.openorb.net.RebindChannelException;
import org.openorb.net.RequestIDAllocator;
import org.openorb.net.ServerManager;

public class ClientBinding {
    public static final int DEAD_PRIORITY = Integer.MAX_VALUE;
    public static final int FORCE_UNSET = -1;
    public static final int FORCE_FALSE = 0;
    public static final int FORCE_TRUE = 1;
    private Address m_address;
    private ClientChannel m_channel;
    private java.lang.Object m_transport_association;
    private ObjectAdapter m_adapter = null;
    private SystemException m_exception;
    private int m_priority = 0;
    private byte[] m_oid = null;
    private int m_forced_marshal;
    private ServerManager m_server_manager;
    public static final int MASK_ADDRESS_PRIORITY = 4095;
    public static final int MASK_PROFILE_PRIORITY = 61440;
    public static final int MASK_IOR_PRIORITY = 0xFF0000;
    public static final Comparator PRIORITY_COMP = new PriorityComparator();

    protected ClientBinding(Address address) {
        this.m_address = address;
        this.m_forced_marshal = -1;
        this.m_priority = address.getPriority();
    }

    public ClientBinding(Address address, ClientChannel clientChannel, java.lang.Object object) {
        this.m_address = address;
        this.m_channel = clientChannel;
        this.m_transport_association = object;
        this.m_forced_marshal = 1;
        this.m_priority = address.getPriority();
    }

    public ClientBinding(Address address, ClientChannel clientChannel, java.lang.Object object, ServerManager serverManager) {
        this.m_address = address;
        this.m_channel = clientChannel;
        this.m_transport_association = object;
        this.m_server_manager = serverManager;
        this.m_forced_marshal = -1;
        this.m_priority = address.getPriority();
    }

    public ClientBinding(Address address, SystemException systemException) {
        this.m_address = address;
        this.m_exception = systemException;
        this.m_priority = Integer.MAX_VALUE;
        this.m_forced_marshal = 0;
    }

    public Address getAddress() {
        return this.m_address;
    }

    public ClientChannel getClientChannel() {
        return this.m_channel;
    }

    public ObjectAdapter getObjectAdapter() {
        if (this.m_server_manager == null) {
            return null;
        }
        if (this.m_oid == null) {
            this.m_oid = this.m_address.getTargetAddress((short)0).object_key();
            this.m_adapter = this.m_server_manager.find_adapter(this.m_oid);
        }
        if (this.m_adapter == null) {
            return null;
        }
        this.m_forced_marshal = -1;
        return this.m_adapter;
    }

    public int getPriority() {
        if (this.m_exception != null) {
            return Integer.MAX_VALUE;
        }
        if (this.m_adapter != null) {
            return this.m_priority | this.m_adapter.cache_priority() & 0xFF000000;
        }
        return this.m_priority | this.m_channel.state();
    }

    public void setPriority(int n) {
        this.m_priority = n > 0 ? n & 0xFFF000 | this.m_priority & 0xFF000FFF : n;
    }

    public int hashCode() {
        return this.m_address.hashCode();
    }

    public boolean equals(java.lang.Object object) {
        if (!(object instanceof ClientBinding)) {
            return false;
        }
        return this.m_address.equals(((ClientBinding)object).m_address);
    }

    public boolean local_invoke() {
        if (this.m_forced_marshal == -1) {
            while (true) {
                this.getObjectAdapter();
                if (this.m_adapter == null) {
                    this.m_forced_marshal = 1;
                    break;
                }
                try {
                    this.m_forced_marshal = this.m_adapter.forced_marshal(this.m_oid) ? 1 : 0;
                }
                catch (AdapterDestroyedException adapterDestroyedException) {
                    this.m_adapter = null;
                    continue;
                }
                break;
            }
        }
        return this.m_forced_marshal == 0;
    }

    public ClientRequest create_request(Object object, String string, boolean bl) {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        while (this.m_channel != null) {
            try {
                return this.m_channel.create_request(object, this.m_address, this.m_transport_association, string, bl);
            }
            catch (RebindChannelException rebindChannelException) {
                this.m_channel = rebindChannelException.getClientChannel();
                this.m_transport_association = rebindChannelException.getTransportAssociation();
                continue;
            }
            break;
        }
        return null;
    }

    public LocalClientRequest create_request_local(ORB oRB, Object object, String string, boolean bl, Address[] addressArray) {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        int n = RequestIDAllocator.get_request_id() << 1;
        LocalClientRequest localClientRequest = new LocalClientRequest(oRB, n, object, string, bl, addressArray);
        return localClientRequest;
    }

    public ClientRequest create_locate_request(Object object) {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        while (this.m_channel != null) {
            try {
                return this.m_channel.create_locate_request(object, this.m_address, this.m_transport_association);
            }
            catch (RebindChannelException rebindChannelException) {
                this.m_channel = rebindChannelException.getClientChannel();
                this.m_transport_association = rebindChannelException.getTransportAssociation();
                continue;
            }
            break;
        }
        return null;
    }

    public ServantObject servant_preinvoke(String string, Class clazz) throws ForwardRequest {
        ServantObject servantObject;
        ObjectAdapter objectAdapter;
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            if ((objectAdapter = this.getObjectAdapter()) == null) {
                return null;
            }
            try {
                servantObject = objectAdapter.servant_preinvoke(this.m_oid, string, clazz);
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                objectAdapter = null;
                continue;
            }
            break;
        }
        if (servantObject == null) {
            this.m_forced_marshal = -1;
            return null;
        }
        LocalServant localServant = new LocalServant();
        localServant.fAdapter = objectAdapter;
        localServant.fOriginalServant = servantObject;
        localServant.servant = servantObject.servant;
        return localServant;
    }

    public void servant_postinvoke(ServantObject servantObject) {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (!(servantObject instanceof LocalServant)) {
            throw new INTERNAL("Servant is not a LocalObject");
        }
        LocalServant localServant = (LocalServant)servantObject;
        localServant.fAdapter.servant_postinvoke(this.m_oid, localServant.fOriginalServant);
    }

    public boolean locate() throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        ObjectAdapter objectAdapter;
        while ((objectAdapter = this.getObjectAdapter()) != null) {
            try {
                return objectAdapter.locate(this.m_oid);
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                objectAdapter = null;
                continue;
            }
            break;
        }
        return false;
    }

    public boolean is_a(String string) throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            ObjectAdapter objectAdapter;
            if ((objectAdapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return objectAdapter.is_a(this.m_oid, string);
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                objectAdapter = null;
                continue;
            }
            break;
        }
    }

    public Object get_interface_def() throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            ObjectAdapter objectAdapter;
            if ((objectAdapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return objectAdapter.get_interface_def(this.m_oid);
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                objectAdapter = null;
                continue;
            }
            break;
        }
    }

    public DomainManager[] get_domain_managers() throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            ObjectAdapter objectAdapter;
            if ((objectAdapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return objectAdapter.get_domain_managers(this.m_oid);
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                objectAdapter = null;
                continue;
            }
            break;
        }
    }

    public Object get_component() throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            ObjectAdapter objectAdapter;
            if ((objectAdapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return objectAdapter.get_component(this.m_oid);
            }
            catch (AdapterDestroyedException adapterDestroyedException) {
                objectAdapter = null;
                continue;
            }
            break;
        }
    }

    private static class PriorityComparator
    implements Comparator {
        private PriorityComparator() {
        }

        public int compare(java.lang.Object object, java.lang.Object object2) {
            if (object == null) {
                if (object2 == null) {
                    return 0;
                }
                return 1;
            }
            if (object2 == null) {
                return -1;
            }
            int n = ((ClientBinding)object).getPriority();
            int n2 = ((ClientBinding)object2).getPriority();
            if (n < 0) {
                if (n2 < 0) {
                    return 0;
                }
                return -1;
            }
            if (n2 < 0) {
                return 1;
            }
            int n3 = n2 - n;
            return n > n2 ? 1 : (n < n2 ? -1 : 0);
        }

        public boolean equals(java.lang.Object object) {
            return object == this;
        }
    }

    private static class LocalServant
    extends ServantObject {
        public ObjectAdapter fAdapter;
        public ServantObject fOriginalServant;

        private LocalServant() {
        }
    }
}

