/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.io.ListOutputStream;
import org.openorb.io.StreamHelper;

public class TypeCodeStreamableValue
implements StreamableValue {
    private TypeCode m_tc;
    private ORB m_orb;
    private ListOutputStream m_os;
    private String[] m_truncatable_ids = null;
    private Logger m_logger = null;

    public TypeCodeStreamableValue(ORB oRB, TypeCode typeCode) throws BadKind {
        if (this.m_tc.kind() != TCKind.tk_value) {
            throw new BadKind();
        }
        this.m_orb = oRB;
        this.m_tc = typeCode;
    }

    public TypeCode getTypeCode() {
        return this.m_tc;
    }

    public OutputStream create_output_stream() {
        this.m_os = (ListOutputStream)this.m_orb.create_output_stream();
        return this.m_os;
    }

    public InputStream create_input_stream() {
        if (this.m_os == null) {
            return null;
        }
        return (InputStream)this.m_os.create_input_stream();
    }

    public void _read(org.omg.CORBA.portable.InputStream inputStream) {
        this.m_os = (ListOutputStream)this.m_orb.create_output_stream();
        TypeCodeStreamableValue.copyState(this.m_tc, (InputStream)inputStream, this.m_os, this.getLogger());
    }

    public void _write(org.omg.CORBA.portable.OutputStream outputStream) {
        TypeCodeStreamableValue.copyState(this.m_tc, (InputStream)this.m_os.create_input_stream(), (OutputStream)outputStream, this.getLogger());
    }

    public TypeCode _type() {
        return this.m_tc;
    }

    public String[] _truncatable_ids() {
        block5: {
            if (this.m_truncatable_ids == null) {
                try {
                    int n = 1;
                    TypeCode typeCode = this.m_tc;
                    while (typeCode != null && typeCode.type_modifier() == 3) {
                        ++n;
                        typeCode = typeCode.concrete_base_type();
                    }
                    this.m_truncatable_ids = new String[n];
                    n = 0;
                    typeCode = this.m_tc;
                    do {
                        this.m_truncatable_ids[n++] = typeCode.id();
                    } while ((typeCode = typeCode.concrete_base_type()) != null && typeCode.type_modifier() == 3);
                }
                catch (BadKind badKind) {
                    if (!this.getLogger().isErrorEnabled()) break block5;
                    this.getLogger().error("BadKind exception should be impossible here.", badKind);
                }
            }
        }
        return this.m_truncatable_ids;
    }

    private static void copyState(TypeCode typeCode, InputStream inputStream, OutputStream outputStream, Logger logger) {
        block6: {
            try {
                TypeCode typeCode2 = typeCode.concrete_base_type();
                if (typeCode2 != null) {
                    TypeCodeStreamableValue.copyState(typeCode2, inputStream, outputStream, logger);
                }
                int n = 0;
                while (n < typeCode.member_count()) {
                    StreamHelper.copy_stream(typeCode.member_type(n), inputStream, outputStream);
                    ++n;
                }
            }
            catch (BadKind badKind) {
                if (logger.isErrorEnabled()) {
                    logger.error("BadKind exception should be impossible here.", badKind);
                }
            }
            catch (Bounds bounds) {
                if (!logger.isErrorEnabled()) break block6;
                logger.error("BadKind exception should be impossible here.", bounds);
            }
        }
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }
}

