/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.io.IOException;
import java.math.BigDecimal;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA_2_3.portable.InputStream;
import org.openorb.io.BufferSource;
import org.openorb.io.ExtendedInputStream;
import org.openorb.io.StorageBuffer;
import org.openorb.util.Trace;

public abstract class AbstractInputStream
extends InputStream
implements ExtendedInputStream {
    private StorageBuffer m_curr_buf;
    private BufferSource m_source;
    private int m_overread;
    private SystemException m_cancel_exception;

    public AbstractInputStream(StorageBuffer storageBuffer) {
        this.m_curr_buf = storageBuffer;
        this.m_source = this.m_source;
    }

    public AbstractInputStream(BufferSource bufferSource) {
        this.m_curr_buf = bufferSource.next();
        this.m_source = bufferSource;
    }

    public String get_codebase() {
        return null;
    }

    public int read() throws IOException {
        if (this.m_overread > 0) {
            return -1;
        }
        if (this.m_cancel_exception != null) {
            throw this.m_cancel_exception;
        }
        try {
            return this.read_octet();
        }
        catch (MARSHAL mARSHAL) {
            if (this.m_overread > 0) {
                return -1;
            }
            throw mARSHAL;
        }
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.m_overread > 0) {
            return -1;
        }
        if (this.m_cancel_exception != null) {
            throw this.m_cancel_exception;
        }
        try {
            this.read_octet_array(byArray, n, n2);
            return n2;
        }
        catch (MARSHAL mARSHAL) {
            if (this.m_overread > 0) {
                int n3 = n2 - this.m_overread;
                return n3 == 0 ? -1 : n3;
            }
            throw mARSHAL;
        }
    }

    protected void force_skip(int n) {
        if ((n = (int)((long)n - this.skip(n))) != 0) {
            this.m_overread = n;
            throw new MARSHAL("Buffer overread by " + n + " bytes", 1146056726, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    protected void cancel(SystemException systemException) {
        if (this.m_source == null) {
            this.m_cancel_exception = systemException;
            throw this.m_cancel_exception;
        }
        this.m_source.setException(systemException);
        try {
            this.m_source.next();
        }
        catch (SystemException systemException2) {
            this.m_cancel_exception = systemException2;
            throw systemException2;
        }
        Trace.signalIllegalCondition(null, "Invalid state.");
    }

    public int available() {
        return this.m_curr_buf.available() + (this.m_source != null ? this.m_source.available() : 0);
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        if (this.m_source != null) {
            this.m_source.mark();
        } else {
            this.m_curr_buf.mark();
        }
    }

    public void reset() throws IOException {
        if (this.m_source != null) {
            StorageBuffer storageBuffer = this.m_source.reset();
            if (storageBuffer == null) {
                throw new IOException("No marked position to reset to");
            }
            this.m_curr_buf = storageBuffer;
        } else if (!this.m_curr_buf.reset()) {
            throw new IOException("No marked position to reset to");
        }
        this.m_overread = 0;
    }

    /*
     * Unable to fully structure code
     */
    public long skip(long var1_1) {
        block8: {
            block7: {
                if (this.m_cancel_exception != null) {
                    throw this.m_cancel_exception;
                }
                var3_2 = var1_1;
                if (this.m_source == null) break block7;
                if (this.m_curr_buf != null) ** GOTO lbl16
                return 0L;
lbl-1000:
                // 1 sources

                {
                    var1_1 -= (long)this.m_curr_buf.available();
                    try {
                        this.m_curr_buf = this.m_source.next();
                    }
                    catch (SystemException var5_3) {
                        this.m_cancel_exception = var5_3;
                        throw var5_3;
                    }
                    if (this.m_curr_buf != null) continue;
                    return var3_2 - var1_1;
lbl16:
                    // 2 sources

                    ** while (var1_1 > (long)this.m_curr_buf.available())
                }
lbl17:
                // 1 sources

                var5_4 = new IntHolder((int)var1_1);
                var1_1 -= (long)this.m_curr_buf.skip(var5_4);
                if (this.m_curr_buf.available() == 0) {
                    try {
                        this.m_curr_buf = this.m_source.next();
                    }
                    catch (SystemException var6_6) {
                        this.m_cancel_exception = var6_6;
                        throw var6_6;
                    }
                }
                break block8;
            }
            var5_5 = new IntHolder((int)var1_1);
            var1_1 -= (long)this.m_curr_buf.skip(var5_5);
        }
        return var3_2 - var1_1;
    }

    protected int next(OctetSeqHolder octetSeqHolder, IntHolder intHolder, IntHolder intHolder2) {
        if (this.m_cancel_exception != null) {
            throw this.m_cancel_exception;
        }
        if (intHolder2.value == 0) {
            return 0;
        }
        if (this.m_curr_buf == null) {
            this.m_overread = intHolder2.value;
            throw new MARSHAL("Buffer overread by " + intHolder2.value + " bytes", 1146056726, CompletionStatus.COMPLETED_MAYBE);
        }
        int n = this.m_curr_buf.next(octetSeqHolder, intHolder, intHolder2);
        while (this.m_source != null && this.m_curr_buf != null && this.m_curr_buf.available() == 0) {
            try {
                this.m_curr_buf = this.m_source.next();
            }
            catch (SystemException systemException) {
                this.m_cancel_exception = systemException;
                throw systemException;
            }
        }
        if (this.m_curr_buf != null && this.m_curr_buf.available() == 0 && this.m_source == null && n < 0) {
            this.m_overread = intHolder2.value;
            throw new MARSHAL("Buffer overread by " + intHolder2.value + " bytes", 1146056726, CompletionStatus.COMPLETED_MAYBE);
        }
        return n;
    }

    public abstract BigDecimal read_fixed(TypeCode var1);
}

