/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.EOFException;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.TooManyListenersException;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.TRANSIENT;
import org.omg.GIOP.Version;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.iiop.CDRInputStream;
import org.openorb.iiop.IIOPClientChannel;
import org.openorb.iiop.IIOPServerChannel;
import org.openorb.io.BufferSource;
import org.openorb.io.StorageBuffer;
import org.openorb.net.Transport;
import org.openorb.net.TransportAssociationHolder;
import org.openorb.util.ExceptionTool;
import org.openorb.util.Trace;

public final class SocketQueue {
    public static final int MAX_FRAG_SIZE = 120000;
    private static final int BUFFER_SIZE = 2048;
    private Transport m_transport;
    private org.omg.CORBA.ORB m_orb;
    private IIOPServerChannel m_server_channel = null;
    private IIOPClientChannel m_client_channel = null;
    private boolean m_connection_originator;
    private boolean m_use_odd_even = false;
    private Object m_sync_send = new Object();
    private boolean m_open = false;
    private Constructor m_os_ctor = null;
    private LinkedList m_incoming_queue = new LinkedList();
    private int m_request_id_1 = -1;
    private boolean m_receive_reply_1 = true;
    private Logger m_logger;
    private OctetSeqHolder m_tmpBuf = new OctetSeqHolder();
    private IntHolder m_tmpOff = new IntHolder();
    private IntHolder m_tmpLen = new IntHolder();
    private BufferSource.WaitingForBufferListener m_waitingForBufferListener = new BufferSource.WaitingForBufferListener(){

        public boolean waitForBuffer(BufferSource bufferSource) {
            SocketQueue.this.process_or_enqueue(false, 0);
            return true;
        }
    };
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class class$org$omg$GIOP$Version;
    static /* synthetic */ Class class$org$openorb$io$BufferSource;

    SocketQueue(Transport transport) {
        this.m_transport = transport;
        this.m_open = this.m_transport.isOpen();
    }

    Transport getTransport() {
        return this.m_transport;
    }

    public String toString() {
        return this.m_transport.toString();
    }

    synchronized void setClientChannel(IIOPClientChannel iIOPClientChannel) {
        if (this.m_client_channel == null) {
            this.m_client_channel = iIOPClientChannel;
            if (this.m_server_channel == null) {
                this.m_connection_originator = true;
                this.m_orb = this.m_client_channel.orb();
                if (null == this.m_logger) {
                    this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
                }
                try {
                    Class[] classArray = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = SocketQueue.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, Boolean.TYPE, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = SocketQueue.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$io$BufferSource == null ? (class$org$openorb$io$BufferSource = SocketQueue.class$("org.openorb.io.BufferSource")) : class$org$openorb$io$BufferSource};
                    this.m_os_ctor = ((ORB)this.m_orb).getLoader().classConstructor("iiop.CDRInputStreamClass", "org.openorb.iiop.CDRInputStream", classArray);
                }
                catch (Exception exception) {
                    if (this.getLogger().isErrorEnabled()) {
                        this.getLogger().error("Unable to create CDROutputStream class.", exception);
                    }
                    throw ExceptionTool.initCause(new INITIALIZE("Unable to create CDROutputStream class (" + exception + ")"), (Throwable)exception);
                }
            } else {
                this.m_use_odd_even = true;
            }
        }
    }

    synchronized void setServerChannel(IIOPServerChannel iIOPServerChannel) {
        this.m_server_channel = iIOPServerChannel;
        if (this.m_client_channel == null) {
            this.m_connection_originator = false;
            this.m_orb = this.m_server_channel.orb();
            if (null == this.m_logger) {
                this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
            }
            try {
                Class[] classArray = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = SocketQueue.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, Boolean.TYPE, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = SocketQueue.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$io$BufferSource == null ? (class$org$openorb$io$BufferSource = SocketQueue.class$("org.openorb.io.BufferSource")) : class$org$openorb$io$BufferSource};
                this.m_os_ctor = ((ORB)this.m_orb).getLoader().classConstructor("iiop.CDRInputStreamClass", "org.openorb.iiop.CDRInputStream", classArray);
            }
            catch (Exception exception) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Unable to create CDROutputStream class.", exception);
                }
                throw ExceptionTool.initCause(new INITIALIZE("Unable to create CDROutputStream class (" + exception + ")"), (Throwable)exception);
            }
        } else {
            this.m_use_odd_even = true;
        }
    }

    public synchronized boolean isOpen() {
        return this.m_transport.isOpen();
    }

    public synchronized void open() {
        this.m_transport.open();
        this.m_open = true;
    }

    public synchronized void close() {
        Object object = this.m_sync_send;
        synchronized (object) {
            this.m_open = false;
        }
        this.m_transport.close();
    }

    public boolean send(StorageBuffer storageBuffer, Object object) {
        if (!this.m_open) {
            return false;
        }
        Object object2 = this.m_sync_send;
        synchronized (object2) {
            if (!this.m_open) {
                boolean bl = false;
                return bl;
            }
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug(Trace.bufferToString("Sending message", storageBuffer));
            }
            this.m_transport.sendMessage(storageBuffer, object);
            boolean bl = true;
            return bl;
        }
    }

    public boolean receive(int n) {
        return this.process_or_enqueue(true, n);
    }

    private boolean process_or_enqueue(boolean bl, int n) {
        CDRInputStream cDRInputStream;
        Object object;
        int n2 = 0;
        if (bl && !this.m_incoming_queue.isEmpty()) {
            object = (IncommingToProcess)this.m_incoming_queue.removeFirst();
            switch (((IncommingToProcess)object).getMessageType()) {
                case 1: 
                case 4: {
                    n2 = this.m_client_channel.process_reply(((IncommingToProcess)object).getMinor(), ((IncommingToProcess)object).getInputStream(), ((IncommingToProcess)object).getMessageType(), ((IncommingToProcess)object).getFragmentFollows(), ((IncommingToProcess)object).getSourceBuffer(), ((IncommingToProcess)object).getTransportAssociation());
                    if (((IncommingToProcess)object).getMinor() == 1) {
                        this.m_request_id_1 = n2;
                    }
                    return true;
                }
                case 0: 
                case 2: 
                case 3: {
                    n2 = this.m_server_channel.process_request(((IncommingToProcess)object).getMinor(), ((IncommingToProcess)object).getInputStream(), ((IncommingToProcess)object).getMessageType(), ((IncommingToProcess)object).getSourceBuffer(), ((IncommingToProcess)object).getTransportAssociation());
                    if (((IncommingToProcess)object).getMinor() == 1) {
                        this.m_request_id_1 = n2;
                    }
                    return true;
                }
                case 7: {
                    if (((IncommingToProcess)object).getMinor() == 1) {
                        ((IncommingToProcess)object).setRequestId(this.m_request_id_1);
                    }
                    if (((IncommingToProcess)object).getReplyFragment()) {
                        this.m_client_channel.process_fragment(((IncommingToProcess)object).getRequestId(), ((IncommingToProcess)object).getFragment(), ((IncommingToProcess)object).getFragmentFollows(), ((IncommingToProcess)object).getTransportAssociation());
                    } else {
                        this.m_server_channel.process_fragment(((IncommingToProcess)object).getRequestId(), ((IncommingToProcess)object).getFragment(), ((IncommingToProcess)object).getFragmentFollows(), ((IncommingToProcess)object).getTransportAssociation());
                    }
                    return true;
                }
            }
        }
        object = null;
        TransportAssociationHolder transportAssociationHolder = new TransportAssociationHolder();
        try {
            object = this.m_transport.recvMessage(n, transportAssociationHolder);
        }
        catch (EOFException eOFException) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("Error receiving message in process_or_enqueue", eOFException);
            }
            if (this.m_client_channel != null) {
                this.m_client_channel.server_pause(ExceptionTool.initCause(new TRANSIENT(0, CompletionStatus.COMPLETED_NO), (Throwable)eOFException));
            } else {
                this.m_server_channel.close();
            }
            return false;
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("Error receiving message in process_or_enqueue", cOMM_FAILURE);
            }
            if (this.m_use_odd_even ? this.m_connection_originator : this.m_client_channel != null) {
                this.m_client_channel.server_pause(cOMM_FAILURE);
            } else {
                this.m_server_channel.close();
            }
            return false;
        }
        if (object == null) {
            return true;
        }
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(Trace.bufferToString("Incoming message", (StorageBuffer)object));
        }
        byte by = -1;
        byte by2 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        this.m_tmpLen.value = 8;
        int n3 = ((StorageBuffer)object).next(this.m_tmpBuf, this.m_tmpOff, this.m_tmpLen);
        switch (n3) {
            case 8: {
                by2 = this.m_tmpBuf.value[this.m_tmpOff.value + 7];
                bl2 = (this.m_tmpBuf.value[this.m_tmpOff.value + 6] & 1) == 1;
                bl3 = (this.m_tmpBuf.value[this.m_tmpOff.value + 6] & 2) == 2;
                by = this.m_tmpBuf.value[this.m_tmpOff.value + 5];
                break;
            }
            case 7: {
                bl2 = (this.m_tmpBuf.value[this.m_tmpOff.value + 6] & 1) == 1;
                bl3 = (this.m_tmpBuf.value[this.m_tmpOff.value + 6] & 2) == 2;
            }
            case 6: {
                by = this.m_tmpBuf.value[this.m_tmpOff.value + 5];
            }
            default: {
                while (n3 < 5) {
                    this.m_tmpLen.value = 5 - n3;
                    n3 += ((StorageBuffer)object).next(this.m_tmpBuf, this.m_tmpOff, this.m_tmpLen);
                }
                while (n3 < 8) {
                    this.m_tmpLen.value = 1;
                    switch (n3 += ((StorageBuffer)object).next(this.m_tmpBuf, this.m_tmpOff, this.m_tmpLen)) {
                        case 6: {
                            by = this.m_tmpBuf.value[this.m_tmpOff.value];
                            break;
                        }
                        case 7: {
                            bl2 = (this.m_tmpBuf.value[this.m_tmpOff.value] & 1) == 1;
                            bl3 = (this.m_tmpBuf.value[this.m_tmpOff.value] & 2) == 2;
                            break;
                        }
                        case 8: {
                            by2 = this.m_tmpBuf.value[this.m_tmpOff.value];
                        }
                    }
                }
                break block8;
            }
        }
        if (by2 == 7) {
            this.m_tmpLen.value = 4;
            if (((StorageBuffer)object).skip(this.m_tmpLen) != 4) {
                Trace.signalIllegalCondition(this.getLogger(), "Unable to read header from buffer.");
            }
            boolean bl4 = true;
            switch (by) {
                case 1: {
                    n2 = this.m_request_id_1;
                    bl4 = this.m_receive_reply_1;
                    break;
                }
                case 2: {
                    boolean bl5;
                    this.m_tmpLen.value = 4;
                    int n4 = ((StorageBuffer)object).next(this.m_tmpBuf, this.m_tmpOff, this.m_tmpLen);
                    if (n4 == 4) {
                        n2 = (this.m_tmpBuf.value[this.m_tmpOff.value] & 0xFF) << (bl2 ? 0 : 24) | (this.m_tmpBuf.value[this.m_tmpOff.value + 1] & 0xFF) << (bl2 ? 8 : 16) | (this.m_tmpBuf.value[this.m_tmpOff.value + 2] & 0xFF) << (bl2 ? 16 : 8) | (this.m_tmpBuf.value[this.m_tmpOff.value + 3] & 0xFF) << (bl2 ? 24 : 0);
                    } else {
                        n2 = 0;
                        int n5 = bl2 ? 0 : 24;
                        while (true) {
                            int n6 = 0;
                            while (n6 < n4) {
                                n2 |= (this.m_tmpBuf.value[this.m_tmpOff.value + n6] & 0xFF) << n5;
                                n5 += bl2 ? 8 : -8;
                                ++n6;
                            }
                            boolean bl6 = bl2 ? n5 < 24 : n5 > 0;
                            if (!bl6) break;
                            n4 = ((StorageBuffer)object).next(this.m_tmpBuf, this.m_tmpOff, this.m_tmpLen);
                        }
                    }
                    if (this.m_use_odd_even) {
                        if (n2 % 2 == 0 == this.m_connection_originator) {
                            bl5 = true;
                            break;
                        }
                        bl5 = false;
                        break;
                    }
                    bl5 = bl4 = this.m_client_channel != null;
                }
            }
            if (bl) {
                if (bl4) {
                    this.m_client_channel.process_fragment(n2, (StorageBuffer)object, bl3, transportAssociationHolder.getValue());
                } else {
                    this.m_server_channel.process_fragment(n2, (StorageBuffer)object, bl3, transportAssociationHolder.getValue());
                }
            } else {
                this.m_incoming_queue.addLast(new IncommingToProcess(n2, bl3, bl4, (StorageBuffer)object, transportAssociationHolder.getValue()));
            }
            return true;
        }
        BufferSource bufferSource = new BufferSource((StorageBuffer)object, !bl3);
        if (bl3) {
            try {
                bufferSource.addWaitingForBufferListener(this.m_waitingForBufferListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                this.getLogger().error("Unable to handle too many Listeners.", tooManyListenersException);
            }
        }
        try {
            cDRInputStream = (CDRInputStream)this.m_os_ctor.newInstance(this.m_orb, bl2 ? Boolean.FALSE : Boolean.TRUE, new Version(1, by), bufferSource);
        }
        catch (Exception exception) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Unable to create CDROutputStream class.", exception);
            }
            throw ExceptionTool.initCause(new INITIALIZE("Unable to create CDROutputStream class (" + exception + ")"), (Throwable)exception);
        }
        if (cDRInputStream.skip(4L) != 4L) {
            Trace.signalIllegalCondition(this.getLogger(), "Unable to read header from buffer.");
        }
        switch (by2) {
            case 1: 
            case 4: {
                if (by == 1 && bl3) {
                    this.m_receive_reply_1 = true;
                }
                if (bl) {
                    if (this.m_client_channel == null) break;
                    n2 = this.m_client_channel.process_reply(by, cDRInputStream, by2, bl3, bufferSource, transportAssociationHolder.getValue());
                    if (by != 1 || !bl3) break;
                    this.m_request_id_1 = n2;
                    break;
                }
                this.m_incoming_queue.addLast(new IncommingToProcess(by2, by, bl3, cDRInputStream, bufferSource, transportAssociationHolder.getValue()));
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                if (by == 1 && bl3) {
                    this.m_receive_reply_1 = false;
                }
                if (bl) {
                    if (this.m_server_channel == null) break;
                    n2 = this.m_server_channel.process_request(by, cDRInputStream, by2, bufferSource, transportAssociationHolder.getValue());
                    if (by != 1 || !bl3) break;
                    this.m_request_id_1 = n2;
                    break;
                }
                this.m_incoming_queue.addLast(new IncommingToProcess(by2, by, bl3, cDRInputStream, bufferSource, transportAssociationHolder.getValue()));
            }
        }
        return true;
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class IncommingToProcess {
        private byte m_minor;
        private CDRInputStream m_in_stream;
        private byte m_message_type;
        private BufferSource m_source_buffer;
        private boolean m_fragment_follows;
        private Object m_transport_association;
        private int m_request_id;
        private StorageBuffer m_fragment;
        private boolean m_reply_fragment;

        public IncommingToProcess(byte by) {
            this.m_message_type = by;
        }

        public IncommingToProcess(byte by, byte by2, boolean bl, CDRInputStream cDRInputStream, BufferSource bufferSource, Object object) {
            this.m_minor = by2;
            this.m_in_stream = cDRInputStream;
            this.m_message_type = by;
            this.m_source_buffer = bufferSource;
            this.m_fragment_follows = bl;
            this.m_transport_association = object;
        }

        public IncommingToProcess(int n, boolean bl, boolean bl2, StorageBuffer storageBuffer, Object object) {
            this.m_message_type = (byte)7;
            this.m_request_id = n;
            this.m_fragment_follows = bl;
            this.m_reply_fragment = bl2;
            this.m_fragment = storageBuffer;
            this.m_transport_association = object;
        }

        public byte getMinor() {
            return this.m_minor;
        }

        public byte getMessageType() {
            return this.m_message_type;
        }

        public Object getTransportAssociation() {
            return this.m_transport_association;
        }

        public boolean getFragmentFollows() {
            return this.m_fragment_follows;
        }

        public StorageBuffer getFragment() {
            return this.m_fragment;
        }

        public int getRequestId() {
            return this.m_request_id;
        }

        public void setRequestId(int n) {
            this.m_request_id = n;
        }

        public BufferSource getSourceBuffer() {
            return this.m_source_buffer;
        }

        public CDRInputStream getInputStream() {
            return this.m_in_stream;
        }

        public boolean getReplyFragment() {
            return this.m_reply_fragment;
        }
    }
}

