/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.IIOP.ListenPoint;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.PI.FeatureInitInfo;
import org.openorb.iiop.IIOPTransport;
import org.openorb.net.Transport;
import org.openorb.net.TransportServerInitializer;
import org.openorb.util.ExceptionTool;

public class IIOPTransportServerInitializer
implements TransportServerInitializer {
    private ListenPoint m_primary_endpoint = new ListenPoint();
    private ListenPoint[] m_bidir_endpoints = new ListenPoint[]{this.m_primary_endpoint};
    private InetAddress m_host;
    private ServerSocket m_svr_socket;
    private Logger m_logger;
    private volatile boolean m_closed = true;
    private final boolean m_socketNoDelay;
    private final boolean m_boostRecvPriority;
    private final int m_sendBufferSize;
    private final int m_receiveBufferSize;
    private final int m_bufferedOutputStreamSize;
    private final int m_backlogQueueLength;
    private final int m_maxSocketTimeout;
    private final int m_minSocketTimeout;
    private final int m_overrideSocketTimeout;
    private int m_currentSocketTimeout;
    static /* synthetic */ Class class$org$openorb$iiop$IIOPTransportServerInitializer;

    public IIOPTransportServerInitializer(ORBInitInfo oRBInitInfo, FeatureInitInfo featureInitInfo) {
        int n;
        ORBLoader oRBLoader = featureInitInfo.getLoader();
        this.m_logger = featureInitInfo.orb().getLogger();
        this.m_socketNoDelay = oRBLoader.getBooleanProperty("iiop.serverNoDelay", true);
        this.m_boostRecvPriority = oRBLoader.getBooleanProperty("iiop.boostReceivePriority", false);
        this.m_sendBufferSize = oRBLoader.getIntProperty("iiop.sendBufferSize", 0);
        this.m_receiveBufferSize = oRBLoader.getIntProperty("iiop.receiveBufferSize", 0);
        this.m_bufferedOutputStreamSize = oRBLoader.getIntProperty("iiop.bufferedOutputStreamSize", 0);
        this.m_backlogQueueLength = oRBLoader.getIntProperty("iiop.serverBacklogQueueLength", 50);
        this.m_maxSocketTimeout = oRBLoader.getIntProperty("iiop.serverMaxSocketAcceptTimeout", 250);
        this.m_minSocketTimeout = (class$org$openorb$iiop$IIOPTransportServerInitializer == null ? (class$org$openorb$iiop$IIOPTransportServerInitializer = IIOPTransportServerInitializer.class$("org.openorb.iiop.IIOPTransportServerInitializer")) : class$org$openorb$iiop$IIOPTransportServerInitializer).equals(this.getClass()) ? oRBLoader.getIntProperty("iiop.serverMinSocketAcceptTimeout", 0) : 0;
        this.m_overrideSocketTimeout = oRBLoader.getIntProperty("iiop.serverOverrideSocketTimeout", 250);
        this.m_primary_endpoint.host = oRBLoader.getStringProperty("iiop.hostname", "");
        if (this.m_primary_endpoint.host.length() == 0) {
            try {
                String string = oRBLoader.getStringProperty("iiop.publishIP", "auto");
                if (string.equalsIgnoreCase("auto")) {
                    this.m_primary_endpoint.host = InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
                    if (this.m_primary_endpoint.host.indexOf(46) < 0) {
                        this.m_primary_endpoint.host = InetAddress.getLocalHost().getHostAddress();
                    }
                } else {
                    this.m_primary_endpoint.host = string.equalsIgnoreCase("true") ? InetAddress.getLocalHost().getHostAddress() : InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.getLogger().error("Unable to find hostname for local host.", unknownHostException);
                throw ExceptionTool.initCause(new INITIALIZE("Unable to find hostname for local host (" + unknownHostException + ")", 0, CompletionStatus.COMPLETED_NO), (Throwable)unknownHostException);
            }
        }
        if ((n = oRBLoader.getIntProperty("iiop.port", 0)) > 65535 || n < 0) {
            throw new INITIALIZE("Value for server port " + n + " is out of range");
        }
        this.m_primary_endpoint.port = (short)n;
        try {
            this.m_host = InetAddress.getByName(oRBLoader.getStringProperty("iiop.listenAddress", "0.0.0.0"));
        }
        catch (UnknownHostException unknownHostException) {
            this.getLogger().error("Unable to find address for local listen port.", unknownHostException);
            throw ExceptionTool.initCause(new INITIALIZE("Unable to find address for local listen port (" + unknownHostException + ")", 0, CompletionStatus.COMPLETED_NO), (Throwable)unknownHostException);
        }
    }

    public void open() {
        if (this.m_svr_socket != null) {
            return;
        }
        this.open_port();
    }

    private void open_port() {
        try {
            int n = this.m_primary_endpoint.port & 0xFFFF;
            this.m_svr_socket = new ServerSocket(n, this.m_backlogQueueLength, this.m_host);
        }
        catch (IOException iOException) {
            this.getLogger().error("Unable to listen on " + this.svrString() + " (" + iOException + ").", iOException);
            throw ExceptionTool.initCause(new COMM_FAILURE("Unable to listen on " + this.svrString() + " (" + iOException + ")"), (Throwable)iOException);
        }
        catch (SecurityException securityException) {
            this.getLogger().error("Access denied for " + this.svrString() + ".", securityException);
            throw ExceptionTool.initCause(new NO_PERMISSION("Access denied for " + this.svrString() + " (" + securityException + ")"), (Throwable)securityException);
        }
        this.m_closed = false;
        if (this.m_primary_endpoint.port == 0) {
            this.m_primary_endpoint.port = (short)this.m_svr_socket.getLocalPort();
        }
    }

    public ListenPoint getPrimaryEndpoint() {
        return this.m_primary_endpoint;
    }

    public ListenPoint[] getBiDirEndpoints() {
        return this.m_bidir_endpoints;
    }

    protected InetAddress getListenHost() {
        return this.m_host;
    }

    public void close() {
        if (this.m_closed || this.m_svr_socket == null) {
            return;
        }
        this.m_closed = true;
        try {
            this.m_svr_socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_svr_socket = null;
    }

    public boolean isOpen() {
        return !this.m_closed;
    }

    public Transport accept(int n) {
        try {
            if (this.m_closed) {
                return null;
            }
            this.setSocketTimeout(n);
            try {
                Socket socket = this.m_svr_socket.accept();
                return new IIOPTransport(socket, this.m_primary_endpoint.port & 0xFFFF, this.getLogger(), this.m_socketNoDelay, this.m_boostRecvPriority, this.m_sendBufferSize, this.m_receiveBufferSize, this.m_bufferedOutputStreamSize);
            }
            catch (InterruptedIOException interruptedIOException) {
                if ("operation interrupted".equals(interruptedIOException.getMessage())) {
                    Thread.currentThread().interrupt();
                }
                return null;
            }
            catch (SocketException socketException) {
                return null;
            }
        }
        catch (IOException iOException) {
            if (this.m_closed) {
                return null;
            }
            this.getLogger().error("IOException during accept.", iOException);
            throw ExceptionTool.initCause(new COMM_FAILURE(), (Throwable)iOException);
        }
    }

    private void setSocketTimeout(int n) throws SocketException {
        ServerSocket serverSocket = this.m_svr_socket;
        synchronized (serverSocket) {
            int n2 = n = this.m_minSocketTimeout < n && n < this.m_maxSocketTimeout ? n : this.m_overrideSocketTimeout;
            if (n == this.m_currentSocketTimeout) {
                return;
            }
            this.m_svr_socket.setSoTimeout(n);
            this.m_currentSocketTimeout = n;
        }
    }

    public String toString() {
        return "(iiop) " + this.svrString();
    }

    protected String svrString() {
        return "" + this.m_host + ":" + (this.m_primary_endpoint.port & 0xFFFF);
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

