/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.adapter.fwd;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.DomainManagersListHelper;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ServantObject;
import org.omg.PortableInterceptor.ForwardRequest;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.adapter.ObjectAdapter;
import org.openorb.adapter.TargetInfo;
import org.openorb.corbaloc.CorbalocServiceHelper;
import org.openorb.corbaloc.CorbalocServiceOperations;
import org.openorb.net.Address;
import org.openorb.net.ServerManager;
import org.openorb.net.ServerRequest;
import org.openorb.util.ExceptionTool;

public class ForwardAdapter
implements ObjectAdapter,
CorbalocServiceOperations {
    public static final byte[] JDK_ID = "INIT".getBytes();
    public static final String CORBALOC_SVC_NAME = "CorbalocService";
    public static final byte[] CORBALOC_SVC_ID = "CorbalocService".getBytes();
    private static final byte[] NO_ADAPTER_ID = new byte[0];
    private static final Policy[] NO_POLICIES = new Policy[0];
    private Map m_target_map = new HashMap();
    private Object m_forwardIDef = null;
    private ORB m_orb;
    private Logger m_logger;
    private static final TargetInfo FORWARD_TI_JDK = new TargetInfo(){

        public byte[] getAdapterID() {
            return NO_ADAPTER_ID;
        }

        public String getRepositoryID() {
            return CorbalocServiceHelper.id();
        }

        public byte[] getObjectID() {
            return JDK_ID;
        }

        public boolean targetIsA(String string) {
            if (string.startsWith("IDL:omg.orb/CORBA/Object:1.")) {
                return true;
            }
            return string.equals(CorbalocServiceHelper.id());
        }
    };
    private static final TargetInfo FORWARD_TI_INIT = new TargetInfo(){

        public byte[] getAdapterID() {
            return NO_ADAPTER_ID;
        }

        public String getRepositoryID() {
            return CorbalocServiceHelper.id();
        }

        public byte[] getObjectID() {
            return CORBALOC_SVC_ID;
        }

        public boolean targetIsA(String string) {
            if (string.startsWith("IDL:omg.orb/CORBA/Object:1.")) {
                return true;
            }
            return string.equals(CorbalocServiceHelper.id());
        }
    };

    public ForwardAdapter(ServerManager serverManager) {
        serverManager.register_adapter(NO_ADAPTER_ID, this);
        this.m_orb = serverManager.orb();
    }

    public Object get(String string) {
        return this.resolve(string.getBytes());
    }

    public void put(String string, Object object) {
        this.register(string.getBytes(), object);
    }

    public Object resolve(byte[] byArray) {
        Target target = this.getTarget(byArray);
        if (target == null) {
            throw new BAD_PARAM("No target registered", 0, CompletionStatus.COMPLETED_NO);
        }
        return target.getDest();
    }

    public void register(byte[] byArray, Object object) {
        if (object == null) {
            Target target = new Target(byArray);
            Map map = this.m_target_map;
            synchronized (map) {
                this.m_target_map.remove(target);
            }
        }
        Target target = new Target(byArray, object);
        Map map = this.m_target_map;
        synchronized (map) {
            this.m_target_map.put(target, target);
        }
    }

    public String put_object(Object object, String string) {
        if (object == null) {
            throw new BAD_PARAM("Null object argument.");
        }
        org.openorb.CORBA.Delegate delegate = (org.openorb.CORBA.Delegate)((ObjectImpl)object)._get_delegate();
        Address[] addressArray = delegate.getAddresses(object);
        String string2 = null;
        int n = 0;
        while (n < addressArray.length) {
            if (addressArray[n].getProtocol().equals("iiop")) {
                string2 = addressArray[n].getEndpointString();
                break;
            }
            ++n;
        }
        if (string2 == null) {
            string2 = addressArray[0].getEndpointString();
        }
        String string3 = string;
        string3 = string.startsWith("/") ? string.substring(1, string.length()) : string;
        this.put(string3, object);
        return "corbaloc:" + string2 + "/" + string3;
    }

    private Target getTarget(byte[] byArray) {
        Map map = this.m_target_map;
        synchronized (map) {
            Target target = (Target)this.m_target_map.get(new Target(byArray));
            return target;
        }
    }

    public int cache_priority() {
        return 0;
    }

    public boolean single_threaded() {
        return false;
    }

    public void etherealize(boolean bl) {
    }

    public ServerManager.AdapterManager getAdapterManager() {
        return null;
    }

    public ObjectAdapter find_adapter(byte[] byArray) throws AdapterDestroyedException {
        Map map = this.m_target_map;
        synchronized (map) {
            if (this.m_target_map.containsKey(new Target(byArray))) {
                ForwardAdapter forwardAdapter = this;
                return forwardAdapter;
            }
        }
        if (Arrays.equals(byArray, JDK_ID) || Arrays.equals(byArray, CORBALOC_SVC_ID)) {
            return this;
        }
        return null;
    }

    public byte[] adapter_id(byte[] byArray) {
        Map map = this.m_target_map;
        synchronized (map) {
            if (this.m_target_map.containsKey(new Target(byArray))) {
                byte[] byArray2 = NO_ADAPTER_ID;
                return byArray2;
            }
        }
        if (Arrays.equals(byArray, JDK_ID) || Arrays.equals(byArray, CORBALOC_SVC_ID)) {
            return NO_ADAPTER_ID;
        }
        return null;
    }

    public byte[] object_id(byte[] byArray) {
        Map map = this.m_target_map;
        synchronized (map) {
            if (this.m_target_map.containsKey(new Target(byArray))) {
                byte[] byArray2 = byArray;
                return byArray2;
            }
        }
        if (Arrays.equals(byArray, JDK_ID) || Arrays.equals(byArray, CORBALOC_SVC_ID)) {
            return byArray;
        }
        return null;
    }

    public Policy[] get_server_policies(int[] nArray) {
        return NO_POLICIES;
    }

    public boolean forced_marshal(byte[] byArray) throws AdapterDestroyedException {
        return false;
    }

    public ServantObject servant_preinvoke(byte[] byArray, String string, Class clazz) throws ForwardRequest, AdapterDestroyedException {
        if (!this.locate(byArray)) {
            throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
        }
        ServantObject servantObject = new ServantObject();
        servantObject.servant = this;
        return servantObject;
    }

    public void servant_postinvoke(byte[] byArray, ServantObject servantObject) {
    }

    public boolean locate(byte[] byArray) throws ForwardRequest, AdapterDestroyedException {
        if (Arrays.equals(byArray, JDK_ID) || Arrays.equals(byArray, CORBALOC_SVC_ID)) {
            return true;
        }
        Target target = this.getTarget(byArray);
        if (target == null) {
            return false;
        }
        throw new ForwardRequest(target.getDest());
    }

    public boolean is_a(byte[] byArray, String string) throws ForwardRequest, AdapterDestroyedException {
        if (Arrays.equals(byArray, JDK_ID) || Arrays.equals(byArray, CORBALOC_SVC_ID)) {
            return string.equals(CorbalocServiceHelper.id());
        }
        Target target = this.getTarget(byArray);
        if (target == null) {
            throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
        }
        return target.getDest()._is_a(string);
    }

    public Object get_interface_def(byte[] byArray) throws ForwardRequest, AdapterDestroyedException {
        if (Arrays.equals(byArray, JDK_ID) || Arrays.equals(byArray, CORBALOC_SVC_ID)) {
            return this.get_interface_def();
        }
        Target target = this.getTarget(byArray);
        if (target == null) {
            throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
        }
        return target.getDest()._get_interface_def();
    }

    private Object get_interface_def() {
        if (this.m_forwardIDef == null) {
            Repository repository;
            Object object;
            try {
                object = this.m_orb.resolve_initial_references("InterfaceRepository");
            }
            catch (InvalidName invalidName) {
                this.getLogger().error("Could not resolve InterfaceRepository.", invalidName);
                throw ExceptionTool.initCause(new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO), (Throwable)invalidName);
            }
            if (object._non_existent()) {
                throw new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO);
            }
            try {
                repository = RepositoryHelper.narrow(object);
            }
            catch (BAD_PARAM bAD_PARAM) {
                this.getLogger().error("Could not narrow obj to type Repository.", bAD_PARAM);
                throw ExceptionTool.initCause(new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO), (Throwable)bAD_PARAM);
            }
            this.m_forwardIDef = repository.lookup_id(CorbalocServiceHelper.id());
            if (this.m_forwardIDef == null) {
                throw new INTF_REPOS(1146056720, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.m_forwardIDef;
    }

    public DomainManager[] get_domain_managers(byte[] byArray) throws ForwardRequest, AdapterDestroyedException {
        if (Arrays.equals(byArray, JDK_ID) || Arrays.equals(byArray, CORBALOC_SVC_ID)) {
            return new DomainManager[0];
        }
        Target target = this.getTarget(byArray);
        if (target == null) {
            throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
        }
        return target.getDest()._get_domain_managers();
    }

    public Object get_component(byte[] byArray) throws ForwardRequest, AdapterDestroyedException {
        if (Arrays.equals(byArray, JDK_ID) || Arrays.equals(byArray, CORBALOC_SVC_ID)) {
            return null;
        }
        Target target = this.getTarget(byArray);
        if (target == null) {
            throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
        }
        Object object = target.getDest();
        if (!(object instanceof ObjectImpl)) {
            throw new BAD_OPERATION(0, CompletionStatus.COMPLETED_NO);
        }
        Delegate delegate = ((ObjectImpl)object)._get_delegate();
        if (!(delegate instanceof org.openorb.CORBA.Delegate)) {
            throw new BAD_OPERATION(0, CompletionStatus.COMPLETED_NO);
        }
        return ((org.openorb.CORBA.Delegate)delegate).get_component(object);
    }

    public TargetInfo predispatch(ServerRequest serverRequest) throws ForwardRequest, AdapterDestroyedException {
        byte[] byArray = serverRequest.object_key();
        this.locate(byArray);
        if (Arrays.equals(byArray, JDK_ID)) {
            return FORWARD_TI_JDK;
        }
        if (Arrays.equals(byArray, CORBALOC_SVC_ID)) {
            return FORWARD_TI_INIT;
        }
        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
    }

    public void dispatch(ServerRequest serverRequest, TargetInfo targetInfo) {
        String string = serverRequest.operation();
        InputStream inputStream = serverRequest.argument_stream();
        if (string.charAt(0) == '_') {
            if (string.equals("_is_a")) {
                String string2 = inputStream.read_string();
                serverRequest.createReply().write_boolean(string2.equals(CorbalocServiceHelper.id()));
                return;
            }
            if (string.equals("_get_domain_managers")) {
                DomainManagersListHelper.write(serverRequest.createReply(), new DomainManager[0]);
                return;
            }
            if (string.equals("_interface")) {
                Object object = this.get_interface_def();
                serverRequest.createReply().write_Object(object);
                return;
            }
            if (string.equals("_non_existent") || string.equals("_not_existent")) {
                serverRequest.createReply().write_boolean(false);
                return;
            }
            if (string.equals("_component")) {
                serverRequest.createReply().write_Object(null);
                return;
            }
        }
        if (string.equals("get")) {
            String string3 = inputStream.read_string();
            Object object = this.get(string3);
            OutputStream outputStream = serverRequest.createReply();
            outputStream.write_Object(object);
        } else if (string.equals("put")) {
            String string4 = inputStream.read_string();
            Object object = inputStream.read_Object();
            this.put(string4, object);
            serverRequest.createReply();
        } else if (string.equals("resolve")) {
            byte[] byArray = OctetSeqHelper.read(inputStream);
            Object object = this.resolve(byArray);
            OutputStream outputStream = serverRequest.createReply();
            outputStream.write_Object(object);
        } else if (string.equals("register")) {
            byte[] byArray = OctetSeqHelper.read(inputStream);
            Object object = inputStream.read_Object();
            this.register(byArray, object);
            serverRequest.createReply();
        } else {
            throw new BAD_OPERATION();
        }
    }

    public void cancel_dispatch(ServerRequest serverRequest, TargetInfo targetInfo) {
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }

    private static class Target {
        private Object m_dest;
        private byte[] m_key;
        private int m_hash;

        public Target(byte[] byArray) {
            this(byArray, null);
        }

        public Target(byte[] byArray, Object object) {
            this.m_key = byArray;
            this.m_dest = object;
            this.m_hash = 0;
            int n = 0;
            while (n < byArray.length) {
                this.m_hash = 31 * this.m_hash + (byArray[n] & 0xFF);
                ++n;
            }
        }

        public int hashCode() {
            return this.m_hash;
        }

        public Object getDest() {
            return this.m_dest;
        }

        public byte[] getKey() {
            return this.m_key;
        }

        public boolean equals(java.lang.Object object) {
            if (!(object instanceof Target)) {
                return false;
            }
            Target target = (Target)object;
            if (this.m_hash != target.m_hash || this.m_key.length != target.m_key.length) {
                return false;
            }
            int n = 0;
            while (n < this.m_key.length) {
                if (this.m_key[n] != target.m_key[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

