/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.PI;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.CurrentOperations;
import org.omg.PortableInterceptor.ForwardRequest;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.CORBA.SystemExceptionHelper;
import org.openorb.PI.ClientManager;
import org.openorb.PI.CurrentImpl;
import org.openorb.PI.RequestCallback;
import org.openorb.util.ExceptionTool;
import org.openorb.util.Trace;

public class SimpleClientManager
implements ClientManager {
    private ClientRequestInterceptor[] m_list = null;
    private CurrentImpl m_current;
    private Logger m_logger;
    public static final int BAD_INTERCEPTOR_RESPONSE = 0;

    public SimpleClientManager(ClientRequestInterceptor[] clientRequestInterceptorArray, CurrentImpl currentImpl) {
        this.m_list = clientRequestInterceptorArray;
        this.m_current = currentImpl;
        this.m_logger = ((ORBSingleton)currentImpl._orb()).getLogger();
    }

    public void send_request(ClientRequestInfo clientRequestInfo, RequestCallback requestCallback) {
        int n = 0;
        CurrentOperations currentOperations = this.m_current.remove();
        try {
            while (n < this.m_list.length) {
                this.m_list[n].send_request(clientRequestInfo);
                this.m_current.remove();
                ++n;
            }
        }
        catch (ForwardRequest forwardRequest) {
            this.m_current.remove();
            requestCallback.reply_location_forward(forwardRequest.forward, false);
            this.receive_other_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (SystemException systemException) {
            SystemException systemException2;
            this.m_current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_NO) {
                systemException2 = ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_NO), (Throwable)systemException);
            }
            systemException2.completed = CompletionStatus.COMPLETED_NO;
            requestCallback.reply_system_exception(systemException2);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ((Object)runtimeException).toString());
            }
            requestCallback.reply_runtime_exception(runtimeException);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (Error error) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ((Object)error).toString());
            }
            requestCallback.reply_error(error);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        this.m_current.set(currentOperations);
    }

    public void send_poll(ClientRequestInfo clientRequestInfo, RequestCallback requestCallback) {
        int n = 0;
        CurrentOperations currentOperations = this.m_current.remove();
        try {
            while (n < this.m_list.length) {
                this.m_list[n].send_poll(clientRequestInfo);
                this.m_current.remove();
                ++n;
            }
        }
        catch (SystemException systemException) {
            SystemException systemException2;
            this.m_current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_NO) {
                systemException2 = ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_NO), (Throwable)systemException);
            }
            requestCallback.reply_system_exception(systemException2);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ((Object)runtimeException).toString());
            }
            requestCallback.reply_runtime_exception(runtimeException);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (Error error) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ((Object)error).toString());
            }
            requestCallback.reply_error(error);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        this.m_current.set(currentOperations);
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo, RequestCallback requestCallback) {
        int n = this.m_list.length - 1;
        CurrentOperations currentOperations = this.m_current.remove();
        try {
            while (n >= 0) {
                this.m_list[n].receive_reply(clientRequestInfo);
                this.m_current.remove();
                --n;
            }
        }
        catch (SystemException systemException) {
            SystemException systemException2;
            this.m_current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_YES) {
                systemException2 = ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_YES), (Throwable)systemException);
            }
            requestCallback.reply_system_exception(systemException2);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ((Object)runtimeException).toString());
            }
            requestCallback.reply_runtime_exception(runtimeException);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (Error error) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ((Object)error).toString());
            }
            requestCallback.reply_error(error);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        this.m_current.set(currentOperations);
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo, RequestCallback requestCallback) {
        CurrentOperations currentOperations = this.m_current.remove();
        this.receive_exception_point(this.m_list.length - 1, clientRequestInfo, requestCallback);
        this.m_current.set(currentOperations);
    }

    private void receive_exception_point(int n, ClientRequestInfo clientRequestInfo, RequestCallback requestCallback) {
        if (n < 0) {
            return;
        }
        CompletionStatus completionStatus = clientRequestInfo.reply_status() == 1 ? SystemExceptionHelper.extract((Any)clientRequestInfo.received_exception()).completed : CompletionStatus.COMPLETED_YES;
        while (n >= 0) {
            block11: {
                try {
                    this.m_list[n].receive_exception(clientRequestInfo);
                }
                catch (SystemException systemException) {
                    SystemException systemException2;
                    if (systemException.completed != completionStatus) {
                        systemException2 = ExceptionTool.initCause(new INTERNAL(0, completionStatus), (Throwable)systemException);
                    }
                    requestCallback.reply_system_exception(systemException2);
                }
                catch (RuntimeException runtimeException) {
                    if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                        this.getLogger().debug("Received an unexcepted exception : " + ((Object)runtimeException).toString());
                    }
                    requestCallback.reply_runtime_exception(runtimeException);
                }
                catch (Error error) {
                    if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                        this.getLogger().debug("Received an unexcepted exception : " + ((Object)error).toString());
                    }
                    requestCallback.reply_error(error);
                }
                catch (ForwardRequest forwardRequest) {
                    this.m_current.remove();
                    if (completionStatus != CompletionStatus.COMPLETED_YES) {
                        requestCallback.reply_system_exception(ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_YES), (Throwable)forwardRequest));
                        break block11;
                    }
                    requestCallback.reply_location_forward(forwardRequest.forward, false);
                    this.receive_other_point(n - 1, clientRequestInfo, requestCallback);
                    return;
                }
                this.m_current.remove();
            }
            --n;
        }
    }

    public void receive_other(ClientRequestInfo clientRequestInfo, RequestCallback requestCallback) {
        CurrentOperations currentOperations = this.m_current.remove();
        this.receive_other_point(this.m_list.length - 1, clientRequestInfo, requestCallback);
        this.m_current.set(currentOperations);
    }

    private void receive_other_point(int n, ClientRequestInfo clientRequestInfo, RequestCallback requestCallback) {
        if (n < 0) {
            return;
        }
        try {
            while (n >= 0) {
                try {
                    this.m_list[n].receive_other(clientRequestInfo);
                }
                catch (ForwardRequest forwardRequest) {
                    requestCallback.reply_location_forward(forwardRequest.forward, false);
                }
                this.m_current.remove();
                --n;
            }
        }
        catch (SystemException systemException) {
            SystemException systemException2;
            this.m_current.remove();
            if (systemException.completed != CompletionStatus.COMPLETED_NO) {
                systemException2 = ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_NO), (Throwable)systemException);
            }
            requestCallback.reply_system_exception(systemException2);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (RuntimeException runtimeException) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ((Object)runtimeException).toString());
            }
            requestCallback.reply_runtime_exception(runtimeException);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
        catch (Error error) {
            this.m_current.remove();
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug("Received an unexcepted exception : " + ((Object)error).toString());
            }
            requestCallback.reply_error(error);
            this.receive_exception_point(n - 1, clientRequestInfo, requestCallback);
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

