/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.kernel;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.log.Priority;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ORBInitializer;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.CORBA.kernel.Configurator;
import org.openorb.CORBA.kernel.ORBConnector;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.CORBA.kernel.Properties;
import org.openorb.CORBA.kernel.Property;
import org.openorb.CORBA.kernel.PropertyNotFoundException;
import org.openorb.PI.FeatureInitializer;
import org.openorb.PI.ORBInitInfo;
import org.openorb.util.ExceptionTool;
import org.openorb.util.Trace;

public class OpenORBLoader
implements ORBLoader {
    private Properties m_properties = null;
    private ORB m_orb;
    private static final String ORBSINGLETON_CLASSKEY = "org.omg.CORBA.ORBSingletonClass";
    private static final String DEFAULT_ORBSINGLETON = "org.openorb.CORBA.ORBSingleton";
    private Logger m_logger;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$openorb$CORBA$ORB;
    static /* synthetic */ Class array$Lorg$omg$PortableInterceptor$ORBInitializer;
    static /* synthetic */ Class array$Lorg$openorb$PI$FeatureInitializer;

    public void init(String[] stringArray, java.util.Properties properties, ORB oRB) {
        ORBInitInfo oRBInitInfo;
        Object object;
        String string;
        if (this.m_orb != null) {
            throw new INITIALIZE("Multiple initialize for orb");
        }
        this.m_orb = oRB;
        try {
            System.setProperty(ORBSINGLETON_CLASSKEY, DEFAULT_ORBSINGLETON);
        }
        catch (SecurityException securityException) {
            System.out.println("Warning: Security settings do not allow this process to set system properties (org.omg.CORBA.ORBSingletonClass).");
        }
        org.omg.CORBA.ORB oRB2 = org.omg.CORBA.ORB.init();
        if (!(oRB2 instanceof ORBSingleton)) {
            throw new INITIALIZE("Unable to complete init orb singleton is not openorb singleton.\nPlease use: System.setProperty(\"org.omg.CORBA.ORBSingletonClass\", \"org.openorb.CORBA.ORBSingleton\");\nAs the first statement in your application.");
        }
        if (properties != null) {
            this.m_logger = (Logger)((Hashtable)properties).get("LOGGER");
        }
        if (this.m_logger == null) {
            this.m_logger = Trace.getLogger(properties);
        }
        this.m_orb.enableLogging(this.m_logger.getChildLogger("ldr#" + System.identityHashCode(this)));
        Configurator configurator = new Configurator(stringArray, properties, this.getLogger());
        this.m_properties = configurator.getProperties();
        if ((this.m_properties.getProperty("openorb.debug") != null || this.m_properties.getProperty("debug") != null || this.m_properties.getProperty("verbose") != null) && this.m_logger.isWarnEnabled()) {
            this.m_logger.warn("The properties \"openorb.debug\", \"debug\", and \"verbose\" have been deprecated and will be ignored. Please use \"openorb.debug.trace\" and \"openorb.debug.level\" instead.");
        }
        try {
            string = this.m_properties.getStringProperty("openorb.debug.trace");
            this.m_logger = Trace.getNewLogger(Trace.getPriorityFromName(string));
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this.m_logger = Trace.getNewLogger(Priority.ERROR);
        }
        string = null;
        try {
            string = this.m_properties.getStringProperty("openorb.debug.level");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            this.m_logger.warn("openorb.debug.level not specified, using default OFF.");
        }
        Trace.setDebugLevel(Trace.getDebugLevelFromName(string));
        if (this.m_logger.isDebugEnabled() && Trace.isMedium()) {
            this.m_logger.debug("\n-----------------------------------------------------------------\nOpenORB\nopenorb.debug.level=" + string + " (OFF(0)/LOW(1)/MEDIUM(2)/HIGH(3))\n" + "-----------------------------------------------------------------\n");
            this.display_configuration(this.m_logger);
            this.m_logger.debug("\n-----------------------------------------------------------------");
        }
        if (this.m_logger.isDebugEnabled() && Trace.isLow()) {
            this.m_logger.debug("ORB loading.");
        }
        this.m_orb.setFeature("ORBLoader", this);
        try {
            object = new Object[4];
            Class[] classArray = new Class[4];
            object[0] = stringArray == null ? new String[]{} : stringArray;
            classArray[0] = array$Ljava$lang$String == null ? (array$Ljava$lang$String = OpenORBLoader.class$("[Ljava.lang.String;")) : array$Ljava$lang$String;
            object[1] = oRB;
            Class clazz = classArray[1] = class$org$openorb$CORBA$ORB == null ? (class$org$openorb$CORBA$ORB = OpenORBLoader.class$("org.openorb.CORBA.ORB")) : class$org$openorb$CORBA$ORB;
            if (properties instanceof Context) {
                this.load_initializers((Object[])object, configurator.getInitializers(), (Context)((Object)properties));
            } else {
                this.load_initializers((Object[])object, configurator.getInitializers());
            }
            classArray[2] = array$Lorg$omg$PortableInterceptor$ORBInitializer == null ? (array$Lorg$omg$PortableInterceptor$ORBInitializer = OpenORBLoader.class$("[Lorg.omg.PortableInterceptor.ORBInitializer;")) : array$Lorg$omg$PortableInterceptor$ORBInitializer;
            classArray[3] = array$Lorg$openorb$PI$FeatureInitializer == null ? (array$Lorg$openorb$PI$FeatureInitializer = OpenORBLoader.class$("[Lorg.openorb.PI.FeatureInitializer;")) : array$Lorg$openorb$PI$FeatureInitializer;
            oRBInitInfo = (ORBInitInfo)this.constructClass("openorb.pi.ORBInitInfoClass", "org.openorb.PI.OpenORBInitInfo", (Object[])object, classArray);
            if (oRBInitInfo instanceof LogEnabled) {
                ((LogEnabled)((Object)oRBInitInfo)).enableLogging(this.m_logger);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            this.getLogger().error("Exception during construction of class openorb.pi.ORBInitInfoClass", invocationTargetException);
            if (invocationTargetException.getTargetException() instanceof SystemException) {
                throw (SystemException)invocationTargetException.getTargetException();
            }
            throw ExceptionTool.initCause(new INITIALIZE("Exception during construction of class openorb.pi.ORBInitInfoClass (" + invocationTargetException + ")"), (Throwable)invocationTargetException);
        }
        oRBInitInfo.pre_init();
        try {
            object = (ORBConnector)this.constructClass("openorb.kernel.ORBConnectorClass", "org.openorb.CORBA.kernel.OpenORBConnector", null);
            object.load_kernel(this.m_orb, this);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.getLogger().error("Exception during construction of class openorb.kernel.ORBConnectorClass", invocationTargetException.getTargetException());
            if (invocationTargetException.getTargetException() instanceof SystemException) {
                throw (SystemException)invocationTargetException.getTargetException();
            }
            throw ExceptionTool.initCause(new INITIALIZE("Exception during construction of class openorb.kernel.ORBConnectorClass (" + invocationTargetException + ")"), (Throwable)invocationTargetException);
        }
        oRBInitInfo.post_init();
    }

    public void display_configuration() {
        this.m_properties.display();
    }

    public void display_configuration(Logger logger) {
        this.m_properties.display(logger);
    }

    public Iterator properties(String string) {
        return this.m_properties.properties(string);
    }

    public Property getProperty(String string) {
        return this.m_properties.getProperty(string);
    }

    public String getStringProperty(String string, String string2) {
        return this.m_properties.getStringProperty(string, string2);
    }

    public String getStringProperty(String string) throws PropertyNotFoundException {
        return this.m_properties.getStringProperty(string);
    }

    public int getIntProperty(String string, int n) {
        return this.m_properties.getIntProperty(string, n);
    }

    public int getIntProperty(String string) throws PropertyNotFoundException {
        return this.m_properties.getIntProperty(string);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        return this.m_properties.getBooleanProperty(string, bl);
    }

    public boolean getBooleanProperty(String string) throws PropertyNotFoundException {
        return this.m_properties.getBooleanProperty(string);
    }

    public URL getURLProperty(String string, URL uRL) {
        return this.m_properties.getURLProperty(string, uRL);
    }

    public URL getURLProperty(String string) throws PropertyNotFoundException {
        return this.m_properties.getURLProperty(string);
    }

    public Class getClassProperty(String string, Class clazz) {
        return this.m_properties.getClassProperty(string, clazz);
    }

    public Class getClassProperty(String string, String string2) {
        return this.m_properties.getClassProperty(string, string2);
    }

    public Class getClassProperty(String string) throws PropertyNotFoundException {
        return this.m_properties.getClassProperty(string);
    }

    public Object constructClass(String string, String string2, Object[] objectArray) throws InvocationTargetException {
        return this.constructClass(string, string2, objectArray, null);
    }

    public Object constructClass(String string, String string2, Object[] objectArray, Class[] classArray) throws InvocationTargetException {
        if (objectArray != null) {
            if (classArray == null) {
                classArray = new Class[objectArray.length];
            } else if (objectArray.length != classArray.length) {
                throw new IllegalArgumentException("Length of args and args_t do not match");
            }
            int n = 0;
            while (n < objectArray.length) {
                if (classArray[n] == null) {
                    classArray[n] = objectArray[n] == null ? Void.TYPE : objectArray[n].getClass();
                }
                ++n;
            }
        }
        try {
            return this.classConstructor(string, string2, classArray).newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            this.getLogger().error("Illegal argument when constructing a class", instantiationException);
            throw ExceptionTool.initCause(new IllegalArgumentException("Illegal argument when constructing a class (" + instantiationException + ")"), (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.getLogger().error("Illegal access when constructing a class", illegalAccessException);
            throw ExceptionTool.initCause(new IllegalArgumentException("Illegal access when constructing a class (" + illegalAccessException + ")"), (Throwable)illegalAccessException);
        }
    }

    public Constructor classConstructor(String string, String string2, Class[] classArray) {
        Class clazz = this.getClassProperty(string, string2);
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string3 = "No constructor found in " + clazz.getName();
            this.getLogger().error(string3, noSuchMethodException);
            throw ExceptionTool.initCause(new IllegalArgumentException(string3 + " (" + noSuchMethodException + ")"), (Throwable)noSuchMethodException);
        }
    }

    private void load_initializers(Object[] objectArray, String[] stringArray) {
        this.load_initializers(objectArray, stringArray, null);
    }

    private void load_initializers(Object[] objectArray, String[] stringArray, Context context) {
        ArrayList arrayList = new ArrayList(stringArray.length);
        ArrayList arrayList2 = new ArrayList(stringArray.length);
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug("Creating initializers now...");
        }
        int n = 0;
        while (n < stringArray.length) {
            Object obj;
            try {
                if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                    this.getLogger().debug("Creating initializer " + stringArray[n] + ".");
                }
                obj = Thread.currentThread().getContextClassLoader().loadClass(stringArray[n]).newInstance();
            }
            catch (Exception exception) {
                String string = "Unable to load initializer class: " + stringArray[n];
                throw new CascadingRuntimeException(string, exception);
            }
            boolean bl = false;
            if (obj instanceof LogEnabled) {
                ((LogEnabled)obj).enableLogging(this.m_logger);
            }
            if (obj instanceof ORBInitializer) {
                arrayList.add(obj);
                bl = true;
            }
            if (obj instanceof FeatureInitializer) {
                arrayList2.add(obj);
                bl = true;
            }
            if (!bl) {
                String string = "Unknown initalizer type: '" + stringArray[n] + "'.";
                throw new IllegalStateException(string);
            }
            ++n;
        }
        objectArray[2] = new ORBInitializer[arrayList.size()];
        arrayList.toArray((Object[])objectArray[2]);
        objectArray[3] = new FeatureInitializer[arrayList2.size()];
        arrayList2.toArray((Object[])objectArray[3]);
    }

    protected Logger getLogger() {
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

