/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.generator;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.idl.reflect.idlParameter;
import org.openorb.compiler.object.IdlArray;
import org.openorb.compiler.object.IdlAttribute;
import org.openorb.compiler.object.IdlComment;
import org.openorb.compiler.object.IdlCommentSection;
import org.openorb.compiler.object.IdlConst;
import org.openorb.compiler.object.IdlContext;
import org.openorb.compiler.object.IdlEnumMember;
import org.openorb.compiler.object.IdlFactoryMember;
import org.openorb.compiler.object.IdlFixed;
import org.openorb.compiler.object.IdlIdent;
import org.openorb.compiler.object.IdlInclude;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlOp;
import org.openorb.compiler.object.IdlParam;
import org.openorb.compiler.object.IdlRaises;
import org.openorb.compiler.object.IdlSequence;
import org.openorb.compiler.object.IdlSimple;
import org.openorb.compiler.object.IdlStateMember;
import org.openorb.compiler.object.IdlString;
import org.openorb.compiler.object.IdlStructMember;
import org.openorb.compiler.object.IdlUnion;
import org.openorb.compiler.object.IdlUnionMember;
import org.openorb.compiler.object.IdlValue;
import org.openorb.compiler.object.IdlValueBox;
import org.openorb.compiler.object.IdlValueInheritance;
import org.openorb.compiler.object.IdlWString;
import org.openorb.util.CharacterCache;

public class IdlToJava {
    public static final String tab = "    ";
    public static final String tab1 = "    ";
    public static final String tab2 = "        ";
    public static final String tab3 = "            ";
    public static final String tab4 = "                ";
    public static final String tab5 = "                    ";
    public static final String tab6 = "                        ";
    private String sep;
    public String current_pkg = this.adaptToDot(IdlCompiler.packageName);
    public IdlObject _root = null;
    private File initial = null;

    public IdlToJava() {
        this.sep = System.getProperty("file.separator");
    }

    public boolean isNativeDefinition(IdlObject idlObject2) {
        int n = 0;
        while (n < IdlCompiler.nativeDefinition.size()) {
            String string = (String)IdlCompiler.nativeDefinition.get(n);
            int n2 = string.indexOf(58);
            String string2 = string.substring(0, n2);
            if (idlObject2.name().equals(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void printNativeDefinition(IdlObject idlObject2, PrintWriter printWriter) {
        int n = 0;
        while (n < IdlCompiler.nativeDefinition.size()) {
            String string = (String)IdlCompiler.nativeDefinition.get(n);
            int n2 = string.indexOf(58);
            String string2 = string.substring(0, n2);
            if (idlObject2.name().equals(string2)) {
                n2 = string.lastIndexOf(58);
                string2 = string.substring(n2 + 1, string.length());
                printWriter.print(string2);
            }
            ++n;
        }
    }

    public PrintWriter fileAccess(File file) {
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            printWriter = new PrintWriter(dataOutputStream, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return printWriter;
    }

    public String inversedPrefix(String string) {
        int n = 0;
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = new String("");
        try {
            while (n != -1) {
                n = string.indexOf(46, n2);
                if (n == -1) continue;
                arrayList.add(new String(string.substring(n2, n)));
                n2 = n + 1;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        arrayList.add(new String(string.substring(n2, string.length())));
        int n3 = arrayList.size() - 1;
        while (n3 >= 0) {
            if (!string2.equals("")) {
                string2 = string2 + ".";
            }
            string2 = string2 + (String)arrayList.get(n3);
            --n3;
        }
        return string2;
    }

    public PrintWriter newFile(File file, String string) {
        if (!file.exists()) {
            file.mkdirs();
        }
        String string2 = new String(file.getPath() + this.sep + string + ".java");
        File file2 = new File(string2);
        return this.fileAccess(file2);
    }

    public File createDirectory(String string, File file) {
        boolean bl = false;
        char[] cArray = new char[string.length() + 20];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '.') {
                cArray[n++] = this.sep.charAt(0);
                bl = true;
            } else {
                cArray[n++] = string.charAt(n2);
            }
            ++n2;
        }
        String string2 = new String(cArray, 0, n);
        String string3 = file != null ? new String(file.getPath() + this.sep + string2) : string2;
        File file2 = new File(string3);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (bl) {
            IdlCompiler.packageName = string2;
        }
        return file2;
    }

    public File createPrefixDirectories(String string, File file) {
        char[] cArray = new char[string.length() + 20];
        String string2 = null;
        string2 = IdlCompiler.reversePrefix ? new String(this.inversedPrefix(string)) : string;
        int n = 0;
        int n2 = 0;
        while (n2 < string2.length()) {
            cArray[n++] = string2.charAt(n2) == '.' ? this.sep.charAt(0) : string2.charAt(n2);
            ++n2;
        }
        string2 = new String(cArray, 0, n);
        String string3 = file != null ? new String(file.getPath() + this.sep + string2) : string2;
        File file2 = new File(string3);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        return file2;
    }

    public File getDirectory(String string, File file) {
        String string2 = file != null ? new String(file.getPath() + this.sep + string) : string;
        File file2 = new File(string2);
        return file2;
    }

    public File getPrefixDirectories(String string, File file) {
        char[] cArray = new char[string.length() + 20];
        String string2 = null;
        string2 = IdlCompiler.reversePrefix ? new String(this.inversedPrefix(string)) : string;
        int n = 0;
        int n2 = 0;
        while (n2 < string2.length()) {
            cArray[n++] = string2.charAt(n2) == '.' ? this.sep.charAt(0) : string2.charAt(n2);
            ++n2;
        }
        string2 = new String(cArray, 0, n);
        String string3 = file != null ? new String(file.getPath() + this.sep + string2) : string2;
        File file2 = new File(string3);
        return file2;
    }

    public void addToPkg(IdlObject idlObject2, String string) {
        this.current_pkg = !IdlCompiler.use_package ? (!this.current_pkg.equals("generated") ? (!this.current_pkg.equals("") ? this.current_pkg + "." + string : string) : string) : (!this.current_pkg.equals("") ? this.current_pkg + "." + string : string);
    }

    public void addPackageName(PrintWriter printWriter) {
        if (this.current_pkg != null) {
            if (this.current_pkg.equals("generated")) {
                if (IdlCompiler.use_package) {
                    printWriter.println("package " + this.current_pkg + ";");
                    printWriter.println();
                }
            } else if (!this.current_pkg.equals("")) {
                printWriter.println("package " + this.current_pkg + ";");
                printWriter.println();
            }
        }
    }

    public void addDescriptiveHeader(PrintWriter printWriter, IdlObject idlObject2) {
        this.addPackageName(printWriter);
        switch (idlObject2.kind()) {
            case 7: {
                if (idlObject2.hasComment()) {
                    this.javadoc(printWriter, idlObject2);
                    break;
                }
                printWriter.println("/**");
                printWriter.println(" * Constant definition : " + idlObject2.name());
                printWriter.println(" *");
                printWriter.println(" * @author OpenORB Compiler");
                printWriter.println("*/");
                break;
            }
            case 2: {
                if (idlObject2.hasComment()) {
                    this.javadoc(printWriter, idlObject2);
                    break;
                }
                printWriter.println("/**");
                printWriter.println(" * Enum definition : " + idlObject2.name());
                printWriter.println(" *");
                printWriter.println(" * @author OpenORB Compiler");
                printWriter.println("*/");
                break;
            }
            case 3: {
                if (idlObject2.hasComment()) {
                    this.javadoc(printWriter, idlObject2);
                    break;
                }
                printWriter.println("/**");
                printWriter.println(" * Struct definition : " + idlObject2.name());
                printWriter.println(" * ");
                printWriter.println(" * @author OpenORB Compiler");
                printWriter.println("*/");
                break;
            }
            case 4: {
                if (idlObject2.hasComment()) {
                    this.javadoc(printWriter, idlObject2);
                    break;
                }
                printWriter.println("/**");
                printWriter.println(" * Union definition : " + idlObject2.name());
                printWriter.println(" * ");
                printWriter.println(" * @author OpenORB Compiler");
                printWriter.println(" */");
                break;
            }
            case 14: {
                if (idlObject2.hasComment()) {
                    this.javadoc(printWriter, idlObject2);
                    break;
                }
                printWriter.println("/**");
                printWriter.println(" * Exception definition : " + idlObject2.name());
                printWriter.println(" * ");
                printWriter.println(" * @author OpenORB Compiler");
                printWriter.println(" */");
                break;
            }
            case 15: {
                if (idlObject2.hasComment()) {
                    this.javadoc(printWriter, idlObject2);
                    break;
                }
                printWriter.println("/**");
                printWriter.println(" * Interface definition : " + idlObject2.name());
                printWriter.println(" * ");
                printWriter.println(" * @author OpenORB Compiler");
                printWriter.println(" */");
                break;
            }
            case 27: {
                if (idlObject2.hasComment()) {
                    this.javadoc(printWriter, idlObject2);
                    break;
                }
                printWriter.println("/**");
                printWriter.println(" * Value box definition : " + idlObject2.name());
                printWriter.println(" * ");
                printWriter.println(" * @author OpenORB Compiler");
                printWriter.println(" */");
                break;
            }
            case 28: {
                if (idlObject2.hasComment()) {
                    this.javadoc(printWriter, idlObject2);
                    break;
                }
                printWriter.println("/**");
                printWriter.println(" * Value Type definition : " + idlObject2.name());
                printWriter.println(" * ");
                printWriter.println(" * @author OpenORB Compiler");
                printWriter.println(" */");
                break;
            }
            case 30: {
                if (idlObject2.hasComment()) {
                    this.javadoc(printWriter, idlObject2);
                    break;
                }
                printWriter.println("/**");
                printWriter.println(" * Factory definition : " + idlObject2.name());
                printWriter.println(" * ");
                printWriter.println(" * @author OpenORB Compiler");
                printWriter.println(" */");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void translate_comment_section(PrintWriter printWriter, String string, IdlObject idlObject2) {
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\n') {
                if (n == string.length() - 1) {
                    printWriter.println("");
                    return;
                }
                printWriter.println("");
                if (idlObject2.kind() == 17 || idlObject2.kind() == 16 || idlObject2.kind() == 29) {
                    printWriter.print("    ");
                }
                printWriter.print(" * ");
            } else {
                printWriter.print(string.charAt(n));
            }
            ++n;
        }
    }

    public void javadoc(PrintWriter printWriter, IdlObject idlObject2) {
        IdlComment idlComment = idlObject2.getComment();
        String string = null;
        if (idlComment != null) {
            string = idlComment.get_description();
            if (idlObject2.kind() == 17 || idlObject2.kind() == 16 || idlObject2.kind() == 29) {
                printWriter.print("    ");
            }
            printWriter.println("/**");
            if (idlObject2.kind() == 17 || idlObject2.kind() == 16 || idlObject2.kind() == 29) {
                printWriter.print("    ");
            }
            printWriter.print(" * ");
            this.translate_comment_section(printWriter, string, idlObject2);
            IdlCommentSection[] idlCommentSectionArray = idlComment.get_sections();
            int n = 0;
            while (n < idlCommentSectionArray.length) {
                switch (idlCommentSectionArray[n].kind().value()) {
                    case 0: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print("    ");
                        }
                        printWriter.print(" * @author ");
                        break;
                    }
                    case 6: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print("    ");
                        }
                        printWriter.print(" * @deprecated ");
                        break;
                    }
                    case 1: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print("    ");
                        }
                        printWriter.print(" * @exception ");
                        break;
                    }
                    case 4: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print("    ");
                        }
                        printWriter.print(" * @return ");
                        break;
                    }
                    case 3: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print("    ");
                        }
                        printWriter.print(" * @param ");
                        break;
                    }
                    case 5: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print("    ");
                        }
                        printWriter.print(" * @see ");
                        break;
                    }
                    case 2: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print("    ");
                        }
                        printWriter.print(" * @version ");
                        break;
                    }
                    case 7: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print("    ");
                        }
                        printWriter.print(" * @" + idlCommentSectionArray[n].get_title() + " ");
                    }
                }
                string = idlCommentSectionArray[n].get_description();
                this.translate_comment_section(printWriter, string, idlObject2);
                ++n;
            }
            if (idlObject2.kind() == 17 || idlObject2.kind() == 16 || idlObject2.kind() == 29) {
                printWriter.print("    ");
            }
            printWriter.println(" */");
        }
    }

    public int final_kind(IdlObject idlObject2) {
        switch (idlObject2.kind()) {
            case 10: {
                return this.final_kind(((IdlIdent)idlObject2).internalObject());
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: {
                return this.final_kind(idlObject2.current());
            }
        }
        return idlObject2.kind();
    }

    public IdlObject final_type(IdlObject idlObject2) {
        switch (idlObject2.kind()) {
            case 10: {
                return this.final_type(((IdlIdent)idlObject2).internalObject());
            }
            case 11: 
            case 12: 
            case 13: 
            case 19: {
                return this.final_type(idlObject2.current());
            }
        }
        return idlObject2;
    }

    private String adaptToDot(String string) {
        char[] cArray = new char[string.length()];
        int n = 0;
        while (n < string.length()) {
            cArray[n] = string.charAt(n) == '/' || string.charAt(n) == '\\' ? 46 : string.charAt(n);
            ++n;
        }
        return new String(cArray);
    }

    public String fullname(IdlObject idlObject2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        IdlObject idlObject3 = idlObject2;
        String string = new String("");
        boolean bl = false;
        while (idlObject3 != null) {
            if (bl) {
                if (idlObject3.kind() == 15 || idlObject3.kind() == 28 || idlObject3.kind() == 3 || idlObject3.kind() == 4 || idlObject3.kind() == 14) {
                    arrayList.add(idlObject3.name() + "Package");
                } else if (idlObject3.kind() != 12) {
                    arrayList.add(idlObject3.name());
                }
            } else if (idlObject3.kind() != 12) {
                arrayList.add(idlObject3.name());
            }
            if (idlObject3.upper() != null && idlObject3.upper().kind() == 0) break;
            idlObject3 = idlObject3.upper();
            bl = true;
        }
        if (!(IdlCompiler.packageName == null || idlObject2.included() || IdlCompiler.packageName.equals("") || IdlCompiler.packageName.equals("generated") && !IdlCompiler.use_package)) {
            string = this.adaptToDot(IdlCompiler.packageName);
        }
        if (IdlCompiler.usePrefix && idlObject2.getPrefix() != null) {
            if (!string.equals("")) {
                string = string + ".";
            }
            string = IdlCompiler.reversePrefix ? string + this.inversedPrefix(idlObject2.getPrefix()) : string + idlObject2.getPrefix();
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            String string2 = (String)arrayList.get(n);
            if (string2 != null) {
                if (!string.equals("")) {
                    string = string + ".";
                }
                string = string + string2;
            }
            --n;
        }
        return string;
    }

    public String removePackageName(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = "";
        while (true) {
            if ((n2 = string.indexOf("Package", n)) == -1) break;
            string2 = string2 + string.substring(n, n2);
            n = n2 + 7;
        }
        string2 = string2 + string.substring(n, string.length());
        return string2;
    }

    public boolean isEnumCase(String string) {
        boolean bl = false;
        if (string.indexOf("@") != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean isSameScope(String string, IdlObject idlObject2) {
        IdlObject idlObject3 = idlObject2.upper().returnVisibleObject(string, false);
        if (idlObject3 == null) {
            return false;
        }
        return idlObject3.upper().equals(idlObject2.upper());
    }

    public String IdlScopeToJavaScope(String string, boolean bl, boolean bl2, IdlObject idlObject2) {
        int n;
        ArrayList<Character> arrayList = new ArrayList<Character>();
        String string2 = new String();
        int n2 = 0;
        boolean bl3 = false;
        int n3 = 0;
        while (n3 < string.length()) {
            block33: {
                boolean bl4;
                block31: {
                    block32: {
                        if (!Character.isDigit(string.charAt(n3)) && string.charAt(n3) != '-') break block31;
                        if (string.charAt(n3) != '-') break block32;
                        arrayList.add(CharacterCache.getCharacter('-'));
                        if (string.charAt(n3++) == ' ') break block33;
                    }
                    boolean bl5 = false;
                    while (n3 != string.length() && string.charAt(n3) != ' ') {
                        if (string.charAt(n3) == 'x') {
                            bl5 = true;
                        }
                        arrayList.add(CharacterCache.getCharacter(string.charAt(n3)));
                        ++n3;
                    }
                    if (!bl2) {
                        arrayList.add(CharacterCache.getCharacter('l'));
                    }
                    break block33;
                }
                if (string.charAt(n3) == '\"') {
                    ++n3;
                    arrayList.add(CharacterCache.getCharacter('\"'));
                    bl4 = false;
                    n = 0;
                    while (n3 != string.length() && n == 0) {
                        if (string.charAt(n3) == '\"' && !bl4) {
                            n = 1;
                            continue;
                        }
                        bl4 = false;
                        if (string.charAt(n3) == '\\') {
                            bl4 = true;
                        }
                        arrayList.add(CharacterCache.getCharacter(string.charAt(n3)));
                        ++n3;
                    }
                    arrayList.add(CharacterCache.getCharacter('\"'));
                } else if (string.charAt(n3) == '\'') {
                    ++n3;
                    arrayList.add(CharacterCache.getCharacter('\''));
                    bl4 = false;
                    n = 0;
                    while (n3 != string.length() && n == 0) {
                        if (string.charAt(n3) == '\'' && !bl4) {
                            n = 1;
                            continue;
                        }
                        bl4 = false;
                        if (string.charAt(n3) == '\\') {
                            bl4 = true;
                        }
                        arrayList.add(CharacterCache.getCharacter(string.charAt(n3)));
                        ++n3;
                    }
                    arrayList.add(CharacterCache.getCharacter('\''));
                } else if (Character.isLetter(string.charAt(n3))) {
                    string2 = "";
                    int n4 = n3;
                    while (n3 != string.length() && string.charAt(n3) != ' ') {
                        if (string.charAt(n3) == ':' && ++n3 < string.length()) {
                            if (string.charAt(n3) == ':') {
                                arrayList.add(CharacterCache.getCharacter('.'));
                                n2 = arrayList.size();
                                ++n3;
                            } else {
                                arrayList.add(CharacterCache.getCharacter(':'));
                            }
                        }
                        if (string.charAt(n3) == '.') {
                            n2 = arrayList.size() + 1;
                        }
                        arrayList.add(CharacterCache.getCharacter(string.charAt(n3)));
                        string2 = string2 + string.charAt(n3);
                        ++n3;
                    }
                    if (!string2.equals("true") && !string2.equals("false")) {
                        bl3 = this.isEnumCase(string);
                        bl4 = this.isSameScope(string2, idlObject2);
                        if (bl3) {
                            arrayList.remove(arrayList.size() - 1);
                        }
                        if (!bl3 && !bl4) {
                            if (!string2.endsWith(".value")) {
                                arrayList.add(CharacterCache.getCharacter('.'));
                                arrayList.add(CharacterCache.getCharacter('v'));
                                arrayList.add(CharacterCache.getCharacter('a'));
                                arrayList.add(CharacterCache.getCharacter('l'));
                                arrayList.add(CharacterCache.getCharacter('u'));
                                arrayList.add(CharacterCache.getCharacter('e'));
                            }
                        } else if (bl && !bl4) {
                            arrayList.add(n2, CharacterCache.getCharacter('_'));
                        }
                    }
                } else if (string.charAt(n3) != ' ') {
                    arrayList.add(CharacterCache.getCharacter(string.charAt(n3)));
                }
            }
            ++n3;
        }
        String string3 = new String();
        n = 0;
        while (n < arrayList.size()) {
            string3 = string3 + ((Character)arrayList.get(n)).charValue();
            ++n;
        }
        return string3;
    }

    public boolean isHexaCar(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public String IdlEspaceCharToJavaEscapeChar(String string) {
        ArrayList<Character> arrayList = new ArrayList<Character>();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\\') {
                arrayList.add(CharacterCache.getCharacter('\\'));
                switch (string.charAt(++n)) {
                    case '\\': {
                        break;
                    }
                    case 'a': {
                        arrayList.add(CharacterCache.getCharacter('0'));
                        arrayList.add(CharacterCache.getCharacter('0'));
                        arrayList.add(CharacterCache.getCharacter('7'));
                        break;
                    }
                    case 'v': {
                        arrayList.add(CharacterCache.getCharacter('0'));
                        arrayList.add(CharacterCache.getCharacter('1'));
                        arrayList.add(CharacterCache.getCharacter('3'));
                        break;
                    }
                    case 'x': {
                        ++n;
                        while (this.isHexaCar(string.charAt(n))) {
                            ++n;
                        }
                        arrayList.add(CharacterCache.getCharacter('3'));
                        arrayList.add(CharacterCache.getCharacter('7'));
                        arrayList.add(CharacterCache.getCharacter('7'));
                    }
                    default: {
                        arrayList.add(CharacterCache.getCharacter(string.charAt(n)));
                        break;
                    }
                }
            } else {
                arrayList.add(CharacterCache.getCharacter(string.charAt(n)));
            }
            ++n;
        }
        String string2 = new String();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            string2 = string2 + ((Character)arrayList.get(n2)).charValue();
            ++n2;
        }
        return string2;
    }

    public String translate_to_java_expression(String string, boolean bl, IdlObject idlObject2) {
        String string2 = this.IdlScopeToJavaScope(string, true, bl, idlObject2);
        string2 = this.IdlEspaceCharToJavaEscapeChar(string2);
        if (bl) {
            string2 = "new java.math.BigDecimal(\"" + string2 + "\")";
        }
        return string2;
    }

    public String translate_to_union_case_expression(IdlUnionMember idlUnionMember2, String string) {
        String string2 = "";
        String string3 = this.IdlScopeToJavaScope(string, false, false, idlUnionMember2);
        string3 = this.IdlEspaceCharToJavaEscapeChar(string3);
        idlUnionMember2.reset();
        switch (this.final_type(idlUnionMember2.current()).kind()) {
            case 8: {
                IdlSimple idlSimple = (IdlSimple)this.final_type(idlUnionMember2.current());
                switch (idlSimple.internal()) {
                    case 47: 
                    case 66: {
                        string2 = "short)";
                        break;
                    }
                    case 38: 
                    case 65: {
                        string2 = "int)";
                        break;
                    }
                    case 73: 
                    case 74: {
                        string2 = "long)";
                        break;
                    }
                    case 26: 
                    case 71: {
                        string2 = "char)";
                        break;
                    }
                    case 24: {
                        string2 = "boolean)";
                        break;
                    }
                    case 41: {
                        string2 = "byte)";
                    }
                }
                break;
            }
        }
        if (string2.equals("")) {
            return string3;
        }
        return "(" + string2 + "(" + string3 + ")";
    }

    public void translate_type(IdlObject idlObject2, PrintWriter printWriter) {
        IdlSimple idlSimple = null;
        switch (idlObject2.kind()) {
            case 8: {
                idlSimple = (IdlSimple)idlObject2;
                switch (idlSimple.internal()) {
                    case 55: {
                        printWriter.print("void");
                        break;
                    }
                    case 34: {
                        printWriter.print("float");
                        break;
                    }
                    case 30: {
                        printWriter.print("double");
                        break;
                    }
                    case 47: 
                    case 66: {
                        printWriter.print("short");
                        break;
                    }
                    case 38: 
                    case 65: {
                        printWriter.print("int");
                        break;
                    }
                    case 73: 
                    case 74: {
                        printWriter.print("long");
                        break;
                    }
                    case 26: 
                    case 71: {
                        printWriter.print("char");
                        break;
                    }
                    case 24: {
                        printWriter.print("boolean");
                        break;
                    }
                    case 41: {
                        printWriter.print("byte");
                        break;
                    }
                    case 22: {
                        printWriter.print("org.omg.CORBA.Any");
                        break;
                    }
                    case 70: {
                        printWriter.print("org.omg.CORBA.TypeCode");
                        break;
                    }
                    case 40: {
                        printWriter.print("org.omg.CORBA.Object");
                        break;
                    }
                    case 88: {
                        printWriter.print("java.io.Serializable");
                    }
                }
                break;
            }
            case 26: {
                printWriter.print("java.math.BigDecimal");
                break;
            }
            case 5: 
            case 6: {
                printWriter.print("String");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 18: 
            case 28: 
            case 33: {
                printWriter.print(this.fullname(idlObject2));
                break;
            }
            case 25: {
                if (this.isNativeDefinition(idlObject2)) {
                    this.printNativeDefinition(idlObject2, printWriter);
                    break;
                }
                printWriter.print(this.fullname(idlObject2));
                break;
            }
            case 13: {
                idlObject2.reset();
                this.translate_type(idlObject2.current(), printWriter);
                break;
            }
            case 9: 
            case 24: {
                this.translate_type(idlObject2.current(), printWriter);
                printWriter.print("[]");
                break;
            }
            case 10: {
                this.translate_type(((IdlIdent)idlObject2).internalObject(), printWriter);
                break;
            }
            case 27: {
                if (((IdlValueBox)idlObject2).simple()) {
                    printWriter.print(this.fullname(idlObject2));
                    break;
                }
                idlObject2.reset();
                this.translate_type(idlObject2.current(), printWriter);
            }
        }
    }

    public void translate_parameter(IdlObject idlObject2, PrintWriter printWriter, int n) {
        IdlSimple idlSimple = null;
        switch (idlObject2.kind()) {
            case 8: {
                idlSimple = (IdlSimple)idlObject2;
                switch (idlSimple.internal()) {
                    case 34: {
                        if (n == 0) {
                            printWriter.print("float");
                            break;
                        }
                        printWriter.print("org.omg.CORBA.FloatHolder");
                        break;
                    }
                    case 30: {
                        if (n == 0) {
                            printWriter.print("double");
                            break;
                        }
                        printWriter.print("org.omg.CORBA.DoubleHolder");
                        break;
                    }
                    case 47: 
                    case 66: {
                        if (n == 0) {
                            printWriter.print("short");
                            break;
                        }
                        printWriter.print("org.omg.CORBA.ShortHolder");
                        break;
                    }
                    case 38: 
                    case 65: {
                        if (n == 0) {
                            printWriter.print("int");
                            break;
                        }
                        printWriter.print("org.omg.CORBA.IntHolder");
                        break;
                    }
                    case 73: 
                    case 74: {
                        if (n == 0) {
                            printWriter.print("long");
                            break;
                        }
                        printWriter.print("org.omg.CORBA.LongHolder");
                        break;
                    }
                    case 26: 
                    case 71: {
                        if (n == 0) {
                            printWriter.print("char");
                            break;
                        }
                        printWriter.print("org.omg.CORBA.CharHolder");
                        break;
                    }
                    case 24: {
                        if (n == 0) {
                            printWriter.print("boolean");
                            break;
                        }
                        printWriter.print("org.omg.CORBA.BooleanHolder");
                        break;
                    }
                    case 41: {
                        if (n == 0) {
                            printWriter.print("byte");
                            break;
                        }
                        printWriter.print("org.omg.CORBA.ByteHolder");
                        break;
                    }
                    case 22: {
                        if (n == 0) {
                            printWriter.print("org.omg.CORBA.Any");
                            break;
                        }
                        printWriter.print("org.omg.CORBA.AnyHolder");
                        break;
                    }
                    case 70: {
                        if (n == 0) {
                            printWriter.print("org.omg.CORBA.TypeCode");
                            break;
                        }
                        printWriter.print("org.omg.CORBA.TypeCodeHolder");
                        break;
                    }
                    case 40: {
                        if (n == 0) {
                            printWriter.print("org.omg.CORBA.Object");
                            break;
                        }
                        printWriter.print("org.omg.CORBA.ObjectHolder");
                        break;
                    }
                    case 88: {
                        if (n == 0) {
                            printWriter.print("java.io.Serializable");
                            break;
                        }
                        printWriter.print("org.omg.CORBA.ValueBaseHolder");
                    }
                }
                break;
            }
            case 26: {
                if (n == 0) {
                    printWriter.print("java.math.BigDecimal");
                    break;
                }
                printWriter.print("org.omg.CORBA.FixedHolder");
                break;
            }
            case 5: 
            case 6: {
                if (n == 0) {
                    printWriter.print("String");
                    break;
                }
                printWriter.print("org.omg.CORBA.StringHolder");
                break;
            }
            case 27: {
                if (n == 0) {
                    if (((IdlValueBox)idlObject2).simple()) {
                        printWriter.print(this.fullname(idlObject2));
                        break;
                    }
                    idlObject2.reset();
                    this.translate_parameter(idlObject2.current(), printWriter, n);
                    break;
                }
                printWriter.print(this.fullname(idlObject2) + "Holder");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 28: 
            case 33: {
                if (n == 0) {
                    printWriter.print(this.fullname(idlObject2));
                    break;
                }
                printWriter.print(this.fullname(idlObject2) + "Holder");
                break;
            }
            case 25: {
                if (n != 0) {
                    printWriter.print(this.fullname(idlObject2) + "Holder");
                    break;
                }
                if (this.isNativeDefinition(idlObject2)) {
                    this.printNativeDefinition(idlObject2, printWriter);
                    break;
                }
                printWriter.print(this.fullname(idlObject2));
                break;
            }
            case 13: {
                idlObject2.reset();
                if (n != 0) {
                    if (this.final_type(idlObject2).kind() == 9 || this.final_type(idlObject2).kind() == 24) {
                        printWriter.print(this.fullname(idlObject2) + "Holder");
                        break;
                    }
                    this.translate_parameter(idlObject2.current(), printWriter, n);
                    break;
                }
                this.translate_parameter(idlObject2.current(), printWriter, n);
                break;
            }
            case 9: 
            case 24: {
                if (n == 0) {
                    this.translate_parameter(idlObject2.current(), printWriter, n);
                    printWriter.print("[]");
                    break;
                }
                printWriter.print(this.fullname(idlObject2.upper()) + "Holder");
                break;
            }
            case 10: {
                this.translate_parameter(((IdlIdent)idlObject2).internalObject(), printWriter, n);
            }
        }
    }

    public int recursion(IdlObject idlObject2) {
        String string = this.final_type(idlObject2.current()).name();
        int n = 0;
        if (this.final_type(idlObject2.current()) instanceof IdlSimple) {
            return 0;
        }
        idlObject2 = idlObject2.upper();
        while (idlObject2 != null) {
            if (this.final_type(idlObject2).name() != null && this.final_type(idlObject2).name().equals(string)) {
                return n;
            }
            ++n;
            if ((idlObject2 = idlObject2.upper()) == null) {
                return n;
            }
            if (idlObject2.kind() == 15 || idlObject2.kind() == 1 || idlObject2.kind() == 0) break;
        }
        return 0;
    }

    public void translate_typecode(IdlObject idlObject2, PrintWriter printWriter) {
        IdlSimple idlSimple = null;
        switch (idlObject2.kind()) {
            case 8: {
                idlSimple = (IdlSimple)idlObject2;
                printWriter.print("orb.get_primitive_tc(org.omg.CORBA.TCKind.");
                switch (idlSimple.internal()) {
                    case 34: {
                        printWriter.print("tk_float)");
                        break;
                    }
                    case 30: {
                        printWriter.print("tk_double)");
                        break;
                    }
                    case 47: {
                        printWriter.print("tk_short)");
                        break;
                    }
                    case 66: {
                        printWriter.print("tk_ushort)");
                        break;
                    }
                    case 38: {
                        printWriter.print("tk_long)");
                        break;
                    }
                    case 65: {
                        printWriter.print("tk_ulong)");
                        break;
                    }
                    case 73: {
                        printWriter.print("tk_longlong)");
                        break;
                    }
                    case 74: {
                        printWriter.print("tk_ulonglong)");
                        break;
                    }
                    case 26: {
                        printWriter.print("tk_char)");
                        break;
                    }
                    case 71: {
                        printWriter.print("tk_wchar)");
                        break;
                    }
                    case 24: {
                        printWriter.print("tk_boolean)");
                        break;
                    }
                    case 41: {
                        printWriter.print("tk_octet)");
                        break;
                    }
                    case 22: {
                        printWriter.print("tk_any)");
                        break;
                    }
                    case 70: {
                        printWriter.print("tk_TypeCode)");
                        break;
                    }
                    case 40: {
                        printWriter.print("tk_objref)");
                        break;
                    }
                    case 88: {
                        printWriter.print("tk_value)");
                    }
                }
                break;
            }
            case 26: {
                printWriter.print("orb.create_fixed_tc((short)" + ((IdlFixed)idlObject2).digits() + ",(short)" + ((IdlFixed)idlObject2).scale() + ")");
                break;
            }
            case 5: {
                if (((IdlString)idlObject2).maxSize() == 0) {
                    printWriter.print("orb.get_primitive_tc(org.omg.CORBA.TCKind.tk_string)");
                    break;
                }
                printWriter.print("orb.create_string_tc(" + ((IdlString)idlObject2).maxSize() + ")");
                break;
            }
            case 6: {
                if (((IdlWString)idlObject2).maxSize() == 0) {
                    printWriter.print("orb.get_primitive_tc(org.omg.CORBA.TCKind.tk_wstring)");
                    break;
                }
                printWriter.print("orb.create_wstring_tc(" + ((IdlWString)idlObject2).maxSize() + ")");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                printWriter.print(this.fullname(idlObject2));
                printWriter.print("Helper.type()");
                break;
            }
            case 13: {
                printWriter.print(this.fullname(idlObject2));
                printWriter.print("Helper.type()");
                break;
            }
            case 9: {
                printWriter.print("orb.create_sequence_tc(");
                printWriter.print(((IdlSequence)idlObject2).getSize() + ",");
                idlObject2.reset();
                this.translate_typecode(idlObject2.current(), printWriter);
                printWriter.print(")");
                break;
            }
            case 24: {
                printWriter.print("orb.create_array_tc(");
                printWriter.print(((IdlArray)idlObject2).getDimension() + ",");
                idlObject2.reset();
                this.translate_typecode(idlObject2.current(), printWriter);
                printWriter.print(")");
                break;
            }
            case 10: {
                this.translate_typecode(((IdlIdent)idlObject2).internalObject(), printWriter);
                break;
            }
            default: {
                System.out.println("Unexpected... : " + idlObject2.kind());
            }
        }
    }

    public void translate_any_insert(IdlObject idlObject2, PrintWriter printWriter, String string, String string2) {
        IdlSimple idlSimple = null;
        switch (idlObject2.kind()) {
            case 8: {
                idlSimple = (IdlSimple)idlObject2;
                if (idlSimple.internal() == 88) {
                    printWriter.print("org.omg.CORBA.portable.ValueBaseHelper.insert(" + string + ",(org.omg.CORBA.portable.ValueBase)" + string2 + ")");
                    return;
                }
                printWriter.print(string + ".insert_");
                switch (idlSimple.internal()) {
                    case 34: {
                        printWriter.print("float((float)" + string2 + ")");
                        break;
                    }
                    case 30: {
                        printWriter.print("double((double)" + string2 + ")");
                        break;
                    }
                    case 47: {
                        printWriter.print("short((short)" + string2 + ")");
                        break;
                    }
                    case 66: {
                        printWriter.print("ushort((short)" + string2 + ")");
                        break;
                    }
                    case 38: {
                        printWriter.print("long((int)" + string2 + ")");
                        break;
                    }
                    case 65: {
                        printWriter.print("ulong((int)" + string2 + ")");
                        break;
                    }
                    case 73: {
                        printWriter.print("longlong((long)" + string2 + ")");
                        break;
                    }
                    case 74: {
                        printWriter.print("ulonglong((long)" + string2 + ")");
                        break;
                    }
                    case 26: {
                        printWriter.print("char(" + string2 + ")");
                        break;
                    }
                    case 71: {
                        printWriter.print("wchar(" + string2 + ")");
                        break;
                    }
                    case 24: {
                        printWriter.print("boolean(" + string2 + ")");
                        break;
                    }
                    case 41: {
                        printWriter.print("octet((byte)" + string2 + ")");
                        break;
                    }
                    case 22: {
                        printWriter.print("any(" + string2 + ")");
                        break;
                    }
                    case 70: {
                        printWriter.print("TypeCode(" + string2 + ")");
                        break;
                    }
                    case 40: {
                        printWriter.print("Object(" + string2 + ")");
                    }
                }
                break;
            }
            case 26: {
                printWriter.print(string + ".insert_fixed(" + string2 + ")");
                break;
            }
            case 5: {
                printWriter.print(string + ".insert_string(" + string2 + ")");
                break;
            }
            case 6: {
                printWriter.print(string + ".insert_wstring(" + string2 + ")");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: {
                printWriter.print(this.fullname(idlObject2));
                printWriter.print("Helper.insert(" + string + "," + string2 + ")");
                break;
            }
            case 13: {
                printWriter.print(this.fullname(idlObject2));
                printWriter.print("Helper.insert(" + string + "," + string2 + ")");
                break;
            }
            case 9: 
            case 24: {
                break;
            }
            case 10: {
                this.translate_any_insert(((IdlIdent)idlObject2).internalObject(), printWriter, string, string2);
            }
        }
    }

    public boolean isTruncatable(IdlObject idlObject2) {
        IdlValue idlValue2 = (IdlValue)idlObject2;
        Vector vector = idlValue2.getInheritanceList();
        int n = 0;
        while (n < vector.size()) {
            if (((IdlValueInheritance)vector.get(n)).truncatable_member()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void printConcreteTypeCode(IdlObject idlObject2, PrintWriter printWriter) {
        IdlValue idlValue2 = (IdlValue)idlObject2;
        IdlValue[] idlValueArray = idlValue2.getInheritance();
        int n = 0;
        while (n < idlValueArray.length) {
            if (!idlValueArray[n].abstract_value()) {
                this.translate_typecode(idlValueArray[n], printWriter);
                return;
            }
            ++n;
        }
        printWriter.print("orb.get_primitive_tc(org.omg.CORBA.TCKind.tk_null)");
    }

    public void translate_new_typecode(IdlObject idlObject2, PrintWriter printWriter) {
        switch (idlObject2.kind()) {
            case 2: {
                printWriter.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                printWriter.println("            String []_members = new String[" + idlObject2.length() + "];");
                idlObject2.reset();
                int n = 0;
                while (!idlObject2.end()) {
                    printWriter.println("            _members[" + n + "] = \"" + idlObject2.current().name() + "\";");
                    ++n;
                    idlObject2.next();
                }
                printWriter.println("            _tc = orb.create_enum_tc(id(),\"" + idlObject2.name() + "\",_members);");
                break;
            }
            case 3: {
                printWriter.println("                org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                printWriter.println("                org.omg.CORBA.StructMember []_members = new org.omg.CORBA.StructMember[" + idlObject2.length() + "];");
                printWriter.println("");
                idlObject2.reset();
                int n = 0;
                while (!idlObject2.end()) {
                    printWriter.println("                _members[" + n + "] = new org.omg.CORBA.StructMember();");
                    printWriter.println("                _members[" + n + "].name = \"" + idlObject2.current().name() + "\";");
                    printWriter.print("                _members[" + n + "].type = ");
                    idlObject2.current().reset();
                    this.translate_typecode(idlObject2.current().current(), printWriter);
                    printWriter.println(";");
                    idlObject2.next();
                    ++n;
                }
                printWriter.println("                _tc = orb.create_struct_tc(id(),\"" + idlObject2.name() + "\",_members);");
                break;
            }
            case 4: {
                printWriter.println("                org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                printWriter.println("                org.omg.CORBA.UnionMember []_members = new org.omg.CORBA.UnionMember[" + (idlObject2.length() - 1) + "];");
                printWriter.println("                org.omg.CORBA.Any any;");
                printWriter.println("");
                int n = ((IdlUnion)idlObject2).index();
                idlObject2.reset();
                IdlUnionMember idlUnionMember2 = (IdlUnionMember)idlObject2.current();
                idlUnionMember2.reset();
                idlObject2.next();
                int n2 = 0;
                while (!idlObject2.end()) {
                    printWriter.println("                any = orb.create_any();");
                    if (n2 != n) {
                        printWriter.print(tab4);
                        this.translate_any_insert(idlUnionMember2.current(), printWriter, "any", this.translate_to_union_case_expression(idlUnionMember2, ((IdlUnionMember)idlObject2.current()).getExpression()));
                        printWriter.println(";");
                    } else {
                        printWriter.println("                any.insert_octet((byte)0);");
                    }
                    printWriter.println("                _members[" + n2 + "] = new org.omg.CORBA.UnionMember();");
                    printWriter.println("                _members[" + n2 + "].name = \"" + idlObject2.current().name() + "\";");
                    printWriter.println("                _members[" + n2 + "].label = any;");
                    printWriter.print("                _members[" + n2 + "].type = ");
                    idlObject2.current().reset();
                    this.translate_typecode(idlObject2.current().current(), printWriter);
                    printWriter.println(";");
                    idlObject2.next();
                    ++n2;
                }
                idlObject2.reset();
                printWriter.print("                _tc = orb.create_union_tc(id(),\"" + idlObject2.name() + "\",");
                this.translate_typecode(idlObject2.current().current(), printWriter);
                printWriter.println(",_members);");
                break;
            }
            case 13: {
                printWriter.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                printWriter.print("            _tc = orb.create_alias_tc(id(),\"" + idlObject2.name() + "\",");
                idlObject2.reset();
                this.translate_typecode(idlObject2.current(), printWriter);
                printWriter.println(");");
                break;
            }
            case 14: {
                printWriter.println("                org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                printWriter.println("                org.omg.CORBA.StructMember []_members = new org.omg.CORBA.StructMember[" + idlObject2.length() + "];");
                printWriter.println("");
                idlObject2.reset();
                int n = 0;
                while (!idlObject2.end()) {
                    printWriter.println("                _members[" + n + "] = new org.omg.CORBA.StructMember();");
                    printWriter.println("                _members[" + n + "].name = \"" + idlObject2.current().name() + "\";");
                    printWriter.print("                _members[" + n + "].type = ");
                    idlObject2.current().reset();
                    this.translate_typecode(idlObject2.current().current(), printWriter);
                    printWriter.println(";");
                    idlObject2.next();
                    ++n;
                }
                printWriter.println("                _tc = orb.create_exception_tc(id(),\"" + idlObject2.name() + "\",_members);");
                break;
            }
            case 15: 
            case 18: {
                printWriter.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                if (((IdlInterface)idlObject2).abstract_interface()) {
                    printWriter.println("            _tc = orb.create_abstract_interface_tc(id(),\"" + idlObject2.name() + "\");");
                    break;
                }
                printWriter.println("            _tc = orb.create_interface_tc(id(),\"" + idlObject2.name() + "\");");
                break;
            }
            case 25: {
                printWriter.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                printWriter.println("            _tc = orb.create_native_tc(id(),\"" + idlObject2.name() + "\");");
                break;
            }
            case 27: {
                printWriter.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                printWriter.print("            _tc = orb.create_value_box_tc(id(),\"" + idlObject2.name() + "\",");
                idlObject2.reset();
                this.translate_typecode(idlObject2.current(), printWriter);
                printWriter.println(");");
                break;
            }
            case 28: {
                printWriter.println("                org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
                int n = 0;
                idlObject2.reset();
                while (!idlObject2.end()) {
                    if (idlObject2.current().kind() == 29) {
                        ++n;
                    }
                    idlObject2.next();
                }
                printWriter.println("                org.omg.CORBA.ValueMember []_members = new org.omg.CORBA.ValueMember[" + n + "];");
                printWriter.println("");
                idlObject2.reset();
                int n3 = 0;
                while (!idlObject2.end()) {
                    if (idlObject2.current().kind() == 29) {
                        printWriter.println("                _members[" + n3 + "] = new org.omg.CORBA.ValueMember();");
                        printWriter.println("                _members[" + n3 + "].name = \"" + idlObject2.current().name() + "\";");
                        printWriter.print("                _members[" + n3 + "].type = ");
                        idlObject2.current().reset();
                        this.translate_typecode(idlObject2.current().current(), printWriter);
                        printWriter.println(";");
                        printWriter.print("                _members[" + n3 + "].access = ");
                        if (((IdlStateMember)idlObject2.current()).public_member()) {
                            printWriter.println("org.omg.CORBA.PUBLIC_MEMBER.value;");
                        } else {
                            printWriter.println("org.omg.CORBA.PRIVATE_MEMBER.value;");
                        }
                        ++n3;
                    }
                    idlObject2.next();
                }
                printWriter.println("");
                printWriter.print("                org.omg.CORBA.TypeCode _concrete_tc = ");
                this.printConcreteTypeCode(idlObject2, printWriter);
                printWriter.println(";");
                printWriter.println("");
                printWriter.print("                _tc = orb.create_value_tc(id(),\"" + idlObject2.name() + "\",");
                if (((IdlValue)idlObject2).abstract_value()) {
                    printWriter.print("org.omg.CORBA.VM_ABSTRACT.value");
                } else if (((IdlValue)idlObject2).custom_value()) {
                    printWriter.print("org.omg.CORBA.VM_CUSTOM.value");
                } else if (this.isTruncatable(idlObject2)) {
                    printWriter.print("org.omg.CORBA.VM_TRUNCATABLE.value");
                } else {
                    printWriter.print("org.omg.CORBA.VM_NONE.value");
                }
                printWriter.println(",_concrete_tc,_members);");
            }
        }
    }

    public String get_array_name(IdlObject idlObject2) {
        switch (this.final_kind(idlObject2)) {
            case 8: {
                IdlSimple idlSimple = (IdlSimple)this.final_type(idlObject2);
                switch (idlSimple.internal()) {
                    case 34: {
                        return "float";
                    }
                    case 30: {
                        return "double";
                    }
                    case 47: {
                        return "short";
                    }
                    case 66: {
                        return "ushort";
                    }
                    case 38: {
                        return "long";
                    }
                    case 65: {
                        return "ulong";
                    }
                    case 73: {
                        return "longlong";
                    }
                    case 74: {
                        return "ulonglong";
                    }
                    case 26: {
                        return "char";
                    }
                    case 71: {
                        return "wchar";
                    }
                    case 24: {
                        return "boolean";
                    }
                    case 41: {
                        return "octet";
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void translate_marshalling_member(IdlObject idlObject2, PrintWriter printWriter, String string, String string2, String string3) {
        IdlSimple idlSimple = null;
        String string4 = null;
        switch (idlObject2.kind()) {
            case 8: {
                idlSimple = (IdlSimple)idlObject2;
                if (idlSimple.internal() == 88) {
                    printWriter.println(string3 + "((org.omg.CORBA_2_3.portable.OutputStream)" + string + ").write_value(" + string2 + ");");
                    return;
                }
                printWriter.print(string3 + string + ".write");
                switch (idlSimple.internal()) {
                    case 34: {
                        printWriter.println("_float(" + string2 + ");");
                        break;
                    }
                    case 30: {
                        printWriter.println("_double(" + string2 + ");");
                        break;
                    }
                    case 47: {
                        printWriter.println("_short(" + string2 + ");");
                        break;
                    }
                    case 66: {
                        printWriter.println("_ushort(" + string2 + ");");
                        break;
                    }
                    case 38: {
                        printWriter.println("_long(" + string2 + ");");
                        break;
                    }
                    case 65: {
                        printWriter.println("_ulong(" + string2 + ");");
                        break;
                    }
                    case 73: {
                        printWriter.println("_longlong(" + string2 + ");");
                        break;
                    }
                    case 74: {
                        printWriter.println("_ulonglong(" + string2 + ");");
                        break;
                    }
                    case 26: {
                        printWriter.println("_char(" + string2 + ");");
                        break;
                    }
                    case 71: {
                        printWriter.println("_wchar(" + string2 + ");");
                        break;
                    }
                    case 24: {
                        printWriter.println("_boolean(" + string2 + ");");
                        break;
                    }
                    case 41: {
                        printWriter.println("_octet(" + string2 + ");");
                        break;
                    }
                    case 22: {
                        printWriter.println("_any(" + string2 + ");");
                        break;
                    }
                    case 70: {
                        printWriter.println("_TypeCode(" + string2 + ");");
                        break;
                    }
                    case 40: {
                        printWriter.println("_Object(" + string2 + ");");
                    }
                }
                break;
            }
            case 26: {
                printWriter.println(string3 + string + ".write_fixed(" + string2 + ");");
                break;
            }
            case 5: {
                printWriter.println(string3 + string + ".write_string(" + string2 + ");");
                break;
            }
            case 6: {
                printWriter.println(string3 + string + ".write_wstring(" + string2 + ");");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                printWriter.print(string3 + this.fullname(idlObject2));
                printWriter.println("Helper.write(" + string + "," + string2 + ");");
                break;
            }
            case 13: {
                printWriter.print(string3 + this.fullname(idlObject2));
                printWriter.println("Helper.write(" + string + "," + string2 + ");");
                break;
            }
            case 24: {
                string4 = this.get_array_name(idlObject2.current());
                if (string4 == null) {
                    int n = string3.length() - 1;
                    printWriter.println(string3 + "if (" + string2 + ".length != " + ((IdlArray)idlObject2).getDimension() + ") ");
                    printWriter.println(string3 + "   throw new org.omg.CORBA.MARSHAL();");
                    printWriter.println(string3 + "for (int i" + n + "=0; i" + n + "<" + string2 + ".length; i" + n + "++)");
                    printWriter.println(string3 + "{");
                    this.translate_marshalling_member(idlObject2.current(), printWriter, string, string2 + "[i" + n + "]", string3 + "    " + "");
                    printWriter.println("");
                    printWriter.println(string3 + "}");
                    break;
                }
                printWriter.println(string3 + string + ".write_" + string4 + "_array(" + string2 + ", 0," + string2 + ".length);");
                break;
            }
            case 9: {
                string4 = this.get_array_name(idlObject2.current());
                if (string4 == null) {
                    int n = string3.length() - 1;
                    printWriter.println(string3 + string + ".write_ulong(" + string2 + ".length);");
                    printWriter.println(string3 + "for (int i" + n + "=0; i" + n + "<" + string2 + ".length; i" + n + "++)");
                    printWriter.println(string3 + "{");
                    this.translate_marshalling_member(idlObject2.current(), printWriter, string, string2 + "[i" + n + "]", string3 + "    " + "");
                    printWriter.println("");
                    printWriter.println(string3 + "}");
                    break;
                }
                printWriter.println(string3 + string + ".write_ulong(" + string2 + ".length);");
                printWriter.println(string3 + string + ".write_" + string4 + "_array(" + string2 + ", 0," + string2 + ".length);");
                break;
            }
            case 10: {
                this.translate_marshalling_member(((IdlIdent)idlObject2).internalObject(), printWriter, string, string2, string3);
            }
        }
    }

    public void translate_unmarshalling_member(IdlObject idlObject2, PrintWriter printWriter, String string, String string2, String string3) {
        IdlSimple idlSimple = null;
        String string4 = null;
        IdlObject idlObject3 = null;
        switch (idlObject2.kind()) {
            case 8: {
                idlSimple = (IdlSimple)idlObject2;
                if (idlSimple.internal() == 88) {
                    printWriter.println(string3 + string2 + " = ((org.omg.CORBA_2_3.portable.InputStream)" + string + ").read_value();");
                    return;
                }
                printWriter.print(string3 + string2 + " = " + string + ".read");
                switch (idlSimple.internal()) {
                    case 34: {
                        printWriter.println("_float();");
                        break;
                    }
                    case 30: {
                        printWriter.println("_double();");
                        break;
                    }
                    case 47: {
                        printWriter.println("_short();");
                        break;
                    }
                    case 66: {
                        printWriter.println("_ushort();");
                        break;
                    }
                    case 38: {
                        printWriter.println("_long();");
                        break;
                    }
                    case 65: {
                        printWriter.println("_ulong();");
                        break;
                    }
                    case 73: {
                        printWriter.println("_longlong();");
                        break;
                    }
                    case 74: {
                        printWriter.println("_ulonglong();");
                        break;
                    }
                    case 26: {
                        printWriter.println("_char();");
                        break;
                    }
                    case 71: {
                        printWriter.println("_wchar();");
                        break;
                    }
                    case 24: {
                        printWriter.println("_boolean();");
                        break;
                    }
                    case 41: {
                        printWriter.println("_octet();");
                        break;
                    }
                    case 22: {
                        printWriter.println("_any();");
                        break;
                    }
                    case 70: {
                        printWriter.println("_TypeCode();");
                        break;
                    }
                    case 40: {
                        printWriter.println("_Object();");
                        break;
                    }
                    case 88: {
                        printWriter.println("_value();");
                    }
                }
                break;
            }
            case 26: {
                printWriter.println(string3 + string2 + " =" + string + ".read_fixed();");
                break;
            }
            case 5: {
                printWriter.println(string3 + string2 + " = " + string + ".read_string();");
                break;
            }
            case 6: {
                printWriter.println(string3 + string2 + " = " + string + ".read_wstring();");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                printWriter.print(string3 + string2 + " = " + this.fullname(idlObject2));
                printWriter.println("Helper.read(" + string + ");");
                break;
            }
            case 13: {
                printWriter.print(string3 + string2 + " = " + this.fullname(idlObject2));
                printWriter.println("Helper.read(" + string + ");");
                break;
            }
            case 24: {
                int n = string3.length() - 1;
                printWriter.println(string3 + "{");
                printWriter.println(string3 + "int size" + n + " = " + ((IdlArray)idlObject2).getDimension() + ";");
                printWriter.print(string3 + string2 + " = new ");
                idlObject2.reset();
                idlObject3 = this.final_type(idlObject2.current());
                int n2 = 0;
                while (idlObject3.kind() == 24 || idlObject3.kind() == 9) {
                    idlObject3.reset();
                    ++n2;
                    idlObject3 = this.final_type(idlObject3.current());
                }
                this.translate_type(idlObject3, printWriter);
                printWriter.print("[size" + n + "]");
                int n3 = 0;
                while (n3 < n2) {
                    printWriter.print("[]");
                    ++n3;
                }
                printWriter.println(";");
                string4 = this.get_array_name(idlObject2.current());
                if (string4 == null) {
                    printWriter.println(string3 + "for (int i" + n + "=0; i" + n + "<" + string2 + ".length; i" + n + "++)");
                    printWriter.println(string3 + " {");
                    this.translate_unmarshalling_member(idlObject2.current(), printWriter, string, string2 + "[i" + n + "]", string3 + "    " + "");
                    printWriter.println("");
                    printWriter.println(string3 + " }");
                } else {
                    printWriter.println(string3 + string + ".read_" + string4 + "_array(" + string2 + ", 0, " + string2 + ".length);");
                }
                printWriter.println(string3 + "}");
                break;
            }
            case 9: {
                int n = string3.length() - 1;
                printWriter.println(string3 + "{");
                printWriter.println(string3 + "int size" + n + " = " + string + ".read_ulong();");
                printWriter.print(string3 + string2 + " = new ");
                idlObject2.reset();
                idlObject3 = this.final_type(idlObject2.current());
                int n4 = 0;
                while (idlObject3.kind() == 24 || idlObject3.kind() == 9) {
                    idlObject3.reset();
                    ++n4;
                    idlObject3 = this.final_type(idlObject3.current());
                }
                this.translate_type(idlObject3, printWriter);
                printWriter.print("[size" + n + "]");
                int n5 = 0;
                while (n5 < n4) {
                    printWriter.print("[]");
                    ++n5;
                }
                printWriter.println(";");
                string4 = this.get_array_name(idlObject2.current());
                if (string4 == null) {
                    printWriter.println(string3 + "for (int i" + n + "=0; i" + n + "<" + string2 + ".length; i" + n + "++)");
                    printWriter.println(string3 + " {");
                    this.translate_unmarshalling_member(idlObject2.current(), printWriter, string, string2 + "[i" + n + "]", string3 + "    " + "");
                    printWriter.println("");
                    printWriter.println(string3 + " }");
                } else {
                    printWriter.println(string3 + string + ".read_" + string4 + "_array(" + string2 + ", 0, " + string2 + ".length);");
                }
                printWriter.println(string3 + "}");
                break;
            }
            case 10: {
                this.translate_unmarshalling_member(((IdlIdent)idlObject2).internalObject(), printWriter, string, string2, string3);
            }
        }
    }

    public void translate_marshalling_data(IdlObject idlObject2, PrintWriter printWriter, String string, String string2) {
        IdlSimple idlSimple = null;
        switch (idlObject2.kind()) {
            case 8: {
                idlSimple = (IdlSimple)idlObject2;
                if (idlSimple.internal() == 88) {
                    printWriter.println("((org.omg.CORBA_2_3.portable.OutputStream)" + string + ").write_value(" + string2 + ");");
                    return;
                }
                printWriter.print(string + ".write");
                switch (idlSimple.internal()) {
                    case 34: {
                        printWriter.print("_float");
                        break;
                    }
                    case 30: {
                        printWriter.print("_double");
                        break;
                    }
                    case 47: {
                        printWriter.print("_short");
                        break;
                    }
                    case 66: {
                        printWriter.print("_ushort");
                        break;
                    }
                    case 38: {
                        printWriter.print("_long");
                        break;
                    }
                    case 65: {
                        printWriter.print("_ulong");
                        break;
                    }
                    case 73: {
                        printWriter.print("_longlong");
                        break;
                    }
                    case 74: {
                        printWriter.print("_ulonglong");
                        break;
                    }
                    case 26: {
                        printWriter.print("_char");
                        break;
                    }
                    case 71: {
                        printWriter.print("_wchar");
                        break;
                    }
                    case 24: {
                        printWriter.print("_boolean");
                        break;
                    }
                    case 41: {
                        printWriter.print("_octet");
                        break;
                    }
                    case 22: {
                        printWriter.print("_any");
                        break;
                    }
                    case 70: {
                        printWriter.print("_TypeCode");
                        break;
                    }
                    case 40: {
                        printWriter.print("_Object");
                        break;
                    }
                    case 88: {
                        printWriter.print("_value");
                    }
                }
                printWriter.println("(" + string2 + ");");
                break;
            }
            case 26: {
                printWriter.println(string + ".write_fixed(" + string2 + ");");
                break;
            }
            case 5: {
                printWriter.println(string + ".write_string(" + string2 + ");");
                break;
            }
            case 6: {
                printWriter.println(string + ".write_wstring(" + string2 + ");");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                printWriter.print(this.fullname(idlObject2));
                printWriter.println("Helper.write(" + string + "," + string2 + ");");
                break;
            }
            case 13: {
                printWriter.print(this.fullname(idlObject2));
                printWriter.println("Helper.write(" + string + "," + string2 + ");");
                break;
            }
            case 9: 
            case 24: {
                break;
            }
            case 10: {
                this.translate_marshalling_data(((IdlIdent)idlObject2).internalObject(), printWriter, string, string2);
            }
        }
    }

    public void translate_unmarshalling_data(IdlObject idlObject2, PrintWriter printWriter, String string) {
        IdlSimple idlSimple = null;
        switch (idlObject2.kind()) {
            case 8: {
                idlSimple = (IdlSimple)idlObject2;
                if (idlSimple.internal() == 88) {
                    printWriter.println("((org.omg.CORBA_2_3.portable.InputStream)" + string + ").read_value();");
                    return;
                }
                printWriter.print(string + ".read");
                switch (idlSimple.internal()) {
                    case 34: {
                        printWriter.println("_float();");
                        break;
                    }
                    case 30: {
                        printWriter.println("_double();");
                        break;
                    }
                    case 47: {
                        printWriter.println("_short();");
                        break;
                    }
                    case 66: {
                        printWriter.println("_ushort();");
                        break;
                    }
                    case 38: {
                        printWriter.println("_long();");
                        break;
                    }
                    case 65: {
                        printWriter.println("_ulong();");
                        break;
                    }
                    case 73: {
                        printWriter.println("_longlong();");
                        break;
                    }
                    case 74: {
                        printWriter.println("_ulonglong();");
                        break;
                    }
                    case 26: {
                        printWriter.println("_char();");
                        break;
                    }
                    case 71: {
                        printWriter.println("_wchar();");
                        break;
                    }
                    case 24: {
                        printWriter.println("_boolean();");
                        break;
                    }
                    case 41: {
                        printWriter.println("_octet();");
                        break;
                    }
                    case 22: {
                        printWriter.println("_any();");
                        break;
                    }
                    case 70: {
                        printWriter.println("_TypeCode();");
                        break;
                    }
                    case 40: {
                        printWriter.println("_Object();");
                    }
                }
                break;
            }
            case 26: {
                printWriter.println(string + ".read_fixed();");
                break;
            }
            case 5: {
                printWriter.println(string + ".read_string();");
                break;
            }
            case 6: {
                printWriter.println(string + ".read_wstring();");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 18: 
            case 25: 
            case 27: 
            case 28: 
            case 33: {
                printWriter.print(this.fullname(idlObject2));
                printWriter.println("Helper.read(" + string + ");");
                break;
            }
            case 13: {
                printWriter.print(this.fullname(idlObject2));
                printWriter.println("Helper.read(" + string + ");");
                break;
            }
            case 9: 
            case 24: {
                break;
            }
            case 10: {
                this.translate_unmarshalling_data(((IdlIdent)idlObject2).internalObject(), printWriter, string);
            }
        }
    }

    public void translate_marshalling(IdlObject idlObject2, PrintWriter printWriter, String string, String string2) {
        block0 : switch (idlObject2.kind()) {
            case 8: {
                if (((IdlSimple)idlObject2).internal() != 70) break;
                printWriter.println(tab2 + string + ".write_TypeCode(" + string2 + ");");
                break;
            }
            case 2: {
                printWriter.println(tab2 + string + ".write_ulong(" + string2 + ".value());");
                break;
            }
            case 3: {
                idlObject2.reset();
                while (!idlObject2.end()) {
                    idlObject2.current().reset();
                    this.translate_marshalling_member(idlObject2.current().current(), printWriter, string, string2 + "." + idlObject2.current().name(), tab2);
                    idlObject2.next();
                }
                break;
            }
            case 4: {
                int n = ((IdlUnion)idlObject2).index();
                idlObject2.reset();
                idlObject2.current().reset();
                boolean bl = false;
                if (this.final_kind(idlObject2.current().current()) == 2) {
                    bl = true;
                }
                IdlObject idlObject3 = idlObject2.current().current();
                this.translate_marshalling_member(idlObject2.current().current(), printWriter, string, string2 + "._" + idlObject2.current().name(), tab2);
                idlObject2.next();
                String string3 = null;
                string3 = ((IdlUnionMember)idlObject2.current()).getExpression().equals("true ") || ((IdlUnionMember)idlObject2.current()).getExpression().equals("false ") ? string2 + ".toInt()" : (bl ? string2 + ".__d.value()" : string2 + ".__d");
                int n2 = 0;
                while (!idlObject2.end()) {
                    if (n2 != n) {
                        printWriter.print("        if (" + string3 + " ==");
                        if (((IdlUnionMember)idlObject2.current()).getExpression().equals("true ")) {
                            printWriter.println(" 1)");
                        } else if (((IdlUnionMember)idlObject2.current()).getExpression().equals("false ")) {
                            printWriter.println(" 0)");
                        } else {
                            if (!bl) {
                                printWriter.print("(");
                                this.translate_type(idlObject3, printWriter);
                                printWriter.print(")");
                            }
                            printWriter.println(" " + this.translate_to_java_expression(((IdlUnionMember)idlObject2.current()).getExpression(), false, (IdlUnionMember)idlObject2.current()) + ")");
                        }
                        printWriter.println("        {");
                        if (!((IdlUnionMember)idlObject2.current()).isAsNext()) {
                            idlObject2.current().reset();
                            this.translate_marshalling_member(idlObject2.current().current(), printWriter, string, string2 + "._" + idlObject2.current().name(), tab3);
                        } else {
                            IdlObject idlObject4 = this.getAsNext(idlObject2);
                            idlObject4.reset();
                            this.translate_marshalling_member(idlObject4.current(), printWriter, string, string2 + "._" + idlObject2.current().name(), tab3);
                        }
                        printWriter.println("        }");
                    }
                    idlObject2.next();
                    if (!idlObject2.end() && n2 + 1 != n) {
                        printWriter.println("        else");
                    }
                    ++n2;
                }
                if (n == -1) break;
                n2 = 0;
                idlObject2.reset();
                idlObject2.next();
                while (!idlObject2.end()) {
                    if (n2 == n) {
                        if (idlObject2.length() != 2) {
                            printWriter.println("        else");
                        }
                        printWriter.println("        {");
                        this.translate_marshalling_member(idlObject2.current().current(), printWriter, string, string2 + "._" + idlObject2.current().name(), tab3);
                        printWriter.println("        }");
                    }
                    idlObject2.next();
                    ++n2;
                }
                break;
            }
            case 13: {
                idlObject2.reset();
                switch (idlObject2.current().kind()) {
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 24: 
                    case 26: {
                        this.translate_marshalling_member(idlObject2.current(), printWriter, string, string2, tab2);
                        break block0;
                    }
                }
                this.translate_marshalling(idlObject2.current(), printWriter, string, string2);
                break;
            }
            case 10: {
                this.translate_marshalling(((IdlIdent)idlObject2).internalObject(), printWriter, string, string2);
                break;
            }
            case 14: {
                printWriter.println(tab2 + string + ".write_string(id());");
                idlObject2.reset();
                while (!idlObject2.end()) {
                    idlObject2.current().reset();
                    this.translate_marshalling_member(idlObject2.current().current(), printWriter, string, string2 + "." + idlObject2.current().name(), tab2);
                    idlObject2.next();
                }
                break;
            }
            case 25: {
                printWriter.println("        throw new org.omg.CORBA.MARSHAL();");
                break;
            }
            case 15: 
            case 18: {
                if (((IdlInterface)idlObject2).local_interface()) {
                    printWriter.println("        throw new org.omg.CORBA.MARSHAL();");
                    break;
                }
                if (((IdlInterface)idlObject2).abstract_interface()) {
                    printWriter.println("        ((org.omg.CORBA_2_3.portable.OutputStream)" + string + ").write_abstract_interface(" + string2 + ");");
                    break;
                }
                printWriter.println(tab2 + string + ".write_Object((org.omg.CORBA.portable.ObjectImpl)" + string2 + ");");
                break;
            }
            case 27: {
                idlObject2.reset();
                if (((IdlValueBox)idlObject2).simple()) {
                    printWriter.println(tab2 + idlObject2.name() + " _box = (" + idlObject2.name() + ")" + string2 + ";");
                    this.translate_marshalling_member(idlObject2.current(), printWriter, string, "_box.value", tab2);
                    break;
                }
                printWriter.print(tab2);
                this.translate_type(idlObject2.current(), printWriter);
                printWriter.print(" _box = (");
                this.translate_type(idlObject2.current(), printWriter);
                printWriter.println(")" + string2 + ";");
                this.translate_marshalling_member(idlObject2.current(), printWriter, string, "_box", tab2);
                break;
            }
            case 28: {
                if (((IdlValue)idlObject2).abstract_value()) {
                    printWriter.println("        ((org.omg.CORBA_2_3.portable.OutputStream)" + string + ").write_value(" + string2 + ", _id);");
                    break;
                }
                printWriter.println("        ((org.omg.CORBA_2_3.portable.OutputStream)" + string + ").write_value(" + string2 + ", _id);");
            }
        }
    }

    private IdlObject getAsNext(IdlObject idlObject2) {
        int n = idlObject2.pos();
        while (!idlObject2.end()) {
            IdlUnionMember idlUnionMember2 = (IdlUnionMember)idlObject2.current();
            if (!idlUnionMember2.isAsNext()) {
                idlObject2.pos(n);
                return idlUnionMember2;
            }
            idlObject2.next();
        }
        idlObject2.pos(n);
        return null;
    }

    public void translate_unmarshalling(IdlObject idlObject2, PrintWriter printWriter, String string) {
        block0 : switch (idlObject2.kind()) {
            case 8: {
                if (((IdlSimple)idlObject2).internal() != 70) break;
                printWriter.println("        return " + string + ".read_TypeCode();");
                break;
            }
            case 2: {
                printWriter.println("        return " + idlObject2.name() + ".from_int(" + string + ".read_ulong());");
                break;
            }
            case 3: {
                idlObject2.reset();
                printWriter.println(tab2 + this.fullname(idlObject2) + " new_one = new " + this.fullname(idlObject2) + "();");
                printWriter.println("");
                while (!idlObject2.end()) {
                    idlObject2.current().reset();
                    this.translate_unmarshalling_member(idlObject2.current().current(), printWriter, string, "new_one." + idlObject2.current().name(), tab2);
                    idlObject2.next();
                }
                printWriter.println("");
                printWriter.println("        return new_one;");
                break;
            }
            case 4: {
                int n = ((IdlUnion)idlObject2).index();
                idlObject2.reset();
                printWriter.println(tab2 + this.fullname(idlObject2) + " new_one = new " + this.fullname(idlObject2) + "();");
                printWriter.println("");
                idlObject2.current().reset();
                boolean bl = false;
                if (this.final_kind(idlObject2.current().current()) == 2) {
                    bl = true;
                }
                IdlObject idlObject3 = idlObject2.current().current();
                this.translate_unmarshalling_member(idlObject2.current().current(), printWriter, string, "new_one._" + idlObject2.current().name(), tab2);
                idlObject2.next();
                String string2 = null;
                string2 = ((IdlUnionMember)idlObject2.current()).getExpression().equals("true ") || ((IdlUnionMember)idlObject2.current()).getExpression().equals("false ") ? "new_one.toInt()" : (bl ? "new_one.__d.value()" : "new_one.__d");
                int n2 = 0;
                while (!idlObject2.end()) {
                    if (n2 != n) {
                        printWriter.print("        if (" + string2 + " == ");
                        if (((IdlUnionMember)idlObject2.current()).getExpression().equals("true ")) {
                            printWriter.println("1)");
                        } else if (((IdlUnionMember)idlObject2.current()).getExpression().equals("false ")) {
                            printWriter.println("0)");
                        } else {
                            if (!bl) {
                                printWriter.print("(");
                                this.translate_type(idlObject3, printWriter);
                                printWriter.print(")");
                            }
                            printWriter.println(this.translate_to_java_expression(((IdlUnionMember)idlObject2.current()).getExpression(), false, (IdlUnionMember)idlObject2.current()) + ")");
                        }
                        printWriter.println("        {");
                        if (!((IdlUnionMember)idlObject2.current()).isAsNext()) {
                            idlObject2.current().reset();
                            this.translate_unmarshalling_member(idlObject2.current().current(), printWriter, string, "new_one._" + idlObject2.current().name(), tab3);
                        } else {
                            IdlObject idlObject4 = this.getAsNext(idlObject2);
                            idlObject4.reset();
                            this.translate_unmarshalling_member(idlObject4.current(), printWriter, string, "new_one._" + idlObject2.current().name(), tab3);
                        }
                        printWriter.println("        }");
                    }
                    idlObject2.next();
                    if (!idlObject2.end() && n2 + 1 != n) {
                        printWriter.println("        else");
                    }
                    ++n2;
                }
                n2 = 0;
                idlObject2.reset();
                idlObject2.next();
                while (!idlObject2.end()) {
                    if (n2 == n) {
                        if (idlObject2.length() != 2) {
                            printWriter.println("        else");
                        }
                        printWriter.println("        {");
                        idlObject2.current().reset();
                        this.translate_unmarshalling_member(idlObject2.current().current(), printWriter, string, "new_one._" + idlObject2.current().name(), tab3);
                        printWriter.println("        }");
                    }
                    idlObject2.next();
                    ++n2;
                }
                printWriter.println("");
                printWriter.println("        return new_one;");
                break;
            }
            case 13: {
                idlObject2.reset();
                switch (idlObject2.current().kind()) {
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 24: 
                    case 26: {
                        printWriter.print(tab2);
                        this.translate_type(idlObject2.current(), printWriter);
                        printWriter.println(" new_one;");
                        this.translate_unmarshalling_member(idlObject2.current(), printWriter, string, "new_one", tab2);
                        printWriter.println("");
                        printWriter.println("        return new_one;");
                        break block0;
                    }
                }
                this.translate_unmarshalling(idlObject2.current(), printWriter, string);
                break;
            }
            case 10: {
                this.translate_unmarshalling(((IdlIdent)idlObject2).internalObject(), printWriter, string);
                break;
            }
            case 14: {
                idlObject2.reset();
                printWriter.println(tab2 + this.fullname(idlObject2) + " new_one = new " + this.fullname(idlObject2) + "();");
                printWriter.println("");
                printWriter.println("        if (!" + string + ".read_string().equals(id()))");
                printWriter.println("         throw new org.omg.CORBA.MARSHAL();");
                while (!idlObject2.end()) {
                    idlObject2.current().reset();
                    this.translate_unmarshalling_member(idlObject2.current().current(), printWriter, string, "new_one." + idlObject2.current().name(), tab2);
                    idlObject2.next();
                }
                printWriter.println("");
                printWriter.println("        return new_one;");
                break;
            }
            case 25: {
                printWriter.println("        throw new org.omg.CORBA.MARSHAL();");
                break;
            }
            case 15: 
            case 18: {
                if (((IdlInterface)idlObject2).local_interface()) {
                    printWriter.println("        throw new org.omg.CORBA.MARSHAL();");
                    break;
                }
                if (((IdlInterface)idlObject2).abstract_interface()) {
                    printWriter.print("        Object new_one = ((org.omg.CORBA_2_3.portable.InputStream)" + string + ").read_abstract_interface(");
                    String string3 = this.fullname(idlObject2);
                    string3 = string3.lastIndexOf(".") != -1 ? string3.substring(0, string3.lastIndexOf(".") + 1) : "";
                    string3 = string3 + "_" + idlObject2.name() + "Stub";
                    printWriter.println(string3 + ".class);");
                    printWriter.println("        return (" + this.fullname(idlObject2) + ") new_one;");
                    break;
                }
                String string4 = this.fullname(idlObject2);
                string4 = string4.lastIndexOf(".") != -1 ? string4.substring(0, string4.lastIndexOf(".") + 1) : "";
                string4 = string4 + "_" + idlObject2.name() + "Stub";
                printWriter.println("        return(" + this.fullname(idlObject2) + ")" + string + ".read_Object(" + string4 + ".class);");
                break;
            }
            case 28: {
                if (((IdlValue)idlObject2).abstract_value()) {
                    printWriter.println("        return (" + idlObject2.name() + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value(_id);");
                    break;
                }
                printWriter.println("        return (" + idlObject2.name() + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value(_id);");
                break;
            }
            case 27: {
                idlObject2.reset();
                if (((IdlValueBox)idlObject2).simple()) {
                    if (this.is_boolean(idlObject2.current())) {
                        printWriter.println(tab2 + this.fullname(idlObject2) + " _box = new " + this.fullname(idlObject2) + "(false);");
                    } else {
                        printWriter.print(tab2 + this.fullname(idlObject2) + " _box = new " + this.fullname(idlObject2) + "((");
                        this.translate_type(idlObject2.current(), printWriter);
                        printWriter.println(")0);");
                    }
                    this.translate_unmarshalling_member(idlObject2.current(), printWriter, string, "_box.value", tab2);
                } else {
                    printWriter.print(tab2);
                    this.translate_type(idlObject2.current(), printWriter);
                    printWriter.println(" _box = null;");
                    this.translate_unmarshalling_member(idlObject2.current(), printWriter, string, "_box", tab2);
                }
                printWriter.println("        return _box;");
            }
        }
    }

    private boolean is_boolean(IdlObject idlObject2) {
        switch (this.final_kind(idlObject2)) {
            case 8: {
                if (((IdlSimple)idlObject2).internal() != 24) break;
                return true;
            }
        }
        return false;
    }

    public void translate_constant(IdlObject idlObject2, File file, PrintWriter printWriter) {
        IdlConst idlConst2 = (IdlConst)idlObject2;
        PrintWriter printWriter2 = null;
        if (idlConst2.into(15) || idlConst2.into(28)) {
            printWriter.println("    /**");
            printWriter.println("     * Constant value");
            printWriter.println("     */");
            printWriter.print("    public static final ");
            boolean bl = false;
            if (this.final_kind(idlObject2.current()) == 26) {
                bl = true;
            }
            this.translate_type(idlObject2.current(), printWriter);
            printWriter.print(" " + idlObject2.name() + " = ");
            if (!bl) {
                printWriter.print("(");
                idlObject2.reset();
                this.translate_type(idlObject2.current(), printWriter);
                printWriter.print(") ");
            }
            printWriter.println("(" + this.translate_to_java_expression(idlConst2.expression(), bl, idlObject2) + ");");
            printWriter.println("");
        } else {
            printWriter2 = this.newFile(file, idlObject2.name());
            this.addDescriptiveHeader(printWriter2, idlObject2);
            printWriter2.println("public interface " + idlObject2.name());
            printWriter2.println("{");
            printWriter2.println("    /**");
            printWriter2.println("     * Constant value");
            printWriter2.println("     */");
            printWriter2.print("     public static final ");
            this.translate_type(idlObject2.current(), printWriter2);
            boolean bl = false;
            if (this.final_kind(idlObject2.current()) == 26) {
                bl = true;
            }
            printWriter2.print(" value = ");
            if (!bl) {
                printWriter2.print(" (");
                idlObject2.reset();
                this.translate_type(idlObject2.current(), printWriter2);
                printWriter2.print(") ");
            }
            printWriter2.println("(" + this.translate_to_java_expression(idlConst2.expression(), bl, idlConst2) + ");");
            printWriter2.println("}");
            printWriter2.close();
        }
    }

    public boolean isAbstractBaseInterface(IdlObject idlObject2) {
        IdlInterface idlInterface2 = (IdlInterface)idlObject2;
        Vector vector = idlInterface2.getInheritance();
        int n = 0;
        while (n < vector.size()) {
            if (((IdlInterface)vector.get(n)).abstract_interface()) {
                return true;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            if (this.isAbstractBaseInterface((IdlInterface)vector.get(n2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void write_helper(IdlObject idlObject2, File file) {
        PrintWriter printWriter = this.newFile(file, idlObject2.name() + "Helper");
        boolean bl = false;
        boolean bl2 = false;
        if (this.current_pkg != null) {
            if (this.current_pkg.equals("generated")) {
                if (IdlCompiler.use_package) {
                    printWriter.println("package " + this.current_pkg + ";");
                    printWriter.println("");
                }
            } else if (!this.current_pkg.equals("")) {
                printWriter.println("package " + this.current_pkg + ";");
                printWriter.println("");
            }
        }
        printWriter.println("/** ");
        printWriter.println(" * Helper class for : " + idlObject2.name());
        printWriter.println(" *  ");
        printWriter.println(" * @author OpenORB Compiler");
        printWriter.println(" */ ");
        if (idlObject2.kind() == 27) {
            printWriter.println("public class " + idlObject2.name() + "Helper implements org.omg.CORBA.portable.BoxedValueHelper");
        } else {
            printWriter.println("public class " + idlObject2.name() + "Helper");
        }
        printWriter.println("{");
        switch (this.final_kind(idlObject2)) {
            case 3: 
            case 4: 
            case 9: 
            case 14: 
            case 24: 
            case 26: {
                if (!IdlCompiler.portableHelper) {
                    printWriter.println("    private static final boolean HAS_OPENORB;");
                    printWriter.println("    static {");
                    printWriter.println("        boolean hasOpenORB = false;");
                    printWriter.println("        try {");
                    printWriter.println("            Thread.currentThread().getContextClassLoader().loadClass(\"org.openorb.CORBA.Any\");");
                    printWriter.println("            hasOpenORB = true;");
                    printWriter.println("        }");
                    printWriter.println("        catch(ClassNotFoundException ex) {");
                    printWriter.println("        }");
                    printWriter.println("        HAS_OPENORB = hasOpenORB;");
                    printWriter.println("    }");
                    break;
                }
                printWriter.println("    private static Object [] _extractMethods;");
                printWriter.println("    static {");
                printWriter.println("        try {");
                printWriter.println("            Class clz = Thread.currentThread().getContextClassLoader().loadClass(\"org.openorb.CORBA.Any\");");
                printWriter.println("            java.lang.reflect.Method meth = clz.getMethod(\"extract_Streamable\", null);");
                printWriter.println("            _extractMethods = new Object[] { clz, meth };");
                printWriter.println("        }");
                printWriter.println("        catch(Exception ex) {");
                printWriter.println("        }");
                printWriter.println("        if(_extractMethods == null)");
                printWriter.println("            _extractMethods = new Object[0];");
                printWriter.println("    }");
                printWriter.println();
                printWriter.println("    private static java.lang.reflect.Method getExtract(Class clz) {");
                printWriter.println("        int len = _extractMethods.length;");
                printWriter.println("        for(int i = 0; i < len; i += 2)");
                printWriter.println("            if(clz.equals(_extractMethods[i]))");
                printWriter.println("                return (java.lang.reflect.Method)_extractMethods[i+1];");
                printWriter.println("        // unknown class, look for method.");
                printWriter.println("        synchronized(org.omg.CORBA.Any.class) {");
                printWriter.println("            for(int i = len; i < _extractMethods.length; i += 2)");
                printWriter.println("                if(clz.equals(_extractMethods[i]))");
                printWriter.println("                    return (java.lang.reflect.Method)_extractMethods[i+1];");
                printWriter.println("            Object [] tmp = new Object[_extractMethods.length+2];");
                printWriter.println("            System.arraycopy(_extractMethods, 0, tmp, 0, _extractMethods.length);");
                printWriter.println("            tmp[_extractMethods.length] = clz;");
                printWriter.println("            try {");
                printWriter.println("                tmp[_extractMethods.length+1] = clz.getMethod(\"extract_Streamable\", null);");
                printWriter.println("            }");
                printWriter.println("            catch(Exception ex) {}");
                printWriter.println("            _extractMethods = tmp;");
                printWriter.println("            return (java.lang.reflect.Method)_extractMethods[_extractMethods.length-1];");
                printWriter.println("        }");
                printWriter.println("    }");
            }
        }
        printWriter.println("    /**");
        printWriter.println("     * Insert " + idlObject2.name() + " into an any");
        printWriter.println("     * @param a an any");
        printWriter.println("     * @param t " + idlObject2.name() + " value");
        printWriter.println("     */");
        printWriter.print("    public static void insert(org.omg.CORBA.Any a, ");
        this.translate_type(idlObject2, printWriter);
        printWriter.println(" t)");
        printWriter.println("    {");
        switch (this.final_kind(idlObject2)) {
            case 15: {
                if (((IdlInterface)this.final_type(idlObject2)).abstract_interface()) {
                    printWriter.println("        if(t instanceof org.omg.CORBA.Object)");
                    printWriter.println("            a.insert_Object((org.omg.CORBA.Object)t , type());");
                    printWriter.println("        else if(t instanceof java.io.Serializable)");
                    printWriter.println("            a.insert_Value((java.io.Serializable)t, type());");
                    printWriter.println("        else");
                    printWriter.println("            throw new org.omg.CORBA.BAD_PARAM();");
                    break;
                }
                printWriter.println("        a.insert_Object(t , type());");
                break;
            }
            case 27: 
            case 28: {
                printWriter.println("        a.insert_Value(t, type());");
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                printWriter.print("        a.insert_Streamable(new ");
                this.translate_type(idlObject2, printWriter);
                printWriter.println("Holder(t));");
                break;
            }
            case 9: 
            case 24: 
            case 26: {
                printWriter.println("        a.insert_Streamable(new " + this.fullname(idlObject2) + "Holder(t));");
                break;
            }
            default: {
                printWriter.println("        a.type(type());");
                printWriter.println("        write(a.create_output_stream(),t);");
            }
        }
        printWriter.println("    }");
        printWriter.println("");
        printWriter.println("    /**");
        printWriter.println("     * Extract " + idlObject2.name() + " from an any");
        printWriter.println("     * @param a an any");
        printWriter.println("     * @return the extracted " + idlObject2.name() + " value");
        printWriter.println("     */");
        printWriter.print("    public static ");
        this.translate_type(idlObject2, printWriter);
        printWriter.println(" extract(org.omg.CORBA.Any a)");
        printWriter.println("    {");
        printWriter.println("        if (!a.type().equal(type()))");
        printWriter.println("            throw new org.omg.CORBA.MARSHAL();");
        switch (this.final_kind(idlObject2)) {
            case 15: {
                printWriter.println("        try {");
                printWriter.print("            return ");
                this.translate_type(idlObject2, printWriter);
                printWriter.println("Helper.narrow(a.extract_Object());");
                printWriter.println("        } catch (final org.omg.CORBA.BAD_PARAM e) {");
                this.writeThrowException(printWriter, tab3, "org.omg.CORBA.MARSHAL", "e.getMessage()", "e");
                printWriter.println("        }");
                if (!((IdlInterface)this.final_type(idlObject2)).abstract_interface()) break;
                printWriter.println("        catch (org.omg.CORBA.BAD_OPERATION ex) {}");
            }
            case 27: 
            case 28: {
                printWriter.println("        try {");
                printWriter.print("            return (");
                this.translate_type(idlObject2, printWriter);
                printWriter.println(")a.extract_Value();");
                printWriter.println("        }");
                printWriter.println("        catch(final ClassCastException e) {");
                this.writeThrowException(printWriter, tab3, "org.omg.CORBA.MARSHAL", "e.getMessage()", "e");
                printWriter.println("        }");
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                if (!IdlCompiler.portableHelper) {
                    printWriter.println("        if (HAS_OPENORB && a instanceof org.openorb.CORBA.Any) {");
                    printWriter.println("            // streamable extraction. The jdk stubs incorrectly define the Any stub");
                    printWriter.println("            org.openorb.CORBA.Any any = (org.openorb.CORBA.Any)a;");
                    printWriter.println("            try {");
                    printWriter.println("                org.omg.CORBA.portable.Streamable s = any.extract_Streamable();");
                } else {
                    printWriter.println("            // streamable extraction. The jdk stubs incorrectly define the Any stub");
                    printWriter.println("        java.lang.reflect.Method meth = getExtract(a.getClass());");
                    printWriter.println("        if(meth != null) {");
                    printWriter.println("            try {");
                    printWriter.println("                org.omg.CORBA.portable.Streamable s ");
                    printWriter.println("                    = (org.omg.CORBA.portable.Streamable)meth.invoke(a, null);");
                }
                printWriter.print("                if(s instanceof ");
                this.translate_type(idlObject2, printWriter);
                printWriter.println("Holder)");
                printWriter.print("                    return ((");
                this.translate_type(idlObject2, printWriter);
                printWriter.println("Holder)s).value;");
                if (!IdlCompiler.portableHelper) {
                    printWriter.println("            } catch (org.omg.CORBA.BAD_INV_ORDER ex) {");
                } else {
                    printWriter.println("            } catch (final IllegalAccessException e) {");
                    this.writeThrowException(printWriter, tab4, "org.omg.CORBA.INTERNAL", "e.toString()", "e");
                    printWriter.println("            } catch (final IllegalArgumentException e) {");
                    this.writeThrowException(printWriter, tab4, "org.omg.CORBA.INTERNAL", "e.toString()", "e");
                    printWriter.println("            } catch (final java.lang.reflect.InvocationTargetException e) {");
                    printWriter.println("                Throwable rex = e.getTargetException();");
                    printWriter.println("                if (rex instanceof org.omg.CORBA.BAD_INV_ORDER) {");
                    printWriter.println("                    // do nothing");
                    printWriter.println("                } else if (rex instanceof Error) {");
                    printWriter.println("                    throw (Error)rex;");
                    printWriter.println("                } else if(rex instanceof RuntimeException) {");
                    printWriter.println("                    throw (RuntimeException)rex;");
                    printWriter.println("                } else {");
                    this.writeThrowException(printWriter, tab5, "org.omg.CORBA.INTERNAL", "rex.toString()", "rex");
                    printWriter.println("                }");
                }
                printWriter.println("            }");
                printWriter.print(tab3);
                this.translate_type(idlObject2, printWriter);
                printWriter.print("Holder h = new ");
                this.translate_type(idlObject2, printWriter);
                printWriter.println("Holder(read(a.create_input_stream()));");
                printWriter.println("            a.insert_Streamable(h);");
                printWriter.println("            return h.value;");
                printWriter.println("        }");
                printWriter.println("        return read(a.create_input_stream());");
                break;
            }
            case 9: 
            case 24: 
            case 26: {
                if (!IdlCompiler.portableHelper) {
                    printWriter.println("        if(HAS_OPENORB && a instanceof org.openorb.CORBA.Any) {");
                    printWriter.println("            // streamable extraction. The jdk stubs incorrectly define the Any stub");
                    printWriter.println("            org.openorb.CORBA.Any any = (org.openorb.CORBA.Any)a;");
                    printWriter.println("            try {");
                    printWriter.println("                org.omg.CORBA.portable.Streamable s = any.extract_Streamable();");
                } else {
                    printWriter.println("            // streamable extraction. The jdk stubs incorrectly define the Any stub");
                    printWriter.println("        java.lang.reflect.Method meth = getExtract(a.getClass());");
                    printWriter.println("        if(meth != null) {");
                    printWriter.println("            try {");
                    printWriter.println("                org.omg.CORBA.portable.Streamable s ");
                    printWriter.println("                    = (org.omg.CORBA.portable.Streamable)meth.invoke(a, null);");
                }
                printWriter.println("                if(s instanceof " + this.fullname(idlObject2) + "Holder)");
                printWriter.println("                    return ((" + this.fullname(idlObject2) + "Holder)s).value;");
                if (!IdlCompiler.portableHelper) {
                    printWriter.println("            } catch (org.omg.CORBA.BAD_INV_ORDER ex) {");
                } else {
                    printWriter.println("            } catch (final IllegalAccessException e) {");
                    this.writeThrowException(printWriter, tab4, "org.omg.CORBA.INTERNAL", "e.toString()", "e");
                    printWriter.println("            } catch (final IllegalArgumentException e) {");
                    this.writeThrowException(printWriter, tab4, "org.omg.CORBA.INTERNAL", "e.toString()", "e");
                    printWriter.println("            } catch (final java.lang.reflect.InvocationTargetException e) {");
                    printWriter.println("                final Throwable rex = e.getTargetException();");
                    printWriter.println("                if (rex instanceof org.omg.CORBA.BAD_INV_ORDER) {");
                    printWriter.println("                    // do nothing");
                    printWriter.println("                } else if (rex instanceof Error) {");
                    printWriter.println("                    throw (Error)rex;");
                    printWriter.println("                } else if (rex instanceof RuntimeException) {");
                    printWriter.println("                    throw (RuntimeException)rex;");
                    printWriter.println("                }");
                    this.writeThrowException(printWriter, tab4, "org.omg.CORBA.INTERNAL", "rex.toString()", "rex");
                }
                printWriter.println("            }");
                printWriter.println(tab3 + this.fullname(idlObject2) + "Holder h = new " + this.fullname(idlObject2) + "Holder(read(a.create_input_stream()));");
                printWriter.println("            a.insert_Streamable(h);");
                printWriter.println("            return h.value;");
                printWriter.println("        }");
                printWriter.println("        return read(a.create_input_stream());");
                break;
            }
            default: {
                printWriter.println("        return read(a.create_input_stream());");
            }
        }
        printWriter.println("    }");
        printWriter.println("");
        printWriter.println("    //");
        printWriter.println("    // Internal TypeCode value");
        printWriter.println("    //");
        printWriter.println("    private static org.omg.CORBA.TypeCode _tc = null;");
        switch (this.final_kind(idlObject2)) {
            case 3: 
            case 4: 
            case 14: 
            case 28: {
                printWriter.println("    private static boolean _working = false;");
            }
        }
        printWriter.println("");
        printWriter.println("    /**");
        printWriter.println("     * Return the " + idlObject2.name() + " TypeCode");
        printWriter.println("     * @return a TypeCode");
        printWriter.println("     */");
        printWriter.println("    public static org.omg.CORBA.TypeCode type()");
        printWriter.println("    {");
        printWriter.println("        if (_tc == null) {");
        switch (this.final_kind(idlObject2)) {
            case 3: 
            case 4: 
            case 14: 
            case 28: {
                printWriter.println("            synchronized(org.omg.CORBA.TypeCode.class) {");
                printWriter.println("                if (_tc != null)");
                printWriter.println("                    return _tc;");
                printWriter.println("                if (_working)");
                printWriter.println("                    return org.omg.CORBA.ORB.init().create_recursive_tc(id());");
                printWriter.println("                _working = true;");
            }
        }
        this.translate_new_typecode(idlObject2, printWriter);
        switch (this.final_kind(idlObject2)) {
            case 3: 
            case 4: 
            case 14: 
            case 28: {
                printWriter.println("                _working = false;");
                printWriter.println("            }");
            }
        }
        printWriter.println("        }");
        printWriter.println("        return _tc;");
        printWriter.println("    }");
        printWriter.println("");
        printWriter.println("    /**");
        printWriter.println("     * Return the " + idlObject2.name() + " IDL ID");
        printWriter.println("     * @return an ID");
        printWriter.println("     */");
        printWriter.println("    public static String id()");
        printWriter.println("    {");
        printWriter.println("        return _id;");
        printWriter.println("    }");
        printWriter.println("");
        printWriter.println("    private final static String _id = \"" + idlObject2.getId() + "\";");
        printWriter.println("");
        printWriter.println("    /**");
        printWriter.println("     * Read " + idlObject2.name() + " from a marshalled stream");
        printWriter.println("     * @param istream the input stream");
        printWriter.println("     * @return the readed " + idlObject2.name() + " value");
        printWriter.println("     */");
        printWriter.print("    public static ");
        this.translate_type(idlObject2, printWriter);
        printWriter.println(" read(org.omg.CORBA.portable.InputStream istream)");
        printWriter.println("    {");
        if (this.final_kind(idlObject2) == 27) {
            printWriter.print("        return (");
            this.translate_type(this.final_type(idlObject2), printWriter);
            printWriter.println(") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value(new " + this.fullname(this.final_type(idlObject2)) + "Helper());");
        } else if (this.final_kind(idlObject2) == 18) {
            if (((IdlInterface)this.final_type(idlObject2)).getInterface().local_interface() || IdlCompiler.pidl) {
                printWriter.println("        throw new org.omg.CORBA.MARSHAL();");
            } else {
                this.translate_unmarshalling(idlObject2, printWriter, "istream");
            }
        } else if (this.final_kind(idlObject2) == 15) {
            if (((IdlInterface)this.final_type(idlObject2)).local_interface() || IdlCompiler.pidl) {
                printWriter.println("        throw new org.omg.CORBA.MARSHAL();");
            } else {
                this.translate_unmarshalling(idlObject2, printWriter, "istream");
            }
        } else if (this.final_kind(idlObject2) == 26) {
            printWriter.println("        java.math.BigDecimal _f = istream.read_fixed();");
            if (((IdlFixed)this.final_type(idlObject2)).scale() != 0) {
                printWriter.println("        return _f.movePointLeft(" + ((IdlFixed)this.final_type(idlObject2)).scale() + ");");
            } else {
                printWriter.println("        return _f;");
            }
        } else if (idlObject2.kind() == 13 && this.final_kind(idlObject2) != 9 && this.final_kind(idlObject2) != 24 && this.final_kind(idlObject2) != 5 && this.final_kind(idlObject2) != 6 && this.final_kind(idlObject2) != 8) {
            printWriter.print("        return ");
            this.translate_type(this.final_type(idlObject2), printWriter);
            printWriter.println("Helper.read(istream);");
        } else {
            this.translate_unmarshalling(idlObject2, printWriter, "istream");
        }
        printWriter.println("    }");
        printWriter.println("");
        printWriter.println("    /**");
        printWriter.println("     * Write " + idlObject2.name() + " into a marshalled stream");
        printWriter.println("     * @param ostream the output stream");
        printWriter.println("     * @param value " + idlObject2.name() + " value");
        printWriter.println("     */");
        printWriter.print("    public static void write(org.omg.CORBA.portable.OutputStream ostream, ");
        this.translate_type(idlObject2, printWriter);
        printWriter.println(" value)");
        printWriter.println("    {");
        if (this.final_kind(idlObject2) == 27) {
            printWriter.println("        ((org.omg.CORBA_2_3.portable.OutputStream)ostream).write_value(value, new " + this.fullname(this.final_type(idlObject2)) + "Helper());");
        } else if (this.final_kind(idlObject2) == 15) {
            if (((IdlInterface)this.final_type(idlObject2)).local_interface() || IdlCompiler.pidl) {
                printWriter.println("        throw new org.omg.CORBA.MARSHAL();");
            } else {
                this.translate_marshalling(idlObject2, printWriter, "ostream", "value");
            }
        } else if (this.final_kind(idlObject2) == 26) {
            if (((IdlFixed)this.final_type(idlObject2)).scale() != 0) {
                printWriter.println("        if (value.scale() != " + ((IdlFixed)this.final_type(idlObject2)).scale() + ")");
                printWriter.println("            throw new org.omg.CORBA.DATA_CONVERSION();");
            }
            printWriter.println("        ostream.write_fixed(value);");
        } else if (idlObject2.kind() == 13 && this.final_kind(idlObject2) != 9 && this.final_kind(idlObject2) != 24 && this.final_kind(idlObject2) != 5 && this.final_kind(idlObject2) != 6 && this.final_kind(idlObject2) != 8) {
            printWriter.print(tab2);
            this.translate_type(this.final_type(idlObject2), printWriter);
            printWriter.println("Helper.write(ostream, value);");
        } else {
            this.translate_marshalling(idlObject2, printWriter, "ostream", "value");
        }
        printWriter.println("    }");
        printWriter.println("");
        if (idlObject2.kind() == 15) {
            if (((IdlInterface)idlObject2).abstract_interface()) {
                bl2 = true;
            } else {
                bl = true;
            }
            if (this.isAbstractBaseInterface(idlObject2)) {
                bl2 = true;
            }
            if (bl2) {
                printWriter.println("    /**");
                printWriter.println("     * Narrow CORBA::Object to " + idlObject2.name());
                printWriter.println("     * @param obj the abstract Object");
                printWriter.println("     * @return " + idlObject2.name() + " Object");
                printWriter.println("     */");
                printWriter.println("    public static " + idlObject2.name() + " narrow(Object obj)");
                printWriter.println("    {");
                printWriter.println("        if (obj == null)");
                printWriter.println("            return null;");
                printWriter.println("        if (obj instanceof " + idlObject2.name() + ")");
                printWriter.println("            return (" + idlObject2.name() + ")obj;");
                if (!IdlCompiler.pidl && !((IdlInterface)idlObject2).local_interface()) {
                    printWriter.println();
                    printWriter.println("        if (obj instanceof org.omg.CORBA.portable.ObjectImpl) {");
                    printWriter.println("            org.omg.CORBA.portable.ObjectImpl objimpl = (org.omg.CORBA.portable.ObjectImpl)obj;");
                    printWriter.println("            if (objimpl._is_a(id())) {");
                    printWriter.println("                _" + idlObject2.name() + "Stub stub = new _" + idlObject2.name() + "Stub();");
                    printWriter.println("                stub._set_delegate(objimpl._get_delegate());");
                    printWriter.println("                return stub;");
                    printWriter.println("            }");
                    printWriter.println("        }");
                    printWriter.println();
                }
                printWriter.println("");
                printWriter.println("        throw new org.omg.CORBA.BAD_PARAM();");
                printWriter.println("    }");
                printWriter.println("");
                printWriter.println("    /**");
                printWriter.println("     * Unchecked Narrow CORBA::Object to " + idlObject2.name());
                printWriter.println("     * @param obj the abstract Object");
                printWriter.println("     * @return " + idlObject2.name() + " Object");
                printWriter.println("     */");
                printWriter.println("    public static " + idlObject2.name() + " unchecked_narrow(Object obj)");
                printWriter.println("    {");
                printWriter.println("        if (obj == null)");
                printWriter.println("            return null;");
                printWriter.println("        if (obj instanceof " + idlObject2.name() + ")");
                printWriter.println("            return (" + idlObject2.name() + ")obj;");
                if (!IdlCompiler.pidl && !((IdlInterface)idlObject2).local_interface()) {
                    printWriter.println();
                    printWriter.println("        if (obj instanceof org.omg.CORBA.portable.ObjectImpl) {");
                    printWriter.println("            org.omg.CORBA.portable.ObjectImpl objimpl = (org.omg.CORBA.portable.ObjectImpl)obj;");
                    printWriter.println("            _" + idlObject2.name() + "Stub stub = new _" + idlObject2.name() + "Stub();");
                    printWriter.println("            stub._set_delegate(objimpl._get_delegate());");
                    printWriter.println("            return stub;");
                    printWriter.println("        }");
                    printWriter.println();
                }
                printWriter.println("");
                printWriter.println("        throw new org.omg.CORBA.BAD_PARAM();");
                printWriter.println("    }");
                printWriter.println("");
            }
            if (bl) {
                printWriter.println("    /**");
                printWriter.println("     * Narrow CORBA::Object to " + idlObject2.name());
                printWriter.println("     * @param obj the CORBA Object");
                printWriter.println("     * @return " + idlObject2.name() + " Object");
                printWriter.println("     */");
                if (!IdlCompiler.pidl) {
                    printWriter.println("    public static " + idlObject2.name() + " narrow(org.omg.CORBA.Object obj)");
                } else {
                    printWriter.println("    public static " + idlObject2.name() + " narrow(Object obj)");
                }
                printWriter.println("    {");
                printWriter.println("        if (obj == null)");
                printWriter.println("            return null;");
                printWriter.println("        if (obj instanceof " + idlObject2.name() + ")");
                printWriter.println("            return (" + idlObject2.name() + ")obj;");
                printWriter.println("");
                if (!IdlCompiler.pidl && !((IdlInterface)idlObject2).local_interface()) {
                    printWriter.println("        if (obj._is_a(id()))");
                    printWriter.println("        {");
                    printWriter.println("            _" + idlObject2.name() + "Stub stub = new _" + idlObject2.name() + "Stub();");
                    printWriter.println("            stub._set_delegate(((org.omg.CORBA.portable.ObjectImpl)obj)._get_delegate());");
                    printWriter.println("            return stub;");
                    printWriter.println("        }");
                    printWriter.println("");
                }
                printWriter.println("        throw new org.omg.CORBA.BAD_PARAM();");
                printWriter.println("    }");
                printWriter.println("");
                printWriter.println("    /**");
                printWriter.println("     * Unchecked Narrow CORBA::Object to " + idlObject2.name());
                printWriter.println("     * @param obj the CORBA Object");
                printWriter.println("     * @return " + idlObject2.name() + " Object");
                printWriter.println("     */");
                if (!IdlCompiler.pidl) {
                    printWriter.println("    public static " + idlObject2.name() + " unchecked_narrow(org.omg.CORBA.Object obj)");
                } else {
                    printWriter.println("    public static " + idlObject2.name() + " unchecked_narrow(Object obj)");
                }
                printWriter.println("    {");
                printWriter.println("        if (obj == null)");
                printWriter.println("            return null;");
                printWriter.println("        if (obj instanceof " + idlObject2.name() + ")");
                printWriter.println("            return (" + idlObject2.name() + ")obj;");
                printWriter.println("");
                if (!IdlCompiler.pidl && !((IdlInterface)idlObject2).local_interface()) {
                    printWriter.println("        _" + idlObject2.name() + "Stub stub = new _" + idlObject2.name() + "Stub();");
                    printWriter.println("        stub._set_delegate(((org.omg.CORBA.portable.ObjectImpl)obj)._get_delegate());");
                    printWriter.println("        return stub;");
                    printWriter.println();
                } else {
                    printWriter.println("        throw new org.omg.CORBA.BAD_PARAM();");
                }
                printWriter.println("    }");
                printWriter.println("");
            }
        }
        if (idlObject2.kind() == 28 && !((IdlValue)idlObject2).abstract_value()) {
            idlObject2.reset();
            while (!idlObject2.end()) {
                if (idlObject2.current().kind() == 30) {
                    IdlFactoryMember idlFactoryMember;
                    printWriter.println("    /**");
                    printWriter.println("     * Create a value type (using factory method)");
                    printWriter.println("     */");
                    printWriter.print("    public static " + idlObject2.name() + " " + idlObject2.current().name() + "(");
                    printWriter.print("org.omg.CORBA.ORB orb");
                    idlObject2.current().reset();
                    while (!idlObject2.current().end()) {
                        printWriter.print(", ");
                        idlFactoryMember = (IdlFactoryMember)idlObject2.current().current();
                        idlFactoryMember.reset();
                        this.translate_type(idlFactoryMember.current(), printWriter);
                        printWriter.print(" " + idlFactoryMember.name());
                        idlObject2.current().next();
                    }
                    printWriter.println(")");
                    printWriter.println("    {");
                    printWriter.println("        org.omg.CORBA.portable.ValueFactory _factory = ((org.omg.CORBA_2_3.ORB)orb).lookup_value_factory(id());");
                    printWriter.println("        if (_factory == null)");
                    printWriter.println("            throw new org.omg.CORBA.BAD_INV_ORDER();");
                    printWriter.print("        return ((" + this.fullname(idlObject2) + "ValueFactory)(_factory))." + idlObject2.current().name() + "(");
                    idlObject2.current().reset();
                    while (!idlObject2.current().end()) {
                        idlFactoryMember = (IdlFactoryMember)idlObject2.current().current();
                        idlFactoryMember.reset();
                        printWriter.print(" " + idlFactoryMember.name());
                        idlObject2.current().next();
                        if (idlObject2.current().end()) continue;
                        printWriter.print(", ");
                    }
                    printWriter.println(");");
                    printWriter.println("    }");
                    printWriter.println("");
                }
                idlObject2.next();
            }
        }
        if (idlObject2.kind() == 27) {
            printWriter.println("    /**");
            printWriter.println("     * Read a value from an input stream");
            printWriter.println("     */");
            printWriter.println("    public java.io.Serializable read_value(org.omg.CORBA.portable.InputStream is)");
            printWriter.println("    {");
            this.translate_unmarshalling(idlObject2, printWriter, "is");
            printWriter.println("    }");
            printWriter.println("");
            printWriter.println("    /**");
            printWriter.println("     * Write a value into an output stream");
            printWriter.println("     */");
            printWriter.println("    public void write_value(org.omg.CORBA.portable.OutputStream os, java.io.Serializable value)");
            printWriter.println("    {");
            this.translate_marshalling(idlObject2, printWriter, "os", "value");
            printWriter.println("    }");
            printWriter.println("");
            printWriter.println("    /**");
            printWriter.println("     * Return the value id");
            printWriter.println("     */");
            printWriter.println("    public String get_id()");
            printWriter.println("    {");
            printWriter.println("        return id();");
            printWriter.println("    }");
            printWriter.println("");
        }
        printWriter.println("}");
        printWriter.close();
    }

    public void write_holder(IdlObject idlObject2, File file) {
        PrintWriter printWriter = this.newFile(file, idlObject2.name() + "Holder");
        if (this.current_pkg != null) {
            if (this.current_pkg.equals("generated")) {
                if (IdlCompiler.use_package) {
                    printWriter.println("package " + this.current_pkg + ";");
                    printWriter.println("");
                }
            } else if (!this.current_pkg.equals("")) {
                printWriter.println("package " + this.current_pkg + ";");
                printWriter.println("");
            }
        }
        printWriter.println("/**");
        printWriter.println(" * Holder class for : " + idlObject2.name());
        printWriter.println(" * ");
        printWriter.println(" * @author OpenORB Compiler");
        printWriter.println(" */");
        printWriter.println("final public class " + idlObject2.name() + "Holder");
        printWriter.println("        implements org.omg.CORBA.portable.Streamable");
        printWriter.println("{");
        printWriter.println("    /**");
        printWriter.println("     * Internal " + idlObject2.name() + " value");
        printWriter.println("     */");
        printWriter.print("    public ");
        if (idlObject2.kind() == 27) {
            if (((IdlValueBox)idlObject2).simple()) {
                idlObject2.reset();
                this.translate_type(idlObject2.current(), printWriter);
            } else {
                this.translate_type(idlObject2, printWriter);
            }
        } else {
            this.translate_type(idlObject2, printWriter);
        }
        printWriter.println(" value;");
        printWriter.println("");
        printWriter.println("    /**");
        printWriter.println("     * Default constructor");
        printWriter.println("     */");
        printWriter.println("    public " + idlObject2.name() + "Holder()");
        printWriter.println("    { }");
        printWriter.println("");
        printWriter.println("    /**");
        printWriter.println("     * Constructor with value initialisation");
        printWriter.println("     * @param initial the initial value");
        printWriter.println("     */");
        printWriter.print("    public " + idlObject2.name() + "Holder(");
        this.translate_type(idlObject2, printWriter);
        printWriter.println(" initial)");
        printWriter.println("    {");
        if (idlObject2.kind() == 27) {
            if (((IdlValueBox)idlObject2).simple()) {
                printWriter.println("        value = initial.value;");
            } else {
                printWriter.println("        value = initial;");
            }
        } else {
            printWriter.println("        value = initial;");
        }
        printWriter.println("    }");
        printWriter.println("");
        printWriter.println("    /**");
        printWriter.println("     * Read " + idlObject2.name() + " from a marshalled stream");
        printWriter.println("     * @param istream the input stream");
        printWriter.println("     */");
        printWriter.println("    public void _read(org.omg.CORBA.portable.InputStream istream)");
        printWriter.println("    {");
        if (idlObject2.kind() == 27) {
            if (((IdlValueBox)idlObject2).simple()) {
                printWriter.println("        value = (" + idlObject2.name() + "Helper.read(istream)).value;");
            } else {
                printWriter.println("        value = " + idlObject2.name() + "Helper.read(istream);");
            }
        } else if (idlObject2.kind() == 15) {
            if (((IdlInterface)idlObject2).local_interface()) {
                printWriter.println("        throw new org.omg.CORBA.NO_IMPLEMENT();");
            } else {
                printWriter.println("        value = " + idlObject2.name() + "Helper.read(istream);");
            }
        } else {
            printWriter.println("        value = " + idlObject2.name() + "Helper.read(istream);");
        }
        printWriter.println("    }");
        printWriter.println("");
        printWriter.println("    /**");
        printWriter.println("     * Write " + idlObject2.name() + " into a marshalled stream");
        printWriter.println("     * @param ostream the output stream");
        printWriter.println("     */");
        printWriter.println("    public void _write(org.omg.CORBA.portable.OutputStream ostream)");
        printWriter.println("    {");
        if (idlObject2.kind() == 27) {
            if (((IdlValueBox)idlObject2).simple()) {
                printWriter.println(tab2 + idlObject2.name() + "Helper.write(ostream, new " + idlObject2.name() + "(value));");
            } else {
                printWriter.println(tab2 + idlObject2.name() + "Helper.write(ostream,value);");
            }
        } else if (idlObject2.kind() == 15) {
            if (((IdlInterface)idlObject2).local_interface()) {
                printWriter.println("        throw new org.omg.CORBA.NO_IMPLEMENT();");
            } else {
                printWriter.println(tab2 + idlObject2.name() + "Helper.write(ostream,value);");
            }
        } else {
            printWriter.println(tab2 + idlObject2.name() + "Helper.write(ostream,value);");
        }
        printWriter.println("    }");
        printWriter.println("");
        printWriter.println("    /**");
        printWriter.println("     * Return the " + idlObject2.name() + " TypeCode");
        printWriter.println("     * @return a TypeCode");
        printWriter.println("     */");
        printWriter.println("    public org.omg.CORBA.TypeCode _type()");
        printWriter.println("    {");
        if (idlObject2.kind() == 15) {
            if (((IdlInterface)idlObject2).local_interface()) {
                printWriter.println("        throw new org.omg.CORBA.NO_IMPLEMENT();");
            } else {
                printWriter.println("        return " + idlObject2.name() + "Helper.type();");
            }
        } else {
            printWriter.println("        return " + idlObject2.name() + "Helper.type();");
        }
        printWriter.println("    }");
        printWriter.println("");
        printWriter.println("}");
        printWriter.close();
    }

    public void translate_enum(IdlObject idlObject2, File file) {
        IdlEnumMember idlEnumMember;
        PrintWriter printWriter = this.newFile(file, idlObject2.name());
        this.addDescriptiveHeader(printWriter, idlObject2);
        printWriter.println("public final class " + idlObject2.name() + " implements org.omg.CORBA.portable.IDLEntity");
        printWriter.println("{");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlEnumMember = (IdlEnumMember)idlObject2.current();
            printWriter.println("    /**");
            printWriter.println("     * Enum member " + idlEnumMember.name() + " value ");
            printWriter.println("     */");
            printWriter.print("    public static final int _" + idlEnumMember.name());
            printWriter.println(" = " + idlEnumMember.getValue() + ";");
            printWriter.println();
            printWriter.println("    /**");
            printWriter.println("     * Enum member " + idlEnumMember.name());
            printWriter.println("     */");
            printWriter.print("    public static final " + idlObject2.name() + " " + idlEnumMember.name());
            printWriter.println(" = new " + idlObject2.name() + "(_" + idlEnumMember.name() + ");");
            printWriter.println();
            idlObject2.next();
        }
        printWriter.println("    /**");
        printWriter.println("     * Internal member value ");
        printWriter.println("     */");
        printWriter.println("    private final int _" + idlObject2.name() + "_value;");
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Private constructor");
        printWriter.println("     * @param  the enum value for this new member");
        printWriter.println("     */");
        printWriter.println("    private " + idlObject2.name() + "( final int value )");
        printWriter.println("    {");
        printWriter.println("        _" + idlObject2.name() + "_value = value;");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Maintains singleton property for serialized enums.");
        printWriter.println("     * Issue 4271: IDL/Java issue, Mapping for IDL enum.");
        printWriter.println("     */");
        printWriter.println("    public java.lang.Object readResolve() throws java.io.ObjectStreamException");
        printWriter.println("    {");
        printWriter.println("        return from_int( value() );");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Return the internal member value");
        printWriter.println("     * @return the member value");
        printWriter.println("     */");
        printWriter.println("    public int value()");
        printWriter.println("    {");
        printWriter.println("        return _" + idlObject2.name() + "_value;");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * Return a enum member from its value");
        printWriter.println("     * @param  an enum value");
        printWriter.println("     * @return an enum member");
        printWriter.println("         */");
        printWriter.println("    public static " + idlObject2.name() + " from_int(int value)");
        printWriter.println("    {");
        printWriter.println("        switch (value)");
        printWriter.println("        {");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlEnumMember = (IdlEnumMember)idlObject2.current();
            printWriter.println("        case " + idlEnumMember.getValue() + " :");
            printWriter.println("            return " + idlEnumMember.name() + ";");
            idlObject2.next();
        }
        printWriter.println("        }");
        printWriter.println("        throw new org.omg.CORBA.BAD_OPERATION();");
        printWriter.println("    }");
        printWriter.println("");
        printWriter.println("    /**");
        printWriter.println("     * Return a string representation");
        printWriter.println("     * @return a string representation of the enumeration");
        printWriter.println("     */");
        printWriter.println("    public java.lang.String toString()");
        printWriter.println("    {");
        printWriter.println("        switch (_" + idlObject2.name() + "_value)");
        printWriter.println("        {");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlEnumMember = (IdlEnumMember)idlObject2.current();
            printWriter.println("        case " + idlEnumMember.getValue() + " :");
            printWriter.println("            return \"" + idlEnumMember.name() + "\";");
            idlObject2.next();
        }
        printWriter.println("        }");
        printWriter.println("        throw new org.omg.CORBA.BAD_OPERATION();");
        printWriter.println("    }");
        printWriter.println("");
        printWriter.println("}");
        printWriter.close();
        this.write_helper(idlObject2, file);
        this.write_holder(idlObject2, file);
    }

    public void translate_struct(IdlObject idlObject2, File file) {
        IdlStructMember idlStructMember2;
        PrintWriter printWriter = this.newFile(file, idlObject2.name());
        File file2 = file;
        String string = this.current_pkg;
        this.addDescriptiveHeader(printWriter, idlObject2);
        if (!this.isEmpty(idlObject2)) {
            file2 = this.createDirectory(idlObject2.name() + "Package", file);
        }
        this.addToPkg(idlObject2, idlObject2.name() + "Package");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlObject2.current().reset();
            switch (idlObject2.current().current().kind()) {
                case 4: {
                    this.translate_union(idlObject2.current().current(), file2);
                    break;
                }
                case 3: {
                    this.translate_struct(idlObject2.current().current(), file2);
                    break;
                }
                case 2: {
                    this.translate_enum(idlObject2.current().current(), file2);
                }
            }
            idlObject2.next();
        }
        this.current_pkg = string;
        printWriter.println("public final class " + idlObject2.name() + " implements org.omg.CORBA.portable.IDLEntity");
        printWriter.println("{");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlStructMember2 = (IdlStructMember)idlObject2.current();
            printWriter.println("    /**");
            printWriter.println("     * Struct member " + idlStructMember2.name());
            printWriter.println("     */");
            printWriter.print("    public ");
            idlStructMember2.reset();
            this.translate_type(idlStructMember2.current(), printWriter);
            printWriter.println(" " + idlStructMember2.name() + ";");
            printWriter.println("");
            idlObject2.next();
        }
        printWriter.println("    /**");
        printWriter.println("     * Default constructor");
        printWriter.println("     */");
        printWriter.println("    public " + idlObject2.name() + "()");
        printWriter.println("    { }");
        printWriter.println("");
        printWriter.println("    /**");
        printWriter.println("     * Constructor with fields initialization");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlStructMember2 = (IdlStructMember)idlObject2.current();
            printWriter.println("     * @param " + idlStructMember2.name() + " " + idlStructMember2.name() + " struct member");
            idlObject2.next();
        }
        printWriter.println("     */");
        printWriter.print("    public " + idlObject2.name() + "(");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlStructMember2 = (IdlStructMember)idlObject2.current();
            this.translate_type(idlStructMember2.current(), printWriter);
            printWriter.print(" " + idlStructMember2.name());
            idlObject2.next();
            if (idlObject2.end()) continue;
            printWriter.print(", ");
        }
        printWriter.println(")");
        printWriter.println("    {");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlStructMember2 = (IdlStructMember)idlObject2.current();
            printWriter.println("        this." + idlStructMember2.name() + " = " + idlStructMember2.name() + ";");
            idlObject2.next();
        }
        printWriter.println("    }");
        printWriter.println("");
        printWriter.println("}");
        printWriter.close();
        this.write_helper(idlObject2, file);
        this.write_holder(idlObject2, file);
    }

    public String find_default_value(IdlObject idlObject2) {
        int n = ((IdlUnion)idlObject2).index();
        int n2 = idlObject2.pos();
        idlObject2.reset();
        IdlUnionMember idlUnionMember2 = (IdlUnionMember)idlObject2.current();
        idlUnionMember2.reset();
        switch (this.final_kind(idlUnionMember2.current())) {
            case 2: {
                IdlObject idlObject3 = this.final_type(idlUnionMember2.current());
                idlObject2.next();
                int n3 = 0;
                int n4 = 0;
                idlObject3.reset();
                String string = this.fullname(idlObject3.current());
                String string2 = string + "@ ";
                while (!idlObject2.end()) {
                    IdlUnionMember idlUnionMember3;
                    if (n4 != n && string2.equals((idlUnionMember3 = (IdlUnionMember)idlObject2.current()).getExpression())) {
                        ++n3;
                        n4 = -1;
                        idlObject3.next();
                        string = this.fullname(idlObject3.current());
                        string2 = string + "@ ";
                        idlObject2.reset();
                    }
                    ++n4;
                    idlObject2.next();
                }
                idlObject2.pos(n2);
                return string;
            }
        }
        int n5 = 0;
        int n6 = 0;
        idlObject2.next();
        while (!idlObject2.end()) {
            IdlUnionMember idlUnionMember4;
            if (n6 != n && (long)n5 == (idlUnionMember4 = (IdlUnionMember)idlObject2.current()).getValue()) {
                ++n5;
                n6 = -1;
                idlObject2.reset();
            }
            ++n6;
            idlObject2.next();
        }
        if (this.final_kind(idlUnionMember2.current()) == 8) {
            // empty if block
        }
        idlObject2.pos(n2);
        return "" + n5;
    }

    public void translate_union(IdlObject idlObject2, File file) {
        IdlUnionMember idlUnionMember2;
        PrintWriter printWriter = this.newFile(file, idlObject2.name());
        File file2 = file;
        String string = this.current_pkg;
        int n = ((IdlUnion)idlObject2).index();
        boolean bl = false;
        this.addDescriptiveHeader(printWriter, idlObject2);
        if (!this.isEmpty(idlObject2)) {
            file2 = this.createDirectory(idlObject2.name() + "Package", file);
        }
        this.addToPkg(idlObject2, idlObject2.name() + "Package");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlObject2.current().reset();
            switch (idlObject2.current().current().kind()) {
                case 4: {
                    this.translate_union(idlObject2.current().current(), file2);
                    break;
                }
                case 3: {
                    this.translate_struct(idlObject2.current().current(), file2);
                    break;
                }
                case 2: {
                    this.translate_enum(idlObject2.current().current(), file2);
                }
            }
            idlObject2.next();
        }
        this.current_pkg = string;
        printWriter.println("public final class " + idlObject2.name() + " implements org.omg.CORBA.portable.IDLEntity");
        printWriter.println("{");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlUnionMember2 = (IdlUnionMember)idlObject2.current();
            if (!idlUnionMember2.isAsNext()) {
                printWriter.println("    /**");
                printWriter.println("     * Union member " + idlUnionMember2.name());
                printWriter.println("     */");
                printWriter.print("    protected ");
                idlUnionMember2.reset();
                this.translate_type(idlUnionMember2.current(), printWriter);
                printWriter.println(" _" + idlUnionMember2.name() + ";");
                printWriter.println("");
            }
            idlObject2.next();
        }
        printWriter.println("    /**");
        printWriter.println("     * Default constructor");
        printWriter.println("     */");
        printWriter.println("    public " + idlObject2.name() + "()");
        printWriter.println("    {");
        if (n != -1) {
            printWriter.println("        __d = " + this.find_default_value(idlObject2) + ";");
        }
        printWriter.println("    }");
        printWriter.println("");
        idlObject2.reset();
        printWriter.println("    /**");
        printWriter.println("     * Get discriminator value");
        printWriter.println("     */");
        printWriter.print("    public ");
        IdlUnionMember idlUnionMember3 = idlUnionMember2 = (IdlUnionMember)idlObject2.current();
        idlUnionMember2.reset();
        IdlObject idlObject3 = idlUnionMember2.current();
        this.translate_type(idlUnionMember2.current(), printWriter);
        printWriter.println(" discriminator()");
        printWriter.println("    {");
        printWriter.println("        return __d;");
        printWriter.println("    }");
        printWriter.println("");
        idlObject2.next();
        int n2 = 0;
        while (!idlObject2.end()) {
            idlUnionMember2 = (IdlUnionMember)idlObject2.current();
            if (!idlUnionMember2.isAsNext()) {
                bl = false;
                printWriter.println("    /**");
                printWriter.println("     * Set " + idlUnionMember2.name() + " value");
                printWriter.println("     */");
                printWriter.print("    public void " + idlUnionMember2.name() + "(");
                idlUnionMember2.reset();
                this.translate_type(idlUnionMember2.current(), printWriter);
                printWriter.println(" value)");
                printWriter.println("    {");
                if (n2 != n) {
                    printWriter.println("        __d = " + this.translate_to_union_case_expression(idlUnionMember3, idlUnionMember2.getExpression()) + ";");
                } else {
                    printWriter.println("        __d = " + this.find_default_value(idlObject2) + ";");
                }
                printWriter.println("        _" + idlUnionMember2.name() + " = value;");
                printWriter.println("    }");
                printWriter.println("");
                if (n2 == n) {
                    printWriter.println("    /**");
                    printWriter.println("     * Set " + idlUnionMember2.name() + " value");
                    printWriter.println("     */");
                    printWriter.print("    public void " + idlUnionMember2.name() + "(");
                    this.translate_type(idlObject3, printWriter);
                    printWriter.print(" dvalue, ");
                    idlUnionMember2.reset();
                    this.translate_type(idlUnionMember2.current(), printWriter);
                    printWriter.println(" value)");
                    printWriter.println("    {");
                    printWriter.println("        __d = dvalue;");
                    printWriter.println("        _" + idlUnionMember2.name() + " = value;");
                    printWriter.println("    }");
                    printWriter.println("");
                }
                printWriter.println("    /**");
                printWriter.println("     * Get " + idlUnionMember2.name() + " value");
                printWriter.println("     */");
                printWriter.print("    public ");
                idlUnionMember2.reset();
                this.translate_type(idlUnionMember2.current(), printWriter);
                printWriter.println(" " + idlUnionMember2.name() + "()");
                printWriter.println("    {");
                printWriter.println("        return _" + idlUnionMember2.name() + ";");
                printWriter.println("    }");
                printWriter.println("");
            } else if (!bl) {
                printWriter.println("    /**");
                printWriter.println("     * Set " + idlUnionMember2.name() + " value");
                printWriter.println("     */");
                printWriter.print("    public void " + idlUnionMember2.name() + "(");
                this.translate_type(idlObject3, printWriter);
                printWriter.print(" dvalue, ");
                idlUnionMember2.reset();
                this.translate_type(idlUnionMember2.current(), printWriter);
                printWriter.println(" value)");
                printWriter.println("    {");
                printWriter.println("        __d = dvalue;");
                printWriter.println("        _" + idlUnionMember2.name() + " = value;");
                printWriter.println("    }");
                printWriter.println("");
                bl = true;
            }
            idlObject2.next();
            ++n2;
        }
        if (n == -1) {
            printWriter.println("    /**");
            printWriter.println("     * default access");
            printWriter.println("     */");
            printWriter.println("    public void __default()");
            printWriter.println("    {");
            printWriter.println("    }");
            printWriter.println("    /**");
            printWriter.println("     * default access");
            printWriter.println("     */");
            printWriter.print("    public void __default(");
            this.translate_type(idlObject3, printWriter);
            printWriter.println(" _discriminator)");
            printWriter.println("    {");
            printWriter.println("    }");
        }
        idlObject2.reset();
        idlObject2.next();
        if (((IdlUnionMember)idlObject2.current()).getExpression().equals("true ") || ((IdlUnionMember)idlObject2.current()).getExpression().equals("false ")) {
            printWriter.println("    /**");
            printWriter.println("     * Return an int value for discriminator");
            printWriter.println("     */");
            printWriter.println("    public int toInt()");
            printWriter.println("    {");
            printWriter.println("    if (__d == true)");
            printWriter.println("     return 1;");
            printWriter.println("    return 0;");
            printWriter.println("    }");
        }
        printWriter.println("}");
        printWriter.close();
        this.write_helper(idlObject2, file);
        this.write_holder(idlObject2, file);
    }

    public void translate_typedef(IdlObject idlObject2, File file) {
        idlObject2.reset();
        switch (idlObject2.current().kind()) {
            case 5: 
            case 6: 
            case 8: {
                this.write_helper(idlObject2, file);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.write_helper(idlObject2, file);
                break;
            }
            case 9: 
            case 24: 
            case 26: {
                this.write_helper(idlObject2, file);
                this.write_holder(idlObject2, file);
                break;
            }
            case 10: {
                this.write_helper(idlObject2, file);
                if (this.final_type(idlObject2.current()).kind() != 9 && this.final_type(idlObject2.current()).kind() != 24) break;
                this.write_holder(idlObject2, file);
                break;
            }
            case 13: {
                this.write_helper(idlObject2, file);
            }
        }
    }

    private void writeThrowException(PrintWriter printWriter, String string, String string2, String string3, String string4) {
        printWriter.print(string);
        printWriter.print("throw ");
        if (IdlCompiler.jdk1_4) {
            printWriter.print("(");
            printWriter.print(string2);
            printWriter.print(")");
        }
        printWriter.print("new ");
        printWriter.print(string2);
        printWriter.print("(");
        printWriter.print(string3);
        printWriter.print(")");
        if (IdlCompiler.jdk1_4) {
            printWriter.print(".initCause(");
            printWriter.print(string4);
            printWriter.print(")");
        }
        printWriter.println(";");
    }

    public void translate_exception(IdlObject idlObject2, File file) {
        IdlStructMember idlStructMember2;
        PrintWriter printWriter = this.newFile(file, idlObject2.name());
        File file2 = file;
        String string = this.current_pkg;
        this.addDescriptiveHeader(printWriter, idlObject2);
        if (!this.isEmpty(idlObject2)) {
            file2 = this.createDirectory(idlObject2.name() + "Package", file);
        }
        this.addToPkg(idlObject2, idlObject2.name() + "Package");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlObject2.current().reset();
            switch (idlObject2.current().current().kind()) {
                case 4: {
                    this.translate_union(idlObject2.current().current(), file2);
                    break;
                }
                case 3: {
                    this.translate_struct(idlObject2.current().current(), file2);
                    break;
                }
                case 2: {
                    this.translate_enum(idlObject2.current().current(), file2);
                }
            }
            idlObject2.next();
        }
        this.current_pkg = string;
        printWriter.println("public final class " + idlObject2.name() + " extends org.omg.CORBA.UserException");
        printWriter.println("{");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlStructMember2 = (IdlStructMember)idlObject2.current();
            printWriter.println("    /**");
            printWriter.println("     * Exception member " + idlStructMember2.name());
            printWriter.println("     */");
            printWriter.print("    public ");
            idlStructMember2.reset();
            this.translate_type(idlStructMember2.current(), printWriter);
            printWriter.println(" " + idlStructMember2.name() + ";");
            printWriter.println("");
            idlObject2.next();
        }
        printWriter.println("    /**");
        printWriter.println("     * Default constructor");
        printWriter.println("     */");
        printWriter.println("    public " + idlObject2.name() + "()");
        printWriter.println("    {");
        printWriter.println("        super(" + idlObject2.name() + "Helper.id());");
        printWriter.println("    }");
        printWriter.println("");
        if (idlObject2.length() != 0) {
            printWriter.println("    /**");
            printWriter.println("     * Constructor with fields initialization");
            idlObject2.reset();
            while (!idlObject2.end()) {
                idlStructMember2 = (IdlStructMember)idlObject2.current();
                printWriter.println("     * @param " + idlStructMember2.name() + " " + idlStructMember2.name() + " exception member");
                idlObject2.next();
            }
            printWriter.println("     */");
            printWriter.print("    public " + idlObject2.name() + "(");
            idlObject2.reset();
            while (!idlObject2.end()) {
                idlStructMember2 = (IdlStructMember)idlObject2.current();
                this.translate_type(idlStructMember2.current(), printWriter);
                printWriter.print(" " + idlStructMember2.name());
                idlObject2.next();
                if (idlObject2.end()) continue;
                printWriter.print(", ");
            }
            printWriter.println(")");
            printWriter.println("    {");
            printWriter.println("        super(" + idlObject2.name() + "Helper.id());");
            idlObject2.reset();
            while (!idlObject2.end()) {
                idlStructMember2 = (IdlStructMember)idlObject2.current();
                printWriter.println("        this." + idlStructMember2.name() + " = " + idlStructMember2.name() + ";");
                idlObject2.next();
            }
            printWriter.println("    }");
            printWriter.println("");
        }
        printWriter.println("    /**");
        printWriter.println("     * Full constructor with fields initialization");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlStructMember2 = (IdlStructMember)idlObject2.current();
            printWriter.println("     * @param " + idlStructMember2.name() + " " + idlStructMember2.name() + " exception member");
            idlObject2.next();
        }
        printWriter.println("     */");
        printWriter.print("    public " + idlObject2.name() + "(String orb_reason");
        idlObject2.reset();
        while (!idlObject2.end()) {
            printWriter.print(", ");
            idlStructMember2 = (IdlStructMember)idlObject2.current();
            this.translate_type(idlStructMember2.current(), printWriter);
            printWriter.print(" " + idlStructMember2.name());
            idlObject2.next();
        }
        printWriter.println(")");
        printWriter.println("    {");
        idlObject2.reset();
        printWriter.println("        super(" + idlObject2.name() + "Helper.id() +\" \" +  orb_reason);");
        while (!idlObject2.end()) {
            idlStructMember2 = (IdlStructMember)idlObject2.current();
            printWriter.println("        this." + idlStructMember2.name() + " = " + idlStructMember2.name() + ";");
            idlObject2.next();
        }
        printWriter.println("    }");
        printWriter.println("");
        printWriter.println("}");
        printWriter.close();
        this.write_helper(idlObject2, file);
        this.write_holder(idlObject2, file);
    }

    public void translate_attribute(IdlObject idlObject2, PrintWriter printWriter) {
        if (idlObject2.hasComment()) {
            this.javadoc(printWriter, idlObject2);
        } else {
            printWriter.println("    /**");
            printWriter.println("     * Read accessor for " + idlObject2.name() + " attribute");
            printWriter.println("     * @return the attribute value");
            printWriter.println("     */");
        }
        printWriter.print("    public ");
        if (idlObject2.upper().kind() == 28) {
            printWriter.print("abstract ");
        }
        idlObject2.reset();
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.println(" " + idlObject2.name() + "();");
        printWriter.println("");
        if (!((IdlAttribute)idlObject2).readOnly()) {
            if (idlObject2.hasComment()) {
                this.javadoc(printWriter, idlObject2);
            } else {
                printWriter.println("    /**");
                printWriter.println("     * Write accessor for " + idlObject2.name() + " attribute");
                printWriter.println("     * @param value the attribute value");
                printWriter.println("     */");
            }
            printWriter.print("    public ");
            if (idlObject2.upper().kind() == 28) {
                printWriter.print("abstract ");
            }
            printWriter.print("void " + idlObject2.name() + "(");
            this.translate_type(idlObject2.current(), printWriter);
            printWriter.println(" value);");
            printWriter.println("");
        }
    }

    public void translate_user_attribute(IdlObject idlObject2, PrintWriter printWriter) {
        printWriter.println("    /**");
        printWriter.println("     * " + idlObject2.name() + " read attribute");
        printWriter.println("     */");
        printWriter.print("    public ");
        idlObject2.reset();
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.println(" " + idlObject2.name() + "()");
        printWriter.println("    {");
        printWriter.println("        //TODO: put your code here");
        printWriter.println("    }");
        printWriter.println("");
        if (!((IdlAttribute)idlObject2).readOnly()) {
            printWriter.println("    //");
            printWriter.println("    // " + idlObject2.name() + " write attribute");
            printWriter.println("    //");
            printWriter.print("    public void " + idlObject2.name() + "(");
            this.translate_type(idlObject2.current(), printWriter);
            printWriter.println(" value)");
            printWriter.println("    {");
            printWriter.println("        //TODO: put your code here");
            printWriter.println("    }");
            printWriter.println("");
        }
    }

    public void translate_attribute_tie(IdlObject idlObject2, PrintWriter printWriter) {
        printWriter.println("    /**");
        printWriter.println("     * Read accessor for " + idlObject2.name() + " attribute");
        printWriter.println("     */");
        printWriter.print("    public ");
        idlObject2.reset();
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.println(" " + idlObject2.name() + "()");
        printWriter.println("    {");
        printWriter.println("        return _tie." + idlObject2.name() + "();");
        printWriter.println("    }");
        printWriter.println("");
        if (!((IdlAttribute)idlObject2).readOnly()) {
            printWriter.println("    /**");
            printWriter.println("     * Write accessor for " + idlObject2.name() + " attribute");
            printWriter.println("     */");
            printWriter.print("    public void " + idlObject2.name() + "(");
            this.translate_type(idlObject2.current(), printWriter);
            printWriter.println(" value)");
            printWriter.println("    {");
            printWriter.println("        _tie." + idlObject2.name() + "(value);");
            printWriter.println("    }");
            printWriter.println("");
        }
    }

    public void translate_attribute_stub(IdlObject idlObject2, PrintWriter printWriter) {
        printWriter.println("    /**");
        printWriter.println("     * Read accessor for " + idlObject2.name() + " attribute");
        printWriter.println("     * @return the attribute value");
        printWriter.println("     */");
        printWriter.print("    public ");
        idlObject2.reset();
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.println(" " + idlObject2.name() + "()");
        printWriter.println("    {");
        printWriter.println("        org.omg.CORBA.Request _arg_request = _request(\"_get_" + idlObject2.name() + "\");");
        printWriter.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
        printWriter.println("");
        printWriter.print("        _arg_request.set_return_type(");
        idlObject2.reset();
        this.translate_typecode(idlObject2.current(), printWriter);
        printWriter.println(");");
        printWriter.println("");
        printWriter.println("        _arg_request.invoke();");
        printWriter.println("");
        printWriter.println("        Exception _except = _arg_request.env().exception();");
        printWriter.println("        if (_except != null)");
        printWriter.println("         throw (org.omg.CORBA.SystemException)_except;");
        printWriter.println("");
        printWriter.println("        org.omg.CORBA.Any _arg_result = _arg_request.return_value();");
        printWriter.print("        return ");
        this.translate_unmarshalling_data(idlObject2.current(), printWriter, "_arg_result.create_input_stream()");
        printWriter.println("    }");
        printWriter.println("");
        if (!((IdlAttribute)idlObject2).readOnly()) {
            printWriter.println("    /**");
            printWriter.println("     * Write accessor for " + idlObject2.name() + " attribute");
            printWriter.println("     * @param value the attribute value");
            printWriter.println("     */");
            printWriter.print("    public void " + idlObject2.name() + "(");
            this.translate_type(idlObject2.current(), printWriter);
            printWriter.println(" value)");
            printWriter.println("    {");
            printWriter.println("        org.omg.CORBA.Request _arg_request = _request(\"_set_" + idlObject2.name() + "\");");
            printWriter.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
            printWriter.println("");
            printWriter.println("        org.omg.CORBA.Any _arg = _arg_request.add_in_arg();");
            printWriter.print(tab2);
            this.translate_any_insert(idlObject2.current(), printWriter, "_arg", "value");
            printWriter.println(";");
            printWriter.println("        _arg_request.invoke();");
            printWriter.println("");
            printWriter.println("        Exception _except = _arg_request.env().exception();");
            printWriter.println("        if (_except != null)");
            printWriter.println("         throw (org.omg.CORBA.SystemException)_except;");
            printWriter.println("");
            printWriter.println("    }");
            printWriter.println("");
        }
    }

    public void translate_attribute_stub_stream(IdlObject idlObject2, PrintWriter printWriter) {
        boolean bl;
        printWriter.println("    /**");
        printWriter.println("     * Read accessor for " + idlObject2.name() + " attribute");
        printWriter.println("     * @return the attribute value");
        printWriter.println("     */");
        printWriter.print("    public ");
        idlObject2.reset();
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.println(" " + idlObject2.name() + "()");
        printWriter.println("    {");
        printWriter.println("        while(true)");
        printWriter.println("        {");
        if (IdlCompiler.local_stub) {
            printWriter.println("            if (!this._is_local())");
            printWriter.println("            {");
        }
        printWriter.println("                org.omg.CORBA.portable.InputStream _input = null;");
        printWriter.println("                try {");
        printWriter.println("                    org.omg.CORBA.portable.OutputStream _output = this._request(\"_get_" + idlObject2.name() + "\",true);");
        printWriter.println("                    _input = this._invoke(_output);");
        printWriter.print("                    return ");
        this.translate_unmarshalling_data(idlObject2.current(), printWriter, "_input");
        printWriter.println("                } catch (final org.omg.CORBA.portable.RemarshalException _exception) {");
        printWriter.println("                    continue;");
        printWriter.println("                } catch (final org.omg.CORBA.portable.ApplicationException _exception) {");
        printWriter.println("                    final String _exception_id = _exception.getId();");
        this.writeThrowException(printWriter, tab5, "org.omg.CORBA.UNKNOWN", "\"Unexpected User Exception: \"+ _exception_id", "_exception");
        printWriter.println("                } finally {");
        printWriter.println("                    this._releaseReply(_input);");
        printWriter.println("                }");
        boolean bl2 = bl = idlObject2.upper().kind() == 15 && ((IdlInterface)idlObject2.upper()).abstract_interface();
        if (IdlCompiler.local_stub) {
            printWriter.println("            }");
            printWriter.println("            else");
            printWriter.println("            {");
            printWriter.println("                org.omg.CORBA.portable.ServantObject _so = _servant_preinvoke(\"_get_" + idlObject2.name() + "\",_opsClass);");
            printWriter.println("                if (_so == null)");
            printWriter.println("                   continue;");
            if (bl) {
                printWriter.println(tab4 + this.fullname(idlObject2.upper()) + " _self = (" + this.fullname(idlObject2.upper()) + ") _so.servant;");
            } else {
                printWriter.println(tab4 + this.fullname(idlObject2.upper()) + "Operations _self = (" + this.fullname(idlObject2.upper()) + "Operations) _so.servant;");
            }
            printWriter.println("                try");
            printWriter.println("                {");
            printWriter.println("                    return _self." + idlObject2.name() + "();");
            printWriter.println("                }");
            printWriter.println("                finally");
            printWriter.println("                {");
            printWriter.println("                    _servant_postinvoke(_so);");
            printWriter.println("                }");
            printWriter.println("            }");
        }
        printWriter.println("        }");
        printWriter.println("    }");
        printWriter.println("");
        if (!((IdlAttribute)idlObject2).readOnly()) {
            printWriter.println("    /**");
            printWriter.println("     * Write accessor for " + idlObject2.name() + " attribute");
            printWriter.println("     * @param value the attribute value");
            printWriter.println("     */");
            printWriter.print("    public void " + idlObject2.name() + "(");
            this.translate_type(idlObject2.current(), printWriter);
            printWriter.println(" value)");
            printWriter.println("    {");
            printWriter.println("        while(true)");
            printWriter.println("        {");
            if (IdlCompiler.local_stub) {
                printWriter.println("            if (!this._is_local())");
                printWriter.println("            {");
            }
            printWriter.println("                    org.omg.CORBA.portable.InputStream _input = null;");
            printWriter.println("                try {");
            printWriter.println("                    org.omg.CORBA.portable.OutputStream _output = this._request(\"_set_" + idlObject2.name() + "\",true);");
            printWriter.print(tab5);
            this.translate_marshalling_data(idlObject2.current(), printWriter, "_output", "value");
            printWriter.println("                    _input = this._invoke(_output);");
            printWriter.println("                    return;");
            printWriter.println("                } catch (final org.omg.CORBA.portable.RemarshalException _exception) {");
            printWriter.println("                    continue;");
            printWriter.println("                } catch (final org.omg.CORBA.portable.ApplicationException _exception) {");
            printWriter.println("                    String _exception_id = _exception.getId();");
            this.writeThrowException(printWriter, tab5, "org.omg.CORBA.UNKNOWN", "\"Unexpected User Exception: \"+ _exception_id", "_exception");
            printWriter.println("                } finally {");
            printWriter.println("                    this._releaseReply(_input);");
            printWriter.println("                }");
            if (IdlCompiler.local_stub) {
                printWriter.println("            }");
                printWriter.println("            else");
                printWriter.println("            {");
                printWriter.println("                org.omg.CORBA.portable.ServantObject _so = _servant_preinvoke(\"_set_" + idlObject2.name() + "\",_opsClass);");
                printWriter.println("                if (_so == null)");
                printWriter.println("                   continue;");
                if (bl) {
                    printWriter.println(tab4 + this.fullname(idlObject2.upper()) + " _self = (" + this.fullname(idlObject2.upper()) + ") _so.servant;");
                } else {
                    printWriter.println(tab4 + this.fullname(idlObject2.upper()) + "Operations _self = (" + this.fullname(idlObject2.upper()) + "Operations) _so.servant;");
                }
                printWriter.println("                try");
                printWriter.println("                {");
                printWriter.println("                    _self." + idlObject2.name() + "(value);");
                printWriter.println("                    return;");
                printWriter.println("                }");
                printWriter.println("                finally");
                printWriter.println("                {");
                printWriter.println("                    _servant_postinvoke(_so);");
                printWriter.println("                }");
                printWriter.println("            }");
            }
            printWriter.println("        }");
            printWriter.println("    }");
            printWriter.println("");
        }
    }

    public void translate_read_attribute_skel(IdlObject idlObject2, PrintWriter printWriter) {
        idlObject2.reset();
        printWriter.print(tab2);
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.println(" arg = " + idlObject2.name() + "();");
        printWriter.println("");
        printWriter.println("        org.omg.CORBA.NVList argList = orb.create_list(0);");
        printWriter.println("        org.omg.CORBA.Any result = orb.create_any();");
        printWriter.println("        request.arguments(argList);");
        printWriter.print(tab2);
        this.translate_any_insert(idlObject2.current(), printWriter, "result", "arg");
        printWriter.println(";");
        printWriter.println("        request.set_result(result);");
    }

    public void translate_read_attribute_skel_stream(IdlObject idlObject2, PrintWriter printWriter) {
        idlObject2.reset();
        printWriter.print(tab2);
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.println(" arg = " + idlObject2.name() + "();");
        printWriter.println("        _output = handler.createReply();");
        printWriter.print(tab2);
        this.translate_marshalling_data(idlObject2.current(), printWriter, "_output", "arg");
        printWriter.println("        return _output;");
    }

    public void translate_write_attribute_skel(IdlObject idlObject2, PrintWriter printWriter) {
        idlObject2.reset();
        printWriter.println("        org.omg.CORBA.NVList argList = orb.create_list(0);");
        printWriter.println("        org.omg.CORBA.Any arg = orb.create_any();");
        printWriter.print("        arg.type(");
        this.translate_typecode(idlObject2.current(), printWriter);
        printWriter.println(");");
        printWriter.println("        argList.add_value(\"\", arg, org.omg.CORBA.ARG_IN.value);");
        printWriter.println("        request.arguments(argList);");
        printWriter.println("");
        printWriter.print(tab2);
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.print(" result = ");
        this.translate_unmarshalling_data(idlObject2.current(), printWriter, "arg.create_input_stream()");
        printWriter.println("");
        printWriter.println(tab2 + idlObject2.name() + "(result);");
    }

    public void translate_write_attribute_skel_stream(IdlObject idlObject2, PrintWriter printWriter) {
        idlObject2.reset();
        printWriter.print(tab2);
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.print(" result = ");
        this.translate_unmarshalling_data(idlObject2.current(), printWriter, "_is");
        printWriter.println();
        printWriter.println(tab2 + idlObject2.name() + "(result);");
        printWriter.println("        _output = handler.createReply();");
        printWriter.println("        return _output;");
    }

    public IdlContext getContext(IdlObject idlObject2) {
        int n = idlObject2.pos();
        IdlObject idlObject3 = null;
        idlObject2.reset();
        while (!idlObject2.end()) {
            if (idlObject2.current().kind() == 21) {
                idlObject3 = idlObject2.current();
                break;
            }
            idlObject2.next();
        }
        idlObject2.pos(n);
        return (IdlContext)idlObject3;
    }

    public void translate_operation(IdlObject idlObject2, PrintWriter printWriter) {
        IdlContext idlContext;
        boolean bl = false;
        if (idlObject2.hasComment()) {
            this.javadoc(printWriter, idlObject2);
        } else {
            printWriter.println("    /**");
            printWriter.println("     * Operation " + idlObject2.name());
            printWriter.println("     */");
        }
        printWriter.print("    public ");
        if (idlObject2.upper().kind() == 28) {
            printWriter.print("abstract ");
        }
        idlObject2.reset();
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.print(" " + idlObject2.name() + "(");
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            bl = true;
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                this.translate_parameter(idlObject2.current().current(), printWriter, ((IdlParam)idlObject2.current()).param_attr());
                printWriter.print(" " + idlObject2.current().name());
                idlObject2.next();
                if (idlObject2.end()) continue;
                if (idlObject2.current().kind() != 19) break;
                printWriter.print(", ");
            }
        }
        if ((idlContext = this.getContext(idlObject2)) != null) {
            if (bl) {
                printWriter.print(", ");
            }
            printWriter.print("org.omg.CORBA.Context ctx");
        }
        printWriter.print(")");
        if (!idlObject2.end() && idlObject2.current().kind() == 20) {
            printWriter.println("");
            printWriter.print("        throws ");
            IdlRaises idlRaises = (IdlRaises)idlObject2.current();
            idlRaises.reset();
            while (!idlRaises.end()) {
                printWriter.print(this.fullname(idlRaises.current()));
                idlRaises.next();
                if (idlRaises.end()) continue;
                printWriter.print(", ");
            }
        }
        printWriter.println(";");
        printWriter.println("");
    }

    public void translate_user_operation(IdlObject idlObject2, PrintWriter printWriter) {
        IdlContext idlContext;
        boolean bl = false;
        printWriter.println("    /**");
        printWriter.println("     * Operation " + idlObject2.name());
        printWriter.println("     */");
        printWriter.print("    public ");
        idlObject2.reset();
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.print(" " + idlObject2.name() + "(");
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            bl = true;
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                this.translate_parameter(idlObject2.current().current(), printWriter, ((IdlParam)idlObject2.current()).param_attr());
                printWriter.print(" " + idlObject2.current().name());
                idlObject2.next();
                if (idlObject2.end()) continue;
                if (idlObject2.current().kind() != 19) break;
                printWriter.print(", ");
            }
        }
        if ((idlContext = this.getContext(idlObject2)) != null) {
            if (bl) {
                printWriter.print(", ");
            }
            printWriter.print("org.omg.CORBA.Context ctx");
        }
        printWriter.print(")");
        if (!idlObject2.end() && idlObject2.current().kind() == 20) {
            printWriter.println("");
            printWriter.print("        throws ");
            IdlRaises idlRaises = (IdlRaises)idlObject2.current();
            idlRaises.reset();
            while (!idlRaises.end()) {
                printWriter.print(this.fullname(idlRaises.current()));
                idlRaises.next();
                if (idlRaises.end()) continue;
                printWriter.print(", ");
            }
        }
        printWriter.println("");
        printWriter.println("    {");
        printWriter.println("        //TODO: put your code here");
        printWriter.println("    }");
        printWriter.println("");
    }

    public void translate_operation_tie(IdlObject idlObject2, PrintWriter printWriter) {
        IdlContext idlContext;
        boolean bl = false;
        printWriter.println("    /**");
        printWriter.println("     * Operation " + idlObject2.name());
        printWriter.println("     */");
        printWriter.print("    public ");
        idlObject2.reset();
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.print(" " + idlObject2.name() + "(");
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            bl = true;
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                this.translate_parameter(idlObject2.current().current(), printWriter, ((IdlParam)idlObject2.current()).param_attr());
                printWriter.print(" " + idlObject2.current().name());
                idlObject2.next();
                if (idlObject2.end()) continue;
                if (idlObject2.current().kind() != 19) break;
                printWriter.print(", ");
            }
        }
        if ((idlContext = this.getContext(idlObject2)) != null) {
            if (bl) {
                printWriter.print(", ");
            }
            printWriter.print("org.omg.CORBA.Context ctx");
        }
        printWriter.print(")");
        if (!idlObject2.end() && idlObject2.current().kind() == 20) {
            printWriter.println("");
            printWriter.print("        throws ");
            IdlRaises idlRaises = (IdlRaises)idlObject2.current();
            idlRaises.reset();
            while (!idlRaises.end()) {
                printWriter.print(this.fullname(idlRaises.current()));
                idlRaises.next();
                if (idlRaises.end()) continue;
                printWriter.print(", ");
            }
        }
        printWriter.println("");
        printWriter.println("    {");
        idlObject2.reset();
        printWriter.print(tab2);
        if (idlObject2.current().kind() == 8) {
            if (((IdlSimple)idlObject2.current()).internal() != 55) {
                printWriter.print("return ");
            }
        } else {
            printWriter.print("return ");
        }
        idlObject2.next();
        printWriter.print("_tie." + idlObject2.name() + "(");
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            while (!idlObject2.end()) {
                printWriter.print(" " + idlObject2.current().name());
                idlObject2.next();
                if (idlObject2.end()) continue;
                if (idlObject2.current().kind() != 19) break;
                printWriter.print(", ");
            }
        }
        if ((idlContext = this.getContext(idlObject2)) != null) {
            if (bl) {
                printWriter.print(", ");
            }
            printWriter.print("ctx");
        }
        printWriter.println(");");
        printWriter.println("    }");
        printWriter.println("");
    }

    public void translate_operation_skel(IdlObject idlObject2, PrintWriter printWriter) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        printWriter.println("    org.omg.CORBA.NVList argList = orb.create_list(0);");
        idlObject2.reset();
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            while (!idlObject2.end()) {
                printWriter.println("        org.omg.CORBA.Any arg" + n + " = orb.create_any();");
                idlObject2.current().reset();
                switch (((IdlParam)idlObject2.current()).param_attr()) {
                    case 0: {
                        printWriter.print("        arg" + n + ".type(");
                        this.translate_typecode(idlObject2.current().current(), printWriter);
                        printWriter.println(");");
                        printWriter.println("        argList.add_value(\"\",arg" + n + ",org.omg.CORBA.ARG_IN.value);");
                        break;
                    }
                    case 1: {
                        printWriter.println("        argList.add_value(\"\",arg" + n + ",org.omg.CORBA.ARG_OUT.value);");
                        break;
                    }
                    case 2: {
                        printWriter.print("        arg" + n + ".type(");
                        this.translate_typecode(idlObject2.current().current(), printWriter);
                        printWriter.println(");");
                        printWriter.println("        argList.add_value(\"\",arg" + n + ",org.omg.CORBA.ARG_INOUT.value);");
                    }
                }
                ++n;
                idlObject2.next();
                if (!idlObject2.end() && idlObject2.current().kind() != 19) break;
            }
        }
        n = 0;
        printWriter.println("");
        printWriter.println("        request.arguments(argList);");
        printWriter.println("");
        IdlContext idlContext = this.getContext(idlObject2);
        if (idlContext != null) {
            printWriter.println("        org.omg.CORBA.Context arg_ctx = request.ctx();");
            printWriter.println("");
        }
        idlObject2.reset();
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                switch (((IdlParam)idlObject2.current()).param_attr()) {
                    case 0: {
                        printWriter.print(tab2);
                        this.translate_type(idlObject2.current().current(), printWriter);
                        printWriter.print(" arg" + n + "_in = ");
                        this.translate_unmarshalling_data(idlObject2.current().current(), printWriter, "arg" + n + ".create_input_stream()");
                        break;
                    }
                    case 1: {
                        printWriter.print(tab2);
                        this.translate_parameter(idlObject2.current().current(), printWriter, ((IdlParam)idlObject2.current()).param_attr());
                        printWriter.print(" arg" + n + "_out = new ");
                        this.translate_parameter(idlObject2.current().current(), printWriter, ((IdlParam)idlObject2.current()).param_attr());
                        printWriter.println("();");
                        break;
                    }
                    case 2: {
                        printWriter.print(tab2);
                        this.translate_parameter(idlObject2.current().current(), printWriter, ((IdlParam)idlObject2.current()).param_attr());
                        printWriter.print(" arg" + n + "_inout = new ");
                        this.translate_parameter(idlObject2.current().current(), printWriter, ((IdlParam)idlObject2.current()).param_attr());
                        printWriter.println("();");
                        printWriter.print("        arg" + n + "_inout.value = ");
                        this.translate_unmarshalling_data(idlObject2.current().current(), printWriter, "arg" + n + ".create_input_stream()");
                    }
                }
                ++n;
                idlObject2.next();
                if (!idlObject2.end() && idlObject2.current().kind() != 19) break;
            }
        }
        n = 0;
        printWriter.println("");
        if (!idlObject2.end() && idlObject2.current().kind() == 20) {
            printWriter.println("        try");
            printWriter.println("        {");
            bl = true;
        }
        idlObject2.reset();
        if (idlObject2.current().kind() == 8) {
            if (((IdlSimple)idlObject2.current()).internal() != 55) {
                if (bl) {
                    printWriter.print("    ");
                }
                printWriter.print(tab2);
                this.translate_type(idlObject2.current(), printWriter);
                printWriter.print(" _arg_result = ");
            } else {
                if (bl) {
                    printWriter.print("    ");
                }
                printWriter.print(tab2);
            }
        } else {
            if (bl) {
                printWriter.print("    ");
            }
            printWriter.print(tab2);
            this.translate_type(idlObject2.current(), printWriter);
            printWriter.print(" _arg_result = ");
        }
        printWriter.print(idlObject2.name() + "(");
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            bl2 = true;
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                switch (((IdlParam)idlObject2.current()).param_attr()) {
                    case 0: {
                        printWriter.print("arg" + n + "_in");
                        break;
                    }
                    case 1: {
                        printWriter.print("arg" + n + "_out");
                        break;
                    }
                    case 2: {
                        printWriter.print("arg" + n + "_inout");
                    }
                }
                ++n;
                idlObject2.next();
                if (idlObject2.end()) continue;
                if (idlObject2.current().kind() != 19) break;
                printWriter.print(", ");
            }
        }
        n = 0;
        if (idlContext != null) {
            if (bl2) {
                printWriter.print(", ");
            }
            printWriter.print("arg_ctx");
        }
        printWriter.println(");");
        printWriter.println("");
        idlObject2.reset();
        if (idlObject2.current().kind() == 8) {
            if (((IdlSimple)idlObject2.current()).internal() != 55) {
                if (bl) {
                    printWriter.print("    ");
                }
                printWriter.println("        org.omg.CORBA.Any any_result = orb.create_any();");
                if (bl) {
                    printWriter.print("    ");
                }
                printWriter.print(tab2);
                this.translate_any_insert(idlObject2.current(), printWriter, "any_result", "_arg_result");
                printWriter.println(";");
                if (bl) {
                    printWriter.print("    ");
                }
                printWriter.println("        request.set_result(any_result);");
            }
        } else {
            if (bl) {
                printWriter.print("    ");
            }
            printWriter.println("        org.omg.CORBA.Any any_result = orb.create_any();");
            if (bl) {
                printWriter.print("    ");
            }
            printWriter.print(tab2);
            this.translate_any_insert(idlObject2.current(), printWriter, "any_result", "_arg_result");
            printWriter.println(";");
            if (bl) {
                printWriter.print("    ");
            }
            printWriter.println("        request.set_result(any_result);");
        }
        printWriter.println("");
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                switch (((IdlParam)idlObject2.current()).param_attr()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (bl) {
                            printWriter.print("    ");
                        }
                        printWriter.print(tab2);
                        this.translate_any_insert(idlObject2.current().current(), printWriter, "arg" + n, "arg" + n + "_out.value");
                        printWriter.println(";");
                        break;
                    }
                    case 2: {
                        if (bl) {
                            printWriter.print("    ");
                        }
                        printWriter.print(tab2);
                        this.translate_any_insert(idlObject2.current().current(), printWriter, "arg" + n, "arg" + n + "_inout.value");
                        printWriter.println(";");
                    }
                }
                ++n;
                idlObject2.next();
                if (!idlObject2.end() && idlObject2.current().kind() != 19) break;
            }
        }
        if (!idlObject2.end() && idlObject2.current().kind() == 20) {
            IdlRaises idlRaises = (IdlRaises)idlObject2.current();
            idlRaises.reset();
            printWriter.println("        }");
            while (!idlRaises.end()) {
                printWriter.println("        catch (" + this.fullname(idlRaises.current()) + " ex)");
                printWriter.println("        {");
                printWriter.println("            org.omg.CORBA.Any any_ex = orb.create_any();");
                printWriter.println(tab3 + this.fullname(idlRaises.current()) + "Helper.insert(any_ex,ex);");
                printWriter.println("            request.set_exception(any_ex);");
                printWriter.println("        }");
                idlRaises.next();
            }
        }
    }

    public void translate_operation_skel_stream(IdlObject idlObject2, PrintWriter printWriter) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        idlObject2.reset();
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                switch (((IdlParam)idlObject2.current()).param_attr()) {
                    case 0: {
                        printWriter.print(tab2);
                        this.translate_type(idlObject2.current().current(), printWriter);
                        printWriter.print(" arg" + n + "_in = ");
                        this.translate_unmarshalling_data(idlObject2.current().current(), printWriter, "_is");
                        break;
                    }
                    case 1: {
                        printWriter.print(tab2);
                        this.translate_parameter(idlObject2.current().current(), printWriter, ((IdlParam)idlObject2.current()).param_attr());
                        printWriter.print(" arg" + n + "_out = new ");
                        this.translate_parameter(idlObject2.current().current(), printWriter, ((IdlParam)idlObject2.current()).param_attr());
                        printWriter.println("();");
                        break;
                    }
                    case 2: {
                        printWriter.print(tab2);
                        this.translate_parameter(idlObject2.current().current(), printWriter, ((IdlParam)idlObject2.current()).param_attr());
                        printWriter.print(" arg" + n + "_inout = new ");
                        this.translate_parameter(idlObject2.current().current(), printWriter, ((IdlParam)idlObject2.current()).param_attr());
                        printWriter.println("();");
                        printWriter.print("        arg" + n + "_inout.value = ");
                        this.translate_unmarshalling_data(idlObject2.current().current(), printWriter, "_is");
                    }
                }
                ++n;
                idlObject2.next();
                if (!idlObject2.end() && idlObject2.current().kind() != 19) break;
            }
        }
        n = 0;
        printWriter.println("");
        IdlContext idlContext = this.getContext(idlObject2);
        if (idlContext != null) {
            printWriter.println("        org.omg.CORBA.Context arg_ctx = _is.read_Context();");
            printWriter.println("");
        }
        if (!idlObject2.end() && idlObject2.current().kind() == 20) {
            printWriter.println("        try");
            printWriter.println("        {");
            bl = true;
        }
        idlObject2.reset();
        if (idlObject2.current().kind() == 8) {
            if (((IdlSimple)idlObject2.current()).internal() != 55) {
                if (bl) {
                    printWriter.print("    ");
                }
                printWriter.print(tab2);
                this.translate_type(idlObject2.current(), printWriter);
                printWriter.print(" _arg_result = ");
            } else {
                if (bl) {
                    printWriter.print("    ");
                }
                printWriter.print(tab2);
            }
        } else {
            if (bl) {
                printWriter.print("    ");
            }
            printWriter.print(tab2);
            this.translate_type(idlObject2.current(), printWriter);
            printWriter.print(" _arg_result = ");
        }
        printWriter.print(idlObject2.name() + "(");
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            bl2 = true;
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                switch (((IdlParam)idlObject2.current()).param_attr()) {
                    case 0: {
                        printWriter.print("arg" + n + "_in");
                        break;
                    }
                    case 1: {
                        printWriter.print("arg" + n + "_out");
                        break;
                    }
                    case 2: {
                        printWriter.print("arg" + n + "_inout");
                    }
                }
                ++n;
                idlObject2.next();
                if (idlObject2.end()) continue;
                if (idlObject2.current().kind() != 19) break;
                printWriter.print(", ");
            }
        }
        n = 0;
        if (idlContext != null) {
            if (bl2) {
                printWriter.print(", ");
            }
            printWriter.print("arg_ctx");
        }
        printWriter.println(");");
        printWriter.println("");
        if (bl) {
            printWriter.print("    ");
        }
        printWriter.println("        _output = handler.createReply();");
        idlObject2.reset();
        if (idlObject2.current().kind() == 8) {
            if (((IdlSimple)idlObject2.current()).internal() != 55) {
                if (bl) {
                    printWriter.print("    ");
                }
                printWriter.print(tab2);
                this.translate_marshalling_data(idlObject2.current(), printWriter, "_output", "_arg_result");
            }
        } else {
            if (bl) {
                printWriter.print("    ");
            }
            printWriter.print(tab2);
            this.translate_marshalling_data(idlObject2.current(), printWriter, "_output", "_arg_result");
        }
        printWriter.println("");
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                switch (((IdlParam)idlObject2.current()).param_attr()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (bl) {
                            printWriter.print("    ");
                        }
                        printWriter.print(tab2);
                        this.translate_marshalling_data(idlObject2.current().current(), printWriter, "_output", "arg" + n + "_out.value");
                        break;
                    }
                    case 2: {
                        if (bl) {
                            printWriter.print("    ");
                        }
                        printWriter.print(tab2);
                        this.translate_marshalling_data(idlObject2.current().current(), printWriter, "_output", "arg" + n + "_inout.value");
                    }
                }
                ++n;
                idlObject2.next();
                if (!idlObject2.end() && idlObject2.current().kind() != 19) break;
            }
        }
        if (!idlObject2.end() && idlObject2.current().kind() == 20) {
            IdlRaises idlRaises = (IdlRaises)idlObject2.current();
            idlRaises.reset();
            printWriter.println("        }");
            while (!idlRaises.end()) {
                printWriter.println("        catch (" + this.fullname(idlRaises.current()) + " _exception)");
                printWriter.println("        {");
                printWriter.println("            _output = handler.createExceptionReply();");
                printWriter.println(tab3 + this.fullname(idlRaises.current()) + "Helper.write(_output,_exception);");
                printWriter.println("        }");
                idlRaises.next();
            }
        }
        printWriter.println("        return _output;");
    }

    public void translate_operation_stub(IdlObject idlObject2, PrintWriter printWriter) {
        IdlRaises idlRaises;
        IdlContext idlContext;
        boolean bl = false;
        int n = 0;
        printWriter.println("    /**");
        printWriter.println("     * Operation " + idlObject2.name());
        printWriter.println("     */");
        printWriter.print("    public ");
        idlObject2.reset();
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.print(" " + idlObject2.name() + "(");
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            bl = true;
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                this.translate_parameter(idlObject2.current().current(), printWriter, ((IdlParam)idlObject2.current()).param_attr());
                printWriter.print(" " + idlObject2.current().name());
                idlObject2.next();
                if (idlObject2.end()) continue;
                if (idlObject2.current().kind() != 19) break;
                printWriter.print(", ");
            }
        }
        if ((idlContext = this.getContext(idlObject2)) != null) {
            if (bl) {
                printWriter.print(", ");
            }
            printWriter.print("org.omg.CORBA.Context ctx");
        }
        printWriter.print(")");
        if (!idlObject2.end() && idlObject2.current().kind() == 20) {
            printWriter.println("");
            printWriter.print("        throws ");
            idlRaises = (IdlRaises)idlObject2.current();
            idlRaises.reset();
            while (!idlRaises.end()) {
                printWriter.print(this.fullname(idlRaises.current()));
                idlRaises.next();
                if (idlRaises.end()) continue;
                printWriter.print(", ");
            }
        }
        printWriter.println("");
        printWriter.println("    {");
        printWriter.println("        org.omg.CORBA.Request request = _request(\"" + this.initialName(idlObject2.name()) + "\");");
        printWriter.println("            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
        printWriter.println("");
        if (idlContext != null) {
            Vector vector = idlContext.getValues();
            int n2 = 0;
            while (n2 < vector.size()) {
                printWriter.print("        request.contexts().add(\"");
                printWriter.print((String)vector.get(n2));
                printWriter.println("\");");
                ++n2;
            }
            printWriter.println("        request.ctx(ctx);");
            printWriter.println("");
        }
        idlObject2.reset();
        if (idlObject2.current().kind() == 8) {
            if (((IdlSimple)idlObject2.current()).internal() != 55) {
                printWriter.print("        request.set_return_type(");
                this.translate_typecode(idlObject2.current(), printWriter);
                printWriter.println(");");
                printWriter.println("");
            }
        } else {
            printWriter.print("        request.set_return_type(");
            this.translate_typecode(idlObject2.current(), printWriter);
            printWriter.println(");");
            printWriter.println("");
        }
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                switch (((IdlParam)idlObject2.current()).param_attr()) {
                    case 0: {
                        printWriter.println("        org.omg.CORBA.Any arg" + n + " = request.add_in_arg();");
                        printWriter.print(tab2);
                        idlObject2.current().reset();
                        this.translate_any_insert(idlObject2.current().current(), printWriter, "arg" + n, idlObject2.current().name());
                        printWriter.println(";");
                        break;
                    }
                    case 1: {
                        printWriter.println("        org.omg.CORBA.Any arg" + n + " = request.add_out_arg();");
                        printWriter.print("        arg" + n + ".type(");
                        this.translate_typecode(idlObject2.current().current(), printWriter);
                        printWriter.println(");");
                        break;
                    }
                    case 2: {
                        printWriter.println("        org.omg.CORBA.Any arg" + n + " = request.add_inout_arg();");
                        printWriter.print(tab2);
                        idlObject2.current().reset();
                        this.translate_any_insert(idlObject2.current().current(), printWriter, "arg" + n, idlObject2.current().name() + ".value");
                        printWriter.println(";");
                    }
                }
                ++n;
                idlObject2.next();
                if (!idlObject2.end() && idlObject2.current().kind() != 19) break;
            }
        }
        if (!idlObject2.end() && idlObject2.current().kind() == 20) {
            printWriter.println("");
            idlRaises = (IdlRaises)idlObject2.current();
            idlRaises.reset();
            while (!idlRaises.end()) {
                printWriter.print("        request.exceptions().add(");
                printWriter.println(this.fullname(idlRaises.current()) + "Helper.type());");
                idlRaises.next();
            }
        }
        printWriter.println("");
        if (((IdlOp)idlObject2).oneway()) {
            printWriter.println("        request.send_oneway();");
        } else {
            printWriter.println("        request.invoke();");
        }
        printWriter.println("");
        if (!idlObject2.end() && idlObject2.current().kind() == 20) {
            printWriter.println("        Exception except = request.env().exception();");
            printWriter.println("        if (except != null)");
            printWriter.println("        {");
            printWriter.println("         org.omg.CORBA.UnknownUserException unk_except;");
            printWriter.println("         try");
            printWriter.println("         {");
            printWriter.println("          unk_except = (org.omg.CORBA.UnknownUserException)except;");
            printWriter.println("         }");
            printWriter.println("         catch (ClassCastException ex)");
            printWriter.println("         {");
            printWriter.println("          throw (org.omg.CORBA.SystemException)except;");
            printWriter.println("         }");
            printWriter.println("");
            idlRaises = (IdlRaises)idlObject2.current();
            idlRaises.reset();
            while (!idlRaises.end()) {
                printWriter.println("         try {");
                printWriter.println("          throw " + this.fullname(idlRaises.current()) + "Helper.extract(unk_except.except);");
                printWriter.println("         } catch (final org.omg.CORBA.MARSHAL e) {");
                printWriter.println("         }");
                printWriter.println("");
                idlRaises.next();
            }
            printWriter.println("        throw new org.omg.CORBA.UNKNOWN();");
            printWriter.println("        }");
            printWriter.println("");
        }
        idlObject2.reset();
        idlObject2.next();
        n = 0;
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                switch (((IdlParam)idlObject2.current()).param_attr()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        printWriter.print(tab2 + idlObject2.current().name() + ".value = ");
                        idlObject2.current().reset();
                        this.translate_unmarshalling_data(idlObject2.current().current(), printWriter, "arg" + n + ".create_input_stream()");
                        break;
                    }
                    case 2: {
                        printWriter.print(tab2 + idlObject2.current().name() + ".value = ");
                        idlObject2.current().reset();
                        this.translate_unmarshalling_data(idlObject2.current().current(), printWriter, "arg" + n + ".create_input_stream()");
                    }
                }
                ++n;
                idlObject2.next();
                if (!idlObject2.end() && idlObject2.current().kind() != 19) break;
            }
        }
        printWriter.println("");
        idlObject2.reset();
        if (idlObject2.current().kind() == 8) {
            if (((IdlSimple)idlObject2.current()).internal() != 55) {
                printWriter.println("        org.omg.CORBA.Any _arg_result = request.return_value();");
                printWriter.print("        return ");
                this.translate_unmarshalling_data(idlObject2.current(), printWriter, "_arg_result.create_input_stream()");
            }
        } else {
            printWriter.println("        org.omg.CORBA.Any _arg_result = request.return_value();");
            printWriter.print("        return ");
            this.translate_unmarshalling_data(idlObject2.current(), printWriter, "_arg_result.create_input_stream()");
        }
        printWriter.println("    }");
        printWriter.println("");
    }

    public void translate_operation_stub_stream(IdlObject idlObject2, PrintWriter printWriter) {
        boolean bl;
        IdlRaises idlRaises;
        IdlContext idlContext;
        boolean bl2 = false;
        boolean bl3 = false;
        printWriter.println("    /**");
        printWriter.println("     * Operation " + idlObject2.name());
        printWriter.println("     */");
        printWriter.print("    public ");
        idlObject2.reset();
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.print(" " + idlObject2.name() + "(");
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            bl2 = true;
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                this.translate_parameter(idlObject2.current().current(), printWriter, ((IdlParam)idlObject2.current()).param_attr());
                printWriter.print(" " + idlObject2.current().name());
                idlObject2.next();
                if (idlObject2.end()) continue;
                if (idlObject2.current().kind() != 19) break;
                printWriter.print(", ");
            }
        }
        if ((idlContext = this.getContext(idlObject2)) != null) {
            if (bl2) {
                printWriter.print(", ");
            }
            printWriter.print("org.omg.CORBA.Context ctx");
        }
        printWriter.print(")");
        if (!idlObject2.end() && idlObject2.current().kind() == 20) {
            printWriter.println("");
            printWriter.print("        throws ");
            idlRaises = (IdlRaises)idlObject2.current();
            idlRaises.reset();
            while (!idlRaises.end()) {
                printWriter.print(this.fullname(idlRaises.current()));
                idlRaises.next();
                if (idlRaises.end()) continue;
                printWriter.print(", ");
            }
        }
        printWriter.println("");
        printWriter.println("    {");
        printWriter.println("        while(true)");
        printWriter.println("        {");
        if (IdlCompiler.local_stub) {
            printWriter.println("            if (!this._is_local())");
            printWriter.println("            {");
        }
        if (idlContext != null) {
            printWriter.println("                org.omg.CORBA.ContextList ctxList = org.omg.CORBA.ORB.init().create_context_list();");
        }
        printWriter.println("                org.omg.CORBA.portable.InputStream _input = null;");
        printWriter.println("                try");
        printWriter.println("                {");
        if (((IdlOp)idlObject2).oneway()) {
            printWriter.println("                    org.omg.CORBA.portable.OutputStream _output = this._request(\"" + this.initialName(idlObject2.name()) + "\",false);");
        } else {
            printWriter.println("                    org.omg.CORBA.portable.OutputStream _output = this._request(\"" + this.initialName(idlObject2.name()) + "\",true);");
        }
        idlObject2.reset();
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                switch (((IdlParam)idlObject2.current()).param_attr()) {
                    case 0: {
                        printWriter.print(tab5);
                        idlObject2.current().reset();
                        this.translate_marshalling_data(idlObject2.current().current(), printWriter, "_output", idlObject2.current().name());
                        break;
                    }
                    case 2: {
                        printWriter.print(tab5);
                        idlObject2.current().reset();
                        this.translate_marshalling_data(idlObject2.current().current(), printWriter, "_output", idlObject2.current().name() + ".value");
                    }
                }
                idlObject2.next();
                if (!idlObject2.end() && idlObject2.current().kind() != 19) break;
            }
        }
        if (idlContext != null) {
            Vector vector = idlContext.getValues();
            int n = 0;
            while (n < vector.size()) {
                printWriter.println("                    ctxList.add(\"" + (String)vector.get(n) + "\");");
                ++n;
            }
            printWriter.println("                    _output.write_Context(ctx,ctxList);");
            printWriter.println("");
        }
        printWriter.println("                    _input = this._invoke(_output);");
        idlObject2.reset();
        if (idlObject2.current().kind() == 8) {
            if (((IdlSimple)idlObject2.current()).internal() != 55) {
                printWriter.print(tab5);
                this.translate_type(idlObject2.current(), printWriter);
                printWriter.print(" _arg_ret = ");
                this.translate_unmarshalling_data(idlObject2.current(), printWriter, "_input");
            }
        } else {
            printWriter.print(tab5);
            this.translate_type(idlObject2.current(), printWriter);
            printWriter.print(" _arg_ret = ");
            this.translate_unmarshalling_data(idlObject2.current(), printWriter, "_input");
        }
        idlObject2.next();
        if (!idlObject2.end() && idlObject2.current().kind() == 19) {
            while (!idlObject2.end()) {
                idlObject2.current().reset();
                switch (((IdlParam)idlObject2.current()).param_attr()) {
                    case 1: 
                    case 2: {
                        printWriter.print(tab5 + idlObject2.current().name() + ".value = ");
                        idlObject2.current().reset();
                        this.translate_unmarshalling_data(idlObject2.current().current(), printWriter, "_input");
                    }
                }
                idlObject2.next();
                if (!idlObject2.end() && idlObject2.current().kind() != 19) break;
            }
        }
        int n = idlObject2.pos();
        idlObject2.reset();
        if (idlObject2.current().kind() == 8) {
            if (((IdlSimple)idlObject2.current()).internal() != 55) {
                printWriter.println("                    return _arg_ret;");
            } else {
                printWriter.println("                    return;");
                bl3 = true;
            }
        } else {
            printWriter.println("                    return _arg_ret;");
        }
        printWriter.println("                }");
        printWriter.println("                catch(org.omg.CORBA.portable.RemarshalException _exception)");
        printWriter.println("                {");
        printWriter.println("                    continue;");
        printWriter.println("                }");
        printWriter.println("                catch(org.omg.CORBA.portable.ApplicationException _exception)");
        printWriter.println("                {");
        printWriter.println("                    String _exception_id = _exception.getId();");
        idlObject2.pos(n);
        if (!idlObject2.end() && idlObject2.current().kind() == 20) {
            idlRaises = (IdlRaises)idlObject2.current();
            idlRaises.reset();
            while (!idlRaises.end()) {
                printWriter.println("                    if (_exception_id.equals(" + this.fullname(idlRaises.current()) + "Helper.id()))");
                printWriter.println("                    {");
                printWriter.println("                        throw " + this.fullname(idlRaises.current()) + "Helper.read(_exception.getInputStream());");
                printWriter.println("                    }");
                printWriter.println("");
                idlRaises.next();
            }
        }
        printWriter.println("                    throw new org.omg.CORBA.UNKNOWN(\"Unexpected User Exception: \"+ _exception_id);");
        printWriter.println("                }");
        printWriter.println("                finally");
        printWriter.println("                {");
        printWriter.println("                    this._releaseReply(_input);");
        printWriter.println("                }");
        boolean bl4 = bl = idlObject2.upper().kind() == 15 && ((IdlInterface)idlObject2.upper()).abstract_interface();
        if (IdlCompiler.local_stub) {
            printWriter.println("            }");
            printWriter.println("            else");
            printWriter.println("            {");
            printWriter.println("                org.omg.CORBA.portable.ServantObject _so = _servant_preinvoke(\"" + idlObject2.name() + "\",_opsClass);");
            printWriter.println("                if (_so == null)");
            printWriter.println("                   continue;");
            if (bl) {
                printWriter.println(tab4 + this.fullname(idlObject2.upper()) + " _self = (" + this.fullname(idlObject2.upper()) + ") _so.servant;");
            } else {
                printWriter.println(tab4 + this.fullname(idlObject2.upper()) + "Operations _self = (" + this.fullname(idlObject2.upper()) + "Operations) _so.servant;");
            }
            printWriter.println("                try");
            printWriter.println("                {");
            if (bl3) {
                printWriter.print("                    _self." + idlObject2.name() + "(");
            } else {
                printWriter.print("                    return _self." + idlObject2.name() + "(");
            }
            idlObject2.reset();
            idlObject2.next();
            if (!idlObject2.end() && idlObject2.current().kind() == 19) {
                bl2 = true;
                while (!idlObject2.end()) {
                    idlObject2.current().reset();
                    printWriter.print(" " + idlObject2.current().name());
                    idlObject2.next();
                    if (idlObject2.end()) continue;
                    if (idlObject2.current().kind() != 19) break;
                    printWriter.print(", ");
                }
            }
            if ((idlContext = this.getContext(idlObject2)) != null) {
                if (bl2) {
                    printWriter.print(", ");
                }
                printWriter.print("ctx");
            }
            printWriter.println(");");
            if (bl3) {
                printWriter.println("                    return;");
            }
            printWriter.println("                }");
            printWriter.println("                finally");
            printWriter.println("                {");
            printWriter.println("                    _servant_postinvoke(_so);");
            printWriter.println("                }");
            printWriter.println("            }");
        }
        printWriter.println("        }");
        printWriter.println("    }");
        printWriter.println("");
    }

    public void translate_interface_operations(IdlObject idlObject2, File file) {
        PrintWriter printWriter = !((IdlInterface)idlObject2).abstract_interface() ? this.newFile(file, idlObject2.name() + "Operations") : this.newFile(file, idlObject2.name());
        Vector vector = ((IdlInterface)idlObject2).getInheritance();
        this.addDescriptiveHeader(printWriter, idlObject2);
        if (!((IdlInterface)idlObject2).abstract_interface()) {
            printWriter.print("public interface " + idlObject2.name() + "Operations");
            if (vector.size() != 0) {
                printWriter.print(" extends ");
            }
        } else {
            printWriter.print("public interface " + idlObject2.name() + " extends org.omg.CORBA.portable.IDLEntity");
            if (vector.size() != 0) {
                printWriter.print(", ");
            }
        }
        if (vector.size() != 0) {
            int n = 0;
            while (n < vector.size()) {
                if (!((IdlInterface)vector.get(n)).abstract_interface()) {
                    printWriter.print(this.fullname((IdlObject)vector.get(n)) + "Operations");
                } else {
                    printWriter.print(this.fullname((IdlObject)vector.get(n)));
                }
                if (n != vector.size() - 1) {
                    printWriter.print(", ");
                }
                ++n;
            }
            printWriter.println("");
        } else {
            printWriter.println("");
        }
        printWriter.println("{");
        idlObject2.reset();
        while (!idlObject2.end()) {
            switch (idlObject2.current().kind()) {
                case 16: {
                    this.translate_operation(idlObject2.current(), printWriter);
                    break;
                }
                case 17: {
                    this.translate_attribute(idlObject2.current(), printWriter);
                    break;
                }
                case 7: {
                    if (!((IdlInterface)idlObject2).abstract_interface()) break;
                    this.translate_constant(idlObject2.current(), null, printWriter);
                }
            }
            idlObject2.next();
        }
        printWriter.println("}");
        printWriter.close();
    }

    public boolean isEmptyInterface(IdlObject idlObject2) {
        idlObject2.reset();
        while (!idlObject2.end()) {
            switch (idlObject2.current().kind()) {
                case 2: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 13: {
                    return false;
                }
                case 14: {
                    return false;
                }
                case 25: {
                    return false;
                }
            }
            idlObject2.next();
        }
        return true;
    }

    public boolean isEmptyValue(IdlObject idlObject2) {
        idlObject2.reset();
        while (!idlObject2.end()) {
            switch (idlObject2.current().kind()) {
                case 2: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 13: {
                    return false;
                }
                case 14: {
                    return false;
                }
                case 25: {
                    return false;
                }
            }
            idlObject2.next();
        }
        return true;
    }

    public boolean isEmpty(IdlObject idlObject2) {
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlObject2.current().reset();
            switch (idlObject2.current().current().kind()) {
                case 2: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
            }
            idlObject2.next();
        }
        return true;
    }

    public void translate_interface(IdlObject idlObject2, File file) {
        PrintWriter printWriter = null;
        if (!((IdlInterface)idlObject2).abstract_interface()) {
            printWriter = this.newFile(file, idlObject2.name());
            this.addDescriptiveHeader(printWriter, idlObject2);
        }
        Vector vector = ((IdlInterface)idlObject2).getInheritance();
        this.translate_interface_operations(idlObject2, file);
        File file2 = null;
        file2 = !this.isEmptyInterface(idlObject2) ? this.createDirectory(idlObject2.name() + "Package", file) : file;
        if (!((IdlInterface)idlObject2).abstract_interface()) {
            printWriter.print("public interface " + idlObject2.name() + " extends " + idlObject2.name() + "Operations");
            if (vector.size() != 0) {
                int n = 0;
                while (n < vector.size()) {
                    printWriter.print(", " + this.fullname((IdlObject)vector.get(n)));
                    ++n;
                }
            }
            printWriter.println(", org.omg.CORBA.Object, org.omg.CORBA.portable.IDLEntity");
            printWriter.println("{");
        }
        String string = this.current_pkg;
        this.addToPkg(idlObject2, idlObject2.name() + "Package");
        idlObject2.reset();
        while (!idlObject2.end()) {
            switch (idlObject2.current().kind()) {
                case 2: {
                    this.translate_enum(idlObject2.current(), file2);
                    break;
                }
                case 3: {
                    this.translate_struct(idlObject2.current(), file2);
                    break;
                }
                case 4: {
                    this.translate_union(idlObject2.current(), file2);
                    break;
                }
                case 13: {
                    this.translate_typedef(idlObject2.current(), file2);
                    break;
                }
                case 14: {
                    this.translate_exception(idlObject2.current(), file2);
                    break;
                }
                case 25: {
                    this.translate_native(idlObject2.current(), file2);
                    break;
                }
                case 7: {
                    if (((IdlInterface)idlObject2).abstract_interface()) break;
                    this.translate_constant(idlObject2.current(), null, printWriter);
                }
            }
            idlObject2.next();
        }
        if (!((IdlInterface)idlObject2).abstract_interface()) {
            printWriter.println("}");
            printWriter.close();
        }
        this.current_pkg = string;
        this.write_helper(idlObject2, file);
        this.write_holder(idlObject2, file);
    }

    public void translate_user_interface(IdlObject idlObject2, File file) {
        PrintWriter printWriter = this.newFile(this.initial, idlObject2.name() + "Impl");
        printWriter.println("//");
        printWriter.println("// Interface implementation definition : " + idlObject2.name());
        printWriter.println("//");
        printWriter.println("// !!!! THIS CODE MUST BE COMPLETED TO BE USED !!!");
        printWriter.println("//");
        if (!IdlCompiler.pidl) {
            if (IdlCompiler.map_poa) {
                if (idlObject2.upper().upper() != null) {
                    printWriter.println("public class " + idlObject2.name() + "Impl extends " + this.fullname(idlObject2.upper()) + "." + idlObject2.name() + "POA");
                } else {
                    printWriter.println("public class " + idlObject2.name() + "Impl extends " + idlObject2.name() + "POA");
                }
            } else if (idlObject2.upper().upper() != null) {
                printWriter.println("public class " + idlObject2.name() + "Impl extends " + this.fullname(idlObject2.upper()) + "._" + idlObject2.name() + "ImplBase");
            } else {
                printWriter.println("public class " + idlObject2.name() + "Impl extends _" + idlObject2.name() + "ImplBase");
            }
        } else {
            printWriter.println("public class " + idlObject2.name() + "Impl implements " + this.fullname(idlObject2) + "Operations");
        }
        printWriter.println("{");
        String string = this.current_pkg;
        this.addToPkg(idlObject2, idlObject2.name() + "Package");
        idlObject2.reset();
        while (!idlObject2.end()) {
            switch (idlObject2.current().kind()) {
                case 16: {
                    this.translate_user_operation(idlObject2.current(), printWriter);
                    break;
                }
                case 17: {
                    this.translate_user_attribute(idlObject2.current(), printWriter);
                }
            }
            idlObject2.next();
        }
        printWriter.println("}");
        printWriter.close();
        this.current_pkg = string;
    }

    public boolean isInto(List list, IdlObject idlObject2) {
        int n = 0;
        while (n < list.size()) {
            IdlObject idlObject3 = (IdlObject)list.get(n);
            if (idlObject2.name().equals(idlObject3.name()) && idlObject2.kind() == idlObject3.kind()) {
                IdlOp idlOp;
                idlParameter[] idlParameterArray;
                IdlOp idlOp2;
                idlParameter[] idlParameterArray2;
                if (idlObject2.kind() == 17) {
                    return true;
                }
                if (idlObject2.kind() == 16 && (idlParameterArray2 = (idlOp2 = (IdlOp)idlObject2).parameters()).length == (idlParameterArray = (idlOp = (IdlOp)idlObject3).parameters()).length) {
                    boolean bl = true;
                    int n2 = 0;
                    while (n2 < idlParameterArray2.length) {
                        if (((IdlObject)((Object)idlParameterArray2[n2])).kind() != ((IdlObject)((Object)idlParameterArray2[n2])).kind()) {
                            bl = false;
                        }
                        ++n2;
                    }
                    if (bl) {
                        return true;
                    }
                }
            }
            ++n;
        }
        return false;
    }

    protected List getInheritanceOpList(IdlObject idlObject2, List list) {
        Vector vector = ((IdlInterface)idlObject2).getInheritance();
        idlObject2.reset();
        while (!idlObject2.end()) {
            switch (idlObject2.current().kind()) {
                case 16: 
                case 17: {
                    if (this.isInto(list, idlObject2.current())) break;
                    list.add(idlObject2.current());
                }
            }
            idlObject2.next();
        }
        int n = 0;
        while (n < vector.size()) {
            if (vector.get(n) instanceof IdlInterface) {
                IdlInterface idlInterface2 = (IdlInterface)vector.get(n);
                if (idlInterface2.kind() == 18) {
                    idlInterface2 = idlInterface2.getInterface();
                }
                list = this.getInheritanceOpList(idlInterface2, list);
            }
            ++n;
        }
        return list;
    }

    protected List getInheritanceList(IdlObject idlObject2, List list) {
        if (!(idlObject2 instanceof IdlInterface)) {
            return list;
        }
        IdlInterface idlInterface2 = (IdlInterface)idlObject2;
        if (idlInterface2.isForward()) {
            idlInterface2 = idlInterface2.getInterface();
        }
        Vector vector = idlInterface2.getInheritance();
        boolean bl = false;
        int n = 0;
        while (n < list.size()) {
            if (((String)list.get(n)).equals(idlObject2.getId())) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            list.add(idlObject2.getId());
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            list = this.getInheritanceList((IdlObject)vector.get(n2), list);
            ++n2;
        }
        return list;
    }

    protected List getImportList(IdlObject idlObject2) {
        if (idlObject2 == null || idlObject2._list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < idlObject2._list.size()) {
            IdlInclude idlInclude;
            if ((IdlObject)idlObject2._list.get(n) instanceof IdlInclude && !(idlInclude = (IdlInclude)idlObject2._list.get(n)).file_name().equals("") && idlInclude.file_name().indexOf(File.separatorChar) <= 0) {
                String string = idlInclude.file_name();
                if (string.endsWith("Ex")) {
                    string = string + "ception";
                }
                arrayList.add(string);
            }
            ++n;
        }
        return arrayList;
    }

    private String initialName(String string) {
        if (string.startsWith("_")) {
            return string.substring(1, string.length());
        }
        return string;
    }

    public void translate_interface_stub(IdlObject idlObject2, File file) {
        int n;
        PrintWriter printWriter = this.newFile(file, "_" + idlObject2.name() + "Stub");
        List list = new ArrayList();
        list = this.getInheritanceList(idlObject2, list);
        this.addDescriptiveHeader(printWriter, idlObject2);
        printWriter.println("public class _" + idlObject2.name() + "Stub extends org.omg.CORBA.portable.ObjectImpl");
        printWriter.print("        implements " + idlObject2.name());
        printWriter.println("");
        printWriter.println("{");
        List list2 = this.getInheritanceOpList(idlObject2, new ArrayList());
        printWriter.println("    static final String[] _ids_list =");
        printWriter.println("    {");
        if (list.size() != 0) {
            n = 0;
            while (n < list.size()) {
                printWriter.print("        \"" + (String)list.get(n) + "\"");
                if (n + 1 < list.size()) {
                    printWriter.println(", ");
                }
                ++n;
            }
        }
        printWriter.println("");
        printWriter.println("    };");
        printWriter.println("");
        printWriter.println("    public String[] _ids()");
        printWriter.println("    {");
        printWriter.println("     return _ids_list;");
        printWriter.println("    }");
        printWriter.println("");
        if (!IdlCompiler.dynamic && IdlCompiler.local_stub) {
            if (!((IdlInterface)idlObject2).abstract_interface()) {
                printWriter.println("    private final static Class _opsClass = " + this.fullname(idlObject2) + "Operations.class;");
            } else {
                printWriter.println("    private final static Class _opsClass = " + this.fullname(idlObject2) + ".class;");
            }
            printWriter.println("");
        }
        String string = this.current_pkg;
        this.addToPkg(idlObject2, idlObject2.name() + "Package");
        n = 0;
        while (n < list2.size()) {
            switch (((IdlObject)list2.get(n)).kind()) {
                case 16: {
                    if (IdlCompiler.dynamic) {
                        this.translate_operation_stub((IdlObject)list2.get(n), printWriter);
                        break;
                    }
                    this.translate_operation_stub_stream((IdlObject)list2.get(n), printWriter);
                    break;
                }
                case 17: {
                    if (IdlCompiler.dynamic) {
                        this.translate_attribute_stub((IdlObject)list2.get(n), printWriter);
                        break;
                    }
                    this.translate_attribute_stub_stream((IdlObject)list2.get(n), printWriter);
                }
            }
            ++n;
        }
        printWriter.println("}");
        printWriter.close();
        this.current_pkg = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void translate_interface_skel(IdlObject idlObject2, File file) {
        String string;
        int n;
        int n2;
        PrintWriter printWriter = null;
        String string2 = !IdlCompiler.map_poa ? "_" + idlObject2.name() + "ImplBase" : idlObject2.name() + "POA";
        printWriter = this.newFile(file, string2);
        List list = new ArrayList();
        list = this.getInheritanceList(idlObject2, list);
        this.addDescriptiveHeader(printWriter, idlObject2);
        if (!IdlCompiler.map_poa) {
            if (IdlCompiler.dynamic) {
                printWriter.println("public abstract class " + string2 + " extends org.omg.CORBA.DynamicImplementation");
            } else {
                printWriter.println("public abstract class " + string2 + " extends org.omg.CORBA.portable.ObjectImpl");
            }
            printWriter.print("        implements " + idlObject2.name());
            if (!IdlCompiler.dynamic) {
                printWriter.print(", org.omg.CORBA.portable.InvokeHandler");
            }
            printWriter.println("");
        } else {
            if (IdlCompiler.dynamic) {
                printWriter.println("public abstract class " + string2 + " extends org.omg.PortableServer.DynamicImplementation");
            } else {
                printWriter.println("public abstract class " + string2 + " extends org.omg.PortableServer.Servant");
            }
            printWriter.print("        implements " + idlObject2.name() + "Operations");
            if (!IdlCompiler.dynamic) {
                printWriter.print(", org.omg.CORBA.portable.InvokeHandler");
            }
            printWriter.println("");
        }
        printWriter.println("{");
        List list2 = this.getInheritanceOpList(idlObject2, new ArrayList());
        if (!IdlCompiler.map_poa) {
            printWriter.println("    static final String[] _ids_list = ");
            printWriter.println("    {");
            if (list.size() != 0) {
                n2 = 0;
                while (n2 < list.size()) {
                    printWriter.print("        \"" + (String)list.get(n2) + "\"");
                    if (n2 + 1 < list.size()) {
                        printWriter.println(", ");
                    }
                    ++n2;
                }
            }
            printWriter.println("");
            printWriter.println("    };");
            printWriter.println("");
            printWriter.println("    public String[] _ids()");
            printWriter.println("    {");
            printWriter.println("     return _ids_list;");
            printWriter.println("    }");
            printWriter.println("");
        } else {
            printWriter.println("    public " + idlObject2.name() + " _this()");
            printWriter.println("    {");
            printWriter.println("        return " + idlObject2.name() + "Helper.narrow(_this_object());");
            printWriter.println("    }");
            printWriter.println("");
            printWriter.println("    public " + idlObject2.name() + " _this(org.omg.CORBA.ORB orb)");
            printWriter.println("    {");
            printWriter.println("        return " + idlObject2.name() + "Helper.narrow(_this_object(orb));");
            printWriter.println("    }");
            printWriter.println("");
            printWriter.println("    private static String [] _ids_list =");
            printWriter.println("    {");
            if (list.size() != 0) {
                n2 = 0;
                while (n2 < list.size()) {
                    printWriter.print("        \"" + (String)list.get(n2) + "\"");
                    if (n2 + 1 < list.size()) {
                        printWriter.println(", ");
                    }
                    ++n2;
                }
            }
            printWriter.println("");
            printWriter.println("    };");
            printWriter.println("");
            printWriter.println("    public String[] _all_interfaces(org.omg.PortableServer.POA poa, byte [] objectId)");
            printWriter.println("    {");
            printWriter.println("        return _ids_list;");
            printWriter.println("    }");
            printWriter.println("");
        }
        int n3 = n2 = IdlCompiler.minTableSize <= list2.size() ? 1 : 0;
        if (IdlCompiler.useReflection) {
            printWriter.println("    private static final Class[] operationTypes = {");
            if (IdlCompiler.dynamic) {
                printWriter.println("            org.omg.CORBA.ServerRequest.class};");
            } else {
                printWriter.println("            org.omg.CORBA.portable.InputStream.class,");
                printWriter.println("            org.omg.CORBA.portable.ResponseHandler.class};");
            }
            printWriter.println();
        }
        String[] stringArray = this.sortIntoArray(list2);
        if (n2 != 0) {
            if (IdlCompiler.useReflection) {
                printWriter.println("    private static final java.util.Map operationMap = new java.util.HashMap();");
                printWriter.println();
                printWriter.println("    static {");
                printWriter.println("        try {");
                printWriter.println("            final Class clazz = " + string2 + ".class;");
                n = 0;
                while (n < stringArray.length) {
                    string = stringArray[n];
                    printWriter.println("            operationMap.put(\"" + string + "\",");
                    printWriter.println("                    clazz.getDeclaredMethod(\"_invoke_" + string + "\", operationTypes));");
                    ++n;
                }
                printWriter.println("        } catch (final NoSuchMethodException e) {");
                this.writeThrowException(printWriter, tab3, "Error", "\"Error constructing operation table\"", "e");
                printWriter.println("        }");
            } else if (IdlCompiler.useClasses) {
                printWriter.println("    private static final java.util.Map operationMap = new java.util.HashMap();");
                printWriter.println();
                printWriter.println("    static {");
                n = 0;
                while (n < stringArray.length) {
                    string = stringArray[n];
                    printWriter.println("            operationMap.put(\"" + string + "\",");
                    printWriter.println("                    new Operation_" + string + "());");
                    ++n;
                }
            } else {
                if (!IdlCompiler.useSwitch) throw new Error("IllegalCondition");
                printWriter.println("    private static final String[] operationNames = new String[" + stringArray.length + "];");
                printWriter.println();
                printWriter.println("    static {");
                n = 0;
                while (n < stringArray.length) {
                    printWriter.println("        operationNames[" + n + "] = \"" + stringArray[n] + "\";");
                    ++n;
                }
            }
            printWriter.println("    }");
            printWriter.println("");
        }
        if (IdlCompiler.dynamic) {
            printWriter.println("    public final void invoke (final org.omg.CORBA.ServerRequest request)");
            printWriter.println("    {");
            printWriter.println("        final String opName = request.operation();");
        } else {
            printWriter.println("    public final org.omg.CORBA.portable.OutputStream _invoke(final String opName,");
            printWriter.println("            final org.omg.CORBA.portable.InputStream _is,");
            printWriter.println("            final org.omg.CORBA.portable.ResponseHandler handler)");
            printWriter.println("    {");
        }
        printWriter.println();
        if (n2 != 0) {
            if (IdlCompiler.useReflection) {
                printWriter.println("        final java.lang.reflect.Method operation = (java.lang.reflect.Method)operationMap.get(opName);");
                printWriter.println();
                printWriter.println("        if (null == operation) {");
                printWriter.println("            throw new org.omg.CORBA.BAD_OPERATION(opName);");
                printWriter.println("        }");
                printWriter.println();
                printWriter.println("        try {");
                if (IdlCompiler.dynamic) {
                    printWriter.println("            operation.invoke(this, new Object[] {(Object)request});");
                    printWriter.println("            return;");
                } else {
                    printWriter.println("            return (org.omg.CORBA.portable.OutputStream)operation.invoke(this, new Object[] {(Object)_is, (Object)handler});");
                }
                printWriter.println("        } catch (final IllegalAccessException e) {");
                this.writeThrowException(printWriter, tab3, "Error", "e.getMessage()", "e");
                printWriter.println("        } catch (final java.lang.reflect.InvocationTargetException e) {");
                printWriter.println("            if (e.getTargetException() instanceof RuntimeException) {");
                printWriter.println("                throw (RuntimeException)e.getTargetException();");
                printWriter.println("            }");
                printWriter.println("            if (e.getTargetException() instanceof Error) {");
                printWriter.println("                throw (Error)e.getTargetException();");
                printWriter.println("            }");
                this.writeThrowException(printWriter, tab3, "Error", "e.getMessage()", "e");
                printWriter.println("        }");
            } else if (IdlCompiler.useClasses) {
                printWriter.println("        final AbstractOperation operation = (AbstractOperation)operationMap.get(opName);");
                printWriter.println();
                printWriter.println("        if (null == operation) {");
                printWriter.println("            throw new org.omg.CORBA.BAD_OPERATION(opName);");
                printWriter.println("        }");
                printWriter.println();
                if (IdlCompiler.dynamic) {
                    printWriter.println("        operation.invoke(this, request);");
                } else {
                    printWriter.println("        return operation.invoke(this, _is, handler);");
                }
            } else {
                if (!IdlCompiler.useSwitch) throw new Error("IllegalCondition");
                printWriter.println("        final int index = java.util.Arrays.binarySearch(operationNames, opName);");
                printWriter.println("        if (index < 0) {");
                printWriter.println("            throw new org.omg.CORBA.BAD_OPERATION(opName);");
                printWriter.println("        }");
                printWriter.println("        switch (index) {");
                n = 0;
                while (n < stringArray.length) {
                    printWriter.println("            case " + n + " :");
                    if (IdlCompiler.dynamic) {
                        printWriter.println("                _invoke_" + stringArray[n] + "(request);");
                        printWriter.println("                return;");
                    } else {
                        printWriter.println("                return _invoke_" + stringArray[n] + "(_is, handler);");
                    }
                    ++n;
                }
                printWriter.println("        }");
                printWriter.println();
                printWriter.println("        throw new Error(\"unreachable code\");");
            }
        } else {
            printWriter.print(tab2);
            n = 0;
            while (n < stringArray.length) {
                string = stringArray[n];
                printWriter.println("if (opName.equals(\"" + string + "\")) {");
                if (IdlCompiler.dynamic) {
                    printWriter.println("                _invoke_" + string + "(request);");
                    printWriter.println("                return;");
                } else {
                    printWriter.println("                return _invoke_" + string + "(_is, handler);");
                }
                printWriter.print("        } else ");
                ++n;
            }
            printWriter.println("{");
            printWriter.println("            throw new org.omg.CORBA.BAD_OPERATION(opName);");
            printWriter.println("        }");
        }
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    // helper methods");
        n = 0;
        while (n < list2.size()) {
            this.writeOperationHelperMethod((IdlObject)list2.get(n), printWriter, IdlCompiler.dynamic);
            ++n;
        }
        if (n2 != 0 && IdlCompiler.useClasses) {
            printWriter.println("    // operation classes");
            printWriter.println("    private abstract static class AbstractOperation {");
            if (IdlCompiler.dynamic) {
                printWriter.println("        protected abstract void invoke(" + string2 + " target,");
                printWriter.println("                org.omg.CORBA.ServerRequest request);");
            } else {
                printWriter.println("        protected abstract org.omg.CORBA.portable.OutputStream invoke(");
                printWriter.println(tab4 + string2 + " target,");
                printWriter.println("                org.omg.CORBA.portable.InputStream _is,");
                printWriter.println("                org.omg.CORBA.portable.ResponseHandler handler);");
            }
            printWriter.println("    }");
            printWriter.println();
            int n4 = 0;
            while (n4 < list2.size()) {
                this.writeOperationHelperClass((IdlObject)list2.get(n4), printWriter, IdlCompiler.dynamic, string2);
                ++n4;
            }
        }
        printWriter.println("}");
        printWriter.close();
    }

    private String[] sortIntoArray(List list) {
        IdlObject idlObject2;
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            idlObject2 = (IdlObject)list.get(n2);
            switch (idlObject2.kind()) {
                case 16: {
                    ++n;
                    break;
                }
                case 17: {
                    n += !((IdlAttribute)idlObject2).readOnly() ? 2 : 1;
                }
            }
            ++n2;
        }
        Object[] objectArray = new String[n];
        n = 0;
        n2 = 0;
        while (n < list.size()) {
            idlObject2 = (IdlObject)list.get(n);
            String string = this.initialName(idlObject2.name());
            switch (idlObject2.kind()) {
                case 16: {
                    objectArray[n2++] = string;
                    break;
                }
                case 17: {
                    objectArray[n2++] = "_get_" + string;
                    if (((IdlAttribute)idlObject2).readOnly()) break;
                    objectArray[n2++] = "_set_" + string;
                }
            }
            ++n;
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    private void writeOperationHelperMethod(IdlObject idlObject2, PrintWriter printWriter, boolean bl) {
        switch (idlObject2.kind()) {
            case 16: {
                this.writeOperationHelperMethodHeader(idlObject2, printWriter, bl, "");
                if (bl) {
                    this.translate_operation_skel(idlObject2, printWriter);
                    break;
                }
                this.translate_operation_skel_stream(idlObject2, printWriter);
                break;
            }
            case 17: {
                this.writeOperationHelperMethodHeader(idlObject2, printWriter, bl, "_get_");
                if (bl) {
                    this.translate_read_attribute_skel(idlObject2, printWriter);
                } else {
                    this.translate_read_attribute_skel_stream(idlObject2, printWriter);
                }
                if (((IdlAttribute)idlObject2).readOnly()) break;
                printWriter.println("    }");
                printWriter.println();
                this.writeOperationHelperMethodHeader(idlObject2, printWriter, bl, "_set_");
                if (bl) {
                    this.translate_write_attribute_skel(idlObject2, printWriter);
                    break;
                }
                this.translate_write_attribute_skel_stream(idlObject2, printWriter);
                break;
            }
            default: {
                throw new Error("Illegal condition");
            }
        }
        printWriter.println("    }");
        printWriter.println();
    }

    private void writeOperationHelperMethodHeader(IdlObject idlObject2, PrintWriter printWriter, boolean bl, String string) {
        String string2 = this.initialName(idlObject2.name());
        if (bl) {
            printWriter.println("    private void _invoke_" + string + string2 + "(");
            printWriter.println("            final org.omg.CORBA.ServerRequest request) {");
            printWriter.println("        final org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();");
        } else {
            printWriter.println("    private org.omg.CORBA.portable.OutputStream _invoke_" + string + string2 + "(");
            printWriter.println("            final org.omg.CORBA.portable.InputStream _is,");
            printWriter.println("            final org.omg.CORBA.portable.ResponseHandler handler) {");
            printWriter.println("        org.omg.CORBA.portable.OutputStream _output;");
        }
    }

    private void writeOperationHelperClass(IdlObject idlObject2, PrintWriter printWriter, boolean bl, String string) {
        String string2 = this.initialName(idlObject2.name());
        switch (idlObject2.kind()) {
            case 16: {
                this.writeOperationHelperClass(printWriter, bl, string, string2, "");
                break;
            }
            case 17: {
                this.writeOperationHelperClass(printWriter, bl, string, string2, "_get_");
                if (((IdlAttribute)idlObject2).readOnly()) break;
                this.writeOperationHelperClass(printWriter, bl, string, string2, "_set_");
            }
        }
    }

    private void writeOperationHelperClass(PrintWriter printWriter, boolean bl, String string, String string2, String string3) {
        printWriter.println("    private static final class Operation_" + string3 + string2 + " extends AbstractOperation");
        printWriter.println("    {");
        if (bl) {
            printWriter.println("        protected void invoke(");
            printWriter.println("                final " + string + " target,");
            printWriter.println("                final org.omg.CORBA.ServerRequest request) {");
            printWriter.println("            _invoke_" + string3 + string2 + "(request);");
        } else {
            printWriter.println("        protected org.omg.CORBA.portable.OutputStream invoke(");
            printWriter.println("                final " + string + " target,");
            printWriter.println("                final org.omg.CORBA.portable.InputStream _is,");
            printWriter.println("                final org.omg.CORBA.portable.ResponseHandler handler) {");
            printWriter.println("            return target._invoke_" + string3 + string2 + "(_is, handler);");
        }
        printWriter.println("        }");
        printWriter.println("    }");
        printWriter.println();
    }

    public void translate_interface_tie(IdlObject idlObject2, File file) {
        PrintWriter printWriter = null;
        printWriter = !IdlCompiler.map_poa ? this.newFile(file, idlObject2.name() + "Tie") : this.newFile(file, idlObject2.name() + "POATie");
        this.addDescriptiveHeader(printWriter, idlObject2);
        if (!IdlCompiler.map_poa) {
            printWriter.println("public class " + idlObject2.name() + "Tie extends _" + idlObject2.name() + "ImplBase");
        } else {
            printWriter.println("public class " + idlObject2.name() + "POATie extends " + idlObject2.name() + "POA");
        }
        printWriter.println("{");
        printWriter.println("");
        printWriter.println("    //");
        printWriter.println("    // Private reference to implementation object");
        printWriter.println("    //");
        printWriter.println("    private " + idlObject2.name() + "Operations _tie;");
        printWriter.println("");
        if (IdlCompiler.map_poa) {
            printWriter.println("    //");
            printWriter.println("    // Private reference to POA");
            printWriter.println("    //");
            printWriter.println("    private org.omg.PortableServer.POA _poa;");
            printWriter.println("");
        }
        printWriter.println("    /**");
        printWriter.println("     * Constructor");
        printWriter.println("     */");
        if (!IdlCompiler.map_poa) {
            printWriter.println("    public " + idlObject2.name() + "Tie(" + idlObject2.name() + "Operations tieObject)");
        } else {
            printWriter.println("    public " + idlObject2.name() + "POATie(" + idlObject2.name() + "Operations tieObject)");
        }
        printWriter.println("    {");
        printWriter.println("        _tie = tieObject;");
        printWriter.println("    }");
        printWriter.println("");
        if (IdlCompiler.map_poa) {
            printWriter.println("    /**");
            printWriter.println("     * Constructor");
            printWriter.println("     */");
            printWriter.println("    public " + idlObject2.name() + "POATie(" + idlObject2.name() + "Operations tieObject, org.omg.PortableServer.POA poa)");
            printWriter.println("    {");
            printWriter.println("        _tie = tieObject;");
            printWriter.println("        _poa = poa;");
            printWriter.println("    }");
            printWriter.println("");
        }
        printWriter.println("    /**");
        printWriter.println("     * Get the delegate");
        printWriter.println("     */");
        printWriter.println("    public " + idlObject2.name() + "Operations _delegate()");
        printWriter.println("    {");
        printWriter.println("        return _tie;");
        printWriter.println("    }");
        printWriter.println("");
        printWriter.println("    /**");
        printWriter.println("     * Set the delegate");
        printWriter.println("     */");
        printWriter.println("    public void _delegate(" + idlObject2.name() + "Operations delegate_)");
        printWriter.println("    {");
        printWriter.println("        _tie = delegate_;");
        printWriter.println("    }");
        printWriter.println("");
        if (IdlCompiler.map_poa) {
            printWriter.println("    /**");
            printWriter.println("     * _default_POA method");
            printWriter.println("     */");
            printWriter.println("    public org.omg.PortableServer.POA _default_POA()");
            printWriter.println("    {");
            printWriter.println("        if (_poa != null)");
            printWriter.println("            return _poa;");
            printWriter.println("        else");
            printWriter.println("            return super._default_POA();");
            printWriter.println("    }");
            printWriter.println("");
        }
        List list = this.getInheritanceOpList(idlObject2, new ArrayList());
        int n = 0;
        while (n < list.size()) {
            switch (((IdlObject)list.get(n)).kind()) {
                case 16: {
                    this.translate_operation_tie((IdlObject)list.get(n), printWriter);
                    break;
                }
                case 17: {
                    this.translate_attribute_tie((IdlObject)list.get(n), printWriter);
                }
            }
            ++n;
        }
        printWriter.println("}");
        printWriter.close();
    }

    public void translate_module(IdlObject idlObject2, File file, int n) {
        File file2 = n == 0 ? this.createDirectory(idlObject2.name(), file) : this.getDirectory(idlObject2.name(), file);
        String string = this.current_pkg;
        this.addToPkg(idlObject2, idlObject2.name());
        this.translate_object(idlObject2, file2, n);
        this.current_pkg = string;
    }

    public void translate_user_module(IdlObject idlObject2, File file) {
        if (idlObject2.getPrefix() != null) {
            file = this.getPrefixDirectories(idlObject2.getPrefix(), file);
        }
        File file2 = this.getDirectory(idlObject2.name(), file);
        String string = this.current_pkg;
        if (idlObject2.getPrefix() != null) {
            if (IdlCompiler.reversePrefix) {
                this.addToPkg(idlObject2, this.inversedPrefix(idlObject2.getPrefix()) + "." + idlObject2.name());
            } else {
                this.addToPkg(idlObject2, idlObject2.getPrefix() + "." + idlObject2.name());
            }
        } else {
            this.addToPkg(idlObject2, idlObject2.name());
        }
        this.translate_user_object(idlObject2, file2);
        this.current_pkg = string;
    }

    public void translate_state_member(IdlObject idlObject2, PrintWriter printWriter) {
        IdlStateMember idlStateMember = (IdlStateMember)idlObject2;
        if (idlObject2.hasComment()) {
            this.javadoc(printWriter, idlObject2);
        } else {
            printWriter.println("    /**");
            if (idlStateMember.public_member()) {
                printWriter.println("     *  Public member : " + idlObject2.name());
            } else {
                printWriter.println("     * Private member : " + idlObject2.name());
            }
            printWriter.println("     */");
        }
        if (idlStateMember.public_member()) {
            printWriter.print("     public ");
        } else {
            printWriter.print("     protected ");
        }
        idlObject2.reset();
        this.translate_type(idlObject2.current(), printWriter);
        printWriter.println(" " + idlObject2.name() + ";");
        printWriter.println("");
    }

    private List getInheritedStateMember(IdlObject idlObject2) {
        ArrayList arrayList = new ArrayList();
        List list = null;
        IdlValue[] idlValueArray = ((IdlValue)idlObject2).getInheritance();
        if (idlValueArray.length != 0) {
            list = this.getInheritedStateMember(idlValueArray[0]);
        }
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                arrayList.add(list.get(n));
                ++n;
            }
        }
        idlObject2.reset();
        while (!idlObject2.end()) {
            if (idlObject2.current().kind() == 29) {
                arrayList.add(idlObject2.current());
            }
            idlObject2.next();
        }
        return arrayList;
    }

    public void translate_value_type(IdlObject idlObject2, File file) {
        IdlValue idlValue2 = (IdlValue)idlObject2;
        boolean bl = false;
        PrintWriter printWriter = this.newFile(file, idlObject2.name());
        this.addDescriptiveHeader(printWriter, idlObject2);
        if (idlValue2.abstract_value()) {
            Serializable serializable;
            printWriter.print("public interface " + idlObject2.name() + " extends org.omg.CORBA.portable.ValueBase");
            IdlValue[] idlValueArray = idlValue2.getInheritance();
            if (idlValueArray.length != 0) {
                printWriter.print(", ");
            }
            int n = 0;
            while (n < idlValueArray.length) {
                printWriter.print(this.fullname(idlValueArray[n]));
                if (n + 1 < idlValueArray.length) {
                    printWriter.print(", ");
                }
                ++n;
            }
            printWriter.println();
            if (idlValue2.supports().size() != 0) {
                printWriter.print("        , ");
                serializable = idlValue2.supports();
                int n2 = 0;
                while (n2 < serializable.size()) {
                    IdlInterface idlInterface2 = (IdlInterface)serializable.get(n2);
                    printWriter.print(this.fullname(idlInterface2));
                    if (!idlInterface2.abstract_interface()) {
                        printWriter.print("Operations");
                    }
                    if (n2 + 1 < serializable.size()) {
                        printWriter.print(", ");
                    }
                    ++n2;
                }
            }
            printWriter.println("{");
            serializable = null;
            serializable = !this.isEmptyValue(idlObject2) ? this.createDirectory(idlObject2.name() + "Package", file) : file;
            String string = this.current_pkg;
            this.addToPkg(idlObject2, idlObject2.name() + "Package");
            idlObject2.reset();
            while (!idlObject2.end()) {
                switch (idlObject2.current().kind()) {
                    case 2: {
                        this.translate_enum(idlObject2.current(), (File)serializable);
                        break;
                    }
                    case 3: {
                        this.translate_struct(idlObject2.current(), (File)serializable);
                        break;
                    }
                    case 4: {
                        this.translate_union(idlObject2.current(), (File)serializable);
                        break;
                    }
                    case 13: {
                        this.translate_typedef(idlObject2.current(), (File)serializable);
                        break;
                    }
                    case 14: {
                        this.translate_exception(idlObject2.current(), (File)serializable);
                        break;
                    }
                    case 25: {
                        this.translate_native(idlObject2.current(), (File)serializable);
                        break;
                    }
                    case 7: {
                        this.translate_constant(idlObject2.current(), null, printWriter);
                        break;
                    }
                    case 16: {
                        this.translate_operation(idlObject2.current(), printWriter);
                        break;
                    }
                    case 17: {
                        this.translate_attribute(idlObject2.current(), printWriter);
                    }
                }
                idlObject2.next();
            }
            this.current_pkg = string;
            printWriter.println("}");
            printWriter.println("");
            printWriter.close();
        } else {
            int n;
            int n3;
            int n4;
            int n5;
            Object object;
            printWriter.print("public abstract class " + idlObject2.name());
            if (idlValue2.supports().size() == 0 && idlValue2.getInheritance().length == 0) {
                if (idlValue2.custom_value()) {
                    printWriter.println(" implements org.omg.CORBA.portable.CustomValue");
                } else {
                    printWriter.println(" implements org.omg.CORBA.portable.StreamableValue");
                }
            } else {
                int n6;
                object = idlValue2.getInheritance();
                boolean bl2 = false;
                n5 = 0;
                if (((IdlValue[])object).length == 0) {
                    n5 = 1;
                }
                if (((IdlValue[])object).length != 0) {
                    bl2 = true;
                }
                n4 = 0;
                while (n4 < ((IdlValue[])object).length) {
                    if (object[n4].custom_value()) {
                        bl = true;
                    }
                    ++n4;
                }
                if (!bl2 && idlValue2.supports().size() == 0) {
                    printWriter.print(" implements org.omg.CORBA.portable.StreamableValue");
                }
                boolean bl3 = false;
                n3 = 0;
                n = 0;
                while (n < ((IdlValue[])object).length) {
                    if (!object[n].abstract_value()) {
                        bl3 = true;
                    } else {
                        n3 = 1;
                    }
                    ++n;
                }
                if (bl2) {
                    int n7;
                    if (bl3) {
                        printWriter.print(" extends ");
                        n6 = 0;
                        n7 = 0;
                        while (n7 < ((IdlValue[])object).length) {
                            if (!object[n7].abstract_value()) {
                                if (++n6 > 1) {
                                    printWriter.print(", ");
                                }
                                printWriter.print(this.fullname(object[n7]));
                            }
                            ++n7;
                        }
                    }
                    if (n3 != 0) {
                        printWriter.print(" implements ");
                        n6 = 0;
                        n7 = 0;
                        while (n7 < ((IdlValue[])object).length) {
                            if (object[n7].abstract_value()) {
                                if (++n6 > 1) {
                                    printWriter.print(", ");
                                }
                                printWriter.print(this.fullname(object[n7]));
                            }
                            ++n7;
                        }
                        if (!bl3) {
                            printWriter.print(", org.omg.CORBA.portable.StreamableValue");
                        }
                    }
                }
                if (n3 == 0 || idlValue2.supports().size() == 0) {
                    printWriter.println("");
                }
                n6 = 0;
                if (idlValue2.custom_value() && !bl) {
                    printWriter.print("        implements org.omg.CORBA.portable.CustomValue");
                    n6 = 1;
                }
                if (idlValue2.supports().size() != 0) {
                    if (n6 != 0) {
                        printWriter.print(", ");
                    } else {
                        if (n3 == 0) {
                            printWriter.print("        implements ");
                        } else {
                            printWriter.print(", ");
                        }
                        if (n5 != 0) {
                            printWriter.print("org.omg.CORBA.portable.StreamableValue, ");
                        }
                    }
                    Vector vector = idlValue2.supports();
                    int n8 = 0;
                    while (n8 < vector.size()) {
                        IdlInterface idlInterface3 = (IdlInterface)vector.get(n8);
                        printWriter.print(idlInterface3.name());
                        if (!idlInterface3.abstract_interface()) {
                            printWriter.print("Operations");
                        }
                        if (n8 + 1 < vector.size()) {
                            printWriter.print(", ");
                        }
                        ++n8;
                    }
                }
                printWriter.println("");
            }
            printWriter.println("{");
            object = null;
            object = !this.isEmptyValue(idlObject2) ? this.createDirectory(idlObject2.name() + "Package", file) : file;
            String string = this.current_pkg;
            this.addToPkg(idlObject2, idlObject2.name() + "Package");
            idlObject2.reset();
            while (!idlObject2.end()) {
                switch (idlObject2.current().kind()) {
                    case 2: {
                        this.translate_enum(idlObject2.current(), (File)object);
                        break;
                    }
                    case 3: {
                        this.translate_struct(idlObject2.current(), (File)object);
                        break;
                    }
                    case 4: {
                        this.translate_union(idlObject2.current(), (File)object);
                        break;
                    }
                    case 13: {
                        this.translate_typedef(idlObject2.current(), (File)object);
                        break;
                    }
                    case 14: {
                        this.translate_exception(idlObject2.current(), (File)object);
                        break;
                    }
                    case 25: {
                        this.translate_native(idlObject2.current(), (File)object);
                        break;
                    }
                    case 7: {
                        this.translate_constant(idlObject2.current(), null, printWriter);
                        break;
                    }
                    case 16: {
                        this.translate_operation(idlObject2.current(), printWriter);
                        break;
                    }
                    case 17: {
                        this.translate_attribute(idlObject2.current(), printWriter);
                        break;
                    }
                    case 29: {
                        this.translate_state_member(idlObject2.current(), printWriter);
                    }
                }
                idlObject2.next();
            }
            this.current_pkg = string;
            printWriter.println("    /**");
            printWriter.println("     * Return the truncatable ids");
            printWriter.println("     */");
            printWriter.println("    static final String[] _ids_list =");
            printWriter.println("    {");
            String[] stringArray = idlValue2.truncatableList();
            n5 = stringArray.length;
            if (!idlValue2.isTruncatable()) {
                n5 = 1;
            }
            n4 = 0;
            while (n4 < n5) {
                printWriter.print("        \"" + stringArray[n4] + "\"");
                if (n4 + 1 < stringArray.length) {
                    printWriter.print(",");
                }
                printWriter.println("");
                ++n4;
            }
            printWriter.println("    };");
            printWriter.println("");
            printWriter.println("    public String [] _truncatable_ids()");
            printWriter.println("    {");
            printWriter.println("        return _ids_list;");
            printWriter.println("    }");
            printWriter.println("");
            if (!idlValue2.custom_value() && !bl) {
                printWriter.println("    /**");
                printWriter.println("     * Unmarshal the value into an InputStream");
                printWriter.println("     */");
                printWriter.println("    public void _read(org.omg.CORBA.portable.InputStream is)");
                printWriter.println("    {");
                List list = this.getInheritedStateMember(idlObject2);
                n3 = 0;
                while (n3 < list.size()) {
                    IdlStateMember idlStateMember = (IdlStateMember)list.get(n3);
                    idlStateMember.reset();
                    this.translate_unmarshalling_member(idlStateMember.current(), printWriter, "is", idlStateMember.name(), tab2);
                    ++n3;
                }
                printWriter.println("    }");
                printWriter.println("");
                printWriter.println("    /**");
                printWriter.println("     * Marshal the value into an OutputStream");
                printWriter.println("     */");
                printWriter.println("     public void _write(org.omg.CORBA.portable.OutputStream os)");
                printWriter.println("     {");
                n = 0;
                while (n < list.size()) {
                    IdlStateMember idlStateMember = (IdlStateMember)list.get(n);
                    idlStateMember.reset();
                    this.translate_marshalling_member(idlStateMember.current(), printWriter, "os", idlStateMember.name(), tab2);
                    ++n;
                }
                printWriter.println("    }");
                printWriter.println("");
                printWriter.println("    /**");
                printWriter.println("     * Return the value TypeCode");
                printWriter.println("     */");
                printWriter.println("     public org.omg.CORBA.TypeCode _type()");
                printWriter.println("     {");
                printWriter.println("        return " + this.fullname(idlObject2) + "Helper.type();");
                printWriter.println("     }");
                printWriter.println("");
            }
            printWriter.println("}");
            printWriter.println("");
            printWriter.close();
            boolean bl4 = false;
            idlObject2.reset();
            while (!idlObject2.end()) {
                if (idlObject2.current().kind() == 30) {
                    bl4 = true;
                    break;
                }
                idlObject2.next();
            }
            if (bl4) {
                printWriter = this.newFile(file, idlObject2.name() + "ValueFactory");
                this.addDescriptiveHeader(printWriter, idlObject2.current());
                printWriter.println("public interface " + idlObject2.name() + "ValueFactory extends org.omg.CORBA.portable.ValueFactory");
                printWriter.println("{");
                idlObject2.reset();
                while (!idlObject2.end()) {
                    if (idlObject2.current().kind() == 30) {
                        printWriter.println("    /**");
                        printWriter.println("     * Return the value type");
                        printWriter.println("     */");
                        printWriter.print("     public abstract " + this.fullname(idlObject2) + " " + idlObject2.current().name() + "(");
                        idlObject2.current().reset();
                        while (!idlObject2.current().end()) {
                            IdlFactoryMember idlFactoryMember = (IdlFactoryMember)idlObject2.current().current();
                            idlFactoryMember.reset();
                            this.translate_type(idlFactoryMember.current(), printWriter);
                            printWriter.print(" " + idlFactoryMember.name());
                            idlObject2.current().next();
                            if (idlObject2.current().end()) continue;
                            printWriter.print(", ");
                        }
                        printWriter.println(");");
                        printWriter.println("");
                    }
                    idlObject2.next();
                }
                printWriter.println("}");
                printWriter.println("");
                printWriter.close();
            }
        }
        this.write_holder(idlObject2, file);
        this.write_helper(idlObject2, file);
        this.writeDefaultValueFactory((IdlValue)idlObject2, file);
        this.writeDefaultValueImpl((IdlValue)idlObject2, file);
    }

    public void writeDefaultValueFactory(IdlValue idlValue2, File file) {
        if (idlValue2.isAbstract() || idlValue2.isCustom() || null == IdlCompiler.generateValueFactory) {
            return;
        }
        String string = idlValue2.name() + "DefaultFactory";
        String string2 = idlValue2.name() + IdlCompiler.generateValueFactory;
        PrintWriter printWriter = this.newFile(file, string);
        this.addPackageName(printWriter);
        printWriter.println("// " + this.fullname(idlValue2));
        printWriter.println("public class " + string + " implements org.omg.CORBA.portable.ValueFactory {");
        printWriter.println("    public " + string + "() {}");
        printWriter.println();
        printWriter.println("    public java.io.Serializable read_value(");
        printWriter.println("            final org.omg.CORBA_2_3.portable.InputStream is) {");
        printWriter.println("        return is.read_value(new " + string2 + "());");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    }");
        printWriter.println();
        printWriter.flush();
        printWriter.close();
    }

    public void writeDefaultValueImpl(IdlValue idlValue2, File file) {
        if (idlValue2.isAbstract() || null == IdlCompiler.generateValueImpl) {
            return;
        }
        String string = idlValue2.name() + IdlCompiler.generateValueImpl;
        PrintWriter printWriter = this.newFile(file, string);
        this.addPackageName(printWriter);
        printWriter.println("public class " + string + " extends " + idlValue2.name() + " {");
        printWriter.println("    public " + string + "() {}");
        printWriter.println();
        this.writeDefaultMethods(printWriter, idlValue2, new HashSet());
        printWriter.println("}");
        printWriter.println();
        printWriter.flush();
        printWriter.close();
    }

    public void writeDefaultMethods(PrintWriter printWriter, IdlObject idlObject2, Set set) {
        if (!set.add(idlObject2.getId())) {
            return;
        }
        idlObject2.reset();
        while (!idlObject2.end()) {
            switch (idlObject2.current().kind()) {
                case 16: {
                    this.writeDefaultOperation(printWriter, (IdlOp)idlObject2.current());
                    break;
                }
                case 17: {
                    this.writeDefaultAttribute(printWriter, (IdlAttribute)idlObject2.current());
                }
            }
            idlObject2.next();
        }
        switch (idlObject2.kind()) {
            case 15: {
                this.writeDefaultMethodsForInterfaces(printWriter, ((IdlInterface)idlObject2).getInheritance(), set);
                break;
            }
            case 28: {
                this.writeDefaultMethodsForValueTypes(printWriter, ((IdlValue)idlObject2).getInheritanceList(), set);
                this.writeDefaultMethodsForInterfaces(printWriter, ((IdlValue)idlObject2).supports(), set);
            }
        }
    }

    public void writeDefaultMethodsForValueTypes(PrintWriter printWriter, List list, Set set) {
        int n = 0;
        while (n < list.size()) {
            this.writeDefaultMethods(printWriter, ((IdlValueInheritance)list.get(n)).getValue(), set);
            ++n;
        }
    }

    public void writeDefaultMethodsForInterfaces(PrintWriter printWriter, List list, Set set) {
        int n = 0;
        while (n < list.size()) {
            this.writeDefaultMethods(printWriter, (IdlInterface)list.get(n), set);
            ++n;
        }
    }

    public void writeDefaultAttribute(PrintWriter printWriter, IdlAttribute idlAttribute2) {
        idlAttribute2.reset();
        IdlObject idlObject2 = idlAttribute2.current();
        printWriter.print("    public ");
        this.translate_type(idlObject2, printWriter);
        printWriter.println(" " + idlAttribute2.name() + "() {");
        printWriter.println("        throw new Error(\"Unimplemented operation\");");
        printWriter.println("    }");
        printWriter.println();
        if (!idlAttribute2.readOnly()) {
            printWriter.print("    public ");
            printWriter.print("void " + idlAttribute2.name() + "(");
            this.translate_type(idlObject2, printWriter);
            printWriter.println(") {");
            printWriter.println("        throw new Error(\"Unimplemented operation\");");
            printWriter.println("    }");
            printWriter.println();
        }
    }

    public void writeDefaultOperation(PrintWriter printWriter, IdlOp idlOp) {
        IdlContext idlContext;
        boolean bl = false;
        printWriter.print("    public ");
        idlOp.reset();
        IdlObject idlObject2 = idlOp.current();
        this.translate_type(idlObject2, printWriter);
        printWriter.print(" " + idlOp.name() + "(");
        idlOp.next();
        if (!idlOp.end() && idlOp.current().kind() == 19) {
            bl = true;
            while (!idlOp.end()) {
                idlOp.current().reset();
                this.translate_parameter(idlOp.current().current(), printWriter, ((IdlParam)idlOp.current()).param_attr());
                printWriter.print(" " + idlOp.current().name());
                idlOp.next();
                if (idlOp.end()) continue;
                if (idlOp.current().kind() != 19) break;
                printWriter.print(", ");
            }
        }
        if ((idlContext = this.getContext(idlOp)) != null) {
            if (bl) {
                printWriter.print(", ");
            }
            printWriter.print("org.omg.CORBA.Context ctx");
        }
        printWriter.print(")");
        if (!idlOp.end() && idlOp.current().kind() == 20) {
            printWriter.println("");
            printWriter.print("        throws ");
            IdlRaises idlRaises = (IdlRaises)idlOp.current();
            idlRaises.reset();
            while (!idlRaises.end()) {
                printWriter.print(this.fullname(idlRaises.current()));
                idlRaises.next();
                if (idlRaises.end()) continue;
                printWriter.print(", ");
            }
        }
        printWriter.println("{");
        printWriter.println("        throw new Error(\"Unimplemented operation\");");
        printWriter.println("    }");
        printWriter.println();
    }

    public void translate_value_box(IdlObject idlObject2, File file) {
        IdlValueBox idlValueBox2 = (IdlValueBox)idlObject2;
        if (idlValueBox2.simple()) {
            PrintWriter printWriter = this.newFile(file, idlObject2.name());
            this.addDescriptiveHeader(printWriter, idlObject2);
            printWriter.println("public class " + idlObject2.name() + " implements org.omg.CORBA.portable.ValueBase");
            printWriter.println("{");
            printWriter.println("    /**");
            printWriter.println("     * Reference to the boxed value");
            printWriter.println("     */");
            printWriter.print("    public ");
            idlObject2.reset();
            this.translate_type(idlObject2.current(), printWriter);
            printWriter.println(" value;");
            printWriter.println("");
            printWriter.println("    /**");
            printWriter.println("     * Constructor");
            printWriter.println("     * ");
            printWriter.println("     * @param initial the initial boxed value");
            printWriter.println("     */");
            printWriter.print("    public " + idlObject2.name() + "(");
            this.translate_type(idlObject2.current(), printWriter);
            printWriter.println(" initial)");
            printWriter.println("    {");
            printWriter.println("        value = initial;");
            printWriter.println("    }");
            printWriter.println("");
            printWriter.println("    //");
            printWriter.println("    // Return value box id");
            printWriter.println("    //");
            printWriter.println("    private static String[] _ids = { " + idlObject2.name() + "Helper.id() };");
            printWriter.println("");
            printWriter.println("    /**");
            printWriter.println("     * Return truncatable ids");
            printWriter.println("     */");
            printWriter.println("     public String[] _truncatable_ids()");
            printWriter.println("     {");
            printWriter.println("        return _ids;");
            printWriter.println("     }");
            printWriter.println("");
            printWriter.println("}");
            printWriter.close();
            this.write_holder(idlObject2, file);
            this.write_helper(idlObject2, file);
        } else {
            idlObject2.reset();
            while (!idlObject2.end()) {
                switch (idlObject2.current().kind()) {
                    case 4: {
                        this.translate_union(idlObject2.current(), file);
                        break;
                    }
                    case 3: {
                        this.translate_struct(idlObject2.current(), file);
                        break;
                    }
                    case 2: {
                        this.translate_enum(idlObject2.current(), file);
                    }
                }
                idlObject2.next();
            }
            idlObject2.reset();
            switch (idlObject2.current().kind()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 24: 
                case 26: {
                    this.write_helper(idlObject2, file);
                    this.write_holder(idlObject2, file);
                }
            }
        }
    }

    public void translate_native(IdlObject idlObject2, File file) {
        this.write_holder(idlObject2, file);
        this.write_helper(idlObject2, file);
    }

    public void translate_object_content(IdlObject idlObject2, File file, int n) {
        switch (idlObject2.current().kind()) {
            case 1: {
                this.translate_module(idlObject2.current(), file, n);
                break;
            }
            case 7: {
                if (n != 0) break;
                this.translate_constant(idlObject2.current(), file, null);
                break;
            }
            case 2: {
                if (n != 0) break;
                this.translate_enum(idlObject2.current(), file);
                break;
            }
            case 3: {
                if (n != 0) break;
                this.translate_struct(idlObject2.current(), file);
                break;
            }
            case 4: {
                if (n != 0) break;
                this.translate_union(idlObject2.current(), file);
                break;
            }
            case 13: {
                if (n != 0) break;
                this.translate_typedef(idlObject2.current(), file);
                break;
            }
            case 14: {
                if (n != 0) break;
                this.translate_exception(idlObject2.current(), file);
                break;
            }
            case 25: {
                if (n != 0) break;
                this.translate_native(idlObject2.current(), file);
                break;
            }
            case 27: {
                if (n != 0) break;
                this.translate_value_box(idlObject2.current(), file);
                break;
            }
            case 28: {
                if (n != 0) break;
                this.translate_value_type(idlObject2.current(), file);
                break;
            }
            case 15: {
                if (n == 0) {
                    this.translate_interface(idlObject2.current(), file);
                    break;
                }
                if (n == 1) {
                    if (((IdlInterface)idlObject2.current()).local_interface()) break;
                    this.translate_interface_stub(idlObject2.current(), file);
                    break;
                }
                if (n == 2) {
                    if (((IdlInterface)idlObject2.current()).abstract_interface() || ((IdlInterface)idlObject2.current()).local_interface()) break;
                    this.translate_interface_skel(idlObject2.current(), file);
                    break;
                }
                if (n != 3 || ((IdlInterface)idlObject2.current()).abstract_interface() || ((IdlInterface)idlObject2.current()).local_interface()) break;
                this.translate_interface_tie(idlObject2.current(), file);
            }
        }
    }

    public void translate_object(IdlObject idlObject2, File file, int n) {
        idlObject2.reset();
        while (!idlObject2.end()) {
            File file2 = file;
            if (!idlObject2.current().included()) {
                String string = this.current_pkg;
                if (IdlCompiler.usePrefix && idlObject2.current().getPrefix() != null && idlObject2.kind() == 0) {
                    file2 = n == 0 ? this.createPrefixDirectories(idlObject2.current().getPrefix(), file) : this.getPrefixDirectories(idlObject2.current().getPrefix(), file);
                    if (IdlCompiler.reversePrefix) {
                        this.addToPkg(idlObject2, this.inversedPrefix(idlObject2.current().getPrefix()));
                    } else {
                        this.addToPkg(idlObject2, idlObject2.current().getPrefix());
                    }
                }
                this.translate_object_content(idlObject2, file2, n);
                this.current_pkg = string;
            }
            idlObject2.next();
        }
    }

    public void translate_user_object(IdlObject idlObject2, File file) {
        idlObject2.reset();
        while (!idlObject2.end()) {
            if (!idlObject2.included()) {
                switch (idlObject2.current().kind()) {
                    case 1: {
                        this.translate_user_module(idlObject2.current(), file);
                        break;
                    }
                    case 15: {
                        this.translate_user_interface(idlObject2.current(), file);
                    }
                }
            }
            idlObject2.next();
        }
    }

    public void translateData(IdlObject idlObject2, String string) {
        this._root = idlObject2;
        File file = null;
        if (IdlCompiler.outdir != null) {
            file = new File(IdlCompiler.outdir);
        }
        File file2 = this.createDirectory(string, file);
        this.translate_object(idlObject2, file2, 0);
    }

    public void translateTIE(IdlObject idlObject2, String string) {
        this._root = idlObject2;
        if (IdlCompiler.pidl) {
            return;
        }
        File file = null;
        if (IdlCompiler.outdir != null) {
            file = new File(IdlCompiler.outdir);
        }
        File file2 = this.getDirectory(string, file);
        this.translate_object(idlObject2, file2, 3);
    }

    public void translateUser(IdlObject idlObject2, String string) {
        File file;
        this._root = idlObject2;
        File file2 = null;
        if (IdlCompiler.outdir != null) {
            file2 = new File(IdlCompiler.outdir);
        }
        this.initial = file = this.getDirectory(string, file2);
        this.translate_user_object(idlObject2, file);
    }

    public void translateStub(IdlObject idlObject2, String string) {
        this._root = idlObject2;
        File file = null;
        if (IdlCompiler.outdir != null) {
            file = new File(IdlCompiler.outdir);
        }
        File file2 = this.getDirectory(string, file);
        this.translate_object(idlObject2, file2, 1);
    }

    public void translateSkeleton(IdlObject idlObject2, String string) {
        this._root = idlObject2;
        File file = null;
        if (IdlCompiler.outdir != null) {
            file = new File(IdlCompiler.outdir);
        }
        File file2 = this.getDirectory(string, file);
        this.translate_object(idlObject2, file2, 2);
    }
}

