/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.io.ExtendedOutputStream;
import org.openorb.io.ListInputStream;
import org.openorb.io.TypeCodeValueBoxHelper;
import org.openorb.util.CharacterCache;
import org.openorb.util.ExceptionTool;
import org.openorb.util.NumberCache;
import org.openorb.util.RepoIDHelper;
import org.openorb.util.Trace;

public class ListOutputStream
extends OutputStream
implements ExtendedOutputStream {
    private final List m_contents;
    private final ORB m_orb;
    private Logger m_logger;

    public ListOutputStream(ORB oRB) {
        this.m_orb = oRB;
        this.m_contents = new ArrayList();
    }

    public ListOutputStream(ORB oRB, List list) {
        this.m_orb = oRB;
        this.m_contents = list;
    }

    public ORB orb() {
        return this.m_orb;
    }

    public InputStream create_input_stream() {
        return new ListInputStream(this.m_orb, this.m_contents);
    }

    private List getContents() {
        return this.m_contents;
    }

    private int getIndex() {
        return this.m_contents.size();
    }

    void write_value_box(TypeCodeValueBoxHelper typeCodeValueBoxHelper) {
        this.m_contents.add(TCKind.tk_value_box);
        this.m_contents.add(typeCodeValueBoxHelper);
    }

    public void write_boolean(boolean bl) {
        this.m_contents.add(TCKind.tk_boolean);
        this.m_contents.add(bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void write_boolean_array(boolean[] blArray, int n, int n2) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(blArray, n, n2, TCKind.tk_boolean, this.getLogger()));
    }

    public void write_octet(byte by) {
        this.m_contents.add(TCKind.tk_octet);
        this.m_contents.add(NumberCache.getByte(by));
    }

    public void write_octet_array(byte[] byArray, int n, int n2) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(byArray, n, n2, TCKind.tk_octet, this.getLogger()));
    }

    public void write_short(short s) {
        this.m_contents.add(TCKind.tk_short);
        this.m_contents.add(NumberCache.getShort(s));
    }

    public void write_short_array(short[] sArray, int n, int n2) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(sArray, n, n2, TCKind.tk_short, this.getLogger()));
    }

    public void write_ushort(short s) {
        this.m_contents.add(TCKind.tk_ushort);
        this.m_contents.add(NumberCache.getShort(s));
    }

    public void write_ushort_array(short[] sArray, int n, int n2) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(sArray, n, n2, TCKind.tk_ushort, this.getLogger()));
    }

    public void write_long(int n) {
        this.m_contents.add(TCKind.tk_ulong);
        this.m_contents.add(NumberCache.getInteger(n));
    }

    public void write_long_array(int[] nArray, int n, int n2) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(nArray, n, n2, TCKind.tk_long, this.getLogger()));
    }

    public void write_ulong(int n) {
        this.m_contents.add(TCKind.tk_ulong);
        this.m_contents.add(NumberCache.getInteger(n));
    }

    public void write_ulong_array(int[] nArray, int n, int n2) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(nArray, n, n2, TCKind.tk_ulong, this.getLogger()));
    }

    public void write_longlong(long l) {
        this.m_contents.add(TCKind.tk_longlong);
        this.m_contents.add(NumberCache.getLong(l));
    }

    public void write_longlong_array(long[] lArray, int n, int n2) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(lArray, n, n2, TCKind.tk_longlong, this.getLogger()));
    }

    public void write_ulonglong(long l) {
        this.m_contents.add(TCKind.tk_ulonglong);
        this.m_contents.add(NumberCache.getLong(l));
    }

    public void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(lArray, n, n2, TCKind.tk_ulonglong, this.getLogger()));
    }

    public void write_float(float f) {
        this.m_contents.add(TCKind.tk_float);
        this.m_contents.add(NumberCache.getFloat(f));
    }

    public void write_float_array(float[] fArray, int n, int n2) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(fArray, n, n2, TCKind.tk_float, this.getLogger()));
    }

    public void write_double(double d) {
        this.m_contents.add(TCKind.tk_double);
        this.m_contents.add(NumberCache.getDouble(d));
    }

    public void write_double_array(double[] dArray, int n, int n2) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(dArray, n, n2, TCKind.tk_double, this.getLogger()));
    }

    public void write_char(char c) {
        this.m_contents.add(TCKind.tk_char);
        this.m_contents.add(CharacterCache.getCharacter(c));
    }

    public void write_char_array(char[] cArray, int n, int n2) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(cArray, n, n2, TCKind.tk_char, this.getLogger()));
    }

    public void write_wchar(char c) {
        this.m_contents.add(TCKind.tk_wchar);
        this.m_contents.add(CharacterCache.getCharacter(c));
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        this.m_contents.add(TCKind.tk_array);
        this.m_contents.add(new ArrayBlock(cArray, n, n2, TCKind.tk_wchar, this.getLogger()));
    }

    public void write_string(String string) {
        this.m_contents.add(TCKind.tk_string);
        this.m_contents.add(string);
    }

    public void write_wstring(String string) {
        this.m_contents.add(TCKind.tk_wstring);
        this.m_contents.add(string);
    }

    public void write_Object(Object object) {
        this.m_contents.add(TCKind.tk_objref);
        this.m_contents.add(object);
    }

    public void write_TypeCode(TypeCode typeCode) {
        this.m_contents.add(TCKind.tk_TypeCode);
        this.m_contents.add(typeCode);
    }

    public void write_any(Any any) {
        this.m_contents.add(TCKind.tk_any);
        this.m_contents.add(any);
    }

    public void write_Context(Context context, ContextList contextList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < contextList.count()) {
            try {
                NVList nVList = context.get_values("", 0, contextList.item(n));
                int n2 = 0;
                while (n2 < nVList.count()) {
                    arrayList.add(nVList.item(n2).name());
                    arrayList.add(nVList.item(n2).value().extract_string());
                    ++n2;
                }
            }
            catch (Bounds bounds) {
                // empty catch block
            }
            ++n;
        }
        if (arrayList.size() != 0) {
            this.write_ulong(arrayList.size());
            int n3 = 0;
            while (n3 < arrayList.size()) {
                this.write_string((String)arrayList.get(n3));
                ++n3;
            }
        } else if (contextList.count() != 0) {
            this.write_ulong(0);
        }
    }

    public void write_Principal(Principal principal) {
        this.m_contents.add(TCKind.tk_Principal);
        this.m_contents.add(principal);
    }

    public void write_fixed(BigDecimal bigDecimal) {
        this.m_contents.add(TCKind.tk_fixed);
        this.m_contents.add(bigDecimal);
    }

    public void write_fixed(BigDecimal bigDecimal, TypeCode typeCode) {
        try {
            this.write_fixed(bigDecimal, typeCode.fixed_digits(), typeCode.fixed_scale());
        }
        catch (BadKind badKind) {
            this.getLogger().error("Type mismatch with fixed type.", badKind);
            throw ExceptionTool.initCause(new BAD_PARAM("Type mismatch with fixed type (" + badKind + ")", 1146056712, CompletionStatus.COMPLETED_MAYBE), (Throwable)badKind);
        }
    }

    public void write_fixed(BigDecimal bigDecimal, short s, short s2) {
        if (s2 >= 0 && bigDecimal.scale() != s2) {
            bigDecimal = bigDecimal.setScale((int)s2, 6);
        }
        if (s >= 0) {
            String string = bigDecimal.toString();
            int n = string.length();
            if (string.charAt(0) == '-') {
                --n;
            }
            if (string.indexOf(46) != -1) {
                --n;
            }
            if (n > s) {
                throw new BAD_PARAM("Type mismatch with fixed type", 1146056712, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        this.m_contents.add(TCKind.tk_fixed);
        this.m_contents.add(bigDecimal);
    }

    public void write_value(Serializable serializable) {
        if (null == serializable) {
            this.m_contents.add(TCKind.tk_value);
            this.m_contents.add(serializable);
            return;
        }
        if (serializable instanceof StreamableValue || serializable instanceof CustomValue) {
            this.m_contents.add(TCKind.tk_value);
            this.m_contents.add(serializable);
            return;
        }
        if (serializable instanceof ValueBase) {
            String string = ((ValueBase)serializable)._truncatable_ids()[0];
            BoxedValueHelper boxedValueHelper = this.locateBoxedValueHelper(string);
            this.m_contents.add(TCKind.tk_value_box);
            this.m_contents.add(boxedValueHelper);
            return;
        }
        if (serializable.getClass().isArray()) {
            throw new MARSHAL("Unable to locate valuebox helper", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        this.m_contents.add(TCKind.tk_value);
        this.m_contents.add(serializable);
    }

    public void write_value(Serializable serializable, String string) {
        if (serializable instanceof StreamableValue || serializable instanceof CustomValue) {
            this.m_contents.add(TCKind.tk_value);
            this.m_contents.add(serializable);
        } else if (serializable instanceof ValueBase || serializable.getClass().isArray()) {
            BoxedValueHelper boxedValueHelper = this.locateBoxedValueHelper(string);
            this.m_contents.add(TCKind.tk_value_box);
            this.m_contents.add(boxedValueHelper);
            boxedValueHelper.write_value(this, serializable);
        } else {
            this.m_contents.add(TCKind.tk_value);
            this.m_contents.add(serializable);
        }
    }

    public void write_value(Serializable serializable, Class clazz) {
        this.write_value(serializable);
    }

    private BoxedValueHelper locateBoxedValueHelper(String string) {
        String string2 = RepoIDHelper.idToClass(string, 2);
        try {
            return (BoxedValueHelper)this.loadClass(string2).newInstance();
        }
        catch (Exception exception) {
            this.getLogger().error("Unable to locate valuebox helper.", exception);
            throw ExceptionTool.initCause(new MARSHAL("Unable to locate valuebox helper (" + exception + ")", 1330446337, CompletionStatus.COMPLETED_NO), (Throwable)exception);
        }
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        this.m_contents.add(TCKind.tk_value_box);
        this.m_contents.add(boxedValueHelper);
        boxedValueHelper.write_value(this, serializable);
    }

    public void write_abstract_interface(java.lang.Object object) {
        this.m_contents.add(TCKind.tk_abstract_interface);
        if (null == object) {
            this.write_Object(null);
            return;
        }
        if (object instanceof Object) {
            this.write_Object((Object)object);
            return;
        }
        if (object instanceof Serializable) {
            this.write_value((Serializable)object);
            return;
        }
        throw new BAD_PARAM("Attempt to marshal unknown interface type", 1146056716, CompletionStatus.COMPLETED_MAYBE);
    }

    public boolean equals(java.lang.Object object) {
        return this.create_input_stream().equals(object);
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.orb()).getLogger();
        }
        return this.m_logger;
    }

    private Class loadClass(String string) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(string);
    }

    static class ArrayBlock {
        private final Logger m_logger;
        private final TCKind m_kind;
        private final int m_length;
        private java.lang.Object m_array;
        private int m_offset;

        ArrayBlock(java.lang.Object object, int n, int n2, TCKind tCKind, Logger logger) {
            this.m_logger = logger;
            this.m_array = object;
            this.m_offset = n;
            this.m_length = n2;
            this.m_kind = tCKind;
        }

        public int getLength() {
            return this.m_length;
        }

        public int getOffset() {
            return this.m_offset;
        }

        public TCKind getContentKind() {
            return this.m_kind;
        }

        public java.lang.Object getContents() {
            if (this.m_offset != 0) {
                java.lang.Object object = Array.newInstance(this.m_array.getClass().getSuperclass(), this.m_length);
                System.arraycopy(this.m_array, this.m_offset, object, 0, this.m_length);
                this.m_array = object;
                this.m_offset = 0;
            }
            return this.m_array;
        }

        public boolean equals(java.lang.Object object) {
            if (!(object instanceof ArrayBlock)) {
                return false;
            }
            ArrayBlock arrayBlock = (ArrayBlock)object;
            if (this.m_length != arrayBlock.m_length || this.m_kind != arrayBlock.m_kind) {
                return false;
            }
            switch (this.m_kind.value()) {
                case 8: {
                    boolean[] blArray = (boolean[])this.m_array;
                    boolean[] blArray2 = (boolean[])arrayBlock.m_array;
                    int n = 0;
                    while (n < this.m_length) {
                        if (blArray[this.m_offset + n] != blArray2[arrayBlock.m_offset + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 10: {
                    byte[] byArray = (byte[])this.m_array;
                    byte[] byArray2 = (byte[])arrayBlock.m_array;
                    int n = 0;
                    while (n < this.m_length) {
                        if (byArray[this.m_offset + n] != byArray2[arrayBlock.m_offset + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 2: 
                case 4: {
                    short[] sArray = (short[])this.m_array;
                    short[] sArray2 = (short[])arrayBlock.m_array;
                    int n = 0;
                    while (n < this.m_length) {
                        if (sArray[this.m_offset + n] != sArray2[arrayBlock.m_offset + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 3: 
                case 5: {
                    int[] nArray = (int[])this.m_array;
                    int[] nArray2 = (int[])arrayBlock.m_array;
                    int n = 0;
                    while (n < this.m_length) {
                        if (nArray[this.m_offset + n] != nArray2[arrayBlock.m_offset + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 23: 
                case 24: {
                    long[] lArray = (long[])this.m_array;
                    long[] lArray2 = (long[])arrayBlock.m_array;
                    int n = 0;
                    while (n < this.m_length) {
                        if (lArray[this.m_offset + n] != lArray2[arrayBlock.m_offset + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 6: {
                    float[] fArray = (float[])this.m_array;
                    float[] fArray2 = (float[])arrayBlock.m_array;
                    int n = 0;
                    while (n < this.m_length) {
                        if (fArray[this.m_offset + n] != fArray2[arrayBlock.m_offset + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 7: {
                    double[] dArray = (double[])this.m_array;
                    double[] dArray2 = (double[])arrayBlock.m_array;
                    int n = 0;
                    while (n < this.m_length) {
                        if (dArray[this.m_offset + n] != dArray2[arrayBlock.m_offset + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 9: 
                case 26: {
                    char[] cArray = (char[])this.m_array;
                    char[] cArray2 = (char[])arrayBlock.m_array;
                    int n = 0;
                    while (n < this.m_length) {
                        if (cArray[this.m_offset + n] != cArray2[arrayBlock.m_offset + n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
            }
            throw Trace.signalIllegalCondition(this.m_logger, "Unexpected case kind.value()==" + this.m_kind.value() + ".");
        }
    }
}

