/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CORBA.Any;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.ServiceContext;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.iiop.CDRCodecFactory;
import org.openorb.iiop.CodeSet;
import org.openorb.iiop.IIOPAddress;
import org.openorb.iiop.IIOPClientChannel;
import org.openorb.iiop.IIOPServerChannel;
import org.openorb.iiop.IIOPServerProtocol;
import org.openorb.net.Address;
import org.openorb.net.ClientBinding;
import org.openorb.net.ClientManager;
import org.openorb.net.ClientProtocol;
import org.openorb.net.RebindChannelException;
import org.openorb.net.ServerManager;
import org.openorb.net.Transport;
import org.openorb.net.TransportAssociationHolder;
import org.openorb.net.TransportClientInitializer;
import org.openorb.util.ExceptionTool;
import org.openorb.util.WeakValueHashMap;

public class IIOPClientProtocol
implements ClientProtocol {
    private ClientManager m_client_manager;
    private ORB m_orb;
    private Codec m_codec;
    private IIOPServerProtocol m_server_protocol = null;
    private ServerManager m_server_manager = null;
    private Map m_channels = new WeakValueHashMap();
    private CodeSetComponentInfo m_codeset_component_info;
    private TransportClientInitializer m_transport_client_init;
    private ServiceContext m_bidir_service_ctxt;
    private Logger m_logger;

    public IIOPClientProtocol(ClientManager clientManager, CDRCodecFactory cDRCodecFactory, CodeSetComponentInfo codeSetComponentInfo, TransportClientInitializer transportClientInitializer, ListenPoint[] listenPointArray) {
        try {
            this.m_codec = cDRCodecFactory.create_codec(new Encoding(0, 1, 2));
        }
        catch (UnknownEncoding unknownEncoding) {
            this.getLogger().error("Could not find codec", unknownEncoding);
        }
        this.m_client_manager = clientManager;
        this.m_orb = this.m_client_manager.orb();
        this.m_codeset_component_info = codeSetComponentInfo;
        this.m_transport_client_init = transportClientInitializer;
        if (listenPointArray != null) {
            this.m_bidir_service_ctxt = null;
            try {
                BiDirIIOPServiceContext biDirIIOPServiceContext = new BiDirIIOPServiceContext(listenPointArray);
                Any any = this.m_orb.create_any();
                BiDirIIOPServiceContextHelper.insert(any, biDirIIOPServiceContext);
                byte[] byArray = this.m_codec.encode_value(any);
                if (byArray != null) {
                    this.m_bidir_service_ctxt = new ServiceContext(5, byArray);
                }
            }
            catch (UserException userException) {
                this.getLogger().error("UserException occured during init of IIOPClientProtocol.", userException);
                throw ExceptionTool.initCause(new INITIALIZE("UserException occured during init of IIOPClientProtocol (" + userException + ")"), (Throwable)userException);
            }
        }
    }

    public void setServerProtocol(IIOPServerProtocol iIOPServerProtocol) {
        this.m_server_protocol = iIOPServerProtocol;
        this.m_server_manager = iIOPServerProtocol.getServerManager();
    }

    public Codec getCodec() {
        return this.m_codec;
    }

    public ORB orb() {
        return this.m_orb;
    }

    public ClientManager getClientManager() {
        return this.m_client_manager;
    }

    public Address[] createAddresses(IORAddressingInfo iORAddressingInfo) {
        return this.m_transport_client_init.establishTransports(IIOPAddress.get_addresses(this.m_codec, iORAddressingInfo.ior, iORAddressingInfo.selected_profile_index, this.getLogger()));
    }

    public ClientBinding createBinding(Address address) {
        ClientBinding clientBinding;
        if (!(address instanceof IIOPAddress)) {
            return null;
        }
        IIOPAddress iIOPAddress = (IIOPAddress)address;
        Map map = this.m_channels;
        synchronized (map) {
            try {
                TransportAssociationHolder transportAssociationHolder = new TransportAssociationHolder();
                IIOPClientChannel iIOPClientChannel = this.findCreateChannel(iIOPAddress, null, transportAssociationHolder);
                clientBinding = this.m_server_manager == null || this.m_server_protocol == null || !this.m_server_protocol.servesAddress(iIOPAddress.get_hostname(), iIOPAddress.get_port()) ? new ClientBinding(iIOPAddress, iIOPClientChannel, transportAssociationHolder.getValue()) : new ClientBinding(iIOPAddress, iIOPClientChannel, transportAssociationHolder.getValue(), this.m_server_manager);
            }
            catch (SystemException systemException) {
                clientBinding = new ClientBinding(iIOPAddress, systemException);
            }
        }
        return clientBinding;
    }

    protected IIOPClientChannel findCreateChannel(IIOPAddress iIOPAddress, IIOPClientChannel iIOPClientChannel, TransportAssociationHolder transportAssociationHolder) {
        InetAddress inetAddress = iIOPAddress.get_host();
        if (inetAddress == null) {
            throw new COMM_FAILURE("Host not found", 1146056971, CompletionStatus.COMPLETED_NO);
        }
        LookupKey lookupKey = new LookupKey(iIOPAddress);
        IIOPClientChannel iIOPClientChannel2 = (IIOPClientChannel)this.m_channels.get(lookupKey);
        if (iIOPClientChannel2 == null || iIOPClientChannel == iIOPClientChannel2) {
            int n;
            int n2;
            if (iIOPAddress.get_port() == 0) {
                throw new NO_PERMISSION("Port number published in IOR is 0.", 1146056984, CompletionStatus.COMPLETED_NO);
            }
            CodeSetComponentInfo codeSetComponentInfo = iIOPAddress.getCodesetComponentInfo();
            if (codeSetComponentInfo == null) {
                n2 = 0;
                n = 0;
            } else {
                n2 = IIOPClientProtocol.selectCodeset(this.m_codeset_component_info.ForCharData, codeSetComponentInfo.ForCharData, true);
                n = IIOPClientProtocol.selectCodeset(this.m_codeset_component_info.ForWcharData, codeSetComponentInfo.ForWcharData, false);
            }
            Transport transport = iIOPAddress.createTransport();
            transport.establishAssociation(iIOPAddress, transportAssociationHolder);
            iIOPClientChannel2 = new IIOPClientChannel(this, transport, this.m_server_protocol, n2, n);
            this.m_channels.put(new HostPortPair(inetAddress, iIOPAddress.get_port(), n2, n, transport), iIOPClientChannel2);
        } else {
            transportAssociationHolder.setValue(lookupKey.getValue());
        }
        return iIOPClientChannel2;
    }

    private static boolean checkCodeset(int n, CodeSetComponent codeSetComponent) {
        if (n == 0x5010001 || n == 65801) {
            return true;
        }
        if (codeSetComponent.native_code_set != n) {
            int n2 = 0;
            while (n2 < codeSetComponent.conversion_code_sets.length) {
                if (codeSetComponent.conversion_code_sets[n2] == n) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    private static int selectCodeset(CodeSetComponent codeSetComponent, CodeSetComponent codeSetComponent2, boolean bl) {
        int n;
        if (codeSetComponent.native_code_set == codeSetComponent2.native_code_set) {
            return codeSetComponent.native_code_set;
        }
        int n2 = 0;
        while (n2 < codeSetComponent.conversion_code_sets.length) {
            if (codeSetComponent2.native_code_set == codeSetComponent.conversion_code_sets[n2]) {
                return codeSetComponent2.native_code_set;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < codeSetComponent2.conversion_code_sets.length) {
            if (codeSetComponent.native_code_set == codeSetComponent2.conversion_code_sets[n3]) {
                return codeSetComponent.native_code_set;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < codeSetComponent2.conversion_code_sets.length) {
            int n5 = 0;
            while (n5 < codeSetComponent.conversion_code_sets.length) {
                if (codeSetComponent2.conversion_code_sets[n4] == codeSetComponent.conversion_code_sets[n5]) {
                    return codeSetComponent2.conversion_code_sets[n4];
                }
                ++n5;
            }
            ++n4;
        }
        int n6 = n = bl ? 0x5010001 : 65801;
        if (CodeSet.compatible(codeSetComponent.native_code_set, codeSetComponent2.native_code_set)) {
            return n;
        }
        int n7 = 0;
        while (n7 < codeSetComponent.conversion_code_sets.length) {
            if (CodeSet.compatible(codeSetComponent2.native_code_set, codeSetComponent.conversion_code_sets[n7])) {
                return n;
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < codeSetComponent2.conversion_code_sets.length) {
            if (CodeSet.compatible(codeSetComponent.native_code_set, codeSetComponent2.conversion_code_sets[n8])) {
                return n;
            }
            ++n8;
        }
        int n9 = 0;
        while (n9 < codeSetComponent2.conversion_code_sets.length) {
            int n10 = 0;
            while (n10 < codeSetComponent.conversion_code_sets.length) {
                if (CodeSet.compatible(codeSetComponent2.conversion_code_sets[n9], codeSetComponent.conversion_code_sets[n10])) {
                    return n;
                }
                ++n10;
            }
            ++n9;
        }
        throw new CODESET_INCOMPATIBLE(0, CompletionStatus.COMPLETED_NO);
    }

    void rebindBidirDelegate(IIOPClientChannel iIOPClientChannel, IIOPAddress iIOPAddress) throws RebindChannelException {
        IIOPClientChannel iIOPClientChannel2;
        TransportAssociationHolder transportAssociationHolder = new TransportAssociationHolder();
        Map map = this.m_channels;
        synchronized (map) {
            iIOPClientChannel2 = this.findCreateChannel(iIOPAddress, iIOPClientChannel, transportAssociationHolder);
        }
        throw new RebindChannelException(iIOPClientChannel2, transportAssociationHolder.getValue());
    }

    ServiceContext getBiDirSC() {
        return this.m_bidir_service_ctxt;
    }

    IIOPClientChannel createBidirDelegate(IIOPServerChannel iIOPServerChannel, ListenPoint[] listenPointArray) {
        IIOPClientChannel iIOPClientChannel;
        Map map = this.m_channels;
        synchronized (map) {
            HostPortPair hostPortPair;
            HostPortPair[] hostPortPairArray = new HostPortPair[listenPointArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < listenPointArray.length) {
                block17: {
                    InetAddress inetAddress;
                    try {
                        inetAddress = InetAddress.getByName(listenPointArray[n2].host);
                    }
                    catch (UnknownHostException unknownHostException) {
                        break block17;
                    }
                    hostPortPair = new HostPortPair(inetAddress, listenPointArray[n2].port & 0xFFFF, iIOPServerChannel.getTCSC(), iIOPServerChannel.getTCSW(), null);
                    IIOPClientChannel iIOPClientChannel2 = (IIOPClientChannel)this.m_channels.get(hostPortPair);
                    if (iIOPClientChannel2 != null) {
                        switch (iIOPClientChannel2.state()) {
                            case 0x11000000: {
                                IIOPClientChannel iIOPClientChannel3 = null;
                                return iIOPClientChannel3;
                            }
                            case 0x12000000: {
                                if (!iIOPClientChannel2.isDelegated()) {
                                    IIOPClientChannel iIOPClientChannel4 = null;
                                    return iIOPClientChannel4;
                                }
                            }
                            case 0x13000000: {
                                iIOPClientChannel2 = null;
                            }
                        }
                    }
                    if (iIOPClientChannel2 == null) {
                        hostPortPairArray[n++] = new HostPortPair(inetAddress, listenPointArray[n2].port & 0xFFFF, iIOPServerChannel.getTCSC(), iIOPServerChannel.getTCSW(), iIOPServerChannel.getSocketQueue().getTransport());
                    }
                }
                ++n2;
            }
            if (n == 0) {
                hostPortPair = null;
                return hostPortPair;
            }
            iIOPClientChannel = new IIOPClientChannel(this, iIOPServerChannel);
            int n3 = 0;
            while (n3 < n) {
                if (hostPortPairArray[n3] != null) {
                    this.m_channels.put(hostPortPairArray[n3], iIOPClientChannel);
                }
                ++n3;
            }
        }
        return iIOPClientChannel;
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.orb()).getLogger();
        }
        return this.m_logger;
    }

    private static class HostPortPair
    extends TransportAssociationHolder {
        private int m_hash;
        private InetAddress m_host;
        private int m_port;
        private int m_tcsc = -1;
        private int m_tcsw = -1;
        private Transport m_transport;

        public HostPortPair(InetAddress inetAddress, int n, int n2, int n3, Transport transport) {
            this.m_host = inetAddress;
            this.m_port = n;
            this.m_hash = inetAddress.hashCode() ^ n;
            this.m_tcsc = n2;
            this.m_tcsw = n3;
            this.m_transport = transport;
        }

        public int hashCode() {
            return this.m_hash;
        }

        public boolean equals(Object object) {
            if (object instanceof LookupKey) {
                return object.equals(this);
            }
            HostPortPair hostPortPair = (HostPortPair)object;
            if (this.m_transport != null && hostPortPair.m_transport != null) {
                return this == hostPortPair;
            }
            return hostPortPair.m_hash == this.m_hash && hostPortPair.m_port == this.m_port && hostPortPair.m_host.equals(this.m_host) && this.m_tcsc == hostPortPair.m_tcsc && this.m_tcsw == hostPortPair.m_tcsw;
        }
    }

    private static class LookupKey
    extends TransportAssociationHolder {
        private int m_hash;
        private InetAddress m_host;
        private int m_port;
        private CodeSetComponentInfo m_codeset_component_info;
        private IIOPAddress m_address;

        LookupKey(IIOPAddress iIOPAddress) {
            this.m_host = iIOPAddress.get_host();
            this.m_port = iIOPAddress.get_port();
            this.m_hash = this.m_host.hashCode() ^ this.m_port;
            this.m_address = iIOPAddress;
            this.m_codeset_component_info = iIOPAddress.getCodesetComponentInfo();
        }

        public int hashCode() {
            return this.m_hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof HostPortPair)) {
                return false;
            }
            HostPortPair hostPortPair = (HostPortPair)object;
            if (hostPortPair.m_hash != this.m_hash || hostPortPair.m_port != this.m_port || !hostPortPair.m_host.equals(this.m_host)) {
                return false;
            }
            if (this.m_address == null) {
                return true;
            }
            if (!(this.m_codeset_component_info == null || IIOPClientProtocol.checkCodeset(hostPortPair.m_tcsc, this.m_codeset_component_info.ForCharData) && IIOPClientProtocol.checkCodeset(hostPortPair.m_tcsw, this.m_codeset_component_info.ForWcharData))) {
                return false;
            }
            return hostPortPair.m_transport.establishAssociation(this.m_address, this);
        }
    }
}

