/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import org.openorb.iiop.CodeSet;
import org.openorb.util.JREVersion;

public class CodeSetDatabase {
    public static String canonicalize(String string) throws UnsupportedEncodingException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)System.out, string);
        return outputStreamWriter.getEncoding();
    }

    public static void populateNameToIdMap(HashMap hashMap) {
        ArrayList<Integer> arrayList = null;
        arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(196618));
        hashMap.put("JIS0212", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(65801));
        arrayList.add(new Integer(65794));
        arrayList.add(new Integer(65793));
        arrayList.add(new Integer(65792));
        hashMap.put("UNICODEBIGUNMARKED", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268600250));
        hashMap.put("CP33722", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268566965));
        hashMap.put("CP437", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567534));
        hashMap.put("CP1006", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567450));
        hashMap.put("CP922", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567449));
        hashMap.put("CP921", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(0x5000010));
        arrayList.add(new Integer(196624));
        hashMap.put("EUC_JP", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(196614));
        arrayList.add(new Integer(196613));
        arrayList.add(new Integer(196612));
        hashMap.put("JIS0208", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268566825));
        hashMap.put("CP297", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(196609));
        hashMap.put("JIS0201", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268595237));
        arrayList.add(new Integer(268566565));
        hashMap.put("CP037", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567785));
        hashMap.put("CP1257", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567784));
        hashMap.put("CP1256", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567783));
        hashMap.put("CP1255", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567782));
        hashMap.put("CP1254", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567781));
        hashMap.put("CP1253", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567780));
        hashMap.put("CP1252", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567779));
        hashMap.put("CP1251", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567446));
        hashMap.put("CP918", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567778));
        hashMap.put("CP1250", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268566952));
        hashMap.put("CP424", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268575140));
        arrayList.add(new Integer(268566948));
        hashMap.put("CP420", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(0x10010007));
        hashMap.put("EUC_CN", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567498));
        hashMap.put("CP970", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567403));
        hashMap.put("CP875", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268575594));
        arrayList.add(new Integer(268567402));
        hashMap.put("CP874", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567399));
        hashMap.put("CP871", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567398));
        hashMap.put("CP870", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268566813));
        hashMap.put("CP285", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268566812));
        hashMap.put("CP284", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268566808));
        hashMap.put("CP280", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(720897));
        hashMap.put("TIS620", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(0x10010008));
        hashMap.put("BIG5", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567492));
        hashMap.put("CP964", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268571493));
        arrayList.add(new Integer(268567397));
        hashMap.put("CP869", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268571492));
        arrayList.add(new Integer(268567396));
        hashMap.put("CP868", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567394));
        hashMap.put("CP866", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(327696));
        arrayList.add(new Integer(327690));
        arrayList.add(new Integer(327682));
        arrayList.add(new Integer(327681));
        hashMap.put("EUC_TW", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268575584));
        arrayList.add(new Integer(268571488));
        arrayList.add(new Integer(268567392));
        hashMap.put("CP864", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567391));
        hashMap.put("CP863", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268566806));
        hashMap.put("CP278", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268566805));
        hashMap.put("CP277", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567390));
        hashMap.put("CP862", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567389));
        hashMap.put("CP861", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(0x10020111));
        hashMap.put("CP273", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(83886098));
        arrayList.add(new Integer(0x5000011));
        hashMap.put("SJIS", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(65568));
        hashMap.put("ASCII", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567028));
        hashMap.put("CP500", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567626));
        hashMap.put("CP1098", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567625));
        hashMap.put("CP1097", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268571481));
        arrayList.add(new Integer(268567385));
        hashMap.put("CP857", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268600152));
        arrayList.add(new Integer(268591960));
        arrayList.add(new Integer(268571480));
        arrayList.add(new Integer(268567384));
        hashMap.put("CP856", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567478));
        hashMap.put("CP950", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268571479));
        arrayList.add(new Integer(268567383));
        hashMap.put("CP855", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268571476));
        arrayList.add(new Integer(268567380));
        hashMap.put("CP852", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268591954));
        arrayList.add(new Integer(268571474));
        arrayList.add(new Integer(268567378));
        hashMap.put("CP850", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567911));
        hashMap.put("CP1383", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567909));
        hashMap.put("CP1381", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567477));
        hashMap.put("CP949", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567650));
        hashMap.put("CP1122", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567476));
        hashMap.put("CP948", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567554));
        hashMap.put("CP1026", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567553));
        hashMap.put("CP1025", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567471));
        hashMap.put("CP943", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567470));
        arrayList.add(new Integer(268567460));
        hashMap.put("CP942", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(65545));
        hashMap.put("ISO8859_9", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(65544));
        hashMap.put("ISO8859_8", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(65543));
        hashMap.put("ISO8859_7", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(0x5010001));
        hashMap.put("UTF8", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(65551));
        hashMap.put("ISO8859_15_FDIS", arrayList);
        hashMap.put("ISO-8859-15", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(65542));
        hashMap.put("ISO8859_6", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567467));
        hashMap.put("CP939", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567640));
        hashMap.put("CP1112", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(65541));
        hashMap.put("ISO8859_5", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(65540));
        hashMap.put("ISO8859_4", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567465));
        hashMap.put("CP937", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(65539));
        hashMap.put("ISO8859_3", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(65538));
        hashMap.put("ISO8859_2", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567463));
        hashMap.put("CP935", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(65537));
        hashMap.put("ISO8859_1", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268575558));
        arrayList.add(new Integer(268567366));
        hashMap.put("CP838", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(268567458));
        hashMap.put("CP930", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Integer(262154));
        arrayList.add(new Integer(262145));
        hashMap.put("EUC_KR", arrayList);
    }

    public static CodeSet getCodeSetFromId(int n) {
        switch (n) {
            case 268567391: {
                return new CodeSet("IBM-863 (CCSID 00863); PC Data Canadian French", 268567391, new short[]{17}, 1, "Cp863", "cp863", 1, false);
            }
            case 268567390: {
                return new CodeSet("IBM-862 (CCSID 00862); PC Data Hebrew", 268567390, new short[]{24}, 1, "Cp862", "cp862", 1, false);
            }
            case 268567389: {
                return new CodeSet("IBM-861 (CCSID 00861); PC Data Iceland", 268567389, new short[]{17}, 1, "Cp861", "cp861", 1, false);
            }
            case 268566813: {
                return new CodeSet("IBM-285 (CCSID 00285); CECP for United Kingdom", 268566813, new short[]{17}, 1, "Cp285", "cp285", 1, false);
            }
            case 268566812: {
                return new CodeSet("IBM-284 (CCSID 00284); CECP for Spain, Latin America (Spanish)", 268566812, new short[]{17}, 1, "Cp284", "cp284", 1, false);
            }
            case 268567385: {
                return new CodeSet("IBM-857 (CCSID 00857); Turkish Latin-5 PC Data", 268567385, new short[]{25}, 1, "Cp857", "cp857", 1, false);
            }
            case 268567384: {
                return new CodeSet("IBM-856 (CCSID 00856); Hebrew PC Data (extensions)", 268567384, new short[]{24}, 1, "Cp856", "cp856", 1, false);
            }
            case 268567383: {
                return new CodeSet("IBM-855 (CCSID 00855); Cyrillic PC Data", 268567383, new short[]{21}, 1, "Cp855", "cp855", 1, false);
            }
            case 268575594: {
                return new CodeSet("IBM-874 (CCSID 09066); Thai PC Display Extended SBCS", 268575594, new short[]{512}, 1, "Cp874", "cp874", 1, false);
            }
            case 268566808: {
                return new CodeSet("IBM-280 (CCSID 00280); CECP for Italy", 268566808, new short[]{17}, 1, "Cp280", "cp280", 1, false);
            }
            case 268567380: {
                return new CodeSet("IBM-852 (CCSID 00852); Multilingual Latin-2", 268567380, new short[]{18}, 1, "Cp852", "cp852", 1, false);
            }
            case 268566806: {
                return new CodeSet("IBM-278 (CCSID 00278); CECP for Finland, Sweden", 268566806, new short[]{17}, 1, "Cp278", "cp278", 1, false);
            }
            case 268566805: {
                return new CodeSet("IBM-277 (CCSID 00277); CECP for Denmark, Norway", 268566805, new short[]{17}, 1, "Cp277", "Cp277", 1, false);
            }
            case 268567378: {
                return new CodeSet("IBM-850 (CCSID 00850); Multilingual IBM PC Data-MLP 222", 268567378, new short[]{17}, 1, "Cp850", "cp850", 1, false);
            }
            case 0x10020111: {
                return new CodeSet("IBM-273 (CCSID 00273); CECP for Austria, Germany", 0x10020111, new short[]{17}, 1, "Cp273", "cp273", 1, false);
            }
            case 268575584: {
                return new CodeSet("IBM-864 (CCSID 09056); Arabic PC Data (unshaped)", 268575584, new short[]{22}, 1, "Cp864", "cp864", 1, false);
            }
            case 268567366: {
                return new CodeSet("IBM-838 (CCSID 00838); Thai Host Extended SBCS", 268567366, new short[]{512}, 1, "Cp838", "cp838", 1, false);
            }
            case 268567554: {
                return new CodeSet("IBM-1026 (CCSID 01026); Turkish Latin-5", 268567554, new short[]{25}, 1, "Cp1026", "cp1026", 1, false);
            }
            case 268567553: {
                return new CodeSet("IBM-1025 (CCSID 01025); Cyrillic Multilingual", 268567553, new short[]{21}, 1, "Cp1025", "cp1025", 1, false);
            }
            case 268595237: {
                return new CodeSet("IBM-037 (CCSID 28709); T-Ch Host Extended SBCS", 268595237, new short[]{1}, 1, "Cp037", "cp037", 1, false);
            }
            case 268566965: {
                return new CodeSet("IBM-437 (CCSID 00437); PC USA", 268566965, new short[]{17}, 1, "Cp437", "cp437", 1, false);
            }
            case 268575558: {
                return new CodeSet("IBM-838 (CCSID 09030); Thai Host Extended SBCS", 268575558, new short[]{512}, 1, "Cp838", "cp838", 1, false);
            }
            case 268567534: {
                return new CodeSet("IBM-1006 (CCSID 01006); Urdu 8-bit", 268567534, new short[]{22}, 1, "Cp1006", "cp1006", 1, false);
            }
            case 268567911: {
                return new CodeSet("IBM-1383 (CCSID 01383); S-Ch EUC GB 2312-80 set (1382)", 268567911, new short[]{1, 768}, 3, "Cp1383", "cp1383", 1, false);
            }
            case 268567909: {
                return new CodeSet("IBM-1381 (CCSID 01381); S-Ch PC Data Mixed incl 1880 UDC", 268567909, new short[]{1, 768}, 2, "Cp1381", "cp1381", 1, false);
            }
            case 268566952: {
                return new CodeSet("IBM-424 (CCSID 00424); Hebrew", 268566952, new short[]{24}, 1, "Cp424", "cp424", 1, false);
            }
            case 327696: {
                return new CodeSet("CNS eucTW:1993; Taiwanese EUC", 327696, new short[]{1, 385}, 4, "EUC_TW", "EUC_TW", 1, true);
            }
            case 268566948: {
                return new CodeSet("IBM-420 (CCSID 00420); Arabic (presentation shapes)", 268566948, new short[]{22}, 1, "Cp420", "cp420", 1, false);
            }
            case 268566565: {
                return new CodeSet("IBM-037 (CCSID 00037); CECP for USA, Canada, NL, Ptgl, Brazil, Australia, NZ", 268566565, new short[]{17}, 1, "Cp037", "cp037", 1, false);
            }
            case 327690: {
                return new CodeSet("CNS eucTW:1991; Taiwanese EUC", 327690, new short[]{1, 384}, 4, "EUC_TW", "EUC_TW", 1, true);
            }
            case 268591960: {
                return new CodeSet("IBM-856 (CCSID 25432); Hebrew PC Display (extensions)", 268591960, new short[]{24}, 1, "Cp856", "cp856", 1, false);
            }
            case 327682: {
                return new CodeSet("CNS 11643:1992; Taiwanese Extended Hanzi Graphic Chars", 327682, new short[]{385}, 4, "EUC_TW", "CNS11643", 1, true);
            }
            case 327681: {
                return new CodeSet("CNS 11643:1986; Taiwanese Hanzi Graphic Characters", 327681, new short[]{384}, 2, "EUC_TW", "CNS11643", 1, true);
            }
            case 268591954: {
                return new CodeSet("IBM-850 (CCSID 25426); Multilingual IBM PC Display-MLP", 268591954, new short[]{17}, 1, "Cp850", "cp850", 1, false);
            }
            case 268575140: {
                return new CodeSet("IBM-420 (CCSID 08612); Arabic (base shapes only)", 268575140, new short[]{22}, 1, "Cp420", "cp420", 1, false);
            }
            case 268567498: {
                return new CodeSet("IBM-970 (CCSID 00970); Korean EUC", 268567498, new short[]{17, 256, 257}, 2, "Cp970", "cp970", 1, false);
            }
            case 262154: {
                return new CodeSet("KS eucKR:1991; Korean EUC", 262154, new short[]{17, 256, 257}, 2, "EUC_KR", "EUC_KR", 1, true);
            }
            case 268567492: {
                return new CodeSet("IBM-964 (CCSID 00964); T-Chinese EUC CNS1163 plane 1,2", 268567492, new short[]{1, 384}, 4, "Cp964", "cp964", 1, false);
            }
            case 268600152: {
                return new CodeSet("IBM-856 (CCSID 33624); Hebrew PC Display", 268600152, new short[]{24}, 1, "Cp856", "cp856", 1, false);
            }
            case 65801: {
                return new CodeSet("ISO/IEC 10646-1:1993; UTF-16, UCS Transformation Format 16-bit form", 65801, new short[]{4096}, 2, "UnicodeBigUnmarked", "UTF-16BE", 2, false);
            }
            case 262145: {
                return new CodeSet("KS C5601:1987; Korean Hangul and Hanja Graphic Characters", 262145, new short[]{256}, 2, "EUC_KR", "KSC5601", 1, true);
            }
            case 268571493: {
                return new CodeSet("IBM-869 (CCSID 04965); Greek PC Data", 268571493, new short[]{23}, 1, "Cp869", "cp869", 1, false);
            }
            case 65794: {
                return new CodeSet("ISO/IEC 10646-1:1993; UCS-2, Level 3", 65794, new short[]{4096}, 2, "UnicodeBigUnmarked", "ISO-10646-UCS-2", 2, false);
            }
            case 268571492: {
                return new CodeSet("IBM-868 (CCSID 04964); PC Data for Urdu", 268571492, new short[]{22}, 1, "Cp868", "cp868", 1, false);
            }
            case 65793: {
                return new CodeSet("ISO/IEC 10646-1:1993; UCS-2, Level 2", 65793, new short[]{4096}, 2, "UnicodeBigUnmarked", "ISO-10646-UCS-2", 2, false);
            }
            case 65792: {
                return new CodeSet("ISO/IEC 10646-1:1993; UCS-2, Level 1", 65792, new short[]{4096}, 2, "UnicodeBigUnmarked", "ISO-10646-UCS-2", 2, true);
            }
            case 268567478: {
                return new CodeSet("IBM-950 (CCSID 00950); T-Ch PC Data Mixed", 268567478, new short[]{1, 384}, 2, "Cp950", "cp950", 1, false);
            }
            case 268571488: {
                return new CodeSet("IBM-864 (CCSID 04960); Arabic PC Data (all shapes)", 268571488, new short[]{22}, 1, "Cp864", "cp864", 1, false);
            }
            case 268567477: {
                return new CodeSet("IBM-949 (CCSID 00949); IBM KS PC Data Mixed", 268567477, new short[]{1, 256}, 2, "Cp949", "cp949", 1, false);
            }
            case 196624: {
                return new CodeSet("JIS eucJP:1993; Japanese EUC", 196624, new short[]{17, 128, 129, 130}, 3, "EUC_JP", "EUC-JP", 1, true);
            }
            case 268567476: {
                return new CodeSet("IBM-948 (CCSID 00948); T-Ch PC Data Mixed", 268567476, new short[]{1, 384}, 2, "Cp948", "cp948", 1, false);
            }
            case 268567471: {
                return new CodeSet("IBM-943 (CCSID 00943); Japanese PC MBCS for Open", 268567471, new short[]{128, 129}, 2, "Cp943", "cp943", 1, false);
            }
            case 196618: {
                return new CodeSet("JIS X0212:1990; Supplementary Japanese Kanji Graphic Chars", 196618, new short[]{130}, 2, "JIS0212", "JIS0212", 1, true);
            }
            case 268571481: {
                return new CodeSet("IBM-857 (CCSID 04953); Turkish Latin-5 PC Data", 268571481, new short[]{25}, 1, "Cp857", "cp857", 1, false);
            }
            case 268567470: {
                return new CodeSet("IBM-942 (CCSID 00942); Japanese PC Data Mixed", 268567470, new short[]{128, 129}, 2, "Cp942", "cp942", 1, false);
            }
            case 268571480: {
                return new CodeSet("IBM-856 (CCSID 04952); Hebrew PC Data", 268571480, new short[]{24}, 1, "Cp856", "cp856", 1, false);
            }
            case 268571479: {
                return new CodeSet("IBM-855 (CCSID 04951); Cyrillic Personal Computer", 268571479, new short[]{21}, 1, "Cp855", "cp855", 1, false);
            }
            case 0x10010008: {
                return new CodeSet("HP big5; encoding method for Traditional Chinese", 0x10010008, new short[]{1, 384}, 2, "Big5", "big5", 1, false);
            }
            case 0x10010007: {
                return new CodeSet("HP15CN; encoding method for Simplified Chinese", 0x10010007, new short[]{1, 768}, 2, "EUC_CN", "GB2312", 1, false);
            }
            case 196614: {
                return new CodeSet("JIS X0208:1990 Japanese Kanji Graphic Characters", 196614, new short[]{129}, 2, "JIS0208", "JIS0208", 1, true);
            }
            case 268567467: {
                return new CodeSet("IBM-939 (CCSID 00939); Latin-Kanji Host MBCS", 268567467, new short[]{128, 129}, 2, "Cp939", "cp939", 1, false);
            }
            case 196613: {
                return new CodeSet("JIS X0208:1983 Japanese Kanji Graphic Characters", 196613, new short[]{129}, 2, "JIS0208", "JIS0208", 1, false);
            }
            case 268571476: {
                return new CodeSet("IBM-852 (CCSID 04948); Latin-2 Personal Computer", 268571476, new short[]{18}, 1, "Cp852", "cp852", 1, false);
            }
            case 196612: {
                return new CodeSet("JIS X0208:1978 Japanese Kanji Graphic Characters", 196612, new short[]{129}, 2, "JIS0208", "JIS0208", 1, false);
            }
            case 268567465: {
                return new CodeSet("IBM-937 (CCSID 00937); T-Ch Host Mixed", 268567465, new short[]{1, 384}, 2, "Cp937", "cp937", 1, false);
            }
            case 268571474: {
                return new CodeSet("IBM-850 (CCSID 04946); Multilingual IBM PC Data-190", 268571474, new short[]{17}, 1, "Cp850", "cp850", 1, false);
            }
            case 268567463: {
                return new CodeSet("IBM-935 (CCSID 00935); S-Ch Host Mixed", 268567463, new short[]{1, 768}, 2, "Cp935", "cp935", 1, false);
            }
            case 196609: {
                return new CodeSet("JIS X0201:1976; Japanese phonetic characters", 196609, new short[]{128}, 1, "JIS0201", "JIS0201", 1, true);
            }
            case 268567460: {
                return new CodeSet("IBM-932 (CCSID 00932); Japanese PC Data Mixed", 268567460, new short[]{128, 129}, 2, "Cp942", "cp942", 1, false);
            }
            case 268567650: {
                return new CodeSet("IBM-1122 (CCSID 01122); Estonia", 268567650, new short[]{26}, 1, "Cp1122", "cp1122", 1, false);
            }
            case 268567458: {
                return new CodeSet("IBM-930 (CCSID 00930); Kat-Kanji Host MBCS Ext-SBCS", 268567458, new short[]{128, 129}, 2, "Cp930", "cp930", 1, false);
            }
            case 720897: {
                return new CodeSet("TIS 620-2529, Thai characters", 720897, new short[]{512}, 1, "TIS620", "TIS620", 1, true);
            }
            case 268567450: {
                return new CodeSet("IBM-922 (CCSID 00922); Estonia 8-Bit", 268567450, new short[]{26}, 1, "Cp922", "cp922", 1, false);
            }
            case 268567640: {
                return new CodeSet("IBM-1112 (CCSID 01112); Baltic Multilingual", 268567640, new short[]{26}, 1, "Cp1112", "cp1112", 1, false);
            }
            case 268567449: {
                return new CodeSet("IBM-921 (CCSID 00921); Baltic 8-Bit", 268567449, new short[]{26}, 1, "Cp921", "cp921", 1, false);
            }
            case 65568: {
                return new CodeSet("ISO 646:1991 IRV (International Reference Version)", 65568, new short[]{1}, 1, "ASCII", "US-ASCII", 1, true);
            }
            case 268567446: {
                return new CodeSet("IBM-918 (CCSID 00918); Urdu", 268567446, new short[]{22}, 1, "Cp918", "cp918", 1, false);
            }
            case 0x5010001: {
                return new CodeSet("X/Open UTF-8; UCS Transformation Format 8 (UTF-8)", 0x5010001, new short[]{4096}, 6, "UTF8", "UTF-8", 1, false);
            }
            case 83886098: {
                return new CodeSet("OSF Japanese SJIS-2", 83886098, new short[]{1, 128, 129}, 2, "SJIS", "SJIS", 1, false);
            }
            case 268567626: {
                return new CodeSet("IBM-1098 (CCSID 01098); Farsi PC Data", 268567626, new short[]{22}, 1, "Cp1098", "cp1098", 1, false);
            }
            case 0x5000011: {
                return new CodeSet("OSF Japanese SJIS-1", 0x5000011, new short[]{1, 128, 129}, 2, "SJIS", "SJIS", 1, false);
            }
            case 268567625: {
                return new CodeSet("IBM-1097 (CCSID 01097); Farsi", 268567625, new short[]{22}, 1, "Cp1097", "cp1097", 1, false);
            }
            case 0x5000010: {
                return new CodeSet("OSF Japanese UJIS", 0x5000010, new short[]{1, 128, 129}, 2, "EUC_JP", "EUC_JP", 1, false);
            }
            case 65551: {
                return new CodeSet("ISO/IEC 8859-15:1999; Latin Alphabet No. 9", 65551, new short[]{17}, 1, "ISO8859_15_FDIS", "ISO-8859-15", 1, true);
            }
            case 65545: {
                return new CodeSet("ISO/IEC 8859-9:1989; Latin Alphabet No. 5", 65545, new short[]{25}, 1, "ISO8859_9", "ISO-8859-9", 1, true);
            }
            case 65544: {
                return new CodeSet("ISO 8859-8:1988; Latin-Hebrew Alphabet", 65544, new short[]{24}, 1, "ISO8859_8", "ISO-8859-8", 1, true);
            }
            case 65543: {
                return new CodeSet("ISO 8859-7:1987; Latin-Greek Alphabet", 65543, new short[]{23}, 1, "ISO8859_7", "ISO-8859-7", 1, true);
            }
            case 65542: {
                return new CodeSet("ISO 8859-6:1987; Latin-Arabic Alphabet", 65542, new short[]{22}, 1, "ISO8859_6", "ISO-8859-6", 1, true);
            }
            case 65541: {
                return new CodeSet("ISO/IEC 8859-5:1988; Latin-Cyrillic Alphabet", 65541, new short[]{21}, 1, "ISO8859_5", "ISO-8859-5", 1, true);
            }
            case 65540: {
                return new CodeSet("ISO 8859-4:1988; Latin Alphabet No. 4", 65540, new short[]{20}, 1, "ISO8859_4", "ISO-8859-4", 1, true);
            }
            case 65539: {
                return new CodeSet("ISO 8859-3:1988; Latin Alphabet No. 3", 65539, new short[]{19}, 1, "ISO8859_3", "ISO-8859-3", 1, true);
            }
            case 65538: {
                return new CodeSet("ISO 8859-2:1987; Latin Alphabet No. 2", 65538, new short[]{18}, 1, "ISO8859_2", "ISO-8859-2", 1, true);
            }
            case 65537: {
                return new CodeSet("ISO 8859-1:1987; Latin Alphabet No. 1", 65537, new short[]{17}, 1, "ISO8859_1", "ISO-8859-1", 1, true);
            }
            case 268567028: {
                return new CodeSet("IBM-500 (CCSID 00500); CECP for Belgium, Switzerland", 268567028, new short[]{17}, 1, "Cp500", "cp500", 1, false);
            }
            case 268567785: {
                return new CodeSet("IBM-1257 (CCSID 01257); MS Windows Baltic", 268567785, new short[]{26}, 1, "Cp1257", "Cp1257", 1, false);
            }
            case 268567403: {
                return new CodeSet("IBM-875 (CCSID 00875); Greek", 268567403, new short[]{23}, 1, "Cp875", "cp875", 1, false);
            }
            case 268567784: {
                return new CodeSet("IBM-1256 (CCSID 01256); MS Windows Arabic", 268567784, new short[]{22}, 1, "Cp1256", "Cp1256", 1, false);
            }
            case 268567402: {
                return new CodeSet("IBM-874 (CCSID 00874); Thai PC Display Extended SBCS", 268567402, new short[]{512}, 1, "Cp874", "cp874", 1, false);
            }
            case 268567783: {
                return new CodeSet("IBM-1255 (CCSID 01255); MS Windows Hebrew", 268567783, new short[]{24}, 1, "Cp1255", "Cp1255", 1, false);
            }
            case 268567782: {
                return new CodeSet("IBM-1254 (CCSID 01254); MS Windows Turkey", 268567782, new short[]{25}, 1, "Cp1254", "Cp1254", 1, false);
            }
            case 268567781: {
                return new CodeSet("IBM-1253 (CCSID 01253); MS Windows Greek", 268567781, new short[]{23}, 1, "Cp1253", "Cp1253", 1, false);
            }
            case 268567399: {
                return new CodeSet("IBM-871 (CCSID 00871); CECP for Iceland", 268567399, new short[]{17}, 1, "Cp871", "cp871", 1, false);
            }
            case 268600250: {
                return new CodeSet("IBM33722 (CCSID 33722); Japanese EUC JISx201,208,212", 268600250, new short[]{128, 129, 130}, 3, "Cp33722", "cp33722", 1, false);
            }
            case 268567780: {
                return new CodeSet("IBM-1252 (CCSID 01252); MS Windows Latin-1", 268567780, new short[]{17}, 1, "Cp1252", "Cp1252", 1, false);
            }
            case 268566825: {
                return new CodeSet("IBM-297 (CCSID 00297); CECP for France", 268566825, new short[]{17}, 1, "Cp297", "cp297", 1, false);
            }
            case 268567398: {
                return new CodeSet("IBM-870 (CCSID 00870); Multilingual Latin-2 EBCDIC", 268567398, new short[]{18}, 1, "Cp870", "cp870", 1, false);
            }
            case 268567779: {
                return new CodeSet("IBM-1251 (CCSID 01251); MS Windows Cyrillic", 268567779, new short[]{21}, 1, "Cp1251", "Cp1251", 1, false);
            }
            case 268567397: {
                return new CodeSet("IBM-869 (CCSID 00869); Greek PC Data", 268567397, new short[]{23}, 1, "Cp869", "cp869", 1, false);
            }
            case 268567778: {
                return new CodeSet("IBM-1250 (CCSID 01250); MS Windows Latin-2", 268567778, new short[]{18}, 1, "Cp1250", "Cp1250", 1, false);
            }
            case 268567396: {
                return new CodeSet("IBM-868 (CCSID 00868); Urdu PC Data", 268567396, new short[]{22}, 1, "Cp868", "cp868", 1, false);
            }
            case 268567394: {
                return new CodeSet("IBM-866 (CCSID 00866); PC Data Cyrillic 2", 268567394, new short[]{21}, 1, "Cp866", "cp866", 1, false);
            }
            case 268567392: {
                return new CodeSet("IBM-864 (CCSID 00864); Arabic PC Data", 268567392, new short[]{22}, 1, "Cp864", "cp864", 1, false);
            }
        }
        return null;
    }

    public static int getAlignmentFromId(int n) {
        switch (n) {
            case 268567391: {
                return 1;
            }
            case 268567390: {
                return 1;
            }
            case 268567389: {
                return 1;
            }
            case 268566813: {
                return 1;
            }
            case 268566812: {
                return 1;
            }
            case 268567385: {
                return 1;
            }
            case 268567384: {
                return 1;
            }
            case 268567383: {
                return 1;
            }
            case 268575594: {
                return 1;
            }
            case 268566808: {
                return 1;
            }
            case 268567380: {
                return 1;
            }
            case 268566806: {
                return 1;
            }
            case 268566805: {
                return 1;
            }
            case 268567378: {
                return 1;
            }
            case 0x10020111: {
                return 1;
            }
            case 268575584: {
                return 1;
            }
            case 268567366: {
                return 1;
            }
            case 268567554: {
                return 1;
            }
            case 268567553: {
                return 1;
            }
            case 268595237: {
                return 1;
            }
            case 268566965: {
                return 1;
            }
            case 268575558: {
                return 1;
            }
            case 268567534: {
                return 1;
            }
            case 268567911: {
                return 1;
            }
            case 268567909: {
                return 1;
            }
            case 268566952: {
                return 1;
            }
            case 327696: {
                return 1;
            }
            case 268566948: {
                return 1;
            }
            case 268566565: {
                return 1;
            }
            case 327690: {
                return 1;
            }
            case 268591960: {
                return 1;
            }
            case 327682: {
                return 1;
            }
            case 327681: {
                return 1;
            }
            case 268591954: {
                return 1;
            }
            case 268575140: {
                return 1;
            }
            case 268567498: {
                return 1;
            }
            case 262154: {
                return 1;
            }
            case 268567492: {
                return 1;
            }
            case 268600152: {
                return 1;
            }
            case 65801: {
                return 2;
            }
            case 262145: {
                return 1;
            }
            case 268571493: {
                return 1;
            }
            case 65794: {
                return 2;
            }
            case 268571492: {
                return 1;
            }
            case 65793: {
                return 2;
            }
            case 65792: {
                return 2;
            }
            case 268567478: {
                return 1;
            }
            case 268571488: {
                return 1;
            }
            case 268567477: {
                return 1;
            }
            case 196624: {
                return 1;
            }
            case 268567476: {
                return 1;
            }
            case 268567471: {
                return 1;
            }
            case 196618: {
                return 1;
            }
            case 268571481: {
                return 1;
            }
            case 268567470: {
                return 1;
            }
            case 268571480: {
                return 1;
            }
            case 268571479: {
                return 1;
            }
            case 0x10010008: {
                return 1;
            }
            case 0x10010007: {
                return 1;
            }
            case 196614: {
                return 1;
            }
            case 268567467: {
                return 1;
            }
            case 196613: {
                return 1;
            }
            case 268571476: {
                return 1;
            }
            case 196612: {
                return 1;
            }
            case 268567465: {
                return 1;
            }
            case 268571474: {
                return 1;
            }
            case 268567463: {
                return 1;
            }
            case 196609: {
                return 1;
            }
            case 268567460: {
                return 1;
            }
            case 268567650: {
                return 1;
            }
            case 268567458: {
                return 1;
            }
            case 720897: {
                return 1;
            }
            case 268567450: {
                return 1;
            }
            case 268567640: {
                return 1;
            }
            case 268567449: {
                return 1;
            }
            case 65568: {
                return 1;
            }
            case 268567446: {
                return 1;
            }
            case 0x5010001: {
                return 1;
            }
            case 83886098: {
                return 1;
            }
            case 268567626: {
                return 1;
            }
            case 0x5000011: {
                return 1;
            }
            case 268567625: {
                return 1;
            }
            case 0x5000010: {
                return 1;
            }
            case 65551: {
                return 1;
            }
            case 65545: {
                return 1;
            }
            case 65544: {
                return 1;
            }
            case 65543: {
                return 1;
            }
            case 65542: {
                return 1;
            }
            case 65541: {
                return 1;
            }
            case 65540: {
                return 1;
            }
            case 65539: {
                return 1;
            }
            case 65538: {
                return 1;
            }
            case 65537: {
                return 1;
            }
            case 268567028: {
                return 1;
            }
            case 268567785: {
                return 1;
            }
            case 268567403: {
                return 1;
            }
            case 268567784: {
                return 1;
            }
            case 268567402: {
                return 1;
            }
            case 268567783: {
                return 1;
            }
            case 268567782: {
                return 1;
            }
            case 268567781: {
                return 1;
            }
            case 268567399: {
                return 1;
            }
            case 268600250: {
                return 1;
            }
            case 268567780: {
                return 1;
            }
            case 268566825: {
                return 1;
            }
            case 268567398: {
                return 1;
            }
            case 268567779: {
                return 1;
            }
            case 268567397: {
                return 1;
            }
            case 268567778: {
                return 1;
            }
            case 268567396: {
                return 1;
            }
            case 268567394: {
                return 1;
            }
            case 268567392: {
                return 1;
            }
        }
        return -1;
    }

    public static String getNameFromId(int n) {
        switch (n) {
            case 268567391: {
                return "cp863";
            }
            case 268567390: {
                return "cp862";
            }
            case 268567389: {
                return "cp861";
            }
            case 268566813: {
                return "cp285";
            }
            case 268566812: {
                return "cp284";
            }
            case 268567385: {
                return "cp857";
            }
            case 268567384: {
                return "cp856";
            }
            case 268567383: {
                return "cp855";
            }
            case 268575594: {
                return "cp874";
            }
            case 268566808: {
                return "cp280";
            }
            case 268567380: {
                return "cp852";
            }
            case 268566806: {
                return "cp278";
            }
            case 268566805: {
                return "Cp277";
            }
            case 268567378: {
                return "cp850";
            }
            case 0x10020111: {
                return "cp273";
            }
            case 268575584: {
                return "cp864";
            }
            case 268567366: {
                return "cp838";
            }
            case 268567554: {
                return "cp1026";
            }
            case 268567553: {
                return "cp1025";
            }
            case 268595237: {
                return "cp037";
            }
            case 268566965: {
                return "cp437";
            }
            case 268575558: {
                return "cp838";
            }
            case 268567534: {
                return "cp1006";
            }
            case 268567911: {
                return "cp1383";
            }
            case 268567909: {
                return "cp1381";
            }
            case 268566952: {
                return "cp424";
            }
            case 327696: {
                return "EUC_TW";
            }
            case 268566948: {
                return "cp420";
            }
            case 268566565: {
                return "cp037";
            }
            case 327690: {
                return "EUC_TW";
            }
            case 268591960: {
                return "cp856";
            }
            case 327682: {
                return "CNS11643";
            }
            case 327681: {
                return "CNS11643";
            }
            case 268591954: {
                return "cp850";
            }
            case 268575140: {
                return "cp420";
            }
            case 268567498: {
                return "cp970";
            }
            case 262154: {
                return "EUC_KR";
            }
            case 268567492: {
                return "cp964";
            }
            case 268600152: {
                return "cp856";
            }
            case 65801: {
                return "UTF-16BE";
            }
            case 262145: {
                return "KSC5601";
            }
            case 268571493: {
                return "cp869";
            }
            case 65794: {
                return "ISO-10646-UCS-2";
            }
            case 268571492: {
                return "cp868";
            }
            case 65793: {
                return "ISO-10646-UCS-2";
            }
            case 65792: {
                return "ISO-10646-UCS-2";
            }
            case 268567478: {
                return "cp950";
            }
            case 268571488: {
                return "cp864";
            }
            case 268567477: {
                return "cp949";
            }
            case 196624: {
                return "EUC-JP";
            }
            case 268567476: {
                return "cp948";
            }
            case 268567471: {
                return "cp943";
            }
            case 196618: {
                return "JIS0212";
            }
            case 268571481: {
                return "cp857";
            }
            case 268567470: {
                return "cp942";
            }
            case 268571480: {
                return "cp856";
            }
            case 268571479: {
                return "cp855";
            }
            case 0x10010008: {
                return "big5";
            }
            case 0x10010007: {
                return "GB2312";
            }
            case 196614: {
                return "JIS0208";
            }
            case 268567467: {
                return "cp939";
            }
            case 196613: {
                return "JIS0208";
            }
            case 268571476: {
                return "cp852";
            }
            case 196612: {
                return "JIS0208";
            }
            case 268567465: {
                return "cp937";
            }
            case 268571474: {
                return "cp850";
            }
            case 268567463: {
                return "cp935";
            }
            case 196609: {
                return "JIS0201";
            }
            case 268567460: {
                return "cp942";
            }
            case 268567650: {
                return "cp1122";
            }
            case 268567458: {
                return "cp930";
            }
            case 720897: {
                return "TIS620";
            }
            case 268567450: {
                return "cp922";
            }
            case 268567640: {
                return "cp1112";
            }
            case 268567449: {
                return "cp921";
            }
            case 65568: {
                return "US-ASCII";
            }
            case 268567446: {
                return "cp918";
            }
            case 0x5010001: {
                return "UTF-8";
            }
            case 83886098: {
                return "SJIS";
            }
            case 268567626: {
                return "cp1098";
            }
            case 0x5000011: {
                return "SJIS";
            }
            case 268567625: {
                return "cp1097";
            }
            case 0x5000010: {
                return "EUC_JP";
            }
            case 65551: {
                if (JREVersion.V1_4) {
                    return "ISO-8859-15";
                }
                return "ISO8859_15_FDIS";
            }
            case 65545: {
                return "ISO-8859-9";
            }
            case 65544: {
                return "ISO-8859-8";
            }
            case 65543: {
                return "ISO-8859-7";
            }
            case 65542: {
                return "ISO-8859-6";
            }
            case 65541: {
                return "ISO-8859-5";
            }
            case 65540: {
                return "ISO-8859-4";
            }
            case 65539: {
                return "ISO-8859-3";
            }
            case 65538: {
                return "ISO-8859-2";
            }
            case 65537: {
                return "ISO-8859-1";
            }
            case 268567028: {
                return "cp500";
            }
            case 268567785: {
                return "Cp1257";
            }
            case 268567403: {
                return "cp875";
            }
            case 268567784: {
                return "Cp1256";
            }
            case 268567402: {
                return "cp874";
            }
            case 268567783: {
                return "Cp1255";
            }
            case 268567782: {
                return "Cp1254";
            }
            case 268567781: {
                return "Cp1253";
            }
            case 268567399: {
                return "cp871";
            }
            case 268600250: {
                return "cp33722";
            }
            case 268567780: {
                return "Cp1252";
            }
            case 268566825: {
                return "cp297";
            }
            case 268567398: {
                return "cp870";
            }
            case 268567779: {
                return "Cp1251";
            }
            case 268567397: {
                return "cp869";
            }
            case 268567778: {
                return "Cp1250";
            }
            case 268567396: {
                return "cp868";
            }
            case 268567394: {
                return "cp866";
            }
            case 268567392: {
                return "cp864";
            }
        }
        return null;
    }

    public static String getCanonicalNameFromId(int n) {
        switch (n) {
            case 268567391: {
                return "Cp863";
            }
            case 268567390: {
                return "Cp862";
            }
            case 268567389: {
                return "Cp861";
            }
            case 268566813: {
                return "Cp285";
            }
            case 268566812: {
                return "Cp284";
            }
            case 268567385: {
                return "Cp857";
            }
            case 268567384: {
                return "Cp856";
            }
            case 268567383: {
                return "Cp855";
            }
            case 268575594: {
                return "Cp874";
            }
            case 268566808: {
                return "Cp280";
            }
            case 268567380: {
                return "Cp852";
            }
            case 268566806: {
                return "Cp278";
            }
            case 268566805: {
                return "Cp277";
            }
            case 268567378: {
                return "Cp850";
            }
            case 0x10020111: {
                return "Cp273";
            }
            case 268575584: {
                return "Cp864";
            }
            case 268567366: {
                return "Cp838";
            }
            case 268567554: {
                return "Cp1026";
            }
            case 268567553: {
                return "Cp1025";
            }
            case 268595237: {
                return "Cp037";
            }
            case 268566965: {
                return "Cp437";
            }
            case 268575558: {
                return "Cp838";
            }
            case 268567534: {
                return "Cp1006";
            }
            case 268567911: {
                return "Cp1383";
            }
            case 268567909: {
                return "Cp1381";
            }
            case 268566952: {
                return "Cp424";
            }
            case 327696: {
                return "EUC_TW";
            }
            case 268566948: {
                return "Cp420";
            }
            case 268566565: {
                return "Cp037";
            }
            case 327690: {
                return "EUC_TW";
            }
            case 268591960: {
                return "Cp856";
            }
            case 327682: {
                return "EUC_TW";
            }
            case 327681: {
                return "EUC_TW";
            }
            case 268591954: {
                return "Cp850";
            }
            case 268575140: {
                return "Cp420";
            }
            case 268567498: {
                return "Cp970";
            }
            case 262154: {
                return "EUC_KR";
            }
            case 268567492: {
                return "Cp964";
            }
            case 268600152: {
                return "Cp856";
            }
            case 65801: {
                return "UnicodeBigUnmarked";
            }
            case 262145: {
                return "EUC_KR";
            }
            case 268571493: {
                return "Cp869";
            }
            case 65794: {
                return "UnicodeBigUnmarked";
            }
            case 268571492: {
                return "Cp868";
            }
            case 65793: {
                return "UnicodeBigUnmarked";
            }
            case 65792: {
                return "UnicodeBigUnmarked";
            }
            case 268567478: {
                return "Cp950";
            }
            case 268571488: {
                return "Cp864";
            }
            case 268567477: {
                return "Cp949";
            }
            case 196624: {
                return "EUC_JP";
            }
            case 268567476: {
                return "Cp948";
            }
            case 268567471: {
                return "Cp943";
            }
            case 196618: {
                return "JIS0212";
            }
            case 268571481: {
                return "Cp857";
            }
            case 268567470: {
                return "Cp942";
            }
            case 268571480: {
                return "Cp856";
            }
            case 268571479: {
                return "Cp855";
            }
            case 0x10010008: {
                return "Big5";
            }
            case 0x10010007: {
                return "EUC_CN";
            }
            case 196614: {
                return "JIS0208";
            }
            case 268567467: {
                return "Cp939";
            }
            case 196613: {
                return "JIS0208";
            }
            case 268571476: {
                return "Cp852";
            }
            case 196612: {
                return "JIS0208";
            }
            case 268567465: {
                return "Cp937";
            }
            case 268571474: {
                return "Cp850";
            }
            case 268567463: {
                return "Cp935";
            }
            case 196609: {
                return "JIS0201";
            }
            case 268567460: {
                return "Cp942";
            }
            case 268567650: {
                return "Cp1122";
            }
            case 268567458: {
                return "Cp930";
            }
            case 720897: {
                return "TIS620";
            }
            case 268567450: {
                return "Cp922";
            }
            case 268567640: {
                return "Cp1112";
            }
            case 268567449: {
                return "Cp921";
            }
            case 65568: {
                return "ASCII";
            }
            case 268567446: {
                return "Cp918";
            }
            case 0x5010001: {
                return "UTF8";
            }
            case 83886098: {
                return "SJIS";
            }
            case 268567626: {
                return "Cp1098";
            }
            case 0x5000011: {
                return "SJIS";
            }
            case 268567625: {
                return "Cp1097";
            }
            case 0x5000010: {
                return "EUC_JP";
            }
            case 65551: {
                if (JREVersion.V1_4) {
                    return "ISO-8859-15";
                }
                return "ISO8859_15_FDIS";
            }
            case 65545: {
                return "ISO8859_9";
            }
            case 65544: {
                return "ISO8859_8";
            }
            case 65543: {
                return "ISO8859_7";
            }
            case 65542: {
                return "ISO8859_6";
            }
            case 65541: {
                return "ISO8859_5";
            }
            case 65540: {
                return "ISO8859_4";
            }
            case 65539: {
                return "ISO8859_3";
            }
            case 65538: {
                return "ISO8859_2";
            }
            case 65537: {
                return "ISO8859_1";
            }
            case 268567028: {
                return "Cp500";
            }
            case 268567785: {
                return "Cp1257";
            }
            case 268567403: {
                return "Cp875";
            }
            case 268567784: {
                return "Cp1256";
            }
            case 268567402: {
                return "Cp874";
            }
            case 268567783: {
                return "Cp1255";
            }
            case 268567782: {
                return "Cp1254";
            }
            case 268567781: {
                return "Cp1253";
            }
            case 268567399: {
                return "Cp871";
            }
            case 268600250: {
                return "Cp33722";
            }
            case 268567780: {
                return "Cp1252";
            }
            case 268566825: {
                return "Cp297";
            }
            case 268567398: {
                return "Cp870";
            }
            case 268567779: {
                return "Cp1251";
            }
            case 268567397: {
                return "Cp869";
            }
            case 268567778: {
                return "Cp1250";
            }
            case 268567396: {
                return "Cp868";
            }
            case 268567394: {
                return "Cp866";
            }
            case 268567392: {
                return "Cp864";
            }
        }
        return null;
    }

    public static String getDescriptionFromId(int n) {
        switch (n) {
            case 268567391: {
                return "IBM-863 (CCSID 00863); PC Data Canadian French";
            }
            case 268567390: {
                return "IBM-862 (CCSID 00862); PC Data Hebrew";
            }
            case 268567389: {
                return "IBM-861 (CCSID 00861); PC Data Iceland";
            }
            case 268566813: {
                return "IBM-285 (CCSID 00285); CECP for United Kingdom";
            }
            case 268566812: {
                return "IBM-284 (CCSID 00284); CECP for Spain, Latin America (Spanish)";
            }
            case 268567385: {
                return "IBM-857 (CCSID 00857); Turkish Latin-5 PC Data";
            }
            case 268567384: {
                return "IBM-856 (CCSID 00856); Hebrew PC Data (extensions)";
            }
            case 268567383: {
                return "IBM-855 (CCSID 00855); Cyrillic PC Data";
            }
            case 268575594: {
                return "IBM-874 (CCSID 09066); Thai PC Display Extended SBCS";
            }
            case 268566808: {
                return "IBM-280 (CCSID 00280); CECP for Italy";
            }
            case 268567380: {
                return "IBM-852 (CCSID 00852); Multilingual Latin-2";
            }
            case 268566806: {
                return "IBM-278 (CCSID 00278); CECP for Finland, Sweden";
            }
            case 268566805: {
                return "IBM-277 (CCSID 00277); CECP for Denmark, Norway";
            }
            case 268567378: {
                return "IBM-850 (CCSID 00850); Multilingual IBM PC Data-MLP 222";
            }
            case 0x10020111: {
                return "IBM-273 (CCSID 00273); CECP for Austria, Germany";
            }
            case 268575584: {
                return "IBM-864 (CCSID 09056); Arabic PC Data (unshaped)";
            }
            case 268567366: {
                return "IBM-838 (CCSID 00838); Thai Host Extended SBCS";
            }
            case 268567554: {
                return "IBM-1026 (CCSID 01026); Turkish Latin-5";
            }
            case 268567553: {
                return "IBM-1025 (CCSID 01025); Cyrillic Multilingual";
            }
            case 268595237: {
                return "IBM-037 (CCSID 28709); T-Ch Host Extended SBCS";
            }
            case 268566965: {
                return "IBM-437 (CCSID 00437); PC USA";
            }
            case 268575558: {
                return "IBM-838 (CCSID 09030); Thai Host Extended SBCS";
            }
            case 268567534: {
                return "IBM-1006 (CCSID 01006); Urdu 8-bit";
            }
            case 268567911: {
                return "IBM-1383 (CCSID 01383); S-Ch EUC GB 2312-80 set (1382)";
            }
            case 268567909: {
                return "IBM-1381 (CCSID 01381); S-Ch PC Data Mixed incl 1880 UDC";
            }
            case 268566952: {
                return "IBM-424 (CCSID 00424); Hebrew";
            }
            case 327696: {
                return "CNS eucTW:1993; Taiwanese EUC";
            }
            case 268566948: {
                return "IBM-420 (CCSID 00420); Arabic (presentation shapes)";
            }
            case 268566565: {
                return "IBM-037 (CCSID 00037); CECP for USA, Canada, NL, Ptgl, Brazil, Australia, NZ";
            }
            case 327690: {
                return "CNS eucTW:1991; Taiwanese EUC";
            }
            case 268591960: {
                return "IBM-856 (CCSID 25432); Hebrew PC Display (extensions)";
            }
            case 327682: {
                return "CNS 11643:1992; Taiwanese Extended Hanzi Graphic Chars";
            }
            case 327681: {
                return "CNS 11643:1986; Taiwanese Hanzi Graphic Characters";
            }
            case 268591954: {
                return "IBM-850 (CCSID 25426); Multilingual IBM PC Display-MLP";
            }
            case 268575140: {
                return "IBM-420 (CCSID 08612); Arabic (base shapes only)";
            }
            case 268567498: {
                return "IBM-970 (CCSID 00970); Korean EUC";
            }
            case 262154: {
                return "KS eucKR:1991; Korean EUC";
            }
            case 268567492: {
                return "IBM-964 (CCSID 00964); T-Chinese EUC CNS1163 plane 1,2";
            }
            case 268600152: {
                return "IBM-856 (CCSID 33624); Hebrew PC Display";
            }
            case 65801: {
                return "ISO/IEC 10646-1:1993; UTF-16, UCS Transformation Format 16-bit form";
            }
            case 262145: {
                return "KS C5601:1987; Korean Hangul and Hanja Graphic Characters";
            }
            case 268571493: {
                return "IBM-869 (CCSID 04965); Greek PC Data";
            }
            case 65794: {
                return "ISO/IEC 10646-1:1993; UCS-2, Level 3";
            }
            case 268571492: {
                return "IBM-868 (CCSID 04964); PC Data for Urdu";
            }
            case 65793: {
                return "ISO/IEC 10646-1:1993; UCS-2, Level 2";
            }
            case 65792: {
                return "ISO/IEC 10646-1:1993; UCS-2, Level 1";
            }
            case 268567478: {
                return "IBM-950 (CCSID 00950); T-Ch PC Data Mixed";
            }
            case 268571488: {
                return "IBM-864 (CCSID 04960); Arabic PC Data (all shapes)";
            }
            case 268567477: {
                return "IBM-949 (CCSID 00949); IBM KS PC Data Mixed";
            }
            case 196624: {
                return "JIS eucJP:1993; Japanese EUC";
            }
            case 268567476: {
                return "IBM-948 (CCSID 00948); T-Ch PC Data Mixed";
            }
            case 268567471: {
                return "IBM-943 (CCSID 00943); Japanese PC MBCS for Open";
            }
            case 196618: {
                return "JIS X0212:1990; Supplementary Japanese Kanji Graphic Chars";
            }
            case 268571481: {
                return "IBM-857 (CCSID 04953); Turkish Latin-5 PC Data";
            }
            case 268567470: {
                return "IBM-942 (CCSID 00942); Japanese PC Data Mixed";
            }
            case 268571480: {
                return "IBM-856 (CCSID 04952); Hebrew PC Data";
            }
            case 268571479: {
                return "IBM-855 (CCSID 04951); Cyrillic Personal Computer";
            }
            case 0x10010008: {
                return "HP big5; encoding method for Traditional Chinese";
            }
            case 0x10010007: {
                return "HP15CN; encoding method for Simplified Chinese";
            }
            case 196614: {
                return "JIS X0208:1990 Japanese Kanji Graphic Characters";
            }
            case 268567467: {
                return "IBM-939 (CCSID 00939); Latin-Kanji Host MBCS";
            }
            case 196613: {
                return "JIS X0208:1983 Japanese Kanji Graphic Characters";
            }
            case 268571476: {
                return "IBM-852 (CCSID 04948); Latin-2 Personal Computer";
            }
            case 196612: {
                return "JIS X0208:1978 Japanese Kanji Graphic Characters";
            }
            case 268567465: {
                return "IBM-937 (CCSID 00937); T-Ch Host Mixed";
            }
            case 268571474: {
                return "IBM-850 (CCSID 04946); Multilingual IBM PC Data-190";
            }
            case 268567463: {
                return "IBM-935 (CCSID 00935); S-Ch Host Mixed";
            }
            case 196609: {
                return "JIS X0201:1976; Japanese phonetic characters";
            }
            case 268567460: {
                return "IBM-932 (CCSID 00932); Japanese PC Data Mixed";
            }
            case 268567650: {
                return "IBM-1122 (CCSID 01122); Estonia";
            }
            case 268567458: {
                return "IBM-930 (CCSID 00930); Kat-Kanji Host MBCS Ext-SBCS";
            }
            case 720897: {
                return "TIS 620-2529, Thai characters";
            }
            case 268567450: {
                return "IBM-922 (CCSID 00922); Estonia 8-Bit";
            }
            case 268567640: {
                return "IBM-1112 (CCSID 01112); Baltic Multilingual";
            }
            case 268567449: {
                return "IBM-921 (CCSID 00921); Baltic 8-Bit";
            }
            case 65568: {
                return "ISO 646:1991 IRV (International Reference Version)";
            }
            case 268567446: {
                return "IBM-918 (CCSID 00918); Urdu";
            }
            case 0x5010001: {
                return "X/Open UTF-8; UCS Transformation Format 8 (UTF-8)";
            }
            case 83886098: {
                return "OSF Japanese SJIS-2";
            }
            case 268567626: {
                return "IBM-1098 (CCSID 01098); Farsi PC Data";
            }
            case 0x5000011: {
                return "OSF Japanese SJIS-1";
            }
            case 268567625: {
                return "IBM-1097 (CCSID 01097); Farsi";
            }
            case 0x5000010: {
                return "OSF Japanese UJIS";
            }
            case 65551: {
                return "ISO/IEC 8859-15:1999; Latin Alphabet No. 9";
            }
            case 65545: {
                return "ISO/IEC 8859-9:1989; Latin Alphabet No. 5";
            }
            case 65544: {
                return "ISO 8859-8:1988; Latin-Hebrew Alphabet";
            }
            case 65543: {
                return "ISO 8859-7:1987; Latin-Greek Alphabet";
            }
            case 65542: {
                return "ISO 8859-6:1987; Latin-Arabic Alphabet";
            }
            case 65541: {
                return "ISO/IEC 8859-5:1988; Latin-Cyrillic Alphabet";
            }
            case 65540: {
                return "ISO 8859-4:1988; Latin Alphabet No. 4";
            }
            case 65539: {
                return "ISO 8859-3:1988; Latin Alphabet No. 3";
            }
            case 65538: {
                return "ISO 8859-2:1987; Latin Alphabet No. 2";
            }
            case 65537: {
                return "ISO 8859-1:1987; Latin Alphabet No. 1";
            }
            case 268567028: {
                return "IBM-500 (CCSID 00500); CECP for Belgium, Switzerland";
            }
            case 268567785: {
                return "IBM-1257 (CCSID 01257); MS Windows Baltic";
            }
            case 268567403: {
                return "IBM-875 (CCSID 00875); Greek";
            }
            case 268567784: {
                return "IBM-1256 (CCSID 01256); MS Windows Arabic";
            }
            case 268567402: {
                return "IBM-874 (CCSID 00874); Thai PC Display Extended SBCS";
            }
            case 268567783: {
                return "IBM-1255 (CCSID 01255); MS Windows Hebrew";
            }
            case 268567782: {
                return "IBM-1254 (CCSID 01254); MS Windows Turkey";
            }
            case 268567781: {
                return "IBM-1253 (CCSID 01253); MS Windows Greek";
            }
            case 268567399: {
                return "IBM-871 (CCSID 00871); CECP for Iceland";
            }
            case 268600250: {
                return "IBM33722 (CCSID 33722); Japanese EUC JISx201,208,212";
            }
            case 268567780: {
                return "IBM-1252 (CCSID 01252); MS Windows Latin-1";
            }
            case 268566825: {
                return "IBM-297 (CCSID 00297); CECP for France";
            }
            case 268567398: {
                return "IBM-870 (CCSID 00870); Multilingual Latin-2 EBCDIC";
            }
            case 268567779: {
                return "IBM-1251 (CCSID 01251); MS Windows Cyrillic";
            }
            case 268567397: {
                return "IBM-869 (CCSID 00869); Greek PC Data";
            }
            case 268567778: {
                return "IBM-1250 (CCSID 01250); MS Windows Latin-2";
            }
            case 268567396: {
                return "IBM-868 (CCSID 00868); Urdu PC Data";
            }
            case 268567394: {
                return "IBM-866 (CCSID 00866); PC Data Cyrillic 2";
            }
            case 268567392: {
                return "IBM-864 (CCSID 00864); Arabic PC Data";
            }
        }
        return null;
    }

    public static int[] getCodeSetsFromCharset(short s) {
        switch (s) {
            case 512: {
                return new int[]{268575594, 268575558, 268567402, 268567366, 720897};
            }
            case 130: {
                return new int[]{268600250, 196624, 196618};
            }
            case 129: {
                return new int[]{268600250, 268567471, 268567470, 268567467, 268567460, 268567458, 83886098, 0x5000011, 0x5000010, 196624, 196614, 196613, 196612};
            }
            case 128: {
                return new int[]{268600250, 268567471, 268567470, 268567467, 268567460, 268567458, 83886098, 0x5000011, 0x5000010, 196624, 196609};
            }
            case 26: {
                return new int[]{268567785, 268567650, 268567640, 268567450, 268567449};
            }
            case 25: {
                return new int[]{268571481, 268567782, 268567554, 268567385, 65545};
            }
            case 24: {
                return new int[]{268600152, 268591960, 268571480, 268567783, 268567390, 268567384, 268566952, 65544};
            }
            case 23: {
                return new int[]{268571493, 268567781, 268567403, 268567397, 65543};
            }
            case 257: {
                return new int[]{268567498, 262154};
            }
            case 22: {
                return new int[]{268575584, 268575140, 268571492, 268571488, 268567784, 268567626, 268567625, 268567534, 268567446, 268567396, 268567392, 268566948, 65542};
            }
            case 256: {
                return new int[]{268567498, 268567477, 262154, 262145};
            }
            case 21: {
                return new int[]{268571479, 268567779, 268567553, 268567394, 268567383, 65541};
            }
            case 20: {
                return new int[]{65540};
            }
            case 19: {
                return new int[]{65539};
            }
            case 18: {
                return new int[]{268571476, 268567778, 268567398, 268567380, 65538};
            }
            case 17: {
                return new int[]{268591954, 268571474, 268567780, 268567498, 268567399, 268567391, 268567389, 268567378, 268567028, 268566965, 268566825, 268566813, 268566812, 268566808, 268566806, 268566805, 0x10020111, 268566565, 262154, 196624, 65551, 65537};
            }
            case 768: {
                return new int[]{268567911, 268567909, 268567463, 0x10010007};
            }
            case 385: {
                return new int[]{327696, 327682};
            }
            case 384: {
                return new int[]{268567492, 268567478, 268567476, 268567465, 0x10010008, 327690, 327681};
            }
            case 4096: {
                return new int[]{0x5010001, 65801, 65794, 65793, 65792};
            }
            case 1: {
                return new int[]{268595237, 268567911, 268567909, 268567492, 268567478, 268567477, 268567476, 268567465, 268567463, 0x10010008, 0x10010007, 83886098, 0x5000011, 0x5000010, 327696, 327690, 65568};
            }
        }
        return null;
    }
}

